unit fOddeleni;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, Db, DBTables, DBCtrls, Grids, DBGrids, Mask;

type
  TOddeleniForm = class(TForm)
    CancelBtn: TButton;
    Panel1: TPanel;
    OddeleniGrid: TDBGrid;
    OddeleniNavigator: TDBNavigator;
    OddeleniTbl: TTable;
    OddeleniSrc: TDataSource;
    OddeleniLookupTbl: TTable;
    OddeleniTbl_Nadrazene: TStringField;
    OddeleniLookupTblID: TIntegerField;
    OddeleniLookupTblNazev: TStringField;
    Button1: TButton;
    OddeleniTblID: TIntegerField;
    OddeleniTblNAZEV: TStringField;
    OddeleniTblNADRAZENE: TIntegerField;
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure OddeleniTblAfterPost(DataSet: TDataSet);
    procedure OddeleniTblCalcFields(DataSet: TDataSet);
    procedure Button1Click(Sender: TObject);
    procedure OddeleniTblNewRecord(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OddeleniForm: TOddeleniForm;

implementation

uses
  Dialogs, mDatabaze;

{$R *.DFM}

procedure TOddeleniForm.FormShow(Sender: TObject);
begin
  OddeleniLookupTbl.Open;
  OddeleniTbl.Open;
  OddeleniGrid.SetFocus;
end;

procedure TOddeleniForm.FormHide(Sender: TObject);
begin
  OddeleniTbl.Close;
  OddeleniLookupTbl.Close;
end;

procedure TOddeleniForm.OddeleniTblAfterPost(DataSet: TDataSet);
begin
  OddeleniLookupTbl.Refresh;
end;

procedure TOddeleniForm.OddeleniTblCalcFields(DataSet: TDataSet);
begin
{  if OddeleniLookupTbl.Locate('ID',
     OddeleniTblNadrazene.Value, []) then
    OddeleniTbl_Nadrazene.Value := OddeleniLookupTblNazev.Value;}
{  if OddeleniLookupTbl.FindKey([OddeleniTblNadrazene.Value]) then
    OddeleniTbl_Nadrazene.Value := OddeleniLookupTblNazev.Value;}
end;

procedure TOddeleniForm.Button1Click(Sender: TObject);
var
  s: string;
  n: integer;
begin
  s := inputbox('', '', '');
  n := strtoint(s);
  if OddeleniTbl.FindKey([n]) then
    showmessaGe('ok');
  if OddeleniLookupTbl.FindKey([n]) then
    showmessaGe('ok');
//  OddeleniTbl.Locate('ID', strtoint(inputbox('', '', '')), []);
end;


procedure TOddeleniForm.OddeleniTblNewRecord(DataSet: TDataSet);
begin
  OddeleniTblID.Value := Databaze.NewID(OddeleniTbl); 
end;

end.
