unit mDatabaze;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, Db;

type
  TDatabaze = class(TDataModule)
    Database: TDatabase;
    OddeleniNodeQ: TQuery;
    OddeleniTopNodeQ: TQuery;
    ZamestnanecTopNodeQ: TQuery;
    ZamestnanecNodeQ: TQuery;
    PresunZamestnanceQ: TQuery;
    PresunOddeleniQ: TQuery;
    PresunOddeleniProc: TStoredProc;
    OddeleniTbl: TTable;
    MultiQ: TQuery;
    OddeleniSrc: TDataSource;
    OddeleniDetailTbl: TTable;
    OddeleniDetailSrc: TDataSource;
    ZamestnanecTbl: TTable;
    ZamestnanecSrc: TDataSource;
    FunkceLookupTbl: TTable;
    FunkceLookupSrc: TDataSource;
    TridaLookupTbl: TTable;
    TridaLookupSrc: TDataSource;
    FunkceNodeQ: TQuery;
    TridyNodeQ: TQuery;
    ZamestnanciFunkceNodeQ: TQuery;
    ZamestnanciTridaNodeQ: TQuery;
    PresunTridQ: TQuery;
    PresunFunkciQ: TQuery;
    FunkceTbl: TTable;
    FunkceSrc: TDataSource;
    TridaTbl: TTable;
    TridaSrc: TDataSource;
    ZamestnanecTbl_Plat: TCurrencyField;
    ZamestnanecTblRC: TStringField;
    ZamestnanecTblPRIJMENI: TStringField;
    ZamestnanecTblJMENO: TStringField;
    ZamestnanecTblFUNKCE: TIntegerField;
    ZamestnanecTblODDELENI: TIntegerField;
    ZamestnanecTblPLAT: TIntegerField;
    ZamestnanecTblPRIJETI: TDateTimeField;
    ZamestnanecTblULICE: TStringField;
    ZamestnanecTblMESTO: TStringField;
    ZamestnanecTblPSC: TStringField;
    ZamestnanecTblTELEFON: TStringField;
    DovoleneQ2: TQuery;
    DovoleneSrc: TDataSource;
    DovoleneQ2DRUH: TIntegerField;
    DovoleneQ2RC: TStringField;
    DovoleneQ2ODKDY: TDateField;
    DovoleneQ2DOKDY: TDateField;
    NemocenskeQ2: TQuery;
    NemocenskeSrc: TDataSource;
    NemocenskeQ2DRUH: TIntegerField;
    NemocenskeQ2RC: TStringField;
    NemocenskeQ2ODKDY: TDateField;
    NemocenskeQ2DOKDY: TDateField;
    ZamestnanciDetailSrc: TDataSource;
    ZamestnanciDetailQ: TQuery;
    ZamestnanciDetailQRC: TStringField;
    ZamestnanciDetailQPRIJMENI: TStringField;
    ZamestnanciDetailQJMENO: TStringField;
    ZamestnanciDetailQNAZEV: TStringField;
    ZamestnanciDetailQNAZEV_1: TStringField;
    ZamestnanciDetailQNAZEV_2: TStringField;
    ZamestnanciDetailQCeleJmeno: TStringField;
    ZamestnanciVseDetailQ: TQuery;
    StringField1: TStringField;
    StringField2: TStringField;
    StringField3: TStringField;
    StringField4: TStringField;
    StringField5: TStringField;
    StringField6: TStringField;
    StringField7: TStringField;
    ZamestnanciVseDetailSrc: TDataSource;
    OddeleniVseQ: TQuery;
    OddeleniVseSrc: TDataSource;
    FunkceVseQ: TQuery;
    FunkceVseSrc: TDataSource;
    PlatTbl: TTable;
    PlatSrc: TDataSource;
    PlatTblTRIDA: TIntegerField;
    PlatTblROK: TIntegerField;
    PlatTblPLAT: TFloatField;
    TridyVseQ: TQuery;
    TridyVseSrc: TDataSource;
    PlatQ: TQuery;
    ZamestnanecTbl_Dovolena: TIntegerField;
    ZamestnanecTbl_Nemocenska: TIntegerField;
    DovoleneQ: TTable;
    DovoleneQDRUH: TIntegerField;
    DovoleneQRC: TStringField;
    DovoleneQODKDY: TDateTimeField;
    DovoleneQDOKDY: TDateTimeField;
    NemocenskeQ: TTable;
    IntegerField1: TIntegerField;
    StringField8: TStringField;
    DateTimeField1: TDateTimeField;
    DateTimeField2: TDateTimeField;
    Query1: TQuery;
    FunkceTblID: TIntegerField;
    FunkceTblNAZEV: TStringField;
    procedure DatabazeCreate(Sender: TObject);
    procedure OddeleniTblAfterScroll(DataSet: TDataSet);
    procedure OddeleniTblNewRecord(DataSet: TDataSet);
    procedure TableAfterInsert(DataSet: TDataSet);
    procedure TableAfterCancel(DataSet: TDataSet);
    procedure OddeleniTblAfterPost(DataSet: TDataSet);
    procedure ZamestnanecTblAfterScroll(DataSet: TDataSet);
    procedure ZamestnanecTblAfterPost(DataSet: TDataSet);
    procedure ZamestnanecTblBeforeEditInsert(DataSet: TDataSet);
    procedure ZamestnanecTblNewRecord(DataSet: TDataSet);
    procedure FunkceTblAfterPost(DataSet: TDataSet);
    procedure FunkceTblAfterScroll(DataSet: TDataSet);
    procedure FunkceTblNewRecord(DataSet: TDataSet);
    procedure TridaTblAfterPost(DataSet: TDataSet);
    procedure TridaTblAfterScroll(DataSet: TDataSet);
    procedure TridaTblBeforeScroll(DataSet: TDataSet);
    procedure TridaTblNewRecord(DataSet: TDataSet);
    procedure ZamestnanecTblRCValidate(Sender: TField);
    procedure NepritomnostNewRecord(DataSet: TDataSet);
    procedure ZamestnanciDetailQCalcFields(DataSet: TDataSet);
    procedure OddeleniTblBeforeEditInsert(DataSet: TDataSet);
    procedure TridaTblBeforeEditInsert(DataSet: TDataSet);
    procedure FunkceTblBeforeEditInsert(DataSet: TDataSet);
    procedure ZamestnanecTblCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
    Vkladam: Boolean;
    TridaPred, FunkcePred: Integer;
    function ProvedSQL(aSQL: string): Variant;
  public
    { Public declarations }
    Upozornovat: Boolean;
    function NadrazeneOddeleni(Oddeleni: Integer): Integer;
    function NewID(Table: TTable): LongInt;
    procedure SmazOddeleni;
    procedure SmazZamestnance;
    procedure SmazFunkci;
    procedure SmazTridu;
    function OddeleniSQL(Oddeleni: Integer; Sloupec: string): string;
  end;

var
  Databaze: TDatabaze;

implementation

uses
  ComCtrls, DBGrids,
  uObecne,
  fMain, mMenus;

{$R *.DFM}

function TDatabaze.NadrazeneOddeleni(Oddeleni: Integer): Integer;
// zjisti cislo nadrazeneho oddeleni
begin
  Result := ProvedSQL(
    Format('select nadrazene from oddeleni where id = %d;', [Oddeleni]));
end;

function TDataBaze.NewID(Table: TTable): LongInt;
// vrati jeste nepouzity klic k tabulce predate parametrem Table 
var
  ID: Variant;
begin
  ID := ProvedSQL(
    Format('select max(id)+1 from %s', [Table.TableName]));
  if VarIsNull(ID) then ID := 1;
  Result := ID;
end;

procedure TDatabaze.SmazOddeleni;
// smaze aktualne vybrane oddeleni a vybere jeho nadrizene
var
  Node: TTreeNode;
begin
  with OddeleniTbl, HlavniOkno do
  begin
    Node := TreeView.Selected.Parent;
    OddeleniTbl.Delete;
    HlavniOkno.NahrajNode(Node);
    TreeView.Selected := Node;
  end;
end;

procedure TDatabaze.SmazZamestnance;
// smaze aktualne vybraneho zamestnance
var
  Oddeleni, Trida, Funkce: Integer;
  Node: TTreeNode;
begin
  with ZamestnanecTbl, HlavniOkno do
  begin
    Node := TreeView.Selected.Parent;
    // zapamatujeme si v jakych zlozkach je obsazen
    Oddeleni := FieldByName('oddeleni').AsInteger;
    Trida := FieldByName('plat').AsInteger;
    Funkce := FieldByName('funkce').AsInteger;
    // smazeme ho ale musime zajistit aby se nevybral jiny
    try
      Upozornovat := False;
      Delete;
    finally
      Upozornovat := True;
    end;
    // obnovyme obsah vsech 3 slozek ve kterych byl obsazen
    if Oddeleni = 0 then NahrajNode(StrukturaNode)
      else NahrajNode(NajdiNode(StrukturaNode, niOddeleni, Pointer(Oddeleni)));
    NahrajNode(NajdiNode(FunkceNode, niFunkce, Pointer(Funkce)));
    NahrajNode(NajdiNode(PlatyNode, niTrida, Pointer(Trida)));
    // vybereme nadrizenou slozku
    TreeView.Selected := nil;
    TreeView.Selected := Node;
  end;
end;

procedure TDatabaze.SmazFunkci;
// smaze aktualne vybranou funkci
var
  PActive: Boolean;
begin
  with FunkceTbl, HlavniOkno do
  begin
    // zaznamename stav tabulky
    PActive := Active;
    try
      // pokud tabulka neni otevrena otevreme ji
      if not PActive then Open;
      // smazeme ho ale musime zajistit aby se nevybrala jina
      Upozornovat := False;
      Delete;
      Upozornovat := True;
      // obnovime slozku funkci
      NahrajNode(FunkceNode);
    finally
      // obnovime stav pred otevrenim
      FunkceTbl.Active := PActive;
      // vybereme slozku funkci
      TreeView.Selected := nil;
      TreeView.Selected := FunkceNode;
    end;
  end;
end;

procedure TDatabaze.SmazTridu;
// smaze aktualne vybranou platovou tridu
var
  PActive: Boolean;
begin
  with TridaTbl, HlavniOkno do
  begin
    // zaznamename stav tabulky
    PActive := TridaTbl.Active;
    try
      // pokud tabulka neni otevrena otevreme ji
      if not PActive then Open;
      // smazeme ji ale musime zajistit aby se nevybrala jina
      Upozornovat := False;
      Delete;
      Upozornovat := True;
      // obnovime slozku platovych trid
      NahrajNode(PlatyNode);
    finally
      // obnovime stav pred otevrenim
      TridaTbl.Active := PActive;
      // vybereme slozku platovych trid
      TreeView.Selected := nil;
      TreeView.Selected := PlatyNode;
    end;
  end;
end;

function TDatabaze.OddeleniSQL(Oddeleni: Integer; Sloupec: string): string;
// vytvori podminku pro SQL dotaz na vyhledani vsech radku
// v tabulce jejich atribut Sloupec se rovna cislo Oddeleni nebo nejakeho
// z podrizennych oddeleni
const
  SFormat = '%s%s=%d or ';
var
  aSQL: string;
begin
  // vlozime cislo zadaneho oddeleni
  // v result je pozadovany vysledek
  Result := Format(SFormat, ['', Sloupec, Oddeleni]);
  // v aSQL je podminka pro vyhledani vsech podrizennych oddeleni
  aSQL := Format(SFormat, ['', 'nadrazene', Oddeleni]);
  repeat
    // umazene koncove ' or '
    SetLength(aSQL, Length(aSQL)-4);
    with MultiQ do
    begin
      // vyhledame oddeleni splnujici podminku
      if Active then Close;
      SQL.Text := Format('select id from oddeleni where %s', [aSQL]);
      aSQL := '';
      Open;
      // a nalezene doplnime do SQL dotazu
      while not EOF do
      begin
        Result := Format(SFormat, [Result, Sloupec, FieldByName('id').AsInteger]);
        aSQL := Format(SFormat, [aSQL, 'nadrazene', FieldByName('id').AsInteger]);
        Next;
      end;
      Close;
    end;
    // pokud jseme stale jeste nasli nejaka oddeleni zopakujeme cyklus pro
    // dalsi uroven
  until aSQL = '';
  // umazene koncove ' or '
  SetLength(Result, Length(Result)-4);
end;

// --------------- metody (private) ----------------------

function TDatabaze.ProvedSQL(aSQL: string): Variant;
// provede SQL dotaz a vrati hodnotu prvniho sloupecku, prvniho radku vysledku
begin
  with MultiQ do
  begin
    Close;
    SQL.Text := aSQL;
    try
      Open;
      Result := Fields[0].Value;
      Close;
    except
      Result := Unassigned;
    end;
  end;
end;

// ------------------- udalosti --------------------

procedure TDatabaze.DatabazeCreate(Sender: TObject);
begin
  Upozornovat := True;
  // na zacatku otevreme databazi
  Database.Open;
end;

procedure TDatabaze.TableAfterInsert(DataSet: TDataSet);
begin
  // pri vkladani do libovolne tabulky musim zajistit
  // abych po Post vedel ze jsem pouze needitoval, ale vkladal
  Vkladam := True;
  // pri vkladani se muze RC editovat, pri editaci uz ne
  if DataSet = ZamestnanecTbl then
    HlavniOkno.ZamestnanecRCEdit.ReadOnly := False;
end;

procedure TDatabaze.TableAfterCancel(DataSet: TDataSet);
begin
  if Vkladam then
  // pokud jsme prerusili vkladani, je treba vratit panel
  // odpovidajici naposledy vybranemu objektu
  begin
    Vkladam := False;
    with HlavniOkno do
      ZobrazPanelNode(TreeView.Selected);
  end;

  // znovu zobrazime komponenty ktere museji byt skryte pri editaci
  // vetsinou jde o jine tabulky ve vztahu master-detail
  if DataSet = ZamestnanecTbl then
  begin
    // zakazeme editace RC, pro pripad ze je povolena po vkladani
    HlavniOkno.ZamestnanecRCEdit.ReadOnly := True;
    with HlavniOkno do
    begin
      ZamestnanecNemocenskePage.TabVisible := True;
      ZamestnanecDovolenePage.TabVisible := True;
    end;
  end
    else
  if DataSet = OddeleniTbl then HlavniOkno.OddeleniPages.Visible := True
    else
  if DataSet = TridaTbl then HlavniOkno.PlatyPanel.Visible := True
    else
  if DataSet = FunkceTbl then HlavniOkno.FunkceDetailPanel.Visible := True;
end;

procedure TDatabaze.OddeleniTblAfterScroll(DataSet: TDataSet);
begin
  // pri zmene aktualni radky v tabulce Oddeleni vybereme odpovidajici
  // objekt ve stromu
  if Upozornovat and DataSet.Active then
  with HlavniOkno do
  begin
    OtevriOddeleni(DataSet.FieldByName('Nadrazene').AsInteger);
    VyberNode(StrukturaNode,
      niOddeleni, Pointer(DataSet.FieldByName('ID').AsInteger));
    ZamestnanciVseUpdate;
  end;
end;

procedure TDatabaze.OddeleniTblNewRecord(DataSet: TDataSet);
begin
  // nastavime primarni klic a inicializacni hodnoty sloupcu
  with OddeleniTbl do
  begin
    FieldByName('id').AsInteger := NewID(OddeleniTbl);
    FieldByName('nazev').AsString := 'Nov oddlen';
  end;
end;

procedure TDatabaze.OddeleniTblAfterPost(DataSet: TDataSet);
var
  ID: Integer;
begin
  with HlavniOkno, OddeleniTbl do
  begin
    ID := FieldByName('id').AsInteger;
    if Vkladam then
    // po zmene radku v tabulce Oddeleni musime prenahrat nadrizenou slozku
    // aby se zmeny projevily ve stromu
    begin
      Vkladam := False;
      NahrajNode(PopupMenus.Node);
      PopupMenus.Node.Expand(False);
    end
      else NahrajNode(TreeView.Selected.Parent);
    VyberNode(StrukturaNode, niOddeleni, Pointer(ID));
    // zobrazime skryty seznam zamestnancu
    OddeleniPages.Visible := True;
  end;
end;

procedure TDatabaze.ZamestnanecTblAfterScroll(DataSet: TDataSet);
begin
  // pri zmene aktualni radky v tabulce Zamestnanec vybereme odpovidajici
  // objekt ve stromu
  if Upozornovat and ZamestnanecTbl.Active then
  with HlavniOkno do
  begin
    OtevriOddeleni(DataSet.FieldByName('oddeleni').AsInteger);
    VyberNode(StrukturaNode,
      niZamestnanec, RCToPointer(DataSet.FieldByName('rc').AsString));
  end;
end;

procedure TDatabaze.ZamestnanecTblAfterPost(DataSet: TDataSet);
var
  RC: string;
  Node, TopN: TTreeNode;
begin
  with HlavniOkno, ZamestnanecTbl do
  begin
    TopN := TopNode(TreeView.Selected);

    // zapamatujeme si udaje o vlozenem/zeditovanem zamestnanci
    RC := FieldByName('rc').AsString;
    if FieldByName('oddeleni').AsInteger > 0 then
      Node := NajdiNode(StrukturaNode, niOddeleni,
        Pointer(FieldByName('oddeleni').AsInteger))
      else Node := StrukturaNode;
    // obnovime nadrizenou slozku v organizacni strukture
    if Node <> nil then
    begin
      NahrajNode(Node);
      if Vkladam then Node.Expand(False);
    end;
    if not Vkladam then
    begin
      // pokud jsme editovali obnovime slozky Funkce a Platova trida
      // ve kterych byl zamestnanec pred editaci (ale pouze pokud
      // je nyni v jine slozce
      if FieldByName('funkce').AsInteger <> FunkcePred then
        NahrajNode(NajdiNode(FunkceNode, niFunkce, Pointer(FunkcePred)));
      if FieldByName('plat').AsInteger <> TridaPred then
        NahrajNode(NajdiNode(PlatyNode, niTrida, Pointer(TridaPred)));
    end;
    // obnovime obsah slozek Funkce a Paltova trida ve kterych se nachazi
    // zamestnanec, pro pripad ze predtim yl v jine nebo
    // se zmenilo jeho jmeno
    NahrajNode(NajdiNode(FunkceNode, niFunkce,
      Pointer(FieldByName('funkce').AsInteger)));
    NahrajNode(NajdiNode(PlatyNode, niTrida,
      Pointer(FieldByName('plat').AsInteger)));

    // vybereme objekt odpovidajici zamestnanci ve stormu
    // ve kterem jsme dali podnet k editace, pri vkladani se
    // jedna vzdy o strom organizacni struktury
    VyberNode(TopN, niZamestnanec, RCToPointer(RC));

    // zakazeme editaci Rodneho cisla
    HlavniOkno.ZamestnanecRCEdit.ReadOnly := True;

    // zobrazime skryty seznam Nemocenskych a Dovolenych
    ZamestnanecNemocenskePage.TabVisible := True;
    ZamestnanecDovolenePage.TabVisible := True;

    Vkladam := False;
  end;
end;

procedure TDatabaze.ZamestnanecTblBeforeEditInsert(DataSet: TDataSet);
begin
  with ZamestnanecTbl do
  begin
    // zapamatujeme si funkci a Platovou tridu pro pripad ze se zmeni
    TridaPred := FieldByName('plat').AsInteger;
    FunkcePred := FieldByName('funkce').AsInteger;
  end;
  // zavreme tabulku Dovolenych a Nemocenskych ktere jsou ve vztahu
  // master-detail k Zamestnanci a skryjeme je z okna
  DovoleneQ.Close;
  NemocenskeQ.Close;
  with HlavniOkno do
  begin
    ZamestnanecPages.ActivePage := ZamestnanecPodrobnostiPage;
    ZamestnanecNemocenskePage.TabVisible := False;
    ZamestnanecDovolenePage.TabVisible := False;
  end;
end;

procedure TDatabaze.ZamestnanecTblNewRecord(DataSet: TDataSet);
begin
  // nastavime inicializacni hodnoty sloupcu
  with ZamestnanecTbl do
  begin
    FieldByName('prijmeni').AsString := 'Nov zamstnanec';
    FieldByName('prijeti').AsDateTime := Date;
  end;
end;

procedure TDatabaze.FunkceTblAfterPost(DataSet: TDataSet);
begin
  with HlavniOkno do
  begin
    // po ulozeni zmen v tabulce Funkce obnovime slozku funkci
    NahrajNode(FunkceNode);
    FunkceNode.Expand(False);
    // a vybereme tu kterou jsme vlozily/editovaly
    VyberNode(FunkceNode, niFunkce, Pointer(DataSet.FieldByName('id').AsInteger));
    FunkceDetailPanel.Visible := True;
  end;
//  ZamestnanciVseDetailQ.Open;
end;

procedure TDatabaze.FunkceTblAfterScroll(DataSet: TDataSet);
begin
  // pri zmene aktualni radky v tabulce Funkce vybereme odpovidajici
  // objekt ve stromu
  if Upozornovat and DataSet.Active  then
  with HlavniOkno do
  begin
    FunkceNode.Expand(False);
    VyberNode(FunkceNode,
      niFunkce, Pointer(DataSet.FieldByName('id').AsInteger));
    ZamestnanciVseUpdate;
  end;
end;

procedure TDatabaze.FunkceTblNewRecord(DataSet: TDataSet);
begin
  // nastavime primarni klic a inicializacni hodnoty sloupcu
  with FunkceTbl do
  begin
    FieldByName('id').AsInteger := NewID(FunkceTbl);
    FieldByName('nazev').AsString := 'Nov funkce';
  end;
end;

procedure TDatabaze.TridaTblAfterPost(DataSet: TDataSet);
begin
  // pri zmene aktualni radky v tabulce Platova trida vybereme odpovidajici
  // objekt ve stromu
  if Upozornovat and DataSet.Active  then
  with HlavniOkno do
  begin
    // po ulozeni zmen v tabulce Platova trida obnovime slozku Platovych trid
    NahrajNode(PlatyNode);
    PlatyNode.Expand(False);
    PlatyPanel.Visible := True;
    // a vybereme tu kterou jsme vlozily/editovaly
    VyberNode(PlatyNode, niTrida, Pointer(DataSet.FieldByName('id').AsInteger));
  end;
end;

procedure TDatabaze.TridaTblAfterScroll(DataSet: TDataSet);
begin
  if Upozornovat and DataSet.Active then
  with HlavniOkno do
  begin
    PlatyNode.Expand(False);
    VyberNode(PlatyNode,
      niTrida, Pointer(DataSet.FieldByName('id').AsInteger));
  end;
end;

procedure TDatabaze.TridaTblBeforeScroll(DataSet: TDataSet);
begin
  with DataSet do
    if State in [dsEdit, dsInsert] then Cancel;
end;

procedure TDatabaze.TridaTblNewRecord(DataSet: TDataSet);
begin
  // pri zmene aktualni radky v tabulce Platova funkce vybereme odpovidajici
  // objekt ve stromu
  with TridaTbl do
  begin
    FieldByName('id').AsInteger := NewID(TridaTbl);
    FieldByName('nazev').AsString := 'Nov platov tda';
  end;
end;

procedure TDatabaze.ZamestnanecTblRCValidate(Sender: TField);
var
  OK: Boolean;
  F: Extended;
begin
  // overi platnost rodneho cisla
  OK := True;
  try
    // bud je deviti-mistne
    if Length(Sender.AsString) < 9 then OK := False
      else
    // nebo je desetimistne a delitelne 11
    if Length(Sender.AsString) = 10 then
    begin
      F := StrToFloat(Sender.AsString);
      if F <> Int(F/11)*11 then OK := False;
    end;
  except
    OK := False;
  end;
  if not OK then
    raise Exception.Create('Neplatn rodn slo.');
end;

procedure TDatabaze.NepritomnostNewRecord(DataSet: TDataSet);
begin
  // nastavime primarni klic a inicializacni hodnoty sloupcu
  // spolecne pro Nemocenske a Dovolene
  with Dataset do
  begin
    FieldByName('druh').AsInteger := Integer(DataSet = NemocenskeQ);
    FieldByName('rc').AsString :=
      ZamestnanecTbl.FieldByName('rc').AsString;
    FieldByName('odkdy').AsDateTime := Date;
    FieldByName('dokdy').AsDateTime := Date;
  end;
end;

procedure TDatabaze.ZamestnanciDetailQCalcFields(DataSet: TDataSet);
begin
  // slouci prijmeni a jmeno do jednoho sloupce
  // vyuziva se pri zobrazeni needitovatelnych seznamu zamestnancu
  with DataSet do
    FieldByName('celejmeno').AsString := FormatujJmeno(
      FieldByName('prijmeni').AsString, FieldByName('jmeno').AsString);
end;

procedure TDatabaze.OddeleniTblBeforeEditInsert(DataSet: TDataSet);
begin
  // pred zapocetim editace/vkladani zavreme vsech tabulky ve
  // vztahu master-detail a sryjeme vsechny komponenty ktere
  // zobrazuji jejich obsah
  ZamestnanciDetailQ.Close;
  ZamestnanciVseDetailQ.Close;
  HlavniOkno.OddeleniPages.Visible := False;
end;

procedure TDatabaze.TridaTblBeforeEditInsert(DataSet: TDataSet);
begin
  // pred zapocetim editace/vkladani zavreme vsech tabulky ve
  // vztahu master-detail a sryjeme vsechny komponenty ktere
  // zobrazuji jejich obsah
  PlatTbl.Close;
  HlavniOkno.PlatyPanel.Visible := False;
end;

procedure TDatabaze.FunkceTblBeforeEditInsert(DataSet: TDataSet);
begin
  // pred zapocetim editace/vkladani zavreme vsech tabulky ve
  // vztahu master-detail a sryjeme vsechny komponenty ktere
  // zobrazuji jejich obsah
  ZamestnanciVseDetailQ.Close;
  HlavniOkno.FunkceDetailPanel.Visible := False;
end;

procedure TDatabaze.ZamestnanecTblCalcFields(DataSet: TDataSet);
begin
  // vypocitame plat zamestnance na zaklade doby jeho prijeti a
  // jeho platove tride
  if (not ZamestnanecTbl.FieldByName('prijeti').IsNull) and
     (not ZamestnanecTbl.FieldByName('plat').IsNull) then
  with PlatQ do
  begin
    ParamByName('rok').AsInteger :=
      Trunc((Now - ZamestnanecTbl.FieldByName('prijeti').AsDateTime) / 365.25);
    ParamByName('trida').AsInteger := ZamestnanecTbl.FieldByName('plat').AsInteger;
    try
      Open;
      ZamestnanecTbl.FieldByName('_plat').AsCurrency :=
        FieldByName('plat').AsCurrency;
      Close;
    except
    end;
  end;
  // doplnime kontanty pro propojeni s tabulkou nemocenskych a dovolenych
  ZamestnanecTbl.FieldByName('_dovolena').Value := 0;
  ZamestnanecTbl.FieldByName('_nemocenska').Value := 1;
end;

end.
