-- ============================================================
--   Database name:  BYTOVE_DRUZSTVO                           
--   DBMS name:      ORACLE Version 7.x                        
--   Created on:     24.5.1999  11:20                          
-- ============================================================

-- ============================================================
--   Table: MP_DUM                                             
-- ============================================================
create table MP_DUM
(
    CIS_DUM                 INTEGER                not null,
    ADRESA_DOMU             CHAR(80)               null    ,
    PATRA                   INTEGER                null    
        constraint CKC_PATRA_MP_DUM check (PATRA is null or (PATRA >= 0)),
    VYTAH                   NUMBER(1)              null    ,
    constraint PK_MP_DUM primary key (CIS_DUM)
)
/

-- ============================================================
--   Table: MP_UKLID                                           
-- ============================================================
create table MP_UKLID
(
    ICO_RC                  NUMBER(10)             not null,
    NAZEV                   CHAR(40)               not null,
    ADRESA_UKLID            CHAR(80)               null    ,
    KONTAKTNI_OSOBA         CHAR(40)               null    ,
    TELEFON                 CHAR(20)               null    ,
    constraint PK_MP_UKLID primary key (ICO_RC)
)
/

-- ============================================================
--   Table: MP_CIS_NAKLAD                                      
-- ============================================================
create table MP_CIS_NAKLAD
(
    CIS_NAKLAD              INTEGER                not null,
    NAZEV                   CHAR(30)               not null,
    constraint PK_MP_CIS_NAKLAD primary key (CIS_NAKLAD)
)
/

-- ============================================================
--   Table: MP_BYT                                             
-- ============================================================
create table MP_BYT
(
    CIS_DUM                 INTEGER                not null,
    CIS_BYT                 INTEGER                not null,
    VYTAPENA_PLOCHA         FLOAT                  not null
        constraint CKC_VYTAPENA_PLOCHA_MP_BYT check (VYTAPENA_PLOCHA >= 0),
    NEVYTAPENA_PLOCHA       FLOAT                  not null
        constraint CKC_NEVYTAPENA_PLOCHA_MP_BYT check (NEVYTAPENA_PLOCHA >= 0),
    PATRO                   INTEGER                null    
        constraint CKC_PATRO_MP_BYT check (PATRO is null or (PATRO >= 0)),
    BALKON                  NUMBER(1)              null    ,
    constraint PK_MP_BYT primary key (CIS_DUM, CIS_BYT)
)
/

-- ============================================================
--   Index: BYT_V_DOME_FK                                      
-- ============================================================
create index BYT_V_DOME_FK on MP_BYT (CIS_DUM asc)
/

-- ============================================================
--   Table: MP_NAKLAD                                          
-- ============================================================
create table MP_NAKLAD
(
    ROK                     INTEGER                not null
        constraint CKC_ROK_MP_NAKLA check (ROK between 1900 and 2100),
    MESIC                   SMALLINT               not null
        constraint CKC_MESIC_MP_NAKLA check (MESIC between 1 and 12),
    CIS_NAKLAD              INTEGER                not null,
    CENAZAJEDNOTKU          NUMBER(8,2)            null    
        constraint CKC_CENAZAJEDNOTKU_MP_NAKLA check (CENAZAJEDNOTKU is null or (CENAZAJEDNOTKU >= 0)),
    constraint PK_MP_NAKLAD primary key (ROK, MESIC, CIS_NAKLAD)
)
/

-- ============================================================
--   Table: MP_NAJEMNIK                                        
-- ============================================================
create table MP_NAJEMNIK
(
    CIS_DUM                 INTEGER                not null,
    CIS_BYT                 INTEGER                not null,
    DATUMOD                 DATE                   not null,
    RC                      NUMBER(10)             not null,
    DATUMDO                 DATE                   null    ,
    PRIJMENI                CHAR(30)               not null,
    JMENO                   CHAR(30)               not null,
    constraint PK_MP_NAJEMNIK primary key (CIS_DUM, CIS_BYT, DATUMOD, RC)
)
/

-- ============================================================
--   Index: NAJEMNIK_V_BYTE_FK                                 
-- ============================================================
create index NAJEMNIK_V_BYTE_FK on MP_NAJEMNIK (CIS_DUM asc, CIS_BYT asc)
/

-- ============================================================
--   Table: MP_DUM_NAKLAD                                      
-- ============================================================
create table MP_DUM_NAKLAD
(
    ROK                     INTEGER                not null
        constraint CKC_ROK_MP_DUM_N check (ROK between 1900 and 2100),
    MESIC                   SMALLINT               not null
        constraint CKC_MESIC_MP_DUM_N check (MESIC between 1 and 12),
    CIS_NAKLAD              INTEGER                not null,
    CIS_DUM                 INTEGER                not null,
    ROZPOCITAT_PODLE        SMALLINT               not null
        constraint CKC_ROZPOCITAT_PODLE_MP_DUM_N check (ROZPOCITAT_PODLE in (0,1,2)),
    SPOTREBA                FLOAT(10)              not null
        constraint CKC_SPOTREBA_MP_DUM_N check (SPOTREBA >= 0),
    constraint PK_MP_DUM_NAKLAD primary key (ROK, MESIC, CIS_NAKLAD, CIS_DUM)
)
/

-- ============================================================
--   Index: NAKLAD_DOMU_FK                                     
-- ============================================================
create index NAKLAD_DOMU_FK on MP_DUM_NAKLAD (CIS_DUM asc)
/

-- ============================================================
--   Index: CENA_NAKLADY_DOMU_FK                               
-- ============================================================
create index CENA_NAKLADY_DOMU_FK on MP_DUM_NAKLAD (ROK asc, MESIC asc, CIS_NAKLAD asc)
/

-- ============================================================
--   Table: MP_BYT_NAKLAD                                      
-- ============================================================
create table MP_BYT_NAKLAD
(
    ROK                     INTEGER                not null
        constraint CKC_ROK_MP_BYT_N check (ROK between 1900 and 2100),
    MESIC                   SMALLINT               not null
        constraint CKC_MESIC_MP_BYT_N check (MESIC between 1 and 12),
    CIS_NAKLAD              INTEGER                not null,
    CIS_DUM                 INTEGER                not null,
    CIS_BYT                 INTEGER                not null,
    SPOTREBA                FLOAT(10)              not null
        constraint CKC_SPOTREBA_MP_BYT_N check (SPOTREBA >= 0),
    constraint PK_MP_BYT_NAKLAD primary key (ROK, MESIC, CIS_NAKLAD, CIS_DUM, CIS_BYT)
)
/

-- ============================================================
--   Index: NAKLAD_BYTU_FK                                     
-- ============================================================
create index NAKLAD_BYTU_FK on MP_BYT_NAKLAD (CIS_DUM asc, CIS_BYT asc)
/

-- ============================================================
--   Index: CENA_NAKLADU_BYTU_FK                               
-- ============================================================
create index CENA_NAKLADU_BYTU_FK on MP_BYT_NAKLAD (ROK asc, MESIC asc, CIS_NAKLAD asc)
/

-- ============================================================
--   Table: MP_NAJEMNE                                         
-- ============================================================
create table MP_NAJEMNE
(
    CIS_DUM                 INTEGER                not null,
    ROK_NAJEMNE             SMALLINT               not null
        constraint CKC_ROK_NAJEMNE_MP_NAJEM check (ROK_NAJEMNE between 1900 and 2100),
    MESIC_NAJEMNE           INTEGER                not null
        constraint CKC_MESIC_NAJEMNE_MP_NAJEM check (MESIC_NAJEMNE between 1 and 12),
    CENA_VYTAPENA_PLOCHA    NUMBER(8,2)            not null
        constraint CKC_CENA_VYTAPENA_PLO_MP_NAJEM check (CENA_VYTAPENA_PLOCHA >= 0),
    CENA_NEVYTAPENA_PLOCHA  NUMBER(8,2)            not null
        constraint CKC_CENA_NEVYTAPENA_P_MP_NAJEM check (CENA_NEVYTAPENA_PLOCHA >= 0),
    constraint PK_MP_NAJEMNE primary key (CIS_DUM, ROK_NAJEMNE, MESIC_NAJEMNE)
)
/

-- ============================================================
--   Index: NAJEMNE_V_DOME_FK                                  
-- ============================================================
create index NAJEMNE_V_DOME_FK on MP_NAJEMNE (CIS_DUM asc)
/

-- ============================================================
--   Table: MP_UKLID_DOMU                                      
-- ============================================================
create table MP_UKLID_DOMU
(
    CIS_DUM                 INTEGER                not null,
    ICO_RC                  NUMBER(10)             not null,
    constraint PK_MP_UKLID_DOMU primary key (CIS_DUM, ICO_RC)
)
/

-- ============================================================
--   Index: UKLIZEN_FK                                         
-- ============================================================
create index UKLIZEN_FK on MP_UKLID_DOMU (CIS_DUM asc)
/

-- ============================================================
--   Index: UKLIZI_DUM_FK                                      
-- ============================================================
create index UKLIZI_DUM_FK on MP_UKLID_DOMU (ICO_RC asc)
/

alter table MP_BYT
    add constraint FK_MP_BYT_BYT_V_DOM_MP_DUM foreign key  (CIS_DUM)
       references MP_DUM (CIS_DUM) on delete cascade
/

alter table MP_NAKLAD
    add constraint FK_MP_NAKLA_REF_155_MP_CIS_N foreign key  (CIS_NAKLAD)
       references MP_CIS_NAKLAD (CIS_NAKLAD)
/

alter table MP_NAJEMNIK
    add constraint FK_MP_NAJEM_NAJEMNIK__MP_BYT foreign key  (CIS_DUM, CIS_BYT)
       references MP_BYT (CIS_DUM, CIS_BYT) on delete cascade
/

alter table MP_DUM_NAKLAD
    add constraint FK_MP_DUM_N_NAKLAD_DO_MP_DUM foreign key  (CIS_DUM)
       references MP_DUM (CIS_DUM) on delete cascade
/

alter table MP_DUM_NAKLAD
    add constraint FK_MP_DUM_N_CENA_NAKL_MP_NAKLA foreign key  (CIS_NAKLAD, MESIC, ROK)
       references MP_NAKLAD (CIS_NAKLAD, MESIC, ROK)
/

alter table MP_BYT_NAKLAD
    add constraint FK_MP_BYT_N_NAKLAD_BY_MP_BYT foreign key  (CIS_DUM, CIS_BYT)
       references MP_BYT (CIS_DUM, CIS_BYT) on delete cascade
/

alter table MP_BYT_NAKLAD
    add constraint FK_MP_BYT_N_CENA_NAKL_MP_NAKLA foreign key  (CIS_NAKLAD, MESIC, ROK)
       references MP_NAKLAD (CIS_NAKLAD, MESIC, ROK)
/

alter table MP_NAJEMNE
    add constraint FK_MP_NAJEM_NAJEMNE_V_MP_DUM foreign key  (CIS_DUM)
       references MP_DUM (CIS_DUM) on delete cascade
/

alter table MP_UKLID_DOMU
    add constraint FK_MP_UKLID_UKLIZI_DU_MP_UKLID foreign key  (ICO_RC)
       references MP_UKLID (ICO_RC) on delete cascade
/

