-- ============================================================
--   Database name:  BYTOVE_DRUZSTVO                           
--   DBMS name:      ORACLE Version 7.x                        
--   Created on:     24.5.1999  11:20                          
-- ============================================================

-- Integrity package declaration
create or replace package IntegrityPackage AS
 procedure InitNestLevel;
 function GetNestLevel return number;
 procedure NextNestLevel;
 procedure PreviousNestLevel;
 end IntegrityPackage;
/

-- Integrity package definition
create or replace package body IntegrityPackage AS
 NestLevel number;

-- Procedure to initialize the trigger nest level
 procedure InitNestLevel is
 begin
 NestLevel := 0;
 end;


-- Function to return the trigger nest level
 function GetNestLevel return number is
 begin
 if NestLevel is null then
     NestLevel := 0;
 end if;
 return(NestLevel);
 end;

-- Procedure to increase the trigger nest level
 procedure NextNestLevel is
 begin
 if NestLevel is null then
     NestLevel := 0;
 end if;
 NestLevel := NestLevel + 1;
 end;

-- Procedure to decrease the trigger nest level
 procedure PreviousNestLevel is
 begin
 NestLevel := NestLevel - 1;
 end;

 end IntegrityPackage;
/

--  Before insert trigger "tib_mp_byt" for table "MP_BYT"
create trigger tib_mp_byt before insert
on MP_BYT for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    x_patra          integer;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_DUM"
    cursor cpk1_mp_byt(var_cis_dum integer) is
       select 1
       from   MP_DUM
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;

begin
    
    --  Parent "MP_DUM" must exist when inserting a child in "MP_BYT"
    if :new.CIS_DUM is not null then
       open  cpk1_mp_byt(:new.CIS_DUM);
       fetch cpk1_mp_byt into dummy;
       found := cpk1_mp_byt%FOUND;
       close cpk1_mp_byt;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_DUM". Cannot create child in "MP_BYT".';
          raise integrity_error;
       end if;
    end if;
--  Nelze vlozit vyssi patro nez kolik ma dum
    select patra into x_patra 
      from MP_DUM 
      where CIS_DUM = :new.Cis_Dum;
    if :new.patro > x_patra then
      errno  := -20123;
      errmsg := 'Nelze zadat vyssi patro nez je vyska domu';
      raise integrity_error;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before update trigger "tub_mp_byt" for table "MP_BYT"
create trigger tub_mp_byt before update
of CIS_DUM,
   CIS_BYT
on MP_BYT for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    x_patra          integer;
    seq NUMBER;
    
    --  Declaration of UpdateChildParentExist constraint for the parent "MP_DUM"
    cursor cpk1_mp_byt(var_cis_dum integer) is
       select 1
       from   MP_DUM
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;
    
    --  Declaration of UpdateParentRestrict constraint for "MP_NAJEMNIK"
    cursor cfk1_mp_byt(var_cis_dum integer,
                       var_cis_byt integer) is
       select 1
       from   MP_NAJEMNIK
       where  CIS_DUM = var_cis_dum
        and   CIS_BYT = var_cis_byt
        and   var_cis_dum is not null
        and   var_cis_byt is not null;
    
    --  Declaration of UpdateParentRestrict constraint for "MP_BYT_NAKLAD"
    cursor cfk2_mp_byt(var_cis_dum integer,
                       var_cis_byt integer) is
       select 1
       from   MP_BYT_NAKLAD
       where  CIS_DUM = var_cis_dum
        and   CIS_BYT = var_cis_byt
        and   var_cis_dum is not null
        and   var_cis_byt is not null;

begin
    seq := IntegrityPackage.GetNestLevel;
    
    --  Parent "MP_DUM" must exist when updating a child in "MP_BYT"
    if (:new.CIS_DUM is not null) and (seq = 0) then 
       open  cpk1_mp_byt(:new.CIS_DUM);
       fetch cpk1_mp_byt into dummy;
       found := cpk1_mp_byt%FOUND;
       close cpk1_mp_byt;
       if not found then
          errno  := -20003;
          errmsg := 'Parent does not exist in "MP_DUM". Cannot update child in "MP_BYT".';
          raise integrity_error;
       end if;
    end if;
    
    --  Cannot modify parent code in "MP_BYT" if children still exist in "MP_NAJEMNIK"
    if (updating('CIS_DUM') and :old.CIS_DUM != :new.CIS_DUM) or
       (updating('CIS_BYT') and :old.CIS_BYT != :new.CIS_BYT) then
       open  cfk1_mp_byt(:old.CIS_DUM,
                         :old.CIS_BYT);
       fetch cfk1_mp_byt into dummy;
       found := cfk1_mp_byt%FOUND;
       close cfk1_mp_byt;
       if found then
          errno  := -20005;
          errmsg := 'Children still exist in "MP_NAJEMNIK". Cannot modify parent code in "MP_BYT".';
          raise integrity_error;
       end if;
    end if;
    
    --  Cannot modify parent code in "MP_BYT" if children still exist in "MP_BYT_NAKLAD"
    if (updating('CIS_DUM') and :old.CIS_DUM != :new.CIS_DUM) or
       (updating('CIS_BYT') and :old.CIS_BYT != :new.CIS_BYT) then
       open  cfk2_mp_byt(:old.CIS_DUM,
                         :old.CIS_BYT);
       fetch cfk2_mp_byt into dummy;
       found := cfk2_mp_byt%FOUND;
       close cfk2_mp_byt;
       if found then
          errno  := -20005;
          errmsg := 'Children still exist in "MP_BYT_NAKLAD". Cannot modify parent code in "MP_BYT".';
          raise integrity_error;
       end if;
    end if;
--  Nelze vlozit vyssi patro nez kolik ma dum
    select patra into x_patra 
      from MP_DUM 
      where CIS_DUM = :new.Cis_Dum;
    if :new.patro > x_patra then
      errno  := -20123;
      errmsg := 'Nelze zadat vyssi patro nez je vyska domu';
      raise integrity_error;
    end if;
--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before insert trigger "tib_mp_byt_naklad" for table "MP_BYT_NAKLAD"
create trigger tib_mp_byt_naklad before insert
on MP_BYT_NAKLAD for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_BYT"
    cursor cpk1_mp_byt_naklad(var_cis_dum integer,
                              var_cis_byt integer) is
       select 1
       from   MP_BYT
       where  CIS_DUM = var_cis_dum
        and   CIS_BYT = var_cis_byt
        and   var_cis_dum is not null
        and   var_cis_byt is not null;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_NAKLAD"
    cursor cpk2_mp_byt_naklad(var_cis_naklad integer,
                              var_mesic integer,
                              var_rok integer) is
       select 1
       from   MP_NAKLAD
       where  CIS_NAKLAD = var_cis_naklad
        and   MESIC = var_mesic
        and   ROK = var_rok
        and   var_cis_naklad is not null
        and   var_mesic is not null
        and   var_rok is not null;

begin
    
    --  Parent "MP_BYT" must exist when inserting a child in "MP_BYT_NAKLAD"
    if :new.CIS_DUM is not null and
       :new.CIS_BYT is not null then
       open  cpk1_mp_byt_naklad(:new.CIS_DUM,
                                :new.CIS_BYT);
       fetch cpk1_mp_byt_naklad into dummy;
       found := cpk1_mp_byt_naklad%FOUND;
       close cpk1_mp_byt_naklad;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_BYT". Cannot create child in "MP_BYT_NAKLAD".';
          raise integrity_error;
       end if;
    end if;
    
    --  Parent "MP_NAKLAD" must exist when inserting a child in "MP_BYT_NAKLAD"
    if :new.CIS_NAKLAD is not null and
       :new.MESIC is not null and
       :new.ROK is not null then
       open  cpk2_mp_byt_naklad(:new.CIS_NAKLAD,
                                :new.MESIC,
                                :new.ROK);
       fetch cpk2_mp_byt_naklad into dummy;
       found := cpk2_mp_byt_naklad%FOUND;
       close cpk2_mp_byt_naklad;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_NAKLAD". Cannot create child in "MP_BYT_NAKLAD".';
          raise integrity_error;
       end if;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  After update trigger "tua_mp_dum" for table "MP_DUM"
create trigger tua_mp_dum after update
of CIS_DUM
on MP_DUM for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
begin
    IntegrityPackage.NextNestLevel;
    
    --  Modify parent code of "MP_DUM" for all children in "MP_UKLID_DOMU"
    if (updating('CIS_DUM') and :old.CIS_DUM != :new.CIS_DUM) then
       update MP_UKLID_DOMU
        set   CIS_DUM = :new.CIS_DUM
       where  CIS_DUM = :old.CIS_DUM;
    end if;
    IntegrityPackage.PreviousNestLevel;

--  gestion des erreurs
exception
    when integrity_error then
       begin
       IntegrityPackage.InitNestLevel;
       raise_application_error(errno, errmsg);
       end;
end;
/

--  Before delete trigger "tdb_mp_dum" for table "MP_DUM"
create trigger tdb_mp_dum before delete
on MP_DUM for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    
    --  Declaration of DeleteParentRestrict constraint for "MP_UKLID_DOMU"
    cursor cfk1_mp_dum(var_cis_dum integer) is
       select 1
       from   MP_UKLID_DOMU
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;

begin
    
    --  Cannot delete parent "MP_DUM" if children still exist in "MP_UKLID_DOMU"
    open  cfk1_mp_dum(:old.CIS_DUM);
    fetch cfk1_mp_dum into dummy;
    found := cfk1_mp_dum%FOUND;
    close cfk1_mp_dum;
    if found then
       errno  := -20006;
       errmsg := 'Children still exist in "MP_UKLID_DOMU". Cannot delete parent "MP_DUM".';
       raise integrity_error;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before insert trigger "tib_mp_dum_naklad" for table "MP_DUM_NAKLAD"
create trigger tib_mp_dum_naklad before insert
on MP_DUM_NAKLAD for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_DUM"
    cursor cpk1_mp_dum_naklad(var_cis_dum integer) is
       select 1
       from   MP_DUM
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_NAKLAD"
    cursor cpk2_mp_dum_naklad(var_cis_naklad integer,
                              var_mesic integer,
                              var_rok integer) is
       select 1
       from   MP_NAKLAD
       where  CIS_NAKLAD = var_cis_naklad
        and   MESIC = var_mesic
        and   ROK = var_rok
        and   var_cis_naklad is not null
        and   var_mesic is not null
        and   var_rok is not null;

begin
    
    --  Parent "MP_DUM" must exist when inserting a child in "MP_DUM_NAKLAD"
    if :new.CIS_DUM is not null then
       open  cpk1_mp_dum_naklad(:new.CIS_DUM);
       fetch cpk1_mp_dum_naklad into dummy;
       found := cpk1_mp_dum_naklad%FOUND;
       close cpk1_mp_dum_naklad;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_DUM". Cannot create child in "MP_DUM_NAKLAD".';
          raise integrity_error;
       end if;
    end if;
    
    --  Parent "MP_NAKLAD" must exist when inserting a child in "MP_DUM_NAKLAD"
    if :new.CIS_NAKLAD is not null and
       :new.MESIC is not null and
       :new.ROK is not null then
       open  cpk2_mp_dum_naklad(:new.CIS_NAKLAD,
                                :new.MESIC,
                                :new.ROK);
       fetch cpk2_mp_dum_naklad into dummy;
       found := cpk2_mp_dum_naklad%FOUND;
       close cpk2_mp_dum_naklad;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_NAKLAD". Cannot create child in "MP_DUM_NAKLAD".';
          raise integrity_error;
       end if;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before insert trigger "tib_mp_najemne" for table "MP_NAJEMNE"
create trigger tib_mp_najemne before insert
on MP_NAJEMNE for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_DUM"
    cursor cpk1_mp_najemne(var_cis_dum integer) is
       select 1
       from   MP_DUM
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;

begin
    
    --  Parent "MP_DUM" must exist when inserting a child in "MP_NAJEMNE"
    if :new.CIS_DUM is not null then
       open  cpk1_mp_najemne(:new.CIS_DUM);
       fetch cpk1_mp_najemne into dummy;
       found := cpk1_mp_najemne%FOUND;
       close cpk1_mp_najemne;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_DUM". Cannot create child in "MP_NAJEMNE".';
          raise integrity_error;
       end if;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before insert trigger "tib_mp_najemnik" for table "MP_NAJEMNIK"
create trigger tib_mp_najemnik before insert
on MP_NAJEMNIK for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    x_mesic          integer;
    x_den            integer;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_BYT"
    cursor cpk1_mp_najemnik(var_cis_dum integer,
                            var_cis_byt integer) is
       select 1
       from   MP_BYT
       where  CIS_DUM = var_cis_dum
        and   CIS_BYT = var_cis_byt
        and   var_cis_dum is not null
        and   var_cis_byt is not null;

begin
    
    --  Parent "MP_BYT" must exist when inserting a child in "MP_NAJEMNIK"
    if :new.CIS_DUM is not null and
       :new.CIS_BYT is not null then
       open  cpk1_mp_najemnik(:new.CIS_DUM,
                              :new.CIS_BYT);
       fetch cpk1_mp_najemnik into dummy;
       found := cpk1_mp_najemnik%FOUND;
       close cpk1_mp_najemnik;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_BYT". Cannot create child in "MP_NAJEMNIK".';
          raise integrity_error;
       end if;
    end if;
--  Nelze se odhlasit pred nastehovanim
    if :new.datumdo is not null and
       :new.datumod > :new.datumdo then
      errno  := -20124;
      errmsg := 'Nelze se odhlasit pred nastehovanim';
      raise integrity_error;
    end if;
--- jednoducha kontrola RC.
    x_mesic := mod(trunc(:new.RC / 1000000), 50);
    x_den := mod(trunc(:new.RC / 10000), 100);
    if (mod(:new.RC, 11) <> 0) or
       (x_mesic < 1) or (x_mesic > 12) or
       (x_den < 1) or (x_den > 31) then
      errno  := -20125;
      errmsg := 'Neplatne rodne cislo';
      raise integrity_error;
    end if;
--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before update trigger "tub_mp_najemnik" for table "MP_NAJEMNIK"
create trigger tub_mp_najemnik before update
of CIS_DUM,
   CIS_BYT,
   DATUMOD,
   RC
on MP_NAJEMNIK for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    x_mesic          integer;
    x_den            integer;
    seq NUMBER;
    
    --  Declaration of UpdateChildParentExist constraint for the parent "MP_BYT"
    cursor cpk1_mp_najemnik(var_cis_dum integer,
                            var_cis_byt integer) is
       select 1
       from   MP_BYT
       where  CIS_DUM = var_cis_dum
        and   CIS_BYT = var_cis_byt
        and   var_cis_dum is not null
        and   var_cis_byt is not null;

begin
    seq := IntegrityPackage.GetNestLevel;
    
    --  Parent "MP_BYT" must exist when updating a child in "MP_NAJEMNIK"
    if (:new.CIS_DUM is not null) and
       (:new.CIS_BYT is not null) and (seq = 0) then 
       open  cpk1_mp_najemnik(:new.CIS_DUM,
                              :new.CIS_BYT);
       fetch cpk1_mp_najemnik into dummy;
       found := cpk1_mp_najemnik%FOUND;
       close cpk1_mp_najemnik;
       if not found then
          errno  := -20003;
          errmsg := 'Parent does not exist in "MP_BYT". Cannot update child in "MP_NAJEMNIK".';
          raise integrity_error;
       end if;
    end if;
--  Nelze se odhlasit pred nastehovanim
    if :new.datumdo is not null and
       :new.datumod > :new.datumdo then
      errno  := -20124;
      errmsg := 'Nelze se odhlasit pred nastehovanim';
      raise integrity_error;
    end if;
--- jednoducha kontrola RC.
    x_mesic := mod(trunc(:new.RC / 1000000), 50);
    x_den := mod(trunc(:new.RC / 10000), 100);
    if (mod(:new.RC, 11) <> 0) or
       (x_mesic < 1) or (x_mesic > 12) or
       (x_den < 1) or (x_den > 31) then
      errno  := -20125;
      errmsg := 'Neplatne rodne cislo';
      raise integrity_error;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before insert trigger "tib_mp_naklad" for table "MP_NAKLAD"
create trigger tib_mp_naklad before insert
on MP_NAKLAD for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_CIS_NAKLAD"
    cursor cpk1_mp_naklad(var_cis_naklad integer) is
       select 1
       from   MP_CIS_NAKLAD
       where  CIS_NAKLAD = var_cis_naklad
        and   var_cis_naklad is not null;

begin
    
    --  Parent "MP_CIS_NAKLAD" must exist when inserting a child in "MP_NAKLAD"
    if :new.CIS_NAKLAD is not null then
       open  cpk1_mp_naklad(:new.CIS_NAKLAD);
       fetch cpk1_mp_naklad into dummy;
       found := cpk1_mp_naklad%FOUND;
       close cpk1_mp_naklad;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_CIS_NAKLAD". Cannot create child in "MP_NAKLAD".';
          raise integrity_error;
       end if;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before insert trigger "tib_mp_uklid_domu" for table "MP_UKLID_DOMU"
create trigger tib_mp_uklid_domu before insert
on MP_UKLID_DOMU for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_DUM"
    cursor cpk1_mp_uklid_domu(var_cis_dum integer) is
       select 1
       from   MP_DUM
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;
    
    --  Declaration of InsertChildParentExist constraint for the parent "MP_UKLID"
    cursor cpk2_mp_uklid_domu(var_ico_rc number) is
       select 1
       from   MP_UKLID
       where  ICO_RC = var_ico_rc
        and   var_ico_rc is not null;

begin
    
    --  Parent "MP_DUM" must exist when inserting a child in "MP_UKLID_DOMU"
    if :new.CIS_DUM is not null then
       open  cpk1_mp_uklid_domu(:new.CIS_DUM);
       fetch cpk1_mp_uklid_domu into dummy;
       found := cpk1_mp_uklid_domu%FOUND;
       close cpk1_mp_uklid_domu;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_DUM". Cannot create child in "MP_UKLID_DOMU".';
          raise integrity_error;
       end if;
    end if;
    
    --  Parent "MP_UKLID" must exist when inserting a child in "MP_UKLID_DOMU"
    if :new.ICO_RC is not null then
       open  cpk2_mp_uklid_domu(:new.ICO_RC);
       fetch cpk2_mp_uklid_domu into dummy;
       found := cpk2_mp_uklid_domu%FOUND;
       close cpk2_mp_uklid_domu;
       if not found then
          errno  := -20002;
          errmsg := 'Parent does not exist in "MP_UKLID". Cannot create child in "MP_UKLID_DOMU".';
          raise integrity_error;
       end if;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

--  Before update trigger "tub_mp_uklid_domu" for table "MP_UKLID_DOMU"
create trigger tub_mp_uklid_domu before update
of CIS_DUM,
   ICO_RC
on MP_UKLID_DOMU for each row
declare
    integrity_error  exception;
    errno            integer;
    errmsg           char(200);
    dummy            integer;
    found            boolean;
    seq NUMBER;
    
    --  Declaration of UpdateChildParentExist constraint for the parent "MP_DUM"
    cursor cpk1_mp_uklid_domu(var_cis_dum integer) is
       select 1
       from   MP_DUM
       where  CIS_DUM = var_cis_dum
        and   var_cis_dum is not null;
    
    --  Declaration of UpdateChildParentExist constraint for the parent "MP_UKLID"
    cursor cpk2_mp_uklid_domu(var_ico_rc number) is
       select 1
       from   MP_UKLID
       where  ICO_RC = var_ico_rc
        and   var_ico_rc is not null;

begin
    seq := IntegrityPackage.GetNestLevel;
    
    --  Parent "MP_DUM" must exist when updating a child in "MP_UKLID_DOMU"
    if (:new.CIS_DUM is not null) and (seq = 0) then 
       open  cpk1_mp_uklid_domu(:new.CIS_DUM);
       fetch cpk1_mp_uklid_domu into dummy;
       found := cpk1_mp_uklid_domu%FOUND;
       close cpk1_mp_uklid_domu;
       if not found then
          errno  := -20003;
          errmsg := 'Parent does not exist in "MP_DUM". Cannot update child in "MP_UKLID_DOMU".';
          raise integrity_error;
       end if;
    end if;
    
    --  Parent "MP_UKLID" must exist when updating a child in "MP_UKLID_DOMU"
    if (:new.ICO_RC is not null) and (seq = 0) then 
       open  cpk2_mp_uklid_domu(:new.ICO_RC);
       fetch cpk2_mp_uklid_domu into dummy;
       found := cpk2_mp_uklid_domu%FOUND;
       close cpk2_mp_uklid_domu;
       if not found then
          errno  := -20003;
          errmsg := 'Parent does not exist in "MP_UKLID". Cannot update child in "MP_UKLID_DOMU".';
          raise integrity_error;
       end if;
    end if;

--  Errors handling
exception
    when integrity_error then
       raise_application_error(errno, errmsg);
end;
/

