CREATE TABLE [DWE_C_DATUM] (
	[DATUM] [datetime] NOT NULL ,
	[ROK] [int] NOT NULL ,
	[PULROK] [int] NOT NULL ,
	[NAZEV_KVARTALU] [char] (20) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV_MESICE] [char] (20) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV_DNE] [char] (20) COLLATE Czech_CI_AS NOT NULL ,
	[POR_KVARTALU] [int] NOT NULL ,
	[POR_MESICE] [int] NOT NULL ,
	[POR_MESICE_V_KVARTALU] [int] NOT NULL ,
	[POR_DEKADY] [int] NOT NULL ,
	[POR_DEKADY_V_KVARTALU] [int] NOT NULL ,
	[POR_DEKADY_V_MESICI] [int] NOT NULL ,
	[POR_TYDNE] [int] NOT NULL ,
	[POR_TYDNE_V_KVARTALU] [int] NOT NULL ,
	[POR_TYDNE_V_MESICI] [int] NOT NULL ,
	[POR_DNE] [int] NOT NULL ,
	[POR_DNE_V_KVARTALU] [int] NOT NULL ,
	[POR_DNE_V_MESICI] [int] NOT NULL ,
	[POR_DNE_V_DEKADE] [int] NOT NULL ,
	[POR_DNE_V_TYDNU] [int] NOT NULL ,
	CONSTRAINT [PK_DWE_C_DATUM] PRIMARY KEY  CLUSTERED 
	(
		[DATUM]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_CINNOST] (
	[CINNOST] [char] (3) COLLATE Czech_CI_AS NOT NULL ,
	[POPIS] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	[USEK_CINNOSTI] [int] NOT NULL ,
	CONSTRAINT [PK_DWE_D_CINNOST] PRIMARY KEY  CLUSTERED 
	(
		[CINNOST]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_KRAJ] (
	[KRAJ] [char] (2) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_KRAJ] PRIMARY KEY  CLUSTERED 
	(
		[KRAJ]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_OKRES] (
	[OKRES] [char] (3) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	[KRAJ] [char] (2) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_OKRES] PRIMARY KEY  CLUSTERED 
	(
		[OKRES]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_D_OK_RELATION__DWE_D_KR] FOREIGN KEY 
	(
		[KRAJ]
	) REFERENCES [DWE_D_KRAJ] (
		[KRAJ]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_PARTNER] (
	[PARTNER] [char] (8) COLLATE Czech_CI_AS NOT NULL ,
	[STAT] [char] (2) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	[ULICE] [varchar] (35) COLLATE Czech_CI_AS NOT NULL ,
	[MESTO] [varchar] (35) COLLATE Czech_CI_AS NOT NULL ,
	[PSC] [char] (10) COLLATE Czech_CI_AS NOT NULL ,
	[OKRES] [char] (3) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_PARTNER] PRIMARY KEY  CLUSTERED 
	(
		[PARTNER]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_D_PA_RELATION__DWE_D_OK] FOREIGN KEY 
	(
		[OKRES]
	) REFERENCES [DWE_D_OKRES] (
		[OKRES]
	),
	CONSTRAINT [FK_DWE_D_PA_RELATION__DWE_D_ST] FOREIGN KEY 
	(
		[STAT]
	) REFERENCES [DWE_D_STAT] (
		[STAT]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_SPOLECNOST] (
	[SPOLECNOST] [int] NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_SPOLECNOST] PRIMARY KEY  CLUSTERED 
	(
		[SPOLECNOST]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_SPOLUPRACE] (
	[SPOLUPRACE] [numeric](18, 0) IDENTITY (1, 1) NOT NULL ,
	[CINNOST] [char] (3) COLLATE Czech_CI_AS NOT NULL ,
	[SPOLECNOST] [int] NOT NULL ,
	[STREDISKO] [int] NOT NULL ,
	[POPIS] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_SPOLUPRACE] PRIMARY KEY  CLUSTERED 
	(
		[SPOLUPRACE]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_D_SP_RELATION__DWE_D_CI] FOREIGN KEY 
	(
		[CINNOST]
	) REFERENCES [DWE_D_CINNOST] (
		[CINNOST]
	),
	CONSTRAINT [FK_DWE_D_SP_RELATION__DWE_D_SP] FOREIGN KEY 
	(
		[SPOLECNOST]
	) REFERENCES [DWE_D_SPOLECNOST] (
		[SPOLECNOST]
	),
	CONSTRAINT [FK_DWE_D_SP_RELATION__DWE_D_ST] FOREIGN KEY 
	(
		[STREDISKO]
	) REFERENCES [DWE_D_STREDISKO] (
		[STREDISKO]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_STAT] (
	[STAT] [char] (2) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_STAT] PRIMARY KEY  CLUSTERED 
	(
		[STAT]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_STREDISKO] (
	[STREDISKO] [int] NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_STREDISKO] PRIMARY KEY  CLUSTERED 
	(
		[STREDISKO]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_D_TYP_TRANSAKCE] (
	[TYP_TRANSAKCE] [char] (2) COLLATE Czech_CI_AS NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	[SKUPINA_TRANSAKCE] [int] NOT NULL ,
	[NAZEV_SKUPINY] [varchar] (100) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_D_TYP_TRANSAKCE] PRIMARY KEY  CLUSTERED 
	(
		[TYP_TRANSAKCE]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


CREATE TABLE [DWE_F] (
	[DATUM] [datetime] NOT NULL ,
	[SPOLUPRACE] [numeric](18, 0) NOT NULL ,
	[ANALYTIKA] [char] (10) COLLATE Czech_CI_AS NOT NULL ,
	[PARTNER] [char] (8) COLLATE Czech_CI_AS NOT NULL ,
	[TYP_TRANSAKCE] [char] (2) COLLATE Czech_CI_AS NOT NULL ,
	[ZDROJ_TRAN] [char] (1) COLLATE Czech_CI_AS NOT NULL ,
	[CISLO_DOKLADU] [char] (8) COLLATE Czech_CI_AS NOT NULL ,
	[RADEK_DOKLADU] [int] NOT NULL ,
	[MD] [money] NOT NULL ,
	[DAL] [money] NOT NULL ,
	[OBRAT] [money] NOT NULL ,
	CONSTRAINT [PK_DWE_F] PRIMARY KEY  CLUSTERED 
	(
		[DATUM],
		[SPOLUPRACE],
		[ANALYTIKA],
		[PARTNER],
		[TYP_TRANSAKCE],
		[ZDROJ_TRAN],
		[CISLO_DOKLADU],
		[RADEK_DOKLADU]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_F_RELATION__DWE_C_DA] FOREIGN KEY 
	(
		[DATUM]
	) REFERENCES [DWE_C_DATUM] (
		[DATUM]
	),
	CONSTRAINT [FK_DWE_F_RELATION__DWE_D_PA] FOREIGN KEY 
	(
		[PARTNER]
	) REFERENCES [DWE_D_PARTNER] (
		[PARTNER]
	),
	CONSTRAINT [FK_DWE_F_RELATION__DWE_D_SP] FOREIGN KEY 
	(
		[SPOLUPRACE]
	) REFERENCES [DWE_D_SPOLUPRACE] (
		[SPOLUPRACE]
	),
	CONSTRAINT [FK_DWE_F_RELATION__DWE_D_TY] FOREIGN KEY 
	(
		[TYP_TRANSAKCE]
	) REFERENCES [DWE_D_TYP_TRANSAKCE] (
		[TYP_TRANSAKCE]
	),
	CONSTRAINT [FK_DWE_F_RELATION__DWE_OSNO] FOREIGN KEY 
	(
		[ANALYTIKA]
	) REFERENCES [DWE_OSNOVA] (
		[ANALYTIKA]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_OSNOVA] (
	[ANALYTIKA] [char] (10) COLLATE Czech_CI_AS NOT NULL ,
	[SYNTETIKA] [int] NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	[POVAHA_UCTU] [int] NOT NULL ,
	CONSTRAINT [PK_DWE_OSNOVA] PRIMARY KEY  CLUSTERED 
	(
		[ANALYTIKA]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_OSNO_RELATION__DWE_SYNT] FOREIGN KEY 
	(
		[SYNTETIKA]
	) REFERENCES [DWE_SYNTETIKA] (
		[SYNTETIKA]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_SKUPINA] (
	[SKUPINA] [int] NOT NULL ,
	[TRIDA] [int] NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_SKUPINA] PRIMARY KEY  CLUSTERED 
	(
		[SKUPINA]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_SKUP_RELATION__DWE_TRID] FOREIGN KEY 
	(
		[TRIDA]
	) REFERENCES [DWE_TRIDA] (
		[TRIDA]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_SYNTETIKA] (
	[SYNTETIKA] [int] NOT NULL ,
	[SKUPINA] [int] NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_SYNTETIKA] PRIMARY KEY  CLUSTERED 
	(
		[SYNTETIKA]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_DWE_SYNT_RELATION__DWE_SKUP] FOREIGN KEY 
	(
		[SKUPINA]
	) REFERENCES [DWE_SKUPINA] (
		[SKUPINA]
	)
) ON [PRIMARY]
GO


CREATE TABLE [DWE_TRIDA] (
	[TRIDA] [int] NOT NULL ,
	[NAZEV] [varchar] (50) COLLATE Czech_CI_AS NOT NULL ,
	CONSTRAINT [PK_DWE_TRIDA] PRIMARY KEY  CLUSTERED 
	(
		[TRIDA]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO


