/* ============================================================ */
/*   Database name:  MODEL_33                                   */
/*   DBMS name:      Microsoft SQL Server 6.0                   */
/*   Created on:     4.4.2001  16:03                            */
/* ============================================================ */

if exists (select 1
            from  sysobjects
           where  name = 'DWE_F'
            and   type = 'U')
   drop table DWE_F
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_CINNOST'
            and   type = 'U')
   drop table DWE_D_CINNOST
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_STREDISKO'
            and   type = 'U')
   drop table DWE_D_STREDISKO
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_OSNOVA'
            and   type = 'U')
   drop table DWE_OSNOVA
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_SYNTETIKA'
            and   type = 'U')
   drop table DWE_SYNTETIKA
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_SKUPINA'
            and   type = 'U')
   drop table DWE_SKUPINA
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_PARTNER'
            and   type = 'U')
   drop table DWE_D_PARTNER
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_OKRES'
            and   type = 'U')
   drop table DWE_D_OKRES
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_C_DATUM'
            and   type = 'U')
   drop table DWE_C_DATUM
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_SPOLECNOST'
            and   type = 'U')
   drop table DWE_D_SPOLECNOST
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_TRIDA'
            and   type = 'U')
   drop table DWE_TRIDA
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_TYP_TRANSAKCE'
            and   type = 'U')
   drop table DWE_D_TYP_TRANSAKCE
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_KRAJ'
            and   type = 'U')
   drop table DWE_D_KRAJ
go

if exists (select 1
            from  sysobjects
           where  name = 'DWE_D_STAT'
            and   type = 'U')
   drop table DWE_D_STAT
go

/* ============================================================ */
/*   Table: DWE_D_STAT                                          */
/* ============================================================ */
create table DWE_D_STAT
(
    STAT                   char(2)               not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_D_STAT primary key (STAT)
)
go

/* ============================================================ */
/*   Table: DWE_D_KRAJ                                          */
/* ============================================================ */
create table DWE_D_KRAJ
(
    KRAJ                   char(2)               not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_D_KRAJ primary key (KRAJ)
)
go

/* ============================================================ */
/*   Table: DWE_D_TYP_TRANSAKCE                                 */
/* ============================================================ */
create table DWE_D_TYP_TRANSAKCE
(
    TYP_TRANSAKCE          char(2)               not null,
    NAZEV                  varchar(50)           not null,
    SKUPINA_TRANSAKCE      int                   not null,
    NAZEV_SKUPINY          varchar(100)          not null,
    constraint PK_DWE_D_TYP_TRANSAKCE primary key (TYP_TRANSAKCE)
)
go

/* ============================================================ */
/*   Table: DWE_TRIDA                                           */
/* ============================================================ */
create table DWE_TRIDA
(
    TRIDA                  int                   not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_TRIDA primary key (TRIDA)
)
go

/* ============================================================ */
/*   Table: DWE_D_SPOLECNOST                                    */
/* ============================================================ */
create table DWE_D_SPOLECNOST
(
    SPOLECNOST             int                   not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_D_SPOLECNOST primary key (SPOLECNOST)
)
go

/* ============================================================ */
/*   Table: DWE_C_DATUM                                         */
/* ============================================================ */
create table DWE_C_DATUM
(
    DATUM                  datetime              not null,
    ROK                    int                   not null,
    PULROK                 int                   not null,
    NAZEV_KVARTALU         char(20)              not null,
    NAZEV_MESICE           char(20)              not null,
    NAZEV_DNE              char(20)              not null,
    POR_KVARTALU           int                   not null,
    POR_MESICE             int                   not null,
    POR_MESICE_V_KVARTALU  int                   not null,
    POR_DEKADY             int                   not null,
    POR_DEKADY_V_KVARTALU  int                   not null,
    POR_DEKADY_V_MESICI    int                   not null,
    POR_TYDNE              int                   not null,
    POR_TYDNE_V_KVARTALU   int                   not null,
    POR_TYDNE_V_MESICI     int                   not null,
    POR_DNE                int                   not null,
    POR_DNE_V_KVARTALU     int                   not null,
    POR_DNE_V_MESICI       int                   not null,
    POR_DNE_V_DEKADE       int                   not null,
    POR_DNE_V_TYDNU        int                   not null,
    constraint PK_DWE_C_DATUM primary key (DATUM)
)
go

/* ============================================================ */
/*   Table: DWE_D_OKRES                                         */
/* ============================================================ */
create table DWE_D_OKRES
(
    OKRES                  char(2)               not null,
    NAZEV                  varchar(50)           not null,
    STAT                   char(2)               not null,
    constraint PK_DWE_D_OKRES primary key (OKRES)
)
go

/* ============================================================ */
/*   Index: RELATION_233_FK                                     */
/* ============================================================ */
create index RELATION_233_FK on DWE_D_OKRES (STAT)
go

/* ============================================================ */
/*   Table: DWE_D_PARTNER                                       */
/* ============================================================ */
create table DWE_D_PARTNER
(
    PARTNER                char(8)               not null,
    OKRES                  char(2)               not null,
    KRAJ                   char(2)               not null,
    NAZEV                  varchar(50)           not null,
    ULICE                  varchar(35)           not null,
    MESTO                  varchar(35)           not null,
    PSC                    char(10)              not null,
    constraint PK_DWE_D_PARTNER primary key (PARTNER)
)
go

/* ============================================================ */
/*   Index: RELATION_114_FK                                     */
/* ============================================================ */
create index RELATION_114_FK on DWE_D_PARTNER (OKRES)
go

/* ============================================================ */
/*   Index: RELATION_113_FK                                     */
/* ============================================================ */
create index RELATION_113_FK on DWE_D_PARTNER (KRAJ)
go

/* ============================================================ */
/*   Table: DWE_SKUPINA                                         */
/* ============================================================ */
create table DWE_SKUPINA
(
    SKUPINA                int                   not null,
    TRIDA                  int                   not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_SKUPINA primary key (SKUPINA)
)
go

/* ============================================================ */
/*   Index: RELATION_149_FK                                     */
/* ============================================================ */
create index RELATION_149_FK on DWE_SKUPINA (TRIDA)
go

/* ============================================================ */
/*   Table: DWE_SYNTETIKA                                       */
/* ============================================================ */
create table DWE_SYNTETIKA
(
    SYNTETIKA              int                   not null,
    SKUPINA                int                   not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_SYNTETIKA primary key (SYNTETIKA)
)
go

/* ============================================================ */
/*   Index: RELATION_144_FK                                     */
/* ============================================================ */
create index RELATION_144_FK on DWE_SYNTETIKA (SKUPINA)
go

/* ============================================================ */
/*   Table: DWE_OSNOVA                                          */
/* ============================================================ */
create table DWE_OSNOVA
(
    ANALYTIKA              char(10)              not null,
    SYNTETIKA              int                   not null,
    NAZEV                  varchar(50)           not null,
    POVAHA_UCTU            int                   not null,
    constraint PK_DWE_OSNOVA primary key (ANALYTIKA)
)
go

/* ============================================================ */
/*   Index: RELATION_138_FK                                     */
/* ============================================================ */
create index RELATION_138_FK on DWE_OSNOVA (SYNTETIKA)
go

/* ============================================================ */
/*   Table: DWE_D_STREDISKO                                     */
/* ============================================================ */
create table DWE_D_STREDISKO
(
    SPOLECNOST             int                   not null,
    STREDISKO              int                   not null,
    NAZEV                  varchar(50)           not null,
    constraint PK_DWE_D_STREDISKO primary key (SPOLECNOST, STREDISKO)
)
go

/* ============================================================ */
/*   Index: RELATION_89_FK                                      */
/* ============================================================ */
create index RELATION_89_FK on DWE_D_STREDISKO (SPOLECNOST)
go

/* ============================================================ */
/*   Table: DWE_D_CINNOST                                       */
/* ============================================================ */
create table DWE_D_CINNOST
(
    SPOLECNOST             int                   not null,
    CINNOST                char(3)               not null,
    USEK_CINNOSTI          int                   not null,
    POPIS                  varchar(50)           not null,
    constraint PK_DWE_D_CINNOST primary key (SPOLECNOST, CINNOST)
)
go

/* ============================================================ */
/*   Index: RELATION_87_FK                                      */
/* ============================================================ */
create index RELATION_87_FK on DWE_D_CINNOST (SPOLECNOST)
go

/* ============================================================ */
/*   Table: DWE_F                                               */
/* ============================================================ */
create table DWE_F
(
    ANALYTIKA              char(10)              not null,
    DATUM                  datetime              not null,
    CINNOST_SPOLECNOST     int                   not null,
    CINNOST                char(3)               not null,
    STREDISKO_SPOLECNOST   int                   not null,
    STREDISKO              int                   not null,
    PARTNER                char(8)               not null,
    TYP_TRANSAKCE          char(2)               not null,
    ZDROJ_TRAN             char(1)               not null,
    CISLO_DOKLADU          char(8)               not null,
    RADEK_DOKLADU          int                   null    ,
    AP                     money                 null    ,
    PZ                     money                 null    ,
    MD                     money                 null    ,
    DAL                    money                 null    ,
    constraint PK_DWE_F primary key (ANALYTIKA, DATUM, CINNOST_SPOLECNOST, CINNOST, STREDISKO_SPOLECNOST, STREDISKO, PARTNER, TYP_TRANSAKCE, ZDROJ_TRAN, CISLO_DOKLADU)
)
go

/* ============================================================ */
/*   Index: RELATION_196_FK                                     */
/* ============================================================ */
create index RELATION_196_FK on DWE_F (TYP_TRANSAKCE)
go

/* ============================================================ */
/*   Index: RELATION_111_FK                                     */
/* ============================================================ */
create index RELATION_111_FK on DWE_F (PARTNER)
go

/* ============================================================ */
/*   Index: RELATION_90_FK                                      */
/* ============================================================ */
create index RELATION_90_FK on DWE_F (STREDISKO_SPOLECNOST, STREDISKO)
go

/* ============================================================ */
/*   Index: RELATION_88_FK                                      */
/* ============================================================ */
create index RELATION_88_FK on DWE_F (CINNOST_SPOLECNOST, CINNOST)
go

/* ============================================================ */
/*   Index: RELATION_92_FK                                      */
/* ============================================================ */
create index RELATION_92_FK on DWE_F (DATUM)
go

/* ============================================================ */
/*   Index: RELATION_139_FK                                     */
/* ============================================================ */
create index RELATION_139_FK on DWE_F (ANALYTIKA)
go

alter table DWE_D_OKRES
    add constraint FK_DWE_D_OK_RELATION__DWE_D_ST foreign key  (STAT)
       references DWE_D_STAT (STAT)
go

alter table DWE_D_PARTNER
    add constraint FK_DWE_D_PA_RELATION__DWE_D_OK foreign key  (OKRES)
       references DWE_D_OKRES (OKRES)
go

alter table DWE_D_PARTNER
    add constraint FK_DWE_D_PA_RELATION__DWE_D_KR foreign key  (KRAJ)
       references DWE_D_KRAJ (KRAJ)
go

alter table DWE_SKUPINA
    add constraint FK_DWE_SKUP_RELATION__DWE_TRID foreign key  (TRIDA)
       references DWE_TRIDA (TRIDA)
go

alter table DWE_SYNTETIKA
    add constraint FK_DWE_SYNT_RELATION__DWE_SKUP foreign key  (SKUPINA)
       references DWE_SKUPINA (SKUPINA)
go

alter table DWE_OSNOVA
    add constraint FK_DWE_OSNO_RELATION__DWE_SYNT foreign key  (SYNTETIKA)
       references DWE_SYNTETIKA (SYNTETIKA)
go

alter table DWE_D_STREDISKO
    add constraint FK_DWE_D_ST_RELATION__DWE_D_SP foreign key  (SPOLECNOST)
       references DWE_D_SPOLECNOST (SPOLECNOST)
go

alter table DWE_D_CINNOST
    add constraint FK_DWE_D_CI_RELATION__DWE_D_SP foreign key  (SPOLECNOST)
       references DWE_D_SPOLECNOST (SPOLECNOST)
go

alter table DWE_F
    add constraint FK_DWE_F_RELATION__DWE_D_TY foreign key  (TYP_TRANSAKCE)
       references DWE_D_TYP_TRANSAKCE (TYP_TRANSAKCE)
go

alter table DWE_F
    add constraint FK_DWE_F_RELATION__DWE_D_PA foreign key  (PARTNER)
       references DWE_D_PARTNER (PARTNER)
go

alter table DWE_F
    add constraint FK_DWE_F_RELATION__DWE_D_ST foreign key  (STREDISKO_SPOLECNOST, STREDISKO)
       references DWE_D_STREDISKO (SPOLECNOST, STREDISKO)
go

alter table DWE_F
    add constraint FK_DWE_F_RELATION__DWE_D_CI foreign key  (CINNOST_SPOLECNOST, CINNOST)
       references DWE_D_CINNOST (SPOLECNOST, CINNOST)
go

alter table DWE_F
    add constraint FK_DWE_F_RELATION__DWE_C_DA foreign key  (DATUM)
       references DWE_C_DATUM (DATUM)
go

alter table DWE_F
    add constraint FK_DWE_F_RELATION__DWE_OSNO foreign key  (ANALYTIKA)
       references DWE_OSNOVA (ANALYTIKA)
go

