unit Uhlavni;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MPlayer, StdCtrls, DB, DBTables,
  Buttons, Grids, Mask, Menus,
  UNastav, UGraf, UAbout;

type
  THlavniOkno = class(TForm)
    Tabulka: TStringGrid;
    Titulek: TLabel;
    NastaveniBtn: TBitBtn;
    GrafBtn: TBitBtn;
    KonecBtn: TBitBtn;
    HlavniMenu: TMainMenu;
    Konec1: TMenuItem;
    Nastaveni1: TMenuItem;
    Graf1: TMenuItem;
    OAplikaci1: TMenuItem;
    Data1: TMenuItem;
    SmazTabulku1: TMenuItem;
    NahodneVypln1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure TabulkaColumnMoved(Sender: TObject; FromIndex,
      ToIndex: Longint);
    procedure TabulkaRowMoved(Sender: TObject; FromIndex,
      ToIndex: Longint);
    procedure Konec1Click(Sender: TObject);
    procedure Graf1Click(Sender: TObject);
    procedure Nastaveni1Click(Sender: TObject);
    procedure OAplikaci1Click(Sender: TObject);
    procedure SmazTabulku1Click(Sender: TObject);
    procedure NastaveniBtnClick(Sender: TObject);
    procedure GrafBtnClick(Sender: TObject);
    procedure KonecBtnClick(Sender: TObject);
    procedure NahodneVypln1Click(Sender: TObject);
  private
    { Private declarations }
    NazevGrafu: string;
    OsaX, OsaY: string;
    PocetRadku, PocetSloupcu: Integer;
    TypGrafu: Integer;

    procedure UpdateData;
    procedure UpdateVelikost;
  public
    { Public declarations }
  end;

var
  HlavniOkno: THlavniOkno;

implementation

{$R *.DFM}

procedure THlavniOkno.UpdateData;
var I, Ir, Isl: Integer;
begin
    { Nastaveni nadpisu a velikost tabulky }
  Titulek.Caption := NazevGrafu;
  Tabulka.RowCount := PocetRadku + 1;
  Tabulka.ColCount := PocetSloupcu + 1;

    { Pojmenovani Sloupcu }
  for I := 1 to PocetSloupcu do
    Tabulka.Cells[I, 0] := IntToStr(I);

    { Pojmenovani radek }
  for I := 1 to PocetRadku do
    Tabulka.Cells[0, I] := Char(Byte('A') + I - 1);

    { Do prazdnych policek doplni 0 }
  for Ir := 1 to PocetRadku do
  for Isl := 1 to PocetSloupcu do
    if Tabulka.Cells[Isl, Ir] = '' then
      Tabulka.Cells[Isl, Ir] := '0';
end;

procedure THlavniOkno.UpdateVelikost;
begin
    { Nedovoli mensi okno nez 400x250 }
  if ClientWidth<400 then ClientWidth := 400;
  if ClientHeight<250 then ClientHeight := 250;

    { Upravi velikost komponentu vzhledem k oknu }
  Tabulka.Width := ClientWidth - 16;
  Tabulka.Height := ClientHeight - 105;

  GrafBtn.Left := (ClientWidth - GrafBtn.Width) div 2;
  KonecBtn.Left := ClientWidth - KonecBtn.Width - 16;
  NastaveniBtn.Top := ClientHeight - 50;
  GrafBtn.Top := ClientHeight - 50;
  KonecBtn.Top := ClientHeight - 50;

  Titulek.Width := ClientWidth - 24;
end;

procedure THlavniOkno.NastaveniBtnClick(Sender: TObject);
begin
    { Nastavi dialog podle aktualniho nastaveni }
  NastaveniDlg.NazevGrafu.Text := NazevGrafu;
  NastaveniDlg.OsaX.Text := OsaX;
  NastaveniDlg.OsaY.Text := OsaY;
  NastaveniDlg.PocetRadku.Value := PocetRadku;
  NastaveniDlg.PocetSloupcu.Value := PocetSloupcu;

  if NastaveniDlg.ShowModal=mrOK then
  begin
      { Ulozi udaje zadene v dialogu }
    NazevGrafu := NastaveniDlg.NazevGrafu.Text;
    OsaX := NastaveniDlg.OsaX.Text;
    OsaY := NastaveniDlg.OsaY.Text;
    PocetRadku := NastaveniDlg.PocetRadku.Value;
    PocetSloupcu := NastaveniDlg.PocetSloupcu.Value;

    UpdateData; { Upravi dialog }
  end;
end;

procedure THlavniOkno.KonecBtnClick(Sender: TObject);
begin
  Close;   { Ukonci program }
end;

procedure THlavniOkno.GrafBtnClick(Sender: TObject);
var iRd, iSl: Integer;
    GR: TGridRect;
    A, Max, Min: Extended;
begin
  try
    with GrafDlg.Graf do
    begin
        { Nastavi popisky grafu a pocet radku/sloupcu }
      Title[2] := NazevGrafu;
      Title[0] := OsaY;
      Title[3] := OsaX;
      OpenData[COD_VALUES] :=
        MakeLong(PocetRadku, PocetSloupcu);

        { Doplni data }
      Max := 0; Min := 0;
      for iRd := 1 to PocetRadku do
      begin
        ThisSerie := iRd-1;
        for iSl := 1 to PocetSloupcu do
        begin
          A := StrToFloat(Tabulka.Cells[iSl, iRd]);
          if A > Max then Max := A;
          if A < Min then Min := A;
          Value[iSl-1] := A;
        end;
      end;
      CloseData[COD_VALUES] := 0;
        { Nastavi rozsah Y-nove osy }
      Adm[CSA_MIN] := Min;
      Adm[CSA_MAX] := Max;
    end;
    GrafDlg.ShowModal; { Spusti dialog }
  except
      { Pri chybe zobrazi chybove hlaseni }
    on EConvertError do
    begin
      GR.Left := iSl; GR.Right := iSl;
      GR.Top := iRd; GR.Bottom := iRd;
      Tabulka.Selection := GR;
      MessageDlg('patn zadn hodnoty',
        mtError, [mbOK], 0);
    end;
  end;
end;

procedure THlavniOkno.FormCreate(Sender: TObject);
begin
    { Nastavi pocatecni hodnoty }
  NazevGrafu := 'Graf 1';
  OsaX := 'X'; OsaY := 'Y';
  PocetRadku := 5; PocetSloupcu := 10;
  TypGrafu := 1;
  Randomize;

  UpdateData;
  UpdateVelikost;
end;

procedure THlavniOkno.FormResize(Sender: TObject);
begin
  UpdateVelikost;
end;

procedure THlavniOkno.TabulkaColumnMoved(Sender: TObject; FromIndex,
  ToIndex: Longint);
begin
  UpdateData;  { Upravi popisky }
end;

procedure THlavniOkno.TabulkaRowMoved(Sender: TObject; FromIndex,
  ToIndex: Longint);
begin
  UpdateData;  { Upravi popisky }
end;

procedure THlavniOkno.Konec1Click(Sender: TObject);
begin
  Close; { Ukonci program }
end;

procedure THlavniOkno.Graf1Click(Sender: TObject);
begin
  GrafBtnClick(Sender);
end;

procedure THlavniOkno.Nastaveni1Click(Sender: TObject);
begin
  Nastaveni1Click(Sender);
end;

procedure THlavniOkno.OAplikaci1Click(Sender: TObject);
begin
  AboutBox.ShowModal;  { Spusti okenko 'O Aplikaci' }
end;

procedure THlavniOkno.SmazTabulku1Click(Sender: TObject);
var Ir, Isl: Integer;
begin
    { Do vsech policek vlozi 0 }
  for Ir := 1 to PocetRadku do
  for Isl := 1 to PocetSloupcu do
    Tabulka.Cells[Isl, Ir] := '0';
end;

procedure THlavniOkno.NahodneVypln1Click(Sender: TObject);
var Ir, Isl: Integer;
begin
    { Do prazdnych policek vlozi nahodne hodnoty }
  for Ir := 1 to PocetRadku do
  for Isl := 1 to PocetSloupcu do
    if Tabulka.Cells[Isl, Ir] = '0' then
      Tabulka.Cells[Isl, Ir] := IntToStr(Random(100) + 1);
end;

end.
