PROGRAM Grafy;
{$R-}
USES Crt, Dos, Graph;

CONST GrafickeSoubory = '';

CONST kbEnter = #13;
      kbEsc =   #27;
      kbBack =  #08;

TYPE TCislo = Extended;

CONST LudolfovoCislo = 3.1415;
      RozsireneZadani: Boolean = False;

CONST PozGrafuX = 20;
      PozGrafuY = 20;
      VelGrafuX = 440;
      VelGrafuY = 440;
      OkrajGrafu = 15;

      PozInfoX = 490;
      PozInfoY = 20;
      VelInfoX = 130;
      VelInfoY = 440;
      OkrajInfo = 10;

      VelCarek = 4;

CONST OsaXMin: TCislo = -10;
      OsaXMax: TCislo = 10;
      OsaYMin: TCislo = -10;
      OsaYMax: TCislo = 10;
      JednotkyX: TCislo = 1;
      JednotkyY: TCislo = 1;
      Presnost: TCislo = 2;

CONST TypyCary: ARRAY[0..3] OF String[7] =
        ('', '', '', '-------');
      Barvy: ARRAY[0..15] OF String[13] =
        ('Cerna',        'Modra',         'Zelena',      'Kyanova',
         'Cervena',      'Mahagonova',    'Hneda',       'Seda (sv)',
         'Seda (tm)',    'Modra (sv)',    'Zelena (sv)', 'Kyanova (sv)',
         'Cervena (sv)', 'Mahagon. (sv)', 'Zluta',       'Bila');

CONST MaxDelkaFunkce = 50;
      ZnakyFunkce = ['a'..'w', 'y', 'z',
                     '^', '`', '~', '''', '"', '', '', ''];
      MaxFunkci = 10;
      PocetDemoFunkci = 8;

TYPE TTextFunkce = String[MaxDelkafunkce];
TYPE TFunkce = RECORD
       Funkce: TTextFunkce;
       TypCary: Byte;
       BarvaCary: Byte;
     END;
     TSeznamFunkci = ARRAY[1..MaxFunkci] OF TFunkce;

CONST DemoFunkce: ARRAY[1..PocetDemoFunkci] OF TFunkce =
      ((Funkce: '1/x';    TypCary: 0; BarvaCary: 1),
       (Funkce: '1/(x)'; TypCary: 0; BarvaCary: 2),
       (Funkce: 'x';    TypCary: 0; BarvaCary: 3),
       (Funkce: 'x';     TypCary: 0; BarvaCary: 4),
       (Funkce: 'x';     TypCary: 0; BarvaCary: 5),
       (Funkce: 'x`';     TypCary: 0; BarvaCary: 6),
       (Funkce: 'e x';    TypCary: 0; BarvaCary: 7),
       (Funkce: 'ln x';   TypCary: 0; BarvaCary: 8));

VAR Funkce: TSeznamFunkci;
    PocetFunkci: Integer;
    Chyba: Boolean;
    FatalniChyba: Boolean;


  { ======== POMOCNE FUNKCE A PROCEDURY =============================== }

FUNCTION OpakujZnak(Znak: Char; Pocet: Byte): String;
  { Vrati string, ktery bude obsahovat Pocet znaku Znak                 }
VAR i: Integer;
    S: String;
BEGIN
  S:='';
  FOR i:=1 TO Pocet DO S:=S+Znak;
  OpakujZnak:=S;
END;

FUNCTION DoplnZprava(S: String; Znak: Char; Delka: Byte): String;
  { Rozsiri text S o tolik znaku Znak, aby celkova delka byla Delka }
VAR i: Byte;
BEGIN
  IF Length(S)<Delka THEN
     FOR i:=Length(S)+1 TO Delka DO S:=S+Znak;
  DoplnZprava:=S;
END;

FUNCTION Pismeno(N: Byte): Char;
  { Vrati N-te pismeno anglicke abecedy }
BEGIN
  Pismeno:=Char(Byte('A')-1+N);
END;

PROCEDURE ZakladniBarva;
  { Nastavy barvu textu na zakladni }
  { Pokud chcete zmenit barvu textu, staci to provest v }
  { teto procedure }
BEGIN
  TextAttr:=LightGray;
END;

FUNCTION CisloNaText(R: TCislo): String;
  { Prevede cislo C na text a odstrani prebytecne 0 na konci desetinych mist }
  { v pripade celeho cisla i desetinou tecku }
VAR S: String;
BEGIN
  Str(R:0:10, S);
  WHILE S[Length(S)]='0' DO Dec(S[0]);
  IF S[Length(S)]='.' THEN Dec(S[0]);
  CisloNaText:=S;
END;

FUNCTION TextNaCislo(S: String): TCislo;
  { Prevede text S na realne cislo, bez kontoly spravnosti provedeni }
VAR C: TCislo;
    x: Integer;
BEGIN
  Val(S, C, x);
  TextNaCislo:=C;
END;

FUNCTION DownCases(S: String): String;
  { Vsechna velka pismena v textu S prevede na mala }
VAR i: Byte;
BEGIN
  FOR i:=1 TO Length(S) DO
  BEGIN
    IF S[i] IN ['A'..'Z'] THEN S[i]:=Char(Byte('a')+Byte(S[i])-Byte('A'));
  END;
  DownCases:=S;
END;

FUNCTION Mocnina(Zaklad: TCislo; Mocnitel: Integer): TCislo;
  { Spocita (Mocnitel)-tou mocninu cisla Zaklad }
VAR i: Integer;
    C: TCislo;
BEGIN
  C:=1;
  FOR i:=1 TO Mocnitel DO C:=C*Zaklad;
  Mocnina:=C;
END;

FUNCTION KopirujOdDo(S: String; OdPoz, DoPoz: Byte): String;
  { Vrati cast stringu S mezi pozicemi OdPoz a DoPoz }
BEGIN
  KopirujOdDo:=Copy(S, OdPoz, DoPoz-OdPoz+1);
END;

FUNCTION KopirujDoKonce(S: String; Odkud: Byte): String;
  { Vrati cast textu S od pozice Odkud az do konece stringu }
BEGIN
  KopirujDoKonce:=KopirujOdDo(S, Odkud, Length(S));
END;

PROCEDURE JeToFatalniChyba;
  { Nastavi, ze doslo k fatalni chyba (provadena funkce je nesmysl) }
BEGIN
  FatalniChyba:=True;
  Chyba:=True;
END;

  { ====== HODNOTA FUNKCE ============== }

FUNCTION FunkceZleva(Jmeno: String; Param: TCislo): TCislo;
  { Vypocita hodnotu funkce dane jejim jmenem a parametrem }
VAR H, a: TCislo;
BEGIN
  H:=0;

  IF Jmeno='abs' THEN H:=Abs(Param)
     ELSE
  IF Jmeno='sin' THEN H:=Sin(Param)
     ELSE
  IF Jmeno='cos' THEN H:=Cos(Param)
     ELSE
  IF (Jmeno='tan') OR (Jmeno='tg') THEN
  BEGIN
    a:=Cos(Param);
    IF a=0 THEN Chyba:=True
       ELSE H:=Sin(Param)/a;
  END
     ELSE
  IF (Jmeno='cotan') OR (Jmeno='cotg') THEN
  BEGIN
    a:=Sin(Param);
    IF a=0 THEN Chyba:=True
       ELSE H:=Cos(Param)/a;
  END
     ELSE
  IF (Jmeno='arctan') OR (Jmeno='arctg') THEN H:=ArcTan(Param)
     ELSE
  IF (Jmeno='arccotan') OR (Jmeno='arccotg') THEN
  BEGIN
    IF Param=0 THEN Chyba:=True
       ELSE H:=ArcTan(1/Param)
  END
     ELSE
  IF Jmeno='arcsin' THEN
  BEGIN
    a:=1-Sqr(Param);
    IF a<0 THEN Chyba:=True
       ELSE H:=ArcTan(Param/Sqrt(a))
  END
     ELSE
  IF Jmeno='arccos' THEN
  BEGIN
    a:=1-Sqr(Param);
    IF a<0 THEN Chyba:=True
       ELSE H:=ArcTan(Sqrt(a)/Param)
  END
     ELSE
  IF (Jmeno='sqrt') OR (Jmeno='') THEN
  BEGIN
    IF Param>=0 THEN H:=Sqrt(Param)
       ELSE Chyba:=True;
  END
     ELSE
  IF Jmeno='ln' THEN
  BEGIN
    IF Param>0 THEN H:=Ln(Param)
       ELSE Chyba:=True;
  END
     ELSE
  IF Jmeno='sgn' THEN
  BEGIN
    IF Param=0 THEN H:=0
       ELSE
    IF Param>0 THEN H:=1
       ELSE
    IF Param<0 THEN H:=-1;
  END
     ELSE
  IF Jmeno='e' THEN H:=Exp(Param)
     ELSE
  IF Jmeno='ran' THEN
  BEGIN
    IF Param>=0 THEN H:=Random(Round(Param*100))/100
       ELSE H:=-Random(Round(Abs(Param)*100))/100;
  END
     ELSE JeToFatalniChyba;
  FunkceZleva:=H;
END;

FUNCTION FunkceZprava(Jmeno: String; Param: TCislo): TCislo;
  { Vypocita hodnotu funkce dane jejim jmenem a parametrem }
VAR H: TCislo;
BEGIN
  H:=0;

  IF (Jmeno='^') OR (Jmeno='') THEN H:=Mocnina(Param, 2)
     ELSE
  IF Jmeno='`' THEN H:=Mocnina(Param, 3)
     ELSE
  IF Jmeno='~' THEN H:=Mocnina(Param, 4)
     ELSE
  IF Jmeno='''' THEN H:=Mocnina(Param, 5)
     ELSE
  IF Jmeno='"' THEN H:=Mocnina(Param, 6)
     ELSE JeToFatalniChyba;

  FunkceZprava:=H;
END;

FUNCTION FunkceZlevaIZprava(JmenoL, JmenoP: String; Param: TCislo): TCislo;
  { Vypocita hodnotu funkce dane jejim jmenem a parametrem }
VAR H: TCislo;
BEGIN
  H:=0;

  IF (JmenoL='') AND (JmenoP='') THEN H:=Abs(Param)
     ELSE FatalniChyba:=True;

  FunkceZlevaIZprava:=H;
END;

FUNCTION HodnotaFunkce(Funkce: TTextFunkce; Iks: TCislo): TCislo;
TYPE TZakonceni = SET OF Char;
VAR Delka1Clenu: Byte;
    Konec1Clenu: Char; { +,- neno #0 - konec vzorce }

  FUNCTION HledejPravou(P: Byte): Byte;
     { Vrati pozici prave zavorky odpovidajici leve zavorce }
     { na pozici P }
  VAR i, Vevnitr: Byte;
  BEGIN
    i:=P+1;
    Vevnitr:=0;
    WHILE (Funkce[i]<>')') OR (Vevnitr>0)  DO
    BEGIN
      IF Funkce[i]='(' THEN
      BEGIN
          { Pomyslny kurzor se vnoril o jednu uroven zavorek hloubeji }
        Inc(Vevnitr);
      END;
      IF Funkce[i]=')' THEN
      BEGIN
          { Pomyslny kurzor se vynoril o jednu uroven zavorek }
        Dec(Vevnitr);
      END;

      IF i=Length(Funkce) THEN
      BEGIN
          { Prislusna prava zavorka neexistuje }
        JeToFatalniChyba;
        HledejPravou:=Length(Funkce);
        Exit;
      END;
      Inc(i);
    END;
    HledejPravou:=i;
  END;

  PROCEDURE OdstranPrebytecne;
    { Odstrani pripadne prebytecne zavorny okolo vyrazu a plus na zacatku }
    { Pr:   (+1+2) -> 1+2 }
  BEGIN
    WHILE ((Funkce<>'') AND (Funkce[1]='(') AND
           (HledejPravou(1)=Length(Funkce))) OR
          (Funkce[1]='+') DO
    BEGIN
      IF Funkce[1]='+' THEN Delete(Funkce, 1, 1)
         ELSE Funkce:=Copy(Funkce, 2, Length(Funkce)-2);
    END;
  END;

  PROCEDURE UpravVzorec;
  BEGIN
    Funkce:=DownCases(Funkce);
    WHILE Pos(' ', Funkce)>0 DO Delete(Funkce, Pos(' ', Funkce), 1);
    OdstranPrebytecne;
  END;

  PROCEDURE Hledej1Clen(Zakonceni: TZakonceni);
  VAR i, Vevnitr: Byte;
  BEGIN
    i:=1;
    Vevnitr:=0;
    WHILE ((i=1) AND (Length(Funkce)>1)) OR
          ((i<=Length(Funkce)) AND
           ((NOT (Funkce[i] IN Zakonceni)) OR (Vevnitr>0))) DO
    BEGIN
      IF Funkce[i]='(' THEN
      BEGIN
          { Pomyslny kurzor se vnoril o jednu uroven zavorek hloubeji }
        Inc(Vevnitr);
      END;
      IF Funkce[i]=')' THEN
      BEGIN
          { Pomyslny kurzor se vynoril o jednu uroven zavorek }
        Dec(Vevnitr);
      END;
      Inc(i);
    END;

    Dec(i);
    IF (Length(Funkce)>i) AND (Funkce[i+1] IN Zakonceni) THEN
        Konec1clenu:=Funkce[i+1]
       ELSE Konec1Clenu:=#0;

    Delka1Clenu:=i;
  END;

  PROCEDURE HledejVyssi1Clen;
  BEGIN
    Hledej1Clen(['+', '-']);
  END;

  PROCEDURE HledejNizsi1Clen;
  BEGIN
    Hledej1Clen(['*', '/']);
  END;

  FUNCTION JeCislo: Boolean;
  VAR c: TCislo;
      x: Integer;
  BEGIN
    Val(Funkce, C, x);
    JeCislo:=(x=0);
  END;

  FUNCTION NajdiFunkciZleva: Byte;
     { Vrati kolik znaku od zacatku vyrazu josu pismena krome X }
  VAR i: Byte;
  BEGIN
    i:=1;
    WHILE (i<Length(Funkce)) AND (Funkce[i] IN ZnakyFunkce) DO Inc(i);
    IF NOT (Funkce[i] IN ZnakyFunkce) THEN Dec(i);
    NajdiFunkciZleva:=i;
  END;

  FUNCTION NajdiFunkciZprava: Byte;
     { Vrati kolik znaku od zacatku vyrazu josu pismena krome X }
  VAR i: Byte;
  BEGIN
    i:=Length(Funkce);
    WHILE (i>1) AND (Funkce[i] IN ZnakyFunkce) DO Dec(i);
    IF NOT (Funkce[i] IN ZnakyFunkce) THEN Inc(i);
    NajdiFunkciZprava:=i;
  END;

VAR Hodnota, H: TCislo;
    Plus, Krat: Boolean;
    JmenoFunkceL, JmenoFunkceP: Byte;
BEGIN
  UpravVzorec;

  IF Funkce[1]='-' THEN Funkce:='0'+Funkce;

  HledejVyssi1Clen;

  IF Konec1Clenu=#0 THEN
  BEGIN
      { Vzorec obsahuje pouze 1 clen }
    HledejNizsi1Clen;
    IF Konec1Clenu=#0 THEN
    BEGIN
      IF Funkce='x' THEN Hodnota:=Iks
         ELSE
      IF Funkce='' THEN Hodnota:=LudolfovoCislo
         ELSE
      IF JeCislo THEN Hodnota:=TextNaCislo(Funkce)
         ELSE
      BEGIN
        JmenoFunkceL:=NajdiFunkciZleva;
        JmenoFunkceP:=NajdiFunkciZprava;
        IF (JmenoFunkceL>0) AND (JmenoFunkceP<Length(Funkce)+1) THEN
        BEGIN
          Hodnota:=FunkceZlevaIZprava(Copy(Funkce, 1, JmenoFunkceL),
              KopirujDoKonce(Funkce, JmenoFunkceP),
              HodnotaFunkce(KopirujOdDo(Funkce, JmenoFunkceL+1,
                  JmenoFunkceP-1), Iks));
        END
           ELSE
        IF JmenoFunkceL>0 THEN
        BEGIN
          Hodnota:=FunkceZleva(Copy(Funkce, 1, JmenoFunkceL),
               HodnotaFunkce(KopirujDoKonce(Funkce, JmenoFunkceL+1), Iks));
        END
           ELSE
        IF JmenoFunkceP<Length(Funkce)+1 THEN
        BEGIN
          Hodnota:=FunkceZprava(KopirujDoKonce(Funkce, JmenoFunkceP),
               HodnotaFunkce(Copy(Funkce, 1, JmenoFunkceP-1), Iks));
        END
           ELSE JeToFatalniChyba;
      END;
    END
       ELSE
    BEGIN
      Hodnota:=1;
      Krat:=True;
      REPEAT
        H:=HodnotaFunkce(Copy(Funkce, 1, Delka1Clenu), Iks);
        IF Krat THEN Hodnota:=Hodnota*H
           ELSE
        BEGIN
          IF H<>0 THEN Hodnota:=Hodnota/H
             ELSE
          BEGIN
            Chyba:=True;
            Exit;
          END;
        END;
        Delete(Funkce, 1, Delka1Clenu);
        IF Konec1Clenu<>#0 THEN
        BEGIN
          Krat:=(Funkce[1]='*');
          Delete(Funkce, 1, 1);
        END;
        IF Funkce<>'' THEN HledejNizsi1Clen;
      UNTIL (Funkce='') OR Chyba;
    END;
  END
     ELSE
  BEGIN
    { Vzorec je soucet, pripadne rozdil nekolika clenu }
    Hodnota:=0;
    Plus:=True;
    REPEAT
      H:=HodnotaFunkce(Copy(Funkce, 1, Delka1Clenu), Iks);
      IF Plus THEN Hodnota:=Hodnota+H
         ELSE Hodnota:=Hodnota-H;
      Delete(Funkce, 1, Delka1Clenu);
      IF Konec1Clenu<>#0 THEN
      BEGIN
        Plus:=(Funkce[1]='+');
        Delete(Funkce, 1, 1);
      END;
      IF Funkce<>'' THEN HledejVyssi1Clen;
    UNTIL (Funkce='') OR Chyba;
  END;

  HodnotaFunkce:=Hodnota;
END;


  { ======== VSTUP DAT ================================================ }

PROCEDURE SpatneZadani;
  { Tato procedura je volana z procedur CtiString, CtiCislo }
  { CtiKlavesu pokud uzivatel zada nepripustnou hodnotu     }
BEGIN
  Sound(500);
  Delay(50);
  NoSound;
END;

FUNCTION CekejNaKlavesu: Boolean;
  { Ceka na stisknuti klavesy, pokud je stisknuta klavesa tvorena znakem }
  { #0 a dalsim znakem, precte obe, vrati False pokud klavesa byla Esc   }
VAR C: Char;
BEGIN
  REPEAT
    C:=ReadKey;
  UNTIL C<>#0;
  CekejNaKlavesu:=(C<>kbEsc);
END;

FUNCTION CtiKlavesu(Hlavicka: String; RozlisMalaVelka: Boolean;
   Moznosti: String): Byte;
  { Opakovane cte znaky z klavesnice dokud precteny znak neni obsazen }
  { v textu "Moznosti", vysledkem fce je poradi toho znaku            }
VAR Klavesa: Char;
    JePovolena: Boolean;
BEGIN
    { Vypise hlavicku }
  Write(Hlavicka);
  REPEAT
      { Cte znak z klavesnice }
    Klavesa:=ReadKey;
    IF NOT RozlisMalaVelka THEN
    BEGIN
         { Pokud nema rozlisovat velka/mapa pismena, prevede }
         { precteny znak na velky }
      Klavesa:=Upcase(Klavesa);
    END;
    JePovolena:=(Pos(Klavesa, Moznosti)>0);
    IF NOT JePovolena THEN SpatneZadani;
  UNTIL JePovolena;
  IF Klavesa IN [#32..#255] THEN
  BEGIN
       { Klavesa je zobrazitelna -> vypise ji na obrazovku }
    Writeln(Klavesa);
  END;
  CtiKlavesu:=Pos(Klavesa, Moznosti);
END;

FUNCTION CtiString(Hlavicka: String; Prerusitelne: Boolean; Moznosti: String;
    MaxDelka: Byte; VAR Text: String): Boolean;
    { Nejdrive vypise hlavisku, potom                                      }
    { cte text dokud neni zmacknuta klavesa Enter (vrati True a v promenne }
    { Text zadany text) nebo Esc (pouze pokud Prerusitelne=True a potom    }
    { vrati False a obsah promenne bude nezmenen), v promenne Text je      }
    { mozne zadat pocatecni hodnotu, ktera bude vracena pokud bude okamzite}
    { stisknuta klavesa Enter, pokud Moznosti neni prazdny text, povoli    }
    { pouze znaky v ni obsazene, v opacnem pripade pouze znaky #32..#255,  }
    { Maximalni povolena delka textu je MaxDelka                           }
VAR Klavesa: Char;
    Prvni, Preruseno: Boolean;
    S: String;
    PuvodniX, PuvodniY: Byte;

  FUNCTION JePovolena: Boolean;
    { Vysledkem fce, je zda je klavesa ulozena v promenne Klavesa povolena }
  BEGIN
    JePovolena:=((Moznosti='') AND (Klavesa IN [#32..#255])) OR
                ((Moznosti<>'') AND (Pos(Klavesa, Moznosti)>0))
  END;

BEGIN
  S:=Text;
  Prvni:=True;
  Write(Hlavicka);
  PuvodniX:=WhereX; PuvodniY:=WhereY;
  Preruseno:=False;
  Write(S);
  REPEAT
    Klavesa:=ReadKey;

    IF Prvni AND (NOT (Klavesa IN [kbEnter, kbEsc])) THEN
    BEGIN
         { Nebyl potrvrzen prednastaveny text -> vymazeho }
      GotoXY(PuvodniX, PuvodniY);
      Write(OpakujZnak(' ', Length(S)));
      GotoXY(PuvodniX, PuvodniY);
      S:='';
      Prvni:=False;
      IF Klavesa=kbBack THEN
      BEGIN
           { Pokud byl text vymazan klavesou backspace }
           { zrusi zaznam o jeho tisku (jiz neni co mazat) }
        Klavesa:=#0;
      END;
    END;

    IF (Klavesa=kbBack) AND (Length(S)>0) THEN
    BEGIN
         { Vymaze posledni znak textu }
      Write(kbBack, ' ', kbBack);
      Dec(S[0]);
      Klavesa:=#0;
    END;
    IF (Klavesa=kbEnter) OR
       ((Klavesa=kbEsc) AND Prerusitelne) THEN
    BEGIN
      Preruseno:=True;
      IF Klavesa=kbEnter THEN
      BEGIN
        CtiString:=True;
        Text:=S;
      END
         ELSE CtiString:=False;
      Klavesa:=#0;
    END;

    IF RozsireneZadani THEN
    BEGIN
      CASE Upcase(Klavesa) OF
        'V': Klavesa:='';
        '@': Klavesa:='';
        '|': Klavesa:='';
        'P': Klavesa:='';
      END;
    END;

    IF JePovolena AND (Length(S)<MaxDelka) THEN
    BEGIN
        { Stistknuty znak vlozi na konec textu }
      S:=S+Klavesa;
      Write(Klavesa);
      Klavesa:=#0;
    END;

    IF Klavesa<>#0 THEN
    BEGIN
        { Klavesa nebyla pouzita -> oznameni chyby zadani }
      SpatneZadani;
    END;
  UNTIL Preruseno;
  Writeln;
  RozsireneZadani:=False;
END;

FUNCTION CtiCislo(Hlavicka: String; Prerusitelne, Cele: Boolean;
   Min, Max: TCislo; VAR Cislo: TCislo): Boolean;
   { Cte TCislone cislo, povoli pouze cisla mezi Min a Max, pokud }
   { je Cele True povoli pouze cela cisla, ostatni viz CtiString  }
VAR Vysledek, Vporadku: Boolean;
    S: String;
    C: TCislo;
    Ci: Integer;
    x: Integer;
    PuvodniX, PuvodniY: Integer;
BEGIN
     { V hlavicce nahradi symbol #> dolnim limitem cisla }
  x:=Pos('#>', Hlavicka);
  IF x>0 THEN
  BEGIN
    Delete(Hlavicka, x, 2);
    Insert(CisloNaText(Min), Hlavicka, x);
  END;

     { V hlavicce nahradi symbol #< hornim limitem cisla }
  x:=Pos('#<', Hlavicka);
  IF x>0 THEN
  BEGIN
    Delete(Hlavicka, x, 2);
    Insert(CisloNaText(Max), Hlavicka, x);
  END;

  Write(Hlavicka);
  C:=Cislo;
  Vporadku:=False;
  S:=CisloNaText(Cislo);
  PuvodniX:=WhereX;
  PuvodniY:=WhereY;
  REPEAT
    GotoXY(PuvodniX, PuvodniY);
    Vysledek:=CtiString('', Prerusitelne, '1234567890.-', 14, S);

    IF Cele THEN
    BEGIN
      Val(S, Ci, x);
      C:=Ci;
    END
       ELSE Val(S, C, x);
    Vporadku:=(x=0) AND (C>=Min) AND (C<=Max);
    IF NOT Vporadku THEN SpatneZadani;
  UNTIL (NOT Vysledek) OR Vporadku;
  IF Vysledek THEN Cislo:=C;
  CtiCislo:=Vysledek;
END;

FUNCTION CtiCeleCislo(Hlavicka: String; Prerusitelne: Boolean;
   Min, Max: Integer; VAR Cislo: Integer): Boolean;
   { Zaridi prevod celeho cisla na realne spusti CtiCislo s odpovidajicimi }
   { parametry a po zadani revede realne cislo zpet na cele }
VAR C: TCislo;
    Vysledek: Boolean;
BEGIN
  C:=Cislo;
  Vysledek:=CtiCislo(Hlavicka, Prerusitelne, True, Min, Max, C);
  IF Vysledek THEN
  BEGIN
    { Zadani nebylo preruseno, prevedeme vysledek na cele cislo }
    Cislo:=Round(C);
  END;
  CtiCeleCislo:=Vysledek;
END;

PROCEDURE Nadpis(Text: String);
   { Pouzivano na zacatku kazde hlavni procedury programu }
   { viz tyto procedury (napr: NovaFunkce, VymazFunkci) }
BEGIN
  ClrScr;
  Writeln('----- ', Text, '-----');
  Writeln;
END;


  { ========== PRACE S FUNKCEMI ==================================== }

PROCEDURE SeznamFunkci;
   { Vypise seznam funkci }
VAR i: Byte;
BEGIN
  FOR i:=1 TO PocetFunkci DO
  BEGIN
      { Pr: " A: y=2*sin x                  [------]" }
    Write(' '+Pismeno(i), ': y=', DoplnZprava(Funkce[i].Funkce, ' ',
        MaxDelkaFunkce), ' [');

      { Za vlastni funkci napise priklad vzhledu cary v grafu }
    TextAttr:=Funkce[i].BarvaCary;
    Write(TypyCary[Funkce[i].TypCary]);
    ZakladniBarva;
    Writeln(']');
  END;
END;

FUNCTION VyberFunkci: Byte;
  { Pokud neni senznam prazdny vypise nabydku funkci }
  { a necha uzivatele jednu z nich zvolit, s moznosti preruseni }
  { klavesou Esc }
VAR Moznosti: String;
    i: Byte;
BEGIN
  IF PocetFunkci>0 THEN
  BEGIN
    Writeln('Vyber kterou');
    SeznamFunkci;
    Writeln('ESC: Zpet');
    Writeln;

    Moznosti:=kbEsc;
       { do promene Moznosti vlozi jedno velke pismeno pro }
       { kazdou funkci v seznamu }
       { Pr: 5 funkci v seznamu -> ABCDE }
    FOR i:=1 TO PocetFunkci DO Moznosti:=Moznosti+Pismeno(i);

       { Pokud byla stisknuta klavesa Esc vrati 0 }
       { jinak poradove cislo vybrane funkce }
    VyberFunkci:=CtiKlavesu('> ', False, Moznosti)-1;
  END
     ELSE
  BEGIN
       { Seznam je prazdny -> zobrazi hlaseni a ceka na klavesu }
    Writeln('Zadna funkce');
    CekejNaKlavesu;
       { Vysledek je 0, tj. stejny jako kdyby uzivatel prerusil }
       { vyber funkce klavesou Esc }
    VyberFunkci:=0;
  END;
END;

FUNCTION ZadaniFunkce(VAR F: TFunkce): Boolean;
   { Zadani dat o funkci: vlastni funkce a typ a barva grafu funkce }
VAR i: Integer;
    V: Boolean;
BEGIN
     { Zajisti, aby v pripade preruseni teto funkce byl }
     { jeji vysledek False }
  ZadaniFunkce:=False;

     { Umozni zadavani znaku nedostupnych z klavesnice, viz CtiString }
  RozsireneZadani:=True;
  REPEAT
    FatalniChyba:=False;
    Chyba:=False;
    V:=CtiString('Zadej funkci y=', True, '', MaxDelkaFunkce, F.Funkce);
    HodnotaFunkce(F.Funkce, 1);
    IF V AND FatalniChyba THEN
    BEGIN
      SpatneZadani;
      Writeln('Funkce je spatne zadana');
      CekejNaKlavesu;
      F.Funkce:='';
    END;
       { Opakuj do te doby az funkce bude v poradku nebo }
       { bude zadani preruseno uzivatelem }
  UNTIL (NOT FatalniChyba) OR (NOT V);
  RozsireneZadani:=False;
  IF NOT V THEN Exit;   { Zadani preruseno uzivatelem }

  Writeln;

  Writeln('Typ cary');
     { Vykresli nabydku typu car }
  FOR i:=0 TO 3 DO Writeln(' '+Pismeno(i+1)+' - '+TypyCary[i]);
  F.TypCary:=CtiKlavesu('> ', False, 'ABCD')-1;
  Writeln;

  Writeln;
  Writeln('Barva cary');
  FOR i:=1 TO 15 DO
  BEGIN
       { Vykresllni nabydky barev }
    Write(' '+Pismeno(i)+' - ');
    TextAttr:=i;
    Write(DoplnZprava(Barvy[i], ' ', 14));
    IF i MOD 3=0 THEN Writeln;
    ZakladniBarva;
  END;
  F.BarvaCary:=CtiKlavesu('> ', False, 'ABCDEFGHIJKLMNO');

    { Zadani nebylo preruseno -> vysledek je True }
  ZadaniFunkce:=True;
END;


  { ================================================================ }

FUNCTION Menu: Byte;
  { Zobrazi menu a ceka na zvoleni jedne moznosti, a vrati jeji }
  { poradove cislo, pokud je zvolen "Konec" vrati 0             }
CONST Moznosti = 'ABCDEFG'+kbEsc;
VAR Volba: Byte;
BEGIN
  ClrScr;
  Writeln(' A - Nova funkce');
  Writeln(' B - Vymaz funkci');
  Writeln(' C - Nastav funkci');
  Writeln(' D - Zobraz funkce');
  Writeln(' E - Nastav graf');
  Writeln(' F - Zobraz graf');
  Write  (' G - ');
  TextAttr:=Red;    Write('D');
  TextAttr:=Blue;   Write('E');
  TextAttr:=Green;  Write('M');
  TextAttr:=Yellow; Write('O');
  ZakladniBarva;
  Writeln;
  Writeln('ESC- Konec');
  Writeln;
  Volba:=CtiKlavesu('> ', False, Moznosti);
  IF Volba=Length(Moznosti) THEN Volba:=0;
  Menu:=Volba;
END;

PROCEDURE NovaFunkce;
VAR F: TFunkce;
BEGIN
  Nadpis('NOVA FUNKCE');

  IF PocetFunkci<MaxFunkci THEN
     { Nebylo jiz dosezeno maximalniho postu funkci se seznamu? }
  BEGIN
    F.Funkce:='';
    IF ZadaniFunkce(F) THEN
    BEGIN
          { Zadavani nebylo preruseno, ulozime tedy }
          { zadana data do seznamu }
      Inc(PocetFunkci);
      Funkce[PocetFunkci]:=F;
    END;
  END
     ELSE
  BEGIN
    Writeln('Maximalni pocet funkci je ', MaxFunkci);
    CekejNaKlavesu;
  END;
END;

PROCEDURE VymazFunkci;
VAR Kterou, i: Byte;
BEGIN
  Nadpis('VYMAZ FUNKCI');

    { Zobrazi seznam funkci a necha uzivatele zvolit }
  Kterou:=VyberFunkci;
  Writeln;
  IF (Kterou>0) AND
     (CtiKlavesu('Skutecne vymazat (A/N): ', False, 'AN')=1) THEN
    { = seznam obsahuje alespon 1 fci, uzivatel neprerusil vyber }
    { klavesou Esc a potvrdil vymazani funkce }
  BEGIN
        { Vsechny funkce, ktere jsou v seznamu za vymazavanou }
        { posuneme o jednu pozici }
    FOR i:=Kterou+1 TO PocetFunkci DO Funkce[i-1]:=Funkce[i];
    Dec(PocetFunkci);
  END;
END;

PROCEDURE NastavFunkci;
VAR Kterou: Byte;
BEGIN
  Nadpis('NASTAV FUNKCI');

    { Zobrazi seznam funkci a necha uzivatele zvolit }
  Kterou:=VyberFunkci;
  Writeln;
  IF Kterou>0 THEN
    { = seznam obsahuje alespon 1 fci a uzivatel neprerusil vyber }
    { klavesou Esc }
  BEGIN
    Nadpis('NASTAV FUNKCI');
    ZadaniFunkce(Funkce[Kterou]);
  END;
END;

PROCEDURE ZobrazFunkce;
  { Vypise seznam funkci, pripadne oznameni o tom ze je senzam prazdy }
  { a ceka na stisk klavesy }
BEGIN
  Nadpis('ZOBRAZ FUNKCI');

  SeznamFunkci;

  IF PocetFunkci>0 THEN
  BEGIN
    Writeln;
    Writeln('Pocet: ', PocetFunkci);
  END
     ELSE Writeln('Zadna funkce');

  CekejNaKlavesu;
END;

PROCEDURE NastavGraf;
  { Umozni uzivateli nastavit parametry grafu }
BEGIN
  Nadpis('NASTAV GRAF');

  IF NOT CtiCislo('Dolni limit osy X (#>..#<): ',
     True, False, -100, 0, OsaXMin) THEN Exit;

  IF NOT CtiCislo('Horni limit osy X (#>..#<): ',
     True, False, 0, 100, OsaXMax) THEN Exit;

  IF NOT CtiCislo('Jednotka na ose X (#>..#<): ',
     True, False, 0, 10, JednotkyX) THEN Exit;
  Writeln;

  IF NOT CtiCislo('Dolni limit osy Y (#>..#<): ',
     True, False, -100, 0, OsaYMin) THEN Exit;

  IF NOT CtiCislo('Horni limit osy Y (#>..#<): ',
     True, False, 0, 100, OsaYMax) THEN Exit;

  IF NOT CtiCislo('Jednotka na ose Y (#>..#<): ',
     True, False, 0, 10, JednotkyY) THEN Exit;
  Writeln;

  IF NOT CtiCislo('Presnost grafu (#>..#<): ',
     True, False, 0.1, 20, Presnost) THEN Exit;
END;

FUNCTION ZobrazGraf: Boolean;
CONST OsaX = 1;
      OsaY = 2;

  FUNCTION RozsahOsy(Osa: Byte): TCislo;
    { Vrati rozsah osy, tj. soucet kladne a zaporne casti osy }
  BEGIN
    CASE Osa OF
      OsaX: RozsahOsy:=-OsaXMin+OsaXMax;
      OsaY: RozsahOsy:=-OsaYMin+OsaYMax;
    END;
  END;

  FUNCTION Stred(Osa: Byte): Integer;
    { Vrati souradni pruseciku os, pro OsaX x-ovou, pro OsaY y-ouvou }
  BEGIN
    CASE Osa OF
      OsaX: Stred:=PozGrafuX+Round((VelGrafuX*((-OsaXMin)/RozsahOsy(OsaX))));
      OsaY: Stred:=PozGrafuY+Round((VelGrafuY*(OsaYMax/RozsahOsy(OsaY))));
    END;
  END;

  FUNCTION OsaNaObraz(Osa: Byte): TCislo;
    { Vypocita kolik pixelu obrazovky odpovida jednomu bodu na ose }
    { = pomer mezi obrazovkou a osou }
  BEGIN
    CASE Osa OF
      OsaX: OsaNaObraz:=VelGrafuX/RozsahOsy(OsaX);
      OsaY: OsaNaObraz:=VelGrafuY/RozsahOsy(OsaY);
    END;
  END;

  FUNCTION NaCeleJednotky(R: TCislo): Integer;
    { Odstrani desetinou cast cisla, pokud je cislo jiz cele }
    { vrati cislo o jednicku bliz k nule }
    { Pr: 1.5 -> 1;   -1.5 -> -1;   2 -> 1;  -1.9 -> 1 }
  VAR C: Integer;
  BEGIN
    C:=Round(Int(R));
    IF C=R THEN
    BEGIN
      IF R<0 THEN C:=C+1
         ELSE
      IF R>0 THEN C:=C-1;
    END;
    NaCeleJednotky:=C;
  END;

VAR grDriver, grMode: Integer;
    i: Integer;
    F: TFunkce;
    Iks, Krok, Hodnota: TCislo;
    Prvni, PristePrvni: Boolean;
    Preruseno: Byte;
       { 0=nepreruseno; 1=prerusena funkce (SPACE); 2=prerusen graf }
       { 3=uplne preruseni (ESC) }
    RealY: TCislo;
    X, Y: Integer;
BEGIN
  grDriver:=Detect;
     { Inicializuje grafiku }
  InitGraph(grDriver, grMode, GrafickeSoubory);

  SetColor(White);
     { Plna silna cara }
  SetLineStyle(SolidLn, 0, ThickWidth);

     { Ramecky kolem grafu a legendy }
  Rectangle(PozGrafuX-OkrajGrafu, PozGrafuY-OkrajGrafu,
            PozGrafuX+VelGrafuX+OkrajGrafu, PozGrafuY+VelGrafuY+OkrajGrafu);
  Rectangle(PozInfoX-OkrajInfo, PozInfoY-OkrajInfo,
            PozInfoX+VelInfoX+OkrajInfo, PozInfoY+VelInfoY+OkrajInfo);

  SetColor(LightGray);
     { Plna tenka cara }
  SetLineStyle(SolidLn, 0, NormWidth);

     { Osa X }
  MoveTo(PozGrafuX, Stred(OsaY));
  LineRel(VelGrafuX, 0);

     { Osa Y }
  MoveTo(Stred(OsaX), PozGrafuY);
  LineRel(0, VelGrafuY);

    { Jednotky na ose X }
  FOR i:=   { Pocet jednotek na zaporne casti osy X }
         NaCeleJednotky(OsaXMin/JednotkyX)  TO
            { Pocet jednotek na kladne casti osy X }
         NaCeleJednotky(OsaXMax/JednotkyX) DO
  BEGIN
    MoveTo(Stred(OsaX)+Round((i*JednotkyX*OsaNaObraz(OsaX))),
           Stred(OsaY)-VelCarek);
    LineRel(0, 2*VelCarek);
  END;

    { Jednotky na ose Y }
  FOR i:=   { Pocet jednotek na kladne casti osy Y }
         -NaCeleJednotky(OsaYMax/JednotkyY) TO
            { Pocet jednotek na zaporne casti osy Y }
         -NaCeleJednotky(OsaYMin/JednotkyY) DO
  BEGIN
    MoveTo(Stred(OsaX)-VelCarek,
           Stred(OsaY)+Round((i*JednotkyY*OsaNaObraz(OsaY))));
    LineRel(2*VelCarek, 0);
  END;

    { Jmeno osy X }
  IF -OsaXMin<=OsaXMax THEN
  BEGIN
      { Vetsi, nebo alespon polovicni cast osy X je kladna -> }
      { jmeno osy bude na jejim pravem konci }
    OutTextXY(PozGrafuX+VelGrafuX-7, Stred(OsaY)+3, 'x')
  END
     ELSE
  BEGIN
      { Vetsi cast osy X je zaporna -> }
      { jmeno osy bude na jejim levem konci }
    OutTextXY(PozGrafuX+7, Stred(OsaY)+3, 'x');
  END;

    { Jmeno osy Y }
  IF -OsaYMin<=OsaYMax THEN
  BEGIN
      { Vetsi, nebo alespon polovicni cast osy Y je kladna -> }
      { jmeno osy bude na jejim hornim konci }
    OutTextXY(Stred(OsaX)+3, PozGrafuY+4, 'y')
  END
     ELSE
  BEGIN
      { Vetsi cast osy X je zaporna -> }
      { jmeno osy bude na jejim dolnim konci }
    OutTextXY(Stred(OsaX)-10, PozGrafuY+VelGrafuY-10, 'y');
  END;

    { Info }
  OutTextXY(PozInfoX, PozInfoY, 'Rozsah X:');
  OutTextXY(PozInfoX+10, PozInfoY+12,
      CisloNaText(OsaXMin)+'..'+CisloNaText(OsaXMax));
  OutTextXY(PozInfoX, PozInfoY+32, 'Rozsah Y:');
  OutTextXY(PozInfoX+10, PozInfoY+44,
      CisloNaText(OsaYMin)+'..'+CisloNaText(OsaYMax));
  OutTextXY(PozInfoX, PozInfoY+64, 'Jednotka na X:');
  OutTextXY(PozInfoX+10, PozInfoY+76, CisloNaText(JednotkyX));
  OutTextXY(PozInfoX, PozInfoY+96, 'Jednotka na Y:');
  OutTextXY(PozInfoX+10, PozInfoY+108, CisloNaText(JednotkyY));

    { VLASTNI VYKRESLENI GRAFU FUNKCI }

    { Vypocita periodu v jake se bude vypocitavat hodnota funkce }
    { zavisi to na konstante Jemnost a rozsahu grafu }
    { (tj. pomeru osa/obrazovka }
  Krok:=Presnost/OsaNaObraz(OsaX);
  i:=0;
  Preruseno:=0;
  WHILE (i<PocetFunkci) AND (Preruseno=0) DO
     { Opakuj pro kazdou funkci }
  BEGIN
    i:=i+1;
    F:=Funkce[i];

      { Legenda k funkci }
    SetLineStyle(F.TypCary, 0, NormWidth);
    SetColor(F.BarvaCary);
    MoveTo(PozInfoX, 120+PozInfoY+(i-1)*30+15);
    LineRel(VelInfoX, 0);
    MoveRel(-VelInfoX, 10);
    SetColor(LightGray);
    OutText(F.Funkce);

      { Zaciname kreslit graf z leva }
    Iks:=OsaXMin;
    Prvni:=True;
    PristePrvni:=False;
      { Nastaveni barvy a vzhledu cary podle volby uzivatele }
    SetLineStyle(F.TypCary, 0, NormWidth);
    SetColor(F.BarvaCary);
    WHILE (Iks<OsaXMax) AND (Preruseno=0) DO
      { Opakuj doku nedosahneme praveho okraje grafu }
    BEGIN
        { Vypocitani hodoty funkce pro aktualni X }
      Chyba:=False;
      Hodnota:=HodnotaFunkce(F.Funkce, Iks);

      IF PristePrvni THEN
      BEGIN
        Prvni:=True;
        PristePrvni:=False;
      END;

      IF NOT Chyba THEN
      BEGIN
           { Prevedeni pozice na OseX na x-ovou souradnici na obrazovce }
        X:=Round(PozGrafuX+(Iks-OsaXMin)*OsaNaObraz(OsaX));
           { Prevedeni pozice na OseY na y-ovou souradnici na obrazovce }
        RealY:=Stred(OsaY)-Hodnota*OsaNaObraz(OsaY);
           { Pokud je y-ova pozice prilis mimo okraj obrazovky }
           { prizpusobi ji na hodnotu blizsi }
        IF RealY>480 THEN
        BEGIN
          RealY:=480;
          PristePrvni:=True;
        END;
        IF RealY<0 THEN
        BEGIN
          RealY:=0;
          PristePrvni:=True;
        END;
           { Zaokrouhli na cele cislo }
        Y:=Round(RealY);
        IF Prvni THEN
        BEGIN
            { Je to prvni bod, tedy jeste nekreslime }
            { ale pouze nastavime pomyslny kurzor }
          MoveTo(X, Y);
            { Dalsi bod jiz nebude prvni }
          Prvni:=False;
        END
           ELSE
        BEGIN
            { Neni to prvni bod grafu, nakreslime caru od posledniho }
          LineTo(X, Y);
        END;
      END
         ELSE
      BEGIN
         { Doslo k chybe, preruseni grafu, pokracovani }
         { od dalsi platne hodnoty }
        Prvni:=True;
      END;

        { Posuneme X o dalsi krok doprava }
      Iks:=Iks+Krok;

      IF KeyPressed THEN
         { V prubehu kresleni grafu byla stisknuta klavesa }
      BEGIN
        CASE ReadKey OF
          ' ': Preruseno:=1;
          kbESC: Preruseno:=3;
             ELSE Preruseno:=2;
        END;
           { Pokud jsou zde dalsi znaky (napr: rozsirene klavesy) precte je }
        WHILE Keypressed DO ReadKey;
      END;
    END;
    IF Preruseno=1 THEN
    BEGIN
       { Bylo preruseno pouze kresleni 1 funkce -> pokracujeme dale }
      Preruseno:=0;
    END;
  END;

  IF Preruseno=0 THEN
  BEGIN
     { Graf byl uspesne vykreslen -> ceka na stisk klavesy }
     { Pokud bude stisknuta klavesa  ESC }
     { vysledek funkce bude False -> pri provadeni DEMA }
     { nebude zobrazen dalsi graf }
    ZobrazGraf:=CekejNaKlavesu;
  END
     ELSE
  BEGIN
      { Pokud bylo vykreseleni preruseno klavesou ESC }
      { vysledek funkce bude False -> pri provadeni DEMA }
      { nebude zobrazen dalsi graf }
    ZobrazGraf:=NOT (Preruseno=3);
  END;

     { Obnovy textovy mod }
  RestoreCrtMode;
END;

PROCEDURE DEMO;
VAR AFunkce: TSeznamFunkci;
    APocetFunkci: Integer;
    i: Byte;
BEGIN
    { Ulozi aktualni seznam funkci }
  AFunkce:=Funkce;
  APocetFunkci:=PocetFunkci;

    { Prekopiruje DEMO funkce do seznamu }
  FOR i:=1 TO PocetDemoFunkci DO
      Funkce[i]:=DemoFunkce[i];
  PocetFunkci:=PocetDemoFunkci;
  IF ZobrazGraf THEN
  BEGIN
      { Vytvori seznam funkci obsahujici nasobky funkce "sin x" }
    FOR i:=1 TO MaxFunkci DO
    WITH Funkce[i] DO
    BEGIN
      Funkce:=CisloNaText(i)+'*sin x';
      TypCary:=0;
      BarvaCary:=i;
    END;
    PocetFunkci:=MaxFunkci;
    ZobrazGraf;
  END;

    { Obnovi puvodni seznam }
  Funkce:=AFunkce;
  PocetFunkci:=APocetFunkci;
END;

VAR Volba: Byte;
BEGIN
  Randomize;
    { Na zacatku neni zadana zadna funkce }
  PocetFunkci:=0;
    { Pro jistotu nastavime standartni barvu textu }
  ZakladniBarva;

  REPEAT
      { Nechame uzivatele zvolit jednu z moznosti }
    Volba:=Menu;
    Writeln;

    CASE Volba OF
      1: NovaFunkce;
      2: VymazFunkci;
      3: Nastavfunkci;
      4: ZobrazFunkce;
      5: NAstavGraf;
      6: ZobrazGraf;
      7: DEMO;
    END;
  UNTIL Volba=0;
  Writeln;
END.
