//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <assert.h>
#include "HraciOkno.h"
#include "OknoNastaveni.h"
#include "RizenyHad.h"
#include "HraciPlanCache.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
THraForm *HraForm;
//---------------------------------------------------------------------------
__fastcall THraForm::THraForm(TComponent* Owner)
        : TForm(Owner)
{
  FazeHry = fhZacatek;
  // inicializujeme generator nahornych cisel
  randomize();
  // nastavime vychozi parametry hry
  Parametry.PocetPrekazek = 6;
  Parametry.Sirka = 30;
  Parametry.Vyska = 30;
  Parametry.Rychlost = 80;
  Parametry.PocetHracu = 2;
  Parametry.TypyHracu[0] = LIDSKY_HRAC;
  Parametry.ParametryHracu[0] = 0;
  Parametry.TypyHracu[1] = POCITACOVY_HRAC;
  Parametry.ParametryHracu[1] = 1;
  // prizpusobime okno a komponenty nastavenim hry
  PrizpusobOkno();
  // vychozi stav okna a komponent
  AktualizujFazi();
  // timhle zabranime aby hraci plocha "problikavala" pri prekreslovani
  HraBox->ControlStyle = HraBox->ControlStyle << csOpaque;
}
//---------------------------------------------------------------------------
void __fastcall THraForm::HraBoxPaint(TObject *Sender)
{
  // je vubec co vykreslovat?
  if (Hra)
  {
    #ifdef OBLASTIDEBUG
    int HadX, HadY;
    Hra->VratHrace(0)->Had->VratHlavu(HadX, HadY);
    THraciPlanCache * Cache = new THraciPlanCache(HadX, HadY, Hra->VratHraciPlan());
    #endif

    TCanvas * HraCanvas = HraBox->Canvas;
    int Vzor, Soused;
    int PocatekX, PocatekY;
    HraCanvas->Brush->Style = bsSolid;
    HraCanvas->Pen->Style = psSolid;
    TColor Barva;
    // pro kazde policko hraciho planu...
    for (Integer Y = 0; Y < Hra->VyskaPlanu(); Y++)
      for (Integer X = 0; X < Hra->SirkaPlanu(); X++)
      {
        Soused = ssZadny;
        // zjistime jaky vzor ma byt na policku vykreslen
        Vzor = Hra->Vzor(X, Y, Soused);
        // podle vzoru vybereme barvu "stetce"
        switch (Vzor) {
          case vzPotrava: Barva = clRed; break;
          case vzHad:
          case vzHlavaHada+2: Barva = clGreen; break;
          case vzHlavaHada:
          case vzHad+2: Barva = clOlive; break;
          case vzNic: Barva = baPrazdna; break;
          case vzHorizPrekazka:
          case vzVertPrekazka: Barva = clMaroon; break;
          default: Barva = clBlack; break;
        }

        HraCanvas->Brush->Color = Barva;
        PocatekX = X*10;
        PocatekY = Y*10;
        // nekreslime zadny slozity vzor, proste jen nakreslime
        // ctverec vyplneny vybranou barvou, standartne se okolo nej
        // udela jeden pixel volneho mista, aby nesplyvaly dohromady ...
        HraCanvas->FillRect(
          TRect(PocatekX + 1, PocatekY + 1, PocatekX + 9, PocatekY + 9));
        // ... jen na stranach, kde navazuje na dalsi policko stejneho
        // prvku hry (Soused), tu meyeru prekreslime, aby se vytvorila
        // spojita plocha

        #define HRANAX(JE, PX, PY, KX, KY) \
          if (JE) HraCanvas->Pen->Color = Barva; \
            else HraCanvas->Pen->Color = baPrazdna; \
          HraCanvas->MoveTo(PocatekX + (PX), PocatekY + (PY)); \
          HraCanvas->LineTo(PocatekX + (KX), PocatekY + (KY))

        #ifdef OBLASTIDEBUG
          #define HRANA(JEHRAN, JE, PX, PY, KX, KY) \
            if (JEHRAN) HraCanvas->Pen->Color = clBlack; \
              else HRANAX(JE, PX, PY, KX, KY)
        #else
          #define HRANA(JEHRAN, JE, PX, PY, KX, KY) HRANAX(JE, PX, PY, KX, KY)
        #endif

        HRANA(Cache->Oblast(X, Y) != Cache->Oblast(X, Y-1),
          Soused & ssNahore, 1, 0, 9, 0);
        HRANA(Cache->Oblast(X, Y) != Cache->Oblast(X+1, Y),
          Soused & ssVpravo, 9, 1, 9, 9);
        HRANA(Cache->Oblast(X, Y) != Cache->Oblast(X, Y+1),
          Soused & ssDole,   1, 9, 9, 9);
        HRANA(Cache->Oblast(X, Y) != Cache->Oblast(X-1, Y),
          Soused & ssVlevo,  0, 1, 0, 9);

        #undef HRANA
        #undef HRANAX

        /*#ifdef OBLASTIDEBUG
        HraCanvas->Pen->Color = clBlack;
        #define HRANAOBLASTI(JE, PX, PY, KX, KY) \
          if (JE) { HraCanvas->MoveTo(PocatekX + (PX), PocatekY + (PY)); \
            HraCanvas->LineTo(PocatekX + (KX), PocatekY + (KY)); }
        HRANAOBLASTI(Cache->Oblast(X, Y) != Cache->Oblast(X, Y-1), 1, 0, 9, 0);
        HRANAOBLASTI(Cache->Oblast(X, Y) != Cache->Oblast(X+1, Y), 9, 1, 9, 9);
        HRANAOBLASTI(Cache->Oblast(X, Y) != Cache->Oblast(X, Y+1),   1, 9, 9, 9);
        HRANAOBLASTI(Cache->Oblast(X, Y) != Cache->Oblast(X-1, Y),  0, 1, 0, 9);
        #undef HRANAOBLASTI
        #endif*/

        // umazeme zbyvajici ctyri body v rozich ctverce
        #define MAZBOD(DX, DY) HraCanvas->Pixels[PocatekX+(DX)][PocatekY+(DY)] = baPrazdna
        MAZBOD(0, 0);
        MAZBOD(0, 9);
        MAZBOD(9, 0);
        MAZBOD(9, 9);
        #undef MAZBOD
      }

    #ifdef OBLASTIDEBUG
    delete Cache;
    #endif
  }
    else
  {
    // pokud neni hra aktivni, jen prekreslime celou plochu bile
    HraBox->Canvas->Brush->Color = baPrazdna;
    HraBox->Canvas->FillRect(TRect(0, 0, HraBox->Width, HraBox->Height));
  }
}
//---------------------------------------------------------------------------
void __fastcall THraForm::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  // pri zavirani okna behem rozehrane hry ji musime ukocit, aby se
  // vyskocilo z cyklu THra::Hraj(), jinak by se program neukoncil
  if (Hra) Hra->Ukonci();
}
//---------------------------------------------------------------------------
void __fastcall THraForm::TimerTimer(TObject *Sender)
{
  if (FazeHry == fhHrajeSe)
  {
    // v teto fazy musi existovat Hra
    assert(Hra);
    Hra->Pokracuj();
  }
  // aktualizujeme zobrazeni stavu hry na komponentach
  AktualizujStav();
}
//---------------------------------------------------------------------------
void __fastcall THraForm::KeyDown(Word & Key, TShiftState Shift)
{
  // pokud bezi hra a byla zmacknuta klavesa, predame ji hre, jesli
  // se da pouzit, pokud ano (vrati true), smazeme udalost, aby
  // se klavesa nepouzila jeste na neco jineho
  if (Hra && Hra->KlavesaStisknuta(Key, Shift))
    Key = 0;
  else
    TForm::KeyDown(Key, Shift);
} /* TForm1::KeyDown */
//---------------------------------------------------------------------------
void __fastcall THraForm::PrizpusobOkno()
{
  // nastavime velikost PaintBoxu...
  HraBox->Height = Parametry.Vyska * VELIKOST_POLICKA;
  HraBox->Width = Parametry.Sirka * VELIKOST_POLICKA;
  // ... tim se automaticky pripusobi velikost panelu, na kterem paintbox lezi
  // a podle jeho velikosti a velikosti dalsich komponent upravime
  // velikost celeho formulare
  ClientWidth = HraPanel->Width;
  ClientHeight = MenuPanel->Height + HraPanel->Height + StatusBar->Height;
  // prizpusobime velikosti tlacitek, tak aby zaplnili celou
  // sirku okna
  StartStopButton->Width = MenuPanel->ClientWidth/3;
  PauzaButton->Left = StartStopButton->Width;
  PauzaButton->Width = StartStopButton->Width;
  NastaveniButton->Left = 2*StartStopButton->Width;
  NastaveniButton->Width = MenuPanel->ClientWidth - NastaveniButton->Left-1;
  // nastaveni velikosti panelu na statusbaru podle velikosti okna
  assert(Parametry.PocetHracu == 1 || Parametry.PocetHracu == 2);
  StatusBar->Panels->Items[0]->Width = StatusBar->ClientWidth/(Parametry.PocetHracu+1);
  StatusBar->Panels->Items[1]->Width =
    (Parametry.PocetHracu > 1 ? StatusBar->Panels->Items[0]->Width : 0);
  StatusBar->Panels->Items[2]->Width = StatusBar->ClientWidth -
    StatusBar->Panels->Items[0]->Width - StatusBar->Panels->Items[1]->Width;
  // nastavime interval stopek podle rychlosti hry
  Timer->Interval = Parametry.Rychlost;
  // pro jistotu prekreslime hraci plochu
  HraBox->Invalidate();
} /* TForm1::PrizpusobOkno */
//---------------------------------------------------------------------------
void __fastcall THraForm::AktualizujFazi()
{
  Boolean HrajeSe = (FazeHry != fhZacatek && FazeHry != fhKonec);
  Timer->Enabled = HrajeSe;
  // upravime stav tlacitek podle aktualniho stavu hry
  if (!HrajeSe)
    StartStopButton->Caption = "&Start";
  else
    StartStopButton->Caption = "&Stop";
  PauzaButton->Enabled = HrajeSe;
  if (FazeHry == fhPauza)
    PauzaButton->Caption = "&Pokrauj";
  else
    PauzaButton->Caption = "&Pauza";
  NastaveniButton->Enabled = !HrajeSe;
  // aktualizace zobrazeni stavu hry na statusbaru
  StatusBar->SimplePanel = (FazeHry == fhZacatek || FazeHry == fhPauza);
  switch (FazeHry) {
    case fhZacatek: StatusBar->SimpleText = "Zmkni 'Start'"; break;
    case fhPauza: StatusBar->SimpleText = "Zmkni 'Pokrauj'"; break;
    case fhKonec: StatusBar->Panels->Items[1]->Text = "Konec"; break;
  }
  // prekreslime hraci plochu
  HraBox->Invalidate();
  // a jeste aktualizujeme ukazatele stavu hry
  AktualizujStav();
} /* THraForm::AktualizujFazi */
//---------------------------------------------------------------------------
void __fastcall THraForm::AktualizujStav()
{
  if (FazeHry == fhHrajeSe || FazeHry == fhKonec)
  {
    TStavHry StavHry;
    assert(Hra);
    // sjistime stav hry a na status baru zobrazime pocet bodu
    // a dobu trvani hry
    StavHry = Hra->VratStavHry();
    for (int Hrac = 0; Hrac < Parametry.PocetHracu; Hrac++)
      StatusBar->Panels->Items[Hrac]->Text =
        AnsiString().sprintf("%d bod", StavHry.Body[Hrac]);
    if (FazeHry == fhHrajeSe)
      StatusBar->Panels->Items[2]->Text = (ZacatekHry - Now()).TimeString();
  }
} /* THraForm::AktualizujStav */
//---------------------------------------------------------------------------
void __fastcall THraForm::StartStopButtonClick(TObject *Sender)
{
  // stejne tlacitko ma funkci start i stop, podle faze hry

  // pokud se zrovna nehraje, ma tlacitko funkci start
  if (FazeHry != fhHrajeSe && FazeHry != fhPauza)
  {
    // pokud existuje stara hra (mela by vzdy), tak ji zrusime
    if (Hra) delete Hra;
    // vytvorime novou hru
    Hra = new TVclHra(Parametry, HraBox);
    // zmenime fazi
    FazeHry = fhHrajeSe;
    // zapamatujeme si zacatek hry kvlu zobrazovani doby trvani na statusbaru
    ZacatekHry = Now();
    // promitneme zmenu faze do okna/komponent
    AktualizujFazi();
    try {
      // vlastni hra (cyklus)
      Hra->Hraj();
    } __finally {
      // hra skoncila (prerusenim uzivatelem nebo smrti hrace)
      FazeHry = fhKonec;
      AktualizujFazi();
    }
  }
    else
  // pokud se hraje (i pauza), ma tlacitko funkci 'stop'
  {
    assert(Hra);
    // prerusime cyklus hry Hra->Hraj(), viz par radku vyse
    Hra->Ukonci();
  }
}
//---------------------------------------------------------------------------
void __fastcall THraForm::PauzaButtonClick(TObject *Sender)
{
  // pokud se hraje, tak hru pauzneme
  if (FazeHry == fhHrajeSe) FazeHry = fhPauza;
    else
  // pokud je pauza, tak pokracujeme dal
  if (FazeHry == fhPauza) FazeHry = fhHrajeSe;
  // promitneme zmenu faze do okna/komponent
  AktualizujFazi();
}
//---------------------------------------------------------------------------
void __fastcall THraForm::NastaveniButtonClick(TObject *Sender)
{
  // vytvorime okno pro nastaveni parametru hry
  TNastaveniDialog * Dialog = new TNastaveniDialog(this);
  try {
    // otevreme okno se soucasnymi parametry
    if (Dialog->Spust(Parametry))
    {
      // doslo ke zmene parametru (uzivatel zmackl tlacitko OK)
      
      // pokud je jeste zobrazena minula hra (uz dokoncena)
      // tak ji zrusime, protoze se mozna zmenila velikost hraciho planu
      if (Hra)
      {
        FazeHry = fhZacatek;
        delete Hra;
        Hra = NULL;
      }
      // aktualizujeme velikost okna podle velikosti hraciho planu
      PrizpusobOkno();
    }
  } __finally {
    delete Dialog;
  }
}
//---------------------------------------------------------------------------
void __fastcall THraForm::FormShow(TObject *Sender)
{
  PrizpusobOkno();
}
//---------------------------------------------------------------------------

