//---------------------------------------------------------------------------
#ifndef HraH
#define HraH
//---------------------------------------------------------------------------
class THra;
class THraciPlan;
class THrac;
#include "PrvekHry.h"
#include "Hrac.h"
//---------------------------------------------------------------------------
#define MAX_HRACU 5
#define LIDSKY_HRAC 0
#define POCITACOVY_HRAC 1
//---------------------------------------------------------------------------
// viz THra::VratStavHry()
struct TStavHry {
  int Body[MAX_HRACU];
};
//---------------------------------------------------------------------------
// parametry hry predavane konstruktoru THad()
struct TParametryHry {
  int PocetPrekazek; 
  int Sirka;
  int Vyska;
  int Rychlost;
  int PocetHracu;
  int TypyHracu[MAX_HRACU];
  int ParametryHracu[MAX_HRACU];
};
//---------------------------------------------------------------------------
class THra
{
protected:
  // hra skoncila (smrti hrace)
  int Konec;
  // parametry hry predane v konstruktoru
  TParametryHry Parametry;
  // hraci plan, do zavolani Hraj() je NULL
  THraciPlan * HraciPlan;
  // hrac ovladajici hada, do zavolani Hraj() je NULL
  THrac * Hraci[MAX_HRACU];
  // tato abstrakni metoda musi byt predefinovana, tak aby
  // vykreslila hraci plochu (HraciPlan)
  virtual void Kresli() = 0;
  // tato abstraktni metoda musi byt prefinovana, tak aby hra
  // bezela primerenym tempem (Parametry.Rychlost) a zaroven musi
  // behem cekani ziskavat pokyny od lidskeho hrace
  virtual void Cekej() = 0;
public:
  // nastavi vychozi parametry hry
  THra(TParametryHry AParametry);
  // uvolni hraci plochu, hrace...
  ~THra();
  // hlavni metoda hry: cyklus kresleni hraci plochy, pohybu prvku hry
  // ziskavani vstupu od hrace az do ukonceni hry (smrti hrace)
  void Hraj();
  // vrati sirku hraciho planu (Nastaveni.Sirka)
  int SirkaPlanu();
  // ukonci hru: cyklus v Hraj()
  void Ukonci();
  // vrati hrace: NULL pokud jeste nebyla zavolana metoda Hraj()
  THrac * VratHrace(int Index);
  // vrati hraci plan: NULL pokud jeste nebyla zavolana metoda Hraj()
  THraciPlan * VratHraciPlan();
  // vrati parametry (Parametry)
  TParametryHry VratParametry();
  // vrati stav hry: pocet bodu ziskanych hracem
  TStavHry VratStavHry();
  // vrati vysku hraciho planu (Nastaveni.Vyska)
  int VyskaPlanu();
};
//---------------------------------------------------------------------------
#endif
