//---------------------------------------------------------------------------
#ifndef HraciPlanCacheH
#define HraciPlanCacheH

#include "PrvekHry.h"
//---------------------------------------------------------------------------
struct TPoleCache {
  int Naraz;
  int Parametr;
  int Oblast;
};
struct TOblast {
  int Levy, Horni, Dolni, Pravy; // hranice oblasti
  char * Sousede; // cisla sousednich oblasti
};
//---------------------------------------------------------------------------
class THraciPlanCache : public THraciPlan
{
protected:
  // pole udaju o hracim planu
  TPoleCache * Cache;
  // cachovany hraci plan
  THraciPlan * HraciPlan;
  // velikost cachovaneho hraciho planu
  int FVyska;
  int FSirka;
  // souradnice nejhodnotnejsiho pole a oblast ve ktere lezi
  int FNejX;
  int FNejY;
  int FNejOblast;
  // pole oblasti
  int PocetOblasti;
  TOblast * Oblasti;
  // souradnice hlavy hada
  int StartX;
  int StartY;

  // vrati vysledek narazu do pole
  int JenNaraz(int X, int Y) { int Parametr; return CoKdyzNarazim(X, Y, Parametr); }
  // zaradi pole do oblasti
  void NastavOblast(int X, int Y, int Oblast);
  // najde nejlepsi cestu z PolohaX, PolohaY do DoX, DoY a vrati
  // cislo oblasti do ktere je potreba odpocit jako prvni
  int HledejCestuSmerem(int Inteligence, int DoX, int DoY, char ZOblasti,
    char * ZakazaneOblasti, int DosavadniDelka, int & CelkovaDelka,
    int PolohaX, int PolohaY);
#ifdef OBLASTIDEBUG
public:
#endif
  // vrati cislo oblasti ve ktere lezi pole
  int Oblast(int X, int Y)
    { if (!OhlidejHranice(X, Y)) return -1; else return Cache[Y*FSirka+X].Oblast; }
public:
  // priradi hraci plan a podle jeho velikosti alokuje pamet pro cache
  THraciPlanCache(int StartX, int StartY, THraciPlan * AHraciPlan);
  // uvolni cache
  virtual ~THraciPlanCache();
  // zjisti jestli jsou udaje pro pozadovane policko jiz cachovane, kdyz ne
  // zavola metodu CoKdyzNarazim() cachovaneho hraciho planu a
  // ziskane informace ulozi do cache, kdyz ano, rovnou je nahraje z cache
  virtual int CoKdyzNarazim(int X, int Y, int & Parametr);
  // najde cestu z StartX, StartY do DoX, DoY a vrati smer, kterym se
  // ma hrac nyni vydat
  int HledejCestu(int Inteligence, int DoX, int DoY);

  virtual int Sirka() { return FSirka; };
  virtual int Vyska() { return FVyska; };
  int NejX() { return FNejX; };
  int NejY() { return FNejY; };
  int NejOblast() { return FNejOblast; };
};
//---------------------------------------------------------------------------
#endif
