//---------------------------------------------------------------------------
#ifndef PrekazkaH
#define PrekazkaH

#include "PrvekHry.h"
// mozne orientace prekazky
#define orHorizontalni 0
#define orVertikalni 1
//---------------------------------------------------------------------------
// TPrekazka: objekt v podobe zdi (horizontalni nebo vertikalni), zustava
// stale na stejnem miste, narazem do nej had (hrac) zemre 
//---------------------------------------------------------------------------
class TPrekazka : public TPrvekHry
{
private:
  // souradnice leveho horniho policka prekazky
  int Y;
  int X;
  // delka prekazky
  int Delka;
  // orientace prekazky (vertikalni/horizontalni)
  int Orientace;

protected:
  // umistni nahodne prekazku na hraci plose
  void Generuj();
  // zjisti jestli na danych souradnicich hraci plochy je
  // tato prekazka a vrati index policka prekazky
  // pokud na souradnicich prekazka neni vrati -1
  int JeTamZed(int AX, int AY);
public:
  // vytvori prekazku a vlozi ji na hraci plochu
  TPrekazka(THraciPlan * AHraciPlan);
  // pokud jsou souradnice na prekazce, vrati vzor prekazky pro vykresleni
  virtual int Vzor(int AX, int AY, int & Soused);
  // neudela nic
  virtual int Pohni();
  // vrati smrt, pokud AX,AY jsou souradnice na prekazce
  virtual int CoKdyzNarazim(int AX, int AY, int & Parametr);
  // vrati smrt, pokud AX,AY jsou souradnice na prekazce
  virtual int Naraz(int AX, int AY, int & Parametr);
};
//---------------------------------------------------------------------------
#endif
