//---------------------------------------------------------------------------
#include <assert.h>
#include <stdlib.h>

#include "PrvekHry.h"
#include "Potrava.h"
#include "RizenyHad.h"
#include "Prekazka.h"
//---------------------------------------------------------------------------
//  TPrvekHry
//---------------------------------------------------------------------------
TPrvekHry::TPrvekHry(THraciPlan * AHraciPlan):
  HraciPlan(AHraciPlan), Dalsi(NULL)
{
} /* TPrvekHry::TPrvekHry */
//---------------------------------------------------------------------------
TPrvekHry::~TPrvekHry()
{
} /* TPrvekHry::~TPrvekHry */
//---------------------------------------------------------------------------
//  THraciPlan
//---------------------------------------------------------------------------
THraciPlan::THraciPlan(THra * AHra):
  TPrvekHry(NULL), Hra(AHra), Prvni(NULL)
{
  // vlozime vsechny potrebne prvky hry na hraci plochu
  Generuj();
} /* THraciPlan::THraciPlan */
//---------------------------------------------------------------------------
THraciPlan::~THraciPlan()
{
  // zrusime vsechny prvky, ktere jsou soucasti hraciho planu
  if (Prvni)
  {
    TPrvekHry * PrvekHry = Prvni;
    do {
      TPrvekHry * Dalsi = PrvekHry->Dalsi;
      delete PrvekHry;
      PrvekHry = Dalsi;
    } while (PrvekHry);
  }
} /* THraciPlan::~THraciPlan */
//---------------------------------------------------------------------------
int THraciPlan::Sirka()
{
  assert(Hra);
  return Hra->SirkaPlanu();
} /* THraciPlan::Sirka */
//---------------------------------------------------------------------------
int THraciPlan::Vyska()
{
  assert(Hra);
  return Hra->VyskaPlanu();
} /* THraciPlan::Vyska */
//---------------------------------------------------------------------------
int THraciPlan::CoKdyzNarazim(int X, int Y, int & Parametr)
{
  TPrvekHry * PrvekHry;
  // pokud jsou souradnice na kraji hraci plochy, pak smrt
  if (!OhlidejHranice(X, Y))
  {
    Parametr = 0;
    return nrSmrt;
  }
    else
  // najdeme prvek na danych souradnicich a zavolame jeho metodu CoKdyzNarazim()
  if ((PrvekHry = PrvekNa(X, Y)) != NULL)
      return PrvekHry->CoKdyzNarazim(X, Y, Parametr);
    else
  {
    Parametr = 0;
    return nrNic;
  }
} /* THraciPlan::CoKdyzNarazim */
//---------------------------------------------------------------------------
int THraciPlan::Pohni()
{
  int Vysledek = true;
  if (Prvni)
  {
    // pohneme vsemi prvky ve spojovem seznamu
    // zastavime se jen pokud nektery vrati false -> pri pohybu
    // doslo ke stavu, kdy konci hra (napr: had narazil do steny...)
    TPrvekHry * PrvekHry = Prvni;
    do {
      Vysledek = PrvekHry->Pohni();
      PrvekHry = PrvekHry->Dalsi;
    } while (Vysledek && PrvekHry);
  }
  return Vysledek;
} /* THraciPlan::Pohni */
//---------------------------------------------------------------------------
int THraciPlan::Vzor(int X, int Y, int & Soused)
{
  TPrvekHry * PrvekHry;
  // najdeme prvek na danych souradnicich a zavolame jeho metodu Vzor()
  if (OhlidejHranice(X, Y) && ((PrvekHry = PrvekNa(X, Y)) != NULL))
    return PrvekHry->Vzor(X, Y, Soused);
  else
    return vzNic;
} /* THraciPlan::Vzor */
//---------------------------------------------------------------------------
int THraciPlan::Naraz(int X, int Y, int & Parametr)
{
  TPrvekHry * PrvekHry;
  // pokud jsou souradnice na kraji hraci plochy, pak smrt
  if (!OhlidejHranice(X, Y))
  {
    Parametr = 0;
    return nrSmrt;
  }
    else
  // najdeme prvek na danych souradnicich a zavolame jeho metodu Naraz()
  if ((PrvekHry = PrvekNa(X, Y)) != NULL)
    return PrvekHry->Naraz(X, Y, Parametr);
  else
    return nrNic;
} /* THraciPlan::Naraz */
//---------------------------------------------------------------------------
void THraciPlan::Pridej(TPrvekHry * PrvekHry)
{
  assert(PrvekHry && !PrvekHry->Dalsi);
  // pridame prvek na konec spojoveho seznamu
  if (Prvni)
  {
    TPrvekHry * Posledni = Prvni;
    while (Posledni->Dalsi) Posledni = Posledni->Dalsi;
    Posledni->Dalsi = PrvekHry;
  }
    else Prvni = PrvekHry;
} /* THraciPlan::Pridej */
//---------------------------------------------------------------------------
TPrvekHry * THraciPlan::PrvekNa(int X, int Y)
{
  TPrvekHry * PrvekHry = Prvni;
  // najdeme prevek na danych souradnicich tak, ze u vsech prvku
  // volame metodu Vzor() a prvni prvek, ktery vrati neco jineho nez
  // vzNic, je ten co hledame
  if (Prvni)
  {
    int Vzor, Soused;
    do {
      Vzor = PrvekHry->Vzor(X, Y, Soused);
      if (Vzor == vzNic) PrvekHry = PrvekHry->Dalsi;
    } while ((Vzor == vzNic) && PrvekHry);
  }
  return PrvekHry;
} /* THraciPlan::PrvekNa */
//---------------------------------------------------------------------------
void THraciPlan::Generuj()
{
  // vlozime tolik prekazek, kolik je dano parametry hry
  for (int Prekazka = 0; Prekazka < Hra->VratParametry().PocetPrekazek; Prekazka++)
    Pridej(new TPrekazka(this));

  Pridej(new TPotrava(this));
  // had se musi vlozit jako posledni, protoze ma vetsi naroky
  // na umistneni (pred hadem musi byt na zcatku dost mista)
  // pokud by se po nem vlozila prekazka, mohla by se umistnit blizsko
  // pred nej, protoze pozaduje okolo jen jedno policko volne
  for (int Hrac = 0; Hrac < Hra->VratParametry().PocetHracu; Hrac++)
    Pridej(new THad(this, Hra->VratHrace(Hrac)));
} /* THraciPlan::Generuj */
//---------------------------------------------------------------------------
int THraciPlan::VolnyProstor(int ASirka, int AVyska, int & X, int & Y)
{
  int AX, AY, Volno, Nic;
  // volny prostor o pozadovanych rozmerech hledame tak, ze nahodne
  // vybereme souradnici a testujeme jestli splnuje podminky, kdyz
  // ne, tak vybereme dalsi...
  // teoreticky to muze bezet donekonecna
  do {
    AX = random(Sirka() - ASirka);
    AY = random(Vyska() - AVyska);
    Volno = true;
    int Radek, Sloupec;
    for (Radek = AY; (Radek < AY + AVyska) && Volno; Radek++)
      for (Sloupec = AX; (Sloupec < AX + ASirka) && Volno; Sloupec++)
        Volno = (CoKdyzNarazim(Sloupec, Radek, Nic) == nrNic);
  } while (!Volno);
  X = AX;
  Y = AY;
  return true;
} /* THraciPlan::VolnyProstor */







