//---------------------------------------------------------------------------
#include <assert.h>
#include <stdlib.h>

#include "RizenyHad.h"
//---------------------------------------------------------------------------
void PohniVeSmeru(int & X, int & Y, int Smer)
{
  switch (Smer) {
    case smNahoru: Y--; break;
    case smDoprava: X++; break;
    case smDolu: Y++; break;
    case smDoleva: X--; break;
  }
}
//---------------------------------------------------------------------------
THad::THad(THraciPlan * AHraciPlan, THrac * AHrac):
  TPrvekHry(AHraciPlan), Hrac(AHrac), Clanky(NULL), Delka(0), Mrtvy(false)
{
  assert(Hrac);
  // umistineme hada na hraci plose
  Generuj();
  // hrac musi byt prirazen
  assert(Hrac);
  // hrac take potrebuje vedet jakeho hada ridi
  Hrac->PriradHada(this);
} /* THad::THad */
//---------------------------------------------------------------------------
THad::~THad()
{
  // sdelime hraci, ze had ktereho ridi, je zrusen
  assert(Hrac);
  Hrac->PriradHada(NULL);
  assert(Clanky);
  free(Clanky);
} /* THad::~THad */
//---------------------------------------------------------------------------
void THad::Generuj()
{
  assert(HraciPlan && !Clanky);
  // vychozi delka je vzdy stejna
  Delka = VYCHOZI_DELKA_HADA;
  // alokujeme pamet na vychozi pocet clanku
  Clanky = (char*)malloc(Delka * 2);
  assert(Clanky);
  // nahodne urcime vychozi smer
  Smer = random(4);
  int X, Y;
  // vertikalni smer pochybu
  if (Smer == smNahoru || Smer == smDolu)
  {
    // nalezneme misto pro hada pohybujiciho se ve vetikalnim smeru
    // okolo hada musi byt na zacatku alespon jedno policko volne
    // a pred jeho hlavou musi byt jeste vetsi rezerva, aby mel
    // lidsky hrac cas zareagovat a hned nenarazil do steny
    assert(HraciPlan->VolnyProstor(3, Delka + REZERVA_PRED_HADEM, X, Y));
    // podle polohy nalezeneho volneho mista umistineme za sebe
    // vychozi clanky tela 
    for (int Clanek = 0; Clanek < Delka; Clanek++)
    {
      // pohybujeme se vertikalne -> X-ova souradnice je vzdy stejna
      Clanky[Clanek*2] = X + 1;
      // podle toho jestli jedeme nahoru nebo dolu se posune had
      // vramci volneho mista, tak aby pred hlavou bylo vime cista
      if (Smer == smNahoru) Clanky[Clanek*2+1] = Y + REZERVA_PRED_HADEM + Clanek;
        else Clanky[Clanek*2+1] = Y + Delka - Clanek - 1;
    }
  }
    else
  // horizontalni smer pochybu
  {
    // to same co pri vertiklanim smeru, jen souradnice jsou prohozene...
    assert(HraciPlan->VolnyProstor(Delka + REZERVA_PRED_HADEM, 3, X, Y));
    for (int Clanek = 0; Clanek < Delka; Clanek++)
    {
      if (Smer == smDoleva) Clanky[Clanek*2] = X + REZERVA_PRED_HADEM + Clanek;
        else Clanky[Clanek*2] = X + Delka - Clanek - 1;
      Clanky[Clanek*2+1] = Y + 1;
    }
  }
} /* THad::Generuj */
//---------------------------------------------------------------------------
int THad::Pohni()
{
  assert(Clanky && HraciPlan && Hrac && !Mrtvy);
  int NovySmer;
  // od hrace ovladajiciho hada zjistime jestli jsou nove pokynu pro pohyb
  if (Hrac->Smer(NovySmer))
  {
    // trida THrac musi zajistit, ze smer pohybu nebude opacny nez ted:
    // had se nemuzu otocit najednou o 180 stupnu
    assert((Smer % 2) != (NovySmer % 2));
    Smer = NovySmer;
  }
  // zjistime souradnice na ktere se posouva hlava hada
  int X = Clanky[0];
  int Y = Clanky[1];
  PohniVeSmeru(X, Y, Smer);
  int Parametr;
  // zjistime co se stane kdyz se pohneme na nove souradnice
  int Udalost = HraciPlan->Naraz(X, Y, Parametr);
  // pokud pohyb neznamena smrt, posuneme hada
  if (Udalost != nrSmrt)
  {
    if (Udalost == nrBody)
    {
      // pokud jsme ziskali body, bude se had prodluzovat, tj.
      // musime prodlouzit i buffer
      Delka++;
      Clanky = (char*)realloc(Clanky, Delka*2);
      assert(Clanky);
      // pridame hraci body
      Hrac->PridejBody(Parametr);
    }
    // posuneme vsechny dalsi clanky (krome hlavy)
    // na pozici predesleho clanku
    // pokud se o kkrok drive neprodluzoval buffer, posledni clanek se "ztrati"
    for (int Clanek = Delka-1; Clanek > 0; Clanek--)
    {
      Clanky[Clanek*2] = Clanky[(Clanek-1)*2];
      Clanky[Clanek*2+1] = Clanky[(Clanek-1)*2+1];
    }
    // umistnime hlavu hada na nove souradnice 
    Clanky[0] = X;
    Clanky[1] = Y;
  }
  // pokud narazem doslo ke smrti, vratime false -> konec hry
  Mrtvy = (Udalost == nrSmrt);
  return !Mrtvy;
} /* THad::Pohni */
//---------------------------------------------------------------------------
int THad::Vzor(int X, int Y, int & Soused)
{
  // nejdriv zjitime jestli je had vubec na souradnicich X, Y
  int Clanek = JeTamClanek(X, Y);
  if (Clanek >= 0)
  {
    // pokud tam je zjistime na kterych sousednich polickach je
    // predesly a nasledujici clanek hada
    Soused = ssZadny;
    #define SOUSED(DX, DY, S) if (JeTamSoused(Clanek, X + (DX), Y + (DY))) Soused |= S
    SOUSED(0, -1, ssNahore);
    SOUSED(+1, 0, ssVpravo);
    SOUSED(0, +1, ssDole);
    SOUSED(-1, 0, ssVlevo);
    #undef SOUSED;
    // pro hlavu hada (prvni clanek) vratime jiny vzor nez pro zbytek tela
    if (Clanek == 0) return vzHlavaHada + Hrac->VratPoradi()*2;
      else return vzHad + Hrac->VratPoradi()*2;
  }
    else return vzNic;
} /* THad::Vzor */
//---------------------------------------------------------------------------
int THad::CoKdyzNarazim(int X, int Y, int & Parametr)
{
  if (JeTamClanek(X, Y) >= 0)
  {
    // naraz do tela hada (byt vlastniho) znamena smrt
    Parametr = 0;
    return nrSmrt;
  }
    else return nrNic;
} /* THad:CoKdyzNarazim */
//---------------------------------------------------------------------------
int THad::Naraz(int X, int Y, int & Parametr)
{
  // Naraz() vrati to same jako CoKdyzNarazim(), protoze pokud do hada nekdo
  // narazi pro nej samotneho to nic neznamena
  return CoKdyzNarazim(X, Y, Parametr);
} /* THad::Naraz */
//---------------------------------------------------------------------------
int THad::JeTamClanek(int X, int Y)
{
  assert(Clanky);
  // pokud zadny clanek hada neni na X, Y vratime -1
  int JeTam = -1;
  // projdeme souradnice clanku tela a hledame X, Y
  for (int Clanek = 0; (Clanek < Delka) && (JeTam < 0); Clanek++)
    if (Clanky[Clanek*2] == X && Clanky[Clanek*2+1] == Y)
      JeTam = Clanek;
  return JeTam;
} /* THad::JeTamClanek */
//---------------------------------------------------------------------------
int THad::JeTamSoused(int Clanek, int X, int Y)
{
  assert(Clanky);
  // porovname souradnice sousednich clanku hada (pokud jsou)
  // se zadanymi souradnicemi
  return
    ((Clanek > 0 && Clanky[(Clanek-1)*2] == X && Clanky[(Clanek-1)*2+1] == Y) ||
     (Clanek < Delka-1 && Clanky[(Clanek+1)*2] == X && Clanky[(Clanek+1)*2+1] == Y));
} /* THad::JeTamSoused */
//---------------------------------------------------------------------------
int THad::VratSmer()
{
  return Smer;
} /* THad::VratSmer */
//---------------------------------------------------------------------------
void THad::VratHlavu(int & X, int & Y)
{
  assert(Delka);
  X = Clanky[0];
  Y = Clanky[1];
} /* THad::VratHlavu */
//---------------------------------------------------------------------------
int THad::JeMrtvy()
{
  return Mrtvy;
} /* THad::JeMrtvy */

