//---------------------------------------------------------------------------
#include <assert.h>

#include "Hra.h"
#include "LidskyHrac.h"
#include "AIHrac.h"
//---------------------------------------------------------------------------
THra::THra(TParametryHry AParametry):
  HraciPlan(NULL), Konec(false),
  Parametry(AParametry)
{
  for (int Index = 0; Index < MAX_HRACU; Index++)
    Hraci[Index] = NULL;
} /* THra::THra */
//---------------------------------------------------------------------------
THra::~THra()
{
  // uvolni hraci plan a hrace, pokud uz byli vytvoreni:
  // byla zavolana metoda Hraj()
  if (HraciPlan)
  {
    delete HraciPlan;
    HraciPlan = NULL;
  };
  for (int Index = 0; Index < MAX_HRACU; Index++)
    if (Hraci[Index]) {
      delete Hraci[Index];
      Hraci[Index] = NULL;
    }
} /* THra::~THra */
//---------------------------------------------------------------------------
int THra::SirkaPlanu()
{
  return Parametry.Sirka;
} /* THra::SirkaPlanu */
//---------------------------------------------------------------------------
int THra::VyskaPlanu()
{
  return Parametry.Vyska;
} /* THra::VyskaPlanu */
//---------------------------------------------------------------------------
void THra::Hraj()
{
  if (HraciPlan) return;
  Konec = false;
  // vytvorime hrace
  for (int Index = 0; Index < Parametry.PocetHracu; Index++)
  {
    Hraci[Index] = NULL;
    switch (Parametry.TypyHracu[Index]) {
      case LIDSKY_HRAC: Hraci[Index] = new TLidskyHrac(this, Index); break;
      case POCITACOVY_HRAC: Hraci[Index] = new TAIHrac(this, Index, Parametry.ParametryHracu[Index]); break;
    }
    assert(Hraci[Index]);
  }
  // vytvorime hraci plan
  HraciPlan = new THraciPlan(this);
  do {
    // vykreslime hraci plan
    Kresli();
    // cekame primerene dlouhou dobu a ziskavame vstup (pokyny)
    // od lidskeho hrace
    Cekej();
    // pokud jeste nebyla hra ukoncena (volanim Ukonci)
    // pohneme vsemi prvky hraciho planu a zjitime jestli
    // pohybem nedoslo k smrti hrace -> konec hry
  } while (!Konec && HraciPlan->Pohni());

  // pokud hraje vic hracu, dostane ten co ukoncil hru (narazem)
  // penaltu (zptrati tretinu bodu)
  if (Parametry.PocetHracu > 1)
    for (int Hrac = 0; Hrac < Parametry.PocetHracu; Hrac++)
      if (Hraci[Hrac]->JeMrtvy()) Hraci[Hrac]->Penalta();
} /* THra::Hraj */
//---------------------------------------------------------------------------
void THra::Ukonci()
{
  assert(HraciPlan);
  // prerusi cyklus v Hraj()
  Konec = true;
} /* THra::Ukonci */
//---------------------------------------------------------------------------
THrac * THra::VratHrace(int Index)
{
  return Hraci[Index];
} /* THra::VratHrace */
//---------------------------------------------------------------------------
TStavHry THra::VratStavHry()
{
  TStavHry StavHry;
  // zjistime pocet bodu nastradanych hracem
  for (int Index = 0; Index < MAX_HRACU; Index++)
  {
    if (Index < Parametry.PocetHracu && Hraci[Index])
      StavHry.Body[Index] = Hraci[Index]->Body;
    else
      StavHry.Body[Index] = 0;
  }
  return StavHry;
} /* THra::VratStavHry */
//---------------------------------------------------------------------------
TParametryHry THra::VratParametry()
{
  return Parametry;
} /* THra::VratParametry */
//---------------------------------------------------------------------------
THraciPlan * THra::VratHraciPlan()
{
  return HraciPlan;
} /* THra::VratHraciPlan */

