//---------------------------------------------------------------------------
#include <assert.h>

#include "LidskyHrac.h"
#include "RizenyHad.h"
//---------------------------------------------------------------------------
TLidskyHrac::TLidskyHrac(THra * AHra, int APoradi):
  THrac(Hra, APoradi), PocetSmeru(0)
{
} /* TLidskyHrac::TLidskyHrac */
//---------------------------------------------------------------------------
int TLidskyHrac::Smer(int & NovySmer)
{
  // mame v bufferu pripravenou nejakou zmenu smeru?
  if (PocetSmeru > 0)
  {
    int PovolenySmer;
    int MoznySmer;
    do {
      // prvni zmena smeru v bufferu
      MoznySmer = PristiSmery[0];
      // vymazeme vybranou zmenu z bufferu 
      for (int Smer = 0; Smer < PocetSmeru-1; Smer++)
        PristiSmery[Smer] = PristiSmery[Smer+1];
      PocetSmeru--;
      // had se nemuze otocit o 180 stupnu a smer kterym jiz jede
      // nema smysl posilat (resp. to nesmime poslat, viz THad::Pohni()
      PovolenySmer = (MoznySmer % 2) != (Had->VratSmer() % 2);
    } while (!PovolenySmer && (PocetSmeru > 0));
    // pokud jsme nasli alespon jednu povolenou zmenu smeru, tak ji pouzijeme
    if (PovolenySmer) NovySmer = MoznySmer;
    return PovolenySmer;
  }
    else return false;
} /* TLidskyHrac::Smer */
//---------------------------------------------------------------------------
void TLidskyHrac::PridejSmer(int Smer)
{
  // prida novou zmenu smeru nakonec bufferu, pokud se do nej uz nevejde
  // ignoruje se (ztrati se)
  if (PocetSmeru < MAX_PRISTICH_SMERU-1)
  {
    PocetSmeru++;
    PristiSmery[PocetSmeru-1] = Smer;
  }
} /* TLidskyHrac::PridejSmer */
//---------------------------------------------------------------------------
int TLidskyHrac::Typ()
{
  return LIDSKY_HRAC;
} /* TLidskyHrac::Typ */

