//---------------------------------------------------------------------------
#ifndef LidskyHracH
#define LidskyHracH

#include "Hrac.h"
//---------------------------------------------------------------------------
// maximalni poet stisku klave, ktere muze uzivatel namackat 'dopredu'
#define MAX_PRISTICH_SMERU 4
//---------------------------------------------------------------------------
// TLidskyHrac je dedic abstraktni tridy THrac
// predefinovava metodu Smer(), tak ze reflektuje pokyny cloveka z klavesnice
//---------------------------------------------------------------------------
class TLidskyHrac : public THrac
{
private:
  // pocet zmen smeru v bufferu: uzivatel muze zmeny smeru namackat rychle
  // za sebou (napr. kdyz se chce otocit o 180 stupnu), my je ale
  // musime vydavat postupne krok za krokem, takze si je musime
  // pamatovat ve vyrovnavacim bufferu (PristiSmery)
  int PocetSmeru;
  // vyrovnavaci buffer
  int PristiSmery[MAX_PRISTICH_SMERU];
protected:
public:
  // vytvori hrace a nastavy vychozi hodnoty
  TLidskyHrac(THra * AHra, int APoradi);
  // vrati prvni smer z bufferu, pokud zadny neceka, vrati false
  virtual int Smer(int & NovySmer);
  // prida novou zmenu smeru nakonec bufferu, pokud se do nej uz nevejde
  // ignoruje se (ztrati se)
  void PridejSmer(int Smer);
  // nastavi parametr hrace (ulozi se do Poradi, ovlivni kterimi klavesami hraje)
  virtual int Typ();
};
//---------------------------------------------------------------------------
#endif
