//---------------------------------------------------------------------------
#include <assert.h>
#include <stdlib.h>

#include "Potrava.h"
//---------------------------------------------------------------------------
TPotrava::TPotrava(THraciPlan * AHraciPlan):
  TPrvekHry(AHraciPlan), Body(0)
{
  // na zacatku vygenerujeme novou polohu
  Generuj();
} /* TPotrava::TPotrava */
//---------------------------------------------------------------------------
void TPotrava::Generuj()
{
  Body = 10;

  // premisti potravu na nahodne misto na hraci plose
  assert(HraciPlan);
  HraciPlan->VolnyProstor(1, 1, X, Y);

  // je nova, tj jeste nebyla sezrana
  Sezrana = 0;
} /* TPotrava::Generuj */
//---------------------------------------------------------------------------
int TPotrava::CoKdyzNarazim(int AX, int AY, int & Parametr)
{
  if (!Sezrana && (X == AX) && (Y == AY))
  {
    // pokud by had narazil, tak ziska body
    Parametr = Body;
    return nrBody;
  }
  // pokud souradnice neodpovidaji, nebo je sezrana, tak se nic nedeje
    else return nrNic;
}
//---------------------------------------------------------------------------
int TPotrava::Vzor(int AX, int AY, int & Soused)
{
  if (!Sezrana && (X == AX) && (Y == AY))
  {
    // potrava je na jednom policku -> zadny soused
    Soused = ssZadny;
    return vzPotrava;
  }
  // pokud souradnice neodpovidaji, nebo je sezrana, tak se nic nedeje
    else return vzNic;
} /* TPotrava::Vzor */
//---------------------------------------------------------------------------
int TPotrava::Pohni()
{
  // od posledniho generovani byla sezrana, takze vytvorime novou
  if (Sezrana) Generuj();
  // pohybem potravy nikdy nedojde k ukonceni hry
  return true;
} /* TPotrava::Pohni */
//---------------------------------------------------------------------------
int TPotrava::Naraz(int AX, int AY, int & Parametr)
{
  if (!Sezrana && (X == AX) && (Y == AY))
  {
    // pri narazu se ziskavaji body, musime vratit kolik
    Parametr = Body;
    // naraz znamena, ze potrava je sezrana, muzime vygenerovat novou
    // potravu ==>> TPotrava::Pohni()
    Sezrana = 1;
    return nrBody;
  }
  // pokud souradnice neodpovidaji, nebo je sezrana, tak se nic nedeje
    else return nrNic;
} /* TPotrava::Naraz */
//---------------------------------------------------------------------------

