//---------------------------------------------------------------------------
#ifndef PotravaH
#define PotravaH

#include "PrvekHry.h"
//---------------------------------------------------------------------------
// TPotrava: prvek hry reprezentujici potravu hada, narazem do ni ziskava
// had (resp. hrac) body, po narazu se potrava presune na novou pozici 
//---------------------------------------------------------------------------
class TPotrava : public TPrvekHry
{
private:
  // souradnice potravy
  int X, Y;
  // kolik bodu dostane hrac co ji sezere (narazi do ni)
  int Body;
  // byla sezrana? -> pri dalsim volani Pohni() se musi presunou jinam
  // do te doby jakoby "neexistuje"
  int Sezrana;
protected:
  // presune potravu na nove misto, vola se na zacatku a po kazdem sezrani
  void Generuj();
public:
  // vytvori potravu a zavola Generuj() 
  TPotrava(THraciPlan * AHraciPlan);
  // vrati vzor potravy, pokud AX, AY jsou jeji souradnice
  // Soused je vzdy ssZadny
  // pokud je Sezrana, tak vzdy vrati vzNic
  virtual int Vzor(int AX, int AY, int & Soused);
  // pokud byla od posledniho volani Sezrana, zavola znovu Generuj()
  virtual int Pohni();
  // vrati nrBody, pokud odpovidaji souradnice, v Parametru vrati pocet
  // pripadne zistakych bodu
  // pokud je Sezrana, tak vzdy vrati nrNic
  virtual int CoKdyzNarazim(int AX, int AY, int & Parametr);
  // jako CoKdyzNarazim(), navic nastavi Sezrana = true, aby se pri pristim
  // volani Pohni() presunula na nove misto
  // pokud uz je Sezrana, tak vzdy vrati nrNic
  virtual int Naraz(int AX, int AY, int & Parametr);
};
//---------------------------------------------------------------------------
#endif
