//---------------------------------------------------------------------------
#include <assert.h>
#include <stdlib.h>

#include "Prekazka.h"
//---------------------------------------------------------------------------
TPrekazka::TPrekazka(THraciPlan * AHraciPlan):
  TPrvekHry(AHraciPlan)
{
  // vygenerujeme polohu a orientaci prekazky
  Generuj();
} /* TPrekazka::TPrekazka */
//---------------------------------------------------------------------------
void TPrekazka::Generuj()
{
  // prekazka musi uz byt prvkem nejakeho hraciho planu
  assert(HraciPlan);
  // bude horizontalni nebo vertikalni?
  Orientace = random(2);
  // prekazka je vzdy dlouha jako tretina rozmeru hraci plochy
  if (Orientace == orHorizontalni) Delka = HraciPlan->Sirka()/3;
    Delka = HraciPlan->Vyska()/3;
  // vyhradime si volne misto, tak aby okolo bylo aspon jedno policko volne,
  // tim se zabrani vytvoreni uzavrenych prostoru
  // HraciPlan->VolnyProstor musi vratit true -> jeste existuje
  // dostatecne velke volne misto, zatim neresime co kdyz uz nebude
  assert(HraciPlan->VolnyProstor(
    (Orientace == orHorizontalni ? 1+Delka+1 : 3),
    (Orientace == orHorizontalni ? 3 : 1+Delka+1), X, Y));
  // posuneme souradnice volneho prostoru o 1 a tim ziskame
  // polohu prekazky s 1 volnym polickem na vsech stranach
  X++; Y++;
} /* TPrekazka::Generuj */
//---------------------------------------------------------------------------
int TPrekazka::JeTamZed(int AX, int AY)
{
  // podle orientace a polohy prekazky rohodne, jestli dane souradnice lezi
  // na plose prekazky. vrati index policka prekazky
  if (Orientace == orHorizontalni && AX >= X && AX < X + Delka && AY == Y)
      return AX - X;
    else
  if (Orientace == orVertikalni && AX == X && AY >= Y && AY < Y + Delka)
      return AY - Y;
    // prekazka na souradnicich AX, AY neni
    else return -1;
} /* TPrekazka::JeTamZed */
//---------------------------------------------------------------------------
int TPrekazka::Vzor(int AX, int AY, int & Soused)
{
  // pokud jsou souradnice na plose vratime vzor odpovidajici orientaci
  // prekazky, to umozni pri vykreslovani stejne orientovat vykreslovany vzor
  int Zed = JeTamZed(AX, AY);
  if (Zed >= 0)
  {
    // souradnice jsou v prekazce
    // podle indexu policka prekazky a orientace vratime, v jakych
    // smerech od policka prekazka pokracuje
    Soused = ssZadny;
    if (Orientace == orVertikalni)
    {
      if (Zed > 0) Soused |= ssNahore;
      if (Zed < Delka-1) Soused |= ssDole;
      return vzVertPrekazka;
    }
      else
    {
      if (Zed > 0) Soused |= ssVlevo;
      if (Zed < Delka-1) Soused |= ssVpravo;
      return vzHorizPrekazka;
    }
  }
    else return vzNic;
} /* TPrekazka::Vzor */
//---------------------------------------------------------------------------
int TPrekazka::Pohni()
{
  // prekazka se nepohybuje, tj ani nemuze dojit k ukonceni hry -> true
  return true;
} /* TPrekazka::Pohni */
//---------------------------------------------------------------------------
int TPrekazka::CoKdyzNarazim(int AX, int AY, int & Parametr)
{
  // naraz by znamenal smrt
  if (JeTamZed(AX, AY) >= 0)
  {
    Parametr = 0;
    return nrSmrt;
  }
    else return nrNic;
} /* TPrekazka::CoKdyzNarazim */
//---------------------------------------------------------------------------
int TPrekazka::Naraz(int AX, int AY, int & Parametr)
{
  // vlastni naraz neprovani s prekazkou nic, tj. staci jen zjistit
  // jestli se vubec neco stane, coz uz dela metoda CoKdyzNarazim()
  return CoKdyzNarazim(AX, AY, Parametr);
} /* TPrekazka::Naraz */

