//---------------------------------------------------------------------------
// Trida THad: reprezentuje hada jako prvek hraci plochy, had
// je rizen hracem (THrac)
//---------------------------------------------------------------------------
#ifndef RizenyHadH
#define RizenyHadH

#include "PrvekHry.h"
#include "Hrac.h"
//---------------------------------------------------------------------------
// mozne smery pohybu hada
#define smNahoru 0
#define smDoprava 1
#define smDolu 2
#define smDoleva 3
// kontanty ovlivnujici veliskot/polohu hada
#define VYCHOZI_DELKA_HADA 6
#define REZERVA_PRED_HADEM 5
//---------------------------------------------------------------------------
class THad : public TPrvekHry
{
protected:
  // hrac, ktery ridi tohoto hada
  THrac * Hrac;
  // pole poloh clanku data, vzdy dva prvky za sebou urcuji polohu (X, Y)
  // jednoho clanku
  char * Clanky;
  // pocet clanku v tele hada, tj. pocet alokovanych bajtu v Clanky / 2
  int Delka;
  // smer pohybu hlavy hada (smXXXX)
  int Smer;
  // had je mrtvy (narazil)
  int Mrtvy;

  // vygeneruje vychozi polohu a smer pohybu hada
  void Generuj();
  // vrati index clanku hada na souradnicich X, Y nebo -1 pokud
  // tam zadny clanek neni
  int JeTamClanek(int X, int Y);
  // zjisti jestli na souradnicich X, Y je sousedni clanek
  // N-teho clanku hada
  int JeTamSoused(int Clanek, int X, int Y);
public:
  // vytvori hada a asociuje ho s hlaci plochou a hracem a zavola Generuj()
  THad(THraciPlan * AHraciPlan, THrac * AHrac);
  // uvolni hada a pole s polohami clanku
  virtual ~THad();
  // pokud je had na X, Y vrati index vzoru hada, jiny pro hlavu a zbytek tela
  virtual int Vzor(int X, int Y, int & Soused);
  // pohne vsemi clanky tela hada ve smeru pohybu,
  // pokud pohybem had narazi na potravu prida asociovanemu hraci body,
  // pokud narazi na stenu vrati false -> konec hry
  virtual int Pohni();
  // pokud je had na X, Y, vrati smrt -> naraz do hada (byt sebe sama)
  // neni povolen
  virtual int CoKdyzNarazim(int X, int Y, int & Parametr);
  int JeMrtvy();
  // to same jako CoKdyzNarazim(), protoze pokud do hada nekdo narazi
  // pro nej samotneho to nic neznamena
  virtual int Naraz(int X, int Y, int & Parametr);
  void VratHlavu(int & X, int & Y);
  // vrati smer pohybu hada (viz atribut Smer)
  int VratSmer();
};
//---------------------------------------------------------------------------
void PohniVeSmeru(int & X, int & Y, int Smer);
//---------------------------------------------------------------------------
#endif
