//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <winbase.h>
#include <assert.h>
#include <Classes.hpp>

#include "LidskyHrac.h"
#include "VclHra.h"
#include "RizenyHad.h"
//---------------------------------------------------------------------------
TVclHra::TVclHra(TParametryHry AParametry, TControl * AControl):
  THra(AParametry), Control(AControl)
{
} /* TVclHra::TVclHra */
//---------------------------------------------------------------------------
void TVclHra::Kresli()
{
  assert(Control);
  // vyvolame prekresleni prirazene komponenty (mela by zajistit
  // nakresleni hraci plochy)
  Control->Invalidate();
} /* TVclHra::Kresli */
//---------------------------------------------------------------------------
void TVclHra::Cekej()
{
  // cekaci cyklus, prerusi se volanim metody Pokracuj()
  // nebo ukoncenim hry
  MuzuPokracovat = false;
  do {
    Application->ProcessMessages();
    Sleep(30);
  } while (!MuzuPokracovat && !Konec);
} /* TVclHra::Cekej */
//---------------------------------------------------------------------------
void TVclHra::Pokracuj()
{
  // prerusi cekaci cyklus v metode Cekej();
  MuzuPokracovat = true;
} /* TVclHra::Pokracuj */
//---------------------------------------------------------------------------
int TVclHra::Vzor(int X, int Y, int & Soused)
{
  assert(HraciPlan);
  return HraciPlan->Vzor(X, Y, Soused);
} /* TVclHra::Vzor */
//---------------------------------------------------------------------------
int TVclHra::KlavesaStisknuta(WORD Key, TShiftState Shift)
{
  // stisky klaves prevede na zmenu smeru lidskeho hrace (jeho hada)
  // vrati true, pokud byla klavesa pouzita
  int Vysledek = true;
  int Smer;
  int Poradi;
  switch (Key) {
    case VK_UP: Smer = smNahoru; Poradi = 0; break;
    case VK_RIGHT: Smer = smDoprava; Poradi = 0; break;
    case VK_DOWN: Smer = smDolu; Poradi = 0; break;
    case VK_LEFT: Smer = smDoleva; Poradi = 0; break;
    case 'W': Smer = smNahoru; Poradi = 1; break;
    case 'D': Smer = smDoprava; Poradi = 1; break;
    case 'X': Smer = smDolu; Poradi = 1; break;
    case 'A': Smer = smDoleva; Poradi = 1; break;
    default: Vysledek = false; break;
  }
  if (Vysledek)
  {
    Vysledek = false;
    for (int Index = 0; Index < Parametry.PocetHracu; Index++)
      if (Hraci[Index]->Typ() == LIDSKY_HRAC &&
          Hraci[Index]->VratPoradi() == Poradi)
      {
        ((TLidskyHrac*)Hraci[Index])->PridejSmer(Smer);
        Vysledek = true;
      }
  }
  return Vysledek;
} /* TVclHra::KlavesaStisknuta */

