//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <assert.h>

#include "AIHrac.h"
#include "RizenyHad.h"
#include "HraciPlanCache.h"
//---------------------------------------------------------------------------
TAIHrac::TAIHrac(THra * AHra, int APoradi, int AInteligence):
  THrac(AHra, APoradi), Inteligence(AInteligence)
{
} /* TAIHrac::TAIHrac */
//---------------------------------------------------------------------------
int TAIHrac::MuzuVeSmeru(THraciPlan * HraciPlan, int Smer)
{
  int X, Y, Parametr;
  Had->VratHlavu(X, Y);
  PohniVeSmeru(X, Y, Smer);
  // do daneho smeru muzu, pokud me tam neceka smrt a neni to nepovoleny smer
  // (celem vzad)
  return
    ((HraciPlan->CoKdyzNarazim(X, Y, Parametr) != nrSmrt) &&
     ((Smer % 2) != (Had->VratSmer() % 2)));
} /* TAIHrac::MuzuVeSmeru */
//---------------------------------------------------------------------------
int TAIHrac::Smer(int & NovySmer)
{
  assert(Had && Hra);
  int X, Y, Vysledek;;
  Had->VratHlavu(X, Y);
  // vytvorime si kopii hraciho planu, umoznujici rychli pristup (cache)
  THraciPlanCache * HraciPlan = new THraciPlanCache(X, Y, Hra->VratHraciPlan());
  int MoznySmer = -1;
  // hledame nejkratsi cestu k cili (nejhodnotnejsimu policku)
  if (HraciPlan->NejOblast())
    MoznySmer = HraciPlan->HledejCestu(Inteligence, HraciPlan->NejX(), HraciPlan->NejY());
  // nasli jsme cestu?
  if (MoznySmer >= 0)
  {
    // pokud je doporuceny smer stejny jako stavajici, nic se nemeni
    if (MoznySmer == Had->VratSmer()) Vysledek = false;
      else
    {
      assert(MuzuVeSmeru(HraciPlan, MoznySmer));
      // zmena smeru
      NovySmer = MoznySmer;
      Vysledek = true;
    }
  }
    else
  // pokud jsme nenasli cestu (potrava je sezrana nebo jsme ve slepe ulicce)...
  {
    int Parametr;
    // ...zkusime pokracovat dal stavajicim smerem
    PohniVeSmeru(X, Y, Had->VratSmer());
    if (HraciPlan->CoKdyzNarazim(X, Y, Parametr) != nrSmrt) Vysledek = false;
      else
    // nemuzeme dopredu (znamenalo by to smrt)
    {
      // zjistime jestli se vubec jeste nekam da jit
      // (had je obkliceny ze vsech stran)
      for (MoznySmer = 0; MoznySmer < 4; MoznySmer++)
        if (MuzuVeSmeru(HraciPlan, MoznySmer)) break;
      if (MoznySmer == 4) Vysledek = false; // uz nemam kam jit: zbyva jen smrt
        else
      {
        // nahodne vybereme smer z moznych
        do {
          MoznySmer = random(4);
          Had->VratHlavu(X, Y);
          PohniVeSmeru(X, Y, MoznySmer);
        } while (!MuzuVeSmeru(HraciPlan, MoznySmer));
        NovySmer = MoznySmer;
        Vysledek = true;
      }
    }
  }
  delete HraciPlan;
  return Vysledek;
} /* TAIHrac::Smer */
//---------------------------------------------------------------------------
int TAIHrac::Typ()
{
  return POCITACOVY_HRAC;
} /* TAIHrac::Typ */

