//---------------------------------------------------------------------------
#include <assert.h>

#include "Hrac.h"
#include "RizenyHad.h"
//---------------------------------------------------------------------------
THrac::THrac(THra * AHra, int APoradi):
  Hra(AHra), Body(0), Had(NULL), Poradi(APoradi)
{
} /* THrac::THrac */
//---------------------------------------------------------------------------
THrac::~THrac()
{
  // had musi byt zrusen driv nez hrac
  assert(!Had);
} /* THrac::~THrac */
//---------------------------------------------------------------------------
int THrac::PocetBodu()
{
  return Body;
} /* THrac::PocetBodu */
//---------------------------------------------------------------------------
int THrac::PridejBody(int Kolik)
{
  return Body += Kolik;
} /* THrac::PridejBody */
//---------------------------------------------------------------------------
void THrac::PriradHada(THad * AHad)
{
  Had = AHad;
} /* THrac::PriradHada */
//---------------------------------------------------------------------------
int THrac::VratPoradi()
{
  return Poradi;
} /* THrac::VratPoradi */
//---------------------------------------------------------------------------
void THrac::Penalta()
{
  Body -= Body/3;
} /* THrac::Penalta */
//---------------------------------------------------------------------------
int THrac::JeMrtvy()
{
  assert(Had);
  return Had->JeMrtvy();
} /* THrac::JeMrtvy */

