//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <assert.h>
#include <stdio.h>

#include "HraciPlanCache.h"
#include "AIHrac.h"
#include "RizenyHad.h"
//---------------------------------------------------------------------------
THraciPlanCache::THraciPlanCache(int AStartX, int AStartY, THraciPlan * AHraciPlan):
  HraciPlan(AHraciPlan)
{
  assert(HraciPlan);
  // "nacachujeme" sirku a vysku hraci plochy
  FSirka = HraciPlan->Sirka();
  FVyska = HraciPlan->Vyska();
  StartX = AStartX;
  StartY = AStartY;
  // alokujeme pamet, tak aby se do ni vesla cela hraci plocha
  Cache = (TPoleCache*)malloc(sizeof(TPoleCache) * FSirka * FVyska);
  assert(Cache);
  // prekopirujeme hraci plan do cache
  int Y, X, Index, Nic;
  int NejBody = 0; // nejhodnotnejsi nalezena potrava
  FNejX = -1; FNejY = -1; // kde je nehodnotnejsi potrava nalezena potrava
  for (Y = 0; Y < FVyska; Y++)
    for (X = 0; X < FSirka; X++)
    {
      Index = (FSirka*Y + X);
      Cache[Index].Naraz = HraciPlan->CoKdyzNarazim(X, Y, Cache[Index].Parametr);
      if (Cache[Index].Naraz == nrBody && Cache[Index].Parametr > NejBody)
      {
        FNejX = X;
        FNejY = Y;
      }
      // policko kde je hlava hada je prvni olast, jinak zatim oblast nevime
      Cache[Index].Oblast = (X == StartX && Y == StartY);
    }
  // potrava nekde byt musi
  PocetOblasti = 1;
  FNejOblast = 0;
  // prochazime hraci plan a seskupujeme volna pole do obdelnikovych oblasti
  for (Y = 0; Y < FVyska; Y++)
    for (X = 0; X < FSirka; X++)
      // nasli jsme policko, ktere je volne a jeste neni v zadne oblasti
      if (JenNaraz(X, Y) != nrSmrt && !Oblast(X, Y))
      {
        // nova oblast
        PocetOblasti++;
        int NejSirka, NejPlocha = 0, NejVyska;
        // hledame nejvetsi volnou oblast zacinajici timto polickem:
        // hledame ji tak, ze pro vsechny mozne sirky oblasti zkousime
        // jak vysoke by mohli byt, vybereme tu s nejvetsim nasobkem sirky a vysky
        for (int OSirka = 1; OSirka <= FSirka - X; OSirka++)
        {
          int OVyska = 0;
          int OX;
          // kolik volnych radek o sirce OSirka je pod sebou pocinaje bodem X, Y?
          do {
            OX = 0;
            while ((OX < OSirka) && (JenNaraz(X+OX, Y+OVyska) != nrSmrt) &&
              !Oblast(X+OX, Y+OVyska)) OX++;
            if (OX == OSirka) OVyska++;
          } while (OX == OSirka);
          // vypocitame plochu...
          int Plocha = OVyska*OSirka;
          // ... a pokud je vetsi nez nejvetsi dosud nalezena, tak
          // si ji zapamatujeme
          if (Plocha > NejPlocha)
          {
            NejSirka = OSirka;
            NejPlocha = Plocha;
            NejVyska = OVyska;
          }
        }
        // vybranou oblast oznacime
        for (int OY = 0; OY < NejVyska; OY++)
          for (int OX = 0; OX < NejSirka; OX++)
          {
            NastavOblast(X+OX, Y+OY, PocetOblasti);
            if (X+OX == FNejX && Y+OY == FNejY)
              FNejOblast = PocetOblasti;
          }
      }
  // alokujeme pole v kterem bude pro kazdou oblast retezec indexu
  // sousedicich oblasti
  Oblasti = (TOblast*)malloc(sizeof(TOblast) * (PocetOblasti+1));
  // alokujeme pamet pro jednotlive retezce v poli
  for (Index = 0; Index < PocetOblasti+1; Index++)
  {
    Oblasti[Index].Sousede = (char*)malloc(PocetOblasti+1);
    memset(Oblasti[Index].Sousede, '\0', PocetOblasti+1);
    Oblasti[Index].Levy = FSirka+1;
    Oblasti[Index].Horni = FVyska+1;
    Oblasti[Index].Pravy = -1;
    Oblasti[Index].Dolni = -1;
  }
  char O, OSoused;
  assert(PocetOblasti <= 255);
  // najdeme ke kazde oblasti jeji sousedni oblasti a zazoven si zapamatujeme
  // hranice oblasti (horni, dolni, levou a pravou)
  for (Y = 0; Y < FVyska; Y++)
    for (X = 0; X < FSirka; X++)
    {
      int O;
      O = Oblast(X, Y);
      if (O)
      {
        #define PRIDEJ_SOUSEDA(DX, DY) \
          OSoused = Oblast(X + (DX), Y + (DY)); \
          if (OSoused > 0 && OSoused != O && !strchr(Oblasti[O].Sousede, OSoused)) \
            Oblasti[O].Sousede[strlen(Oblasti[O].Sousede)] = OSoused;
        PRIDEJ_SOUSEDA(-1, 0);
        PRIDEJ_SOUSEDA(+1, 0);
        PRIDEJ_SOUSEDA(0, -1);
        PRIDEJ_SOUSEDA(0, +1);
        #undef PRIDEJ_SOUSEDA
        if (X < Oblasti[O].Levy) Oblasti[O].Levy = X;
        if (X > Oblasti[O].Pravy) Oblasti[O].Pravy = X;
        if (Y < Oblasti[O].Horni) Oblasti[O].Horni = Y;
        if (Y > Oblasti[O].Dolni) Oblasti[O].Dolni = Y;
      }
    }
} /* THraciPlanCache::THraciPlanCache */
//---------------------------------------------------------------------------
int THraciPlanCache::HledejCestu(int Inteligence, int DoX, int DoY)
{
  int CelkovaDelka;
  char ZakazaneOblasti[2]; // pole oblasti do kterych se jiz nema vstupovat
  // na zacatku zakazeme vychozi oblast (nema smysl se do ni vracet)
  sprintf(ZakazaneOblasti, "%c", '\1');
  // zahajime hledani cesty
  int JdiDoOblasti = HledejCestuSmerem(Inteligence, DoX, DoY, 1,
    ZakazaneOblasti, 0, CelkovaDelka, StartX, StartY);
  // pokud jsme cestu nasli ...
  if (JdiDoOblasti)
  {
    // ... sjistime jakym smerem ted jit
    #define SMER_OBLASTI(DX, DY, SMER) \
      if (Oblast(StartX + (DX), StartY + (DY)) == JdiDoOblasti) return SMER;
    SMER_OBLASTI(-1, 0, smDoleva);
    SMER_OBLASTI(+1, 0, smDoprava);
    SMER_OBLASTI(0, -1, smNahoru);
    SMER_OBLASTI(0, +1, smDolu);
    #undef SMER_OBLASTI
    assert(False);
    return -1;
  }
    else return -1;
} /* THraciPlanCache::HledejCestu */
//---------------------------------------------------------------------------
int THraciPlanCache::HledejCestuSmerem(int Inteligence, int DoX, int DoY,
  char ZOblasti, char * ZakazaneOblasti, int DosavadniDelka, int & CelkovaDelka,
  int PolohaX, int PolohaY)
{
  char DoOblasti = Oblast(DoX, DoY);
  assert(DoOblasti != ZOblasti && Oblasti && DoOblasti > 1 &&
    DoOblasti <= PocetOblasti && ZOblasti > 0 && ZOblasti <= PocetOblasti &&
    ZakazaneOblasti && Oblast(PolohaX, PolohaY) == ZOblasti);

  char * Sousede = Oblasti[ZOblasti].Sousede;
  // pokud je cislova oblast sousedni, tak uz jsme to nasli!
  if (strchr(Sousede, DoOblasti))
  {
    // hloupy hrac povazuje kazdy prechod pres hranice za jeden krok
    // (bez ohledu na velikost oblasti)
    if (Inteligence == HLOUPY_POCITAC) CelkovaDelka = DosavadniDelka + 1;
      else
    // chytry si spocita jak dlouho mu to ve skutecnosti bude trvat
    CelkovaDelka = DosavadniDelka + abs(DoX - PolohaX) + abs(DoY - PolohaY);
    return DoOblasti;
  }
    else
  {
    char * NoveZakazaneOblasti = (char*)malloc(PocetOblasti+1);
    strcpy(NoveZakazaneOblasti, ZakazaneOblasti);
    // sousedni oblasti pridame do zakazanych: nema smysl
    // do nich pozdeji odbocovat , protoze se do nich muzeme
    // dotat primo odtud, tj. nebylo by to efektivni
    int PocetZ = strlen(NoveZakazaneOblasti);
    for (int Ostatni = 0; Ostatni < (char)strlen(Sousede); Ostatni ++)
      if (!strchr(NoveZakazaneOblasti, Sousede[Ostatni]))
      {
        NoveZakazaneOblasti[PocetZ] = Sousede[Ostatni];
        PocetZ++;
      }
    NoveZakazaneOblasti[PocetZ] = '\0';

    int Soused, Vysledek, Delka;
    int NejkratsiDelka;
    int NejSoused = 0;
    int NovaDelka, NoveX, NoveY, SOblast;
    // zkousime jit do vsech sousednich oblasti
    for (Soused = 0; Soused < (char)strlen(Sousede); Soused++)
    {
      SOblast = Sousede[Soused];
      // pokud je sousedni oblast zakazana (uz jsme ji zkouseli odnekud jinud
      // nebo jsme ji jeste nezkouseli, ale uz vime ze do ni vede kratsi cesta)
      // tak ji ted zkouset nebudeme
      if (!strchr(ZakazaneOblasti, SOblast))
      {
        // hledame nejblizsi pole v cilove bolasti od aktualni pozice
        
        if (Oblasti[SOblast].Pravy < PolohaX) NoveX = Oblasti[SOblast].Pravy;
          else
        if (Oblasti[SOblast].Levy > PolohaX) NoveX = Oblasti[SOblast].Levy;
          else NoveX = PolohaX;

        if (Oblasti[SOblast].Dolni < PolohaY) NoveY = Oblasti[SOblast].Dolni;
          else
        if (Oblasti[SOblast].Horni > PolohaY) NoveY = Oblasti[SOblast].Horni;
          else NoveY = PolohaY;

        // podle inteligence hrace ohodnotime narocnost prechodu mezi oblastmi
        if (Inteligence == HLOUPY_POCITAC) NovaDelka = DosavadniDelka+1;
          else
        NovaDelka = DosavadniDelka + abs(PolohaX - NoveX) + abs(PolohaY - NoveY);

        // zkusime nalezt cestu ze sousedni oblasti do cile (rekurzivne)
        Vysledek = HledejCestuSmerem(Inteligence, DoX, DoY, SOblast,
          NoveZakazaneOblasti, NovaDelka, Delka, NoveX, NoveY);
        // pokud existuje cesta ze sousedni oblasti, zjistime jestli
        // je lepsi nez tu co uz zname (pokud je to prvni nalezena, breme ji vzdy) 
        if (Vysledek && (!NejSoused || Delka < NejkratsiDelka))
        {
          NejSoused = Sousede[Soused];
          NejkratsiDelka = Delka;
        }
      }
    }
    free(NoveZakazaneOblasti);
    // vratime vysledek hledani
    if (NejSoused)
    {
      CelkovaDelka = NejkratsiDelka;
      return NejSoused;
    }
      else return 0;
  }
} /* THraciPlanCache::HledejCestu */
//---------------------------------------------------------------------------
THraciPlanCache::~THraciPlanCache()
{
  // uvolnime cache
  assert(Cache);
  free(Cache);
  
  assert(Oblasti);
  // uvolnime pole oblasti
  for (int Oblast = 0; Oblast < PocetOblasti+1; Oblast++)
    free(Oblasti[Oblast].Sousede);
  free(Oblasti);
} /* THraciPlanCache::~THraciPlanCache */
//---------------------------------------------------------------------------
int THraciPlanCache::CoKdyzNarazim(int X, int Y, int & Parametr)
{
  if (!OhlidejHranice(X, Y))
  {
    Parametr = 0;
    return nrSmrt;
  }
    else
  {
    assert(Cache);
    int Index = Y*FSirka+X;
    Parametr = Cache[Index].Parametr;
    return Cache[Index].Naraz;
  }
} /* THraciPlanCache::CoKdyzNarazim */
//---------------------------------------------------------------------------
void THraciPlanCache::NastavOblast(int X, int Y, int Oblast)
{
  assert(OhlidejHranice(X, Y));
  Cache[Y*FSirka+X].Oblast = Oblast;
} /* THraciPlanCache::NastavOblast */
//---------------------------------------------------------------------------

