//---------------------------------------------------------------------------
#ifndef PrvekHryH
#define PrvekHryH

#include "Hra.h"
//---------------------------------------------------------------------------
// mozne vzory, pri vykreslovani hraci plochy, TPrvekHry::Vzor
#define vzNic 0
#define vzPotrava 1
#define vzVertPrekazka 2
#define vzHorizPrekazka 3
#define vzHad 4
#define vzHlavaHada 5
//---------------------------------------------------------------------------
// sousedi prvku hry, pouziva se pri vykreslovani, viz TPrvekHry::Vzor
#define ssZadny  0
#define ssNahore 0x01
#define ssVpravo 0x02
#define ssDole   0x04
#define ssVlevo  0x08
//---------------------------------------------------------------------------
// mozne vysledky narazu do prvku hry,
// viz TPrvekHry::CoKdyzNarazim() a TPrvekHry::Naraz() 
#define nrNic 0
#define nrSmrt 1
#define nrBody 2
//---------------------------------------------------------------------------
class THraciPlan;
//---------------------------------------------------------------------------
// TPrvekHry je abstraktni trida reprezentujici libovolny prvek hraciho planu
class TPrvekHry
{
friend
  THraciPlan;
private:
  // slouzi k vytvareni spojoveho seznamu prvku hry vramci hraciho planu 
  TPrvekHry * Dalsi;
protected:
  // hraci plan, jehoz je prvek hry clenem
  THraciPlan * HraciPlan;
public:
  // vytvori prvek hry a zaradi ho do hraciho planu
  TPrvekHry(THraciPlan * AHraciPlan);
  // nedela nic, ale muze v dedicich -> virtualni
  virtual ~TPrvekHry();
  // tato metoda se musi predefinovat tak, aby pohnula prvkem hry, pokud
  // je to potreba a vratila false, pokud pohybem doslo k ukonceni hry
  virtual int Pohni() = 0;
  // vrati index vzoru (vzXXXX), ktery ma byt vykreslen, na danych
  // souradnicich, pokud na nich prvek lezi, jinak vrati vzNic
  virtual int Vzor(int AX, int AY, int & Soused) = 0;
  // vrati co by se stalo (nrXXXX), kdyby had narazil do prvku na danych
  // souradnicich v parametru vrati pripradne dodatecne udaje o narazu
  virtual int CoKdyzNarazim(int AX, int AY, int & Parametr) = 0;
  // provede skutecny naraz, vratit by mela to same jako CoKdyzNarazim()
  // a navic provest vse co je potreba po narazu (napr. zmena polohy)
  virtual int Naraz(int AX, int AY, int & Parametr) = 0;
};
//---------------------------------------------------------------------------
// hraci plan je dedic tridy TPrvekHry, zaobaluje spojovy seznam instanci
// dedicu tridy TPrevekHry. Abstraktni metody tridy TPrvekHry predefinovava tak
// ze vola stejnou metodu podrizeneho prvku hry, ktery lezi na predanych
// souradnicich 
class THraciPlan : public TPrvekHry
{
protected:
  // hra, ktere hraci plan patri
  THra * Hra;
  // prvni prvek hry v hracim planu (spojovy seznam)
  TPrvekHry * Prvni;
  // vlozi vsechny potrebne prvky hry na hraci plochu (hrace, potravu, prekazky...)
  virtual void Generuj();
  // zjisti jestli je dane pole jeste na hraci plose
  int OhlidejHranice(int X, int Y)
    { return (X >= 0) && (X < Sirka()) && (Y >= 0) && (Y < Vyska()); }
  // prida prvek na konec spojoveho seznamu
  void Pridej(TPrvekHry * PrvekHry);
  // najde prvek, ktery je na danych souradnicich, nebo NULL pokud tam zadny neni
  TPrvekHry * PrvekNa(int X, int Y);
public:
  THraciPlan(): TPrvekHry(NULL), Prvni(NULL), Hra(NULL) {};
  // vytvori hraci plan a zavola Generuj()
  THraciPlan(THra * AHra);
  // zrusi hraci plan a cely spojovy seznam prvku hry
  virtual ~THraciPlan();
  // pokud jsou sourardnice mimo hraci plochu vrati smrt, jinak
  // zavola metodu CoKdyzNarazim() prvku na souradnicich X, Y
  virtual int CoKdyzNarazim(int X, int Y, int & Parametr);
  // podobne jako CoKdyzNarazim()
  virtual int Naraz(int X, int Y, int & Parametr);
  // pohne vsemi prvky hry
  virtual int Pohni();
  // zavola Vzor() prvku hry, ktery je na souradnicich X, Y
  virtual int Vzor(int AX, int AY, int & Soused);
  // vrati sirku hraci plochy
  virtual int Sirka();
  // najde prazdny obdelnikovy prostor o velikost ASirka x AVyska
  // a vrati jeho souradnice
  virtual int VolnyProstor(int ASirka, int AVyska, int & X, int & Y);
  // vrati vysku hraci plochy
  virtual int Vyska();
};
//---------------------------------------------------------------------------
#endif
