//---------------------------------------------------------------------------
#ifndef VclHraH
#define VclHraH

#include "Hra.h"
//---------------------------------------------------------------------------
// TVclHra: implementace abstraktni tridy THra do prostredi Windows
// (resp. C++Builder)
//---------------------------------------------------------------------------
class TVclHra : public THra
{
private:
  // ma se vyskocit z cyklu metody Cekej(), nastavi se volanim
  // metody Pokracuj() po vyprseni casoveho intervalu
  // (realizovano napr. tridou TTimer)
  Boolean MuzuPokracovat;
protected:
  // komponenta, ktera zajistuje vykreslovani hraci plochy 
  TControl * Control;
  // implementace abstraktni metody THra::Cekej(), jako cyklu ktery je prerusen
  // volanim metody Pokracuj(), viz takze atribut MuzuPokracovat
  virtual void Cekej();
  // implementace abstraktni metody THra::Kresli(), vyvola
  // prekresleni prirazene komponenty (Control)
  virtual void Kresli();
public:
  // vytvori hru, nastavi paramatry a priradi komponentu
  // pro vykreslovani hraci plochy 
  TVclHra(TParametryHry AParametry, TControl * AControl);
  // prevede stisknutou klavesu (Key, Shift), na zmenu smeru lidskeho hrace
  // a preda mu ji
  int KlavesaStisknuta(WORD Key, TShiftState Shift);
  // prerusi cekaci cyklus v metode Cekej()
  void Pokracuj();
  // slouzi k publikaci metody HraciPlan->Vzor()
  int Vzor(int X, int Y, int & Soused);
};
//---------------------------------------------------------------------------
#endif
