Attribute VB_Name = "Utility"
Option Explicit

Public Const ImplicitniRok As Integer = 1900

Enum TDen
  dnKonkretni
  dnKazdy
  dnVsedni
  dnVikend
  dnPondeli
  dnUtery
  dnStreda
  dnCtvrtek
  dnPatek
  dnSobota
  dnNedele
  dnSvatek
End Enum

Type TImpulz
  Kolikrat As Byte
  Delka As Integer
End Type

Type TCasTarifuData
  Den As TDen
  Datum As Date
  CasOd As Date
  CasDo As Date
  Pocet As Byte
  Impulzy(0 To 9) As TImpulz
End Type

Type TSvatky
  Pocet As Byte
  Data(0 To 99) As Date
End Type

' z retezce S vyjme cast a do znaku Ch a tu vrati
Function CutToChar(ByRef S As String, ByVal Ch As String) As String
  Dim P As Byte
  
  P = InStr(S, Ch)
  If P = 0 Then
    CutToChar = Trim(S)
    S = ""
  Else
    CutToChar = Trim(Mid(S, 1, P - 1))
    S = Trim(Mid(S, P + 1, Len(S)))
  End If
End Function

' vrati retezec identifikujici typ dne, pod kterym
' se to uklada do databaze
Function DenStr(ByVal Den As TDen) As String
  Select Case Den
    Case dnKonkretni: DenStr = "*"
    Case dnKazdy: DenStr = "Each"
    Case dnVsedni: DenStr = "Weekdays"
    Case dnVikend: DenStr = "Weekend"
    Case dnPondeli: DenStr = "Monday"
    Case dnUtery: DenStr = "Tuesday"
    Case dnStreda: DenStr = "Wednesday"
    Case dnCtvrtek: DenStr = "Thursday"
    Case dnPatek: DenStr = "Friday"
    Case dnSobota: DenStr = "Saturday"
    Case dnNedele: DenStr = "Sunday"
    Case dnSvatek: DenStr = "Holidays"
    Case Else: DenStr = ""
  End Select
End Function

' vrati retezec identifikujici tyn dne, pod kterym
' se to zobrazuje v seznamu
Function DenStrCz(ByVal Den As TDen) As String
  Select Case Den
    Case dnKonkretni: DenStrCz = "*"
    Case dnKazdy: DenStrCz = "Po-Ne"
    Case dnVsedni: DenStrCz = "Po-P"
    Case dnVikend: DenStrCz = "So-Ne"
    Case dnPondeli: DenStrCz = "Po"
    Case dnUtery: DenStrCz = "t"
    Case dnStreda: DenStrCz = "St"
    Case dnCtvrtek: DenStrCz = "t"
    Case dnPatek: DenStrCz = "P"
    Case dnSobota: DenStrCz = "So"
    Case dnNedele: DenStrCz = "Ne"
    Case dnSvatek: DenStrCz = "Svtky"
    Case Else: DenStrCz = ""
  End Select
End Function

' zakoduje cas do vnitni reprezentace
' pokud je to 24:00 vrati na rozdil od TimeSerial 1 a ne 0
Function MyEncodeTime(Hod, Min) As Date
  If Hod < 24 Then
    MyEncodeTime = TimeSerial(Hod, Min, 0)
  Else
    MyEncodeTime = 1
  End If
End Function

' zakoduje datum do vnitrni reprezentace
Function MyEncodeDate(Mesic, Den) As Date
  MyEncodeDate = DateSerial(ImplicitniRok, Mesic, Den)
End Function

' prevede retezec na pole impulzu a jejich opakovani
Sub StrToImpulzy(ByVal Str As String, ByRef Pocet As Byte, ByRef Impulzy() As TImpulz)
  Dim Impulz As String, KolikratS As String
  Dim P As Byte
  
  Pocet = 0
  ' dokud retezec neco obsahuje
  Do While Str <> ""
    ' vyjmi cast a po carku
    Impulz = CutToChar(Str, ",")
    ' pokud tam neco bylo
    If Impulz <> "" Then
      ' maximum je 10
      If Pocet = 10 Then Exit Sub
      ' zkusim najit hvezdicku (rozdeluje pocet opakuvani a delku impulzu)
      P = InStr(Impulz, "*")
      If P = 0 Then
        ' pokud tam hvezdicka neni je pocet opakovani 1
        Impulzy(Pocet).Kolikrat = 1
        Impulzy(Pocet).Delka = CInt(Impulz)
      Else
        ' pokud tak je tak zkousim jestli je pocet opakovani
        ' cislo nebo otaznik (nekonecno)
        KolikratS = Trim(Mid(Impulz, 1, P - 1))
        If KolikratS = "?" Then
          Impulzy(Pocet).Kolikrat = 0
        Else
          Impulzy(Pocet).Kolikrat = CInt(KolikratS)
        End If
        Impulzy(Pocet).Delka = CInt(Trim(Mid(Impulz, P + 1, Len(Impulz))))
      End If
      Pocet = Pocet + 1
    End If
  Loop
End Sub

' prevede pole impulzu a jejich opakovani na retezec
Function ImpulzyToStr(ByVal Pocet As Integer, ByRef Impulzy() As TImpulz) As String
  Dim I As Integer
  Dim R As String
  R = ""
  ' pro kazdou dvojici delka-pocet opakovani
  For I = 0 To Pocet - 1
    ' pokud je to 2. a dalsi prvek rozdelime je carkou
    If I > 0 Then R = R + ", "
    Select Case Impulzy(I).Kolikrat
      ' pokud je pocet opakovani 0 (nekonecno) doplnime otaznik
      Case 0: R = R + "?*"
      ' pokud je to 1 tak nemusim doplnovat nic
      Case 1:
      ' pokud je to neco jineho doplnime cislo
      Case Else: R = R + CStr(Impulzy(I).Kolikrat) + "*"
    End Select
    ' pridame delku impulzu
    R = R + CStr(Impulzy(I).Delka)
  Next
  ImpulzyToStr = R
End Function

' vrati textovou reprezentaci data
Function ImpulzyTimeStr(ByVal Time As Date, Optional Full As Boolean = False) As String
  If Time = 1 Then
    ' pokud je to 1 je to 2. pulnoc (ta co konci den)
    ImpulzyTimeStr = "24:00"
  Else
    ' jinak provedem bezne formatovani casu
    Dim Min, Hod As String
    Hod = CStr(DatePart("h", Time))
    If Full Then Hod = String(2 - Len(Hod), "0") & Hod
    Min = CStr(DatePart("n", Time))
    Min = String(2 - Len(Min), "0") & Min
    ImpulzyTimeStr = Hod & ":" & Min
  End If
End Function

' prevede datum na implicitni rok (aby vsechna data mela stejny rok)
Function NaImplicitniRok(ByVal Kdy As Date) As Date
  Dim M As Integer, D As Integer
  
  M = DatePart("m", Kdy)
  D = DatePart("d", Kdy)
  NaImplicitniRok = DateSerial(ImplicitniRok, M, D)
End Function

' zjisti jestli je zadane datum statni svatek
Function JeToSvatek(ByRef Svatky As TSvatky, ByVal Den As Date) As Boolean
  Dim Svatek As Date
  Dim I As Integer
  Dim R As Boolean
  
  ' prevedeme datum na stajny rok v jakem jsou
  ' zadane statni svatky
  Svatek = NaImplicitniRok(Den)
  R = False
  ' a srovnavame ...
  For I = 0 To Svatky.Pocet - 1
    If Svatek = Svatky.Data(I) Then R = True
  Next
  JeToSvatek = R
End Function

' vrati jmeno dne v tydnu
Function DenDoW(ByVal Den As Integer) As TDen
  Select Case Den
    Case 1: DenDoW = dnNedele
    Case 2: DenDoW = dnPondeli
    Case 3: DenDoW = dnUtery
    Case 4: DenDoW = dnStreda
    Case 5: DenDoW = dnCtvrtek
    Case 6: DenDoW = dnPatek
    Case 7: DenDoW = dnSobota
  End Select
End Function

' prevede retezec na pole statnuch svatku
Sub StrToSvatky(ByVal Str As String, ByRef Svatky As TSvatky, ByVal Databaze As Boolean)
  Dim MesicN As Integer, DenN As Integer
  
  Svatky.Pocet = 0
  ' dokud tam neco je
  Do While Str <> ""
    ' maximum je 100
    If Svatky.Pocet = 100 Then Exit Sub
    Svatky.Pocet = Svatky.Pocet + 1
    If Databaze Then
      ' pokud nahravame z databaze tak se oddeluje lomitkem
      MesicN = CInt(CutToChar(Str, "/"))
      DenN = CInt(CutToChar(Str, ","))
    Else
      ' pokud nahravame ze vstupu tak se oddeluje teckou
      DenN = CInt(CutToChar(Str, "."))
      MesicN = CInt(CutToChar(Str, "."))
      Call CutToChar(Str, ",")
    End If
    Svatky.Data(Svatky.Pocet - 1) = DateSerial(ImplicitniRok, MesicN, DenN)
  Loop
End Sub

' prevede pole statnich svatku na retezec
Function SvatkyToStr(ByRef Svatky As TSvatky, ByVal Databaze As Boolean) As String
  Dim I As Integer
  Dim R As String
  
  R = ""
  ' pro kazdy statni svatek ...
  For I = 0 To Svatky.Pocet - 1
    If Databaze Then
      ' pokud ukladame do databaze tak se oddeluje lomitkem ...
      R = R & DatePart("m", Svatky.Data(I)) & "/" & DatePart("d", Svatky.Data(I))
    Else
      ' ... jinak teckou
      R = R & DatePart("d", Svatky.Data(I)) & "." & DatePart("m", Svatky.Data(I)) & "."
    End If
    If I < Svatky.Pocet - 1 Then R = R & ", "
  Next
  SvatkyToStr = R
End Function

' nahraje nastaveni z databaze
Sub NahrajNastaveni()
  Dim Conn As New ADODB.Connection
  Dim Record As New ADODB.Recordset
  Dim SlaveRecord As New ADODB.Recordset
  Dim aAktivniTarif As Integer
  Dim aTarif As Tarif
  Dim aCas As CasTarifu

  ' otevreme databazove spojeni
  Conn.CursorLocation = adUseClient
  Conn.Open (ConnectionString)
  
  Set Record.ActiveConnection = Conn
  Set SlaveRecord.ActiveConnection = Conn
  
  ' nahrajeme obecne nastaveni (1 radek)
  Record.Open "select AktivniTarif, CenaZaImpulz, Svatky from Obecne"
  aAktivniTarif = Record("AktivniTarif")
  Cena = Record("CenaZaImpulz")
  Call StrToSvatky(Record("Svatky"), Svatky, True)
  Record.Close
  
  ' projizdime tabulku tarifu
  Record.Open "select ID, Nazev from Tarif"
  Do While Not Record.EOF
    Set aTarif = Tarify.Add(Tarify)
    aTarif.Nazev = Record("Nazev")
    
    ' pro kazdy tarif najdeme prisslusne casove intervaly
    SlaveRecord.Open _
      "select Kdy, Den, OdKdy, DoKdy, Impulzy from Impulzy " & _
      "where Tarif = " & Record("ID")
    Do While Not SlaveRecord.EOF
      Set aCas = aTarif.Casy.Add(aTarif.Casy)
      ' nahrajeme data z databaze
      Call aCas.AssignRecord(SlaveRecord("Kdy"), SlaveRecord("Den"), SlaveRecord("OdKdy"), _
        SlaveRecord("DoKdy"), SlaveRecord("Impulzy"))
      SlaveRecord.MoveNext
    Loop
    SlaveRecord.Close
    
    Record.MoveNext
  Loop
  Record.Close
  
  ' uzavreme pojeni
  Conn.Close
  Set Record = Nothing
  Set Conn = Nothing
  
  ' vyhledame objekt aktivniho tarifu podle jeho cisla
  If (aAktivniTarif >= 1) And (aAktivniTarif <= Tarify.Count) Then
    Set Aktivni = Tarify(aAktivniTarif)
  Else
    Set Aktivni = Nothing
  End If
End Sub

' ulozime nastaveni do databaze
Sub UlozNastaveni()
  Dim Conn As New ADODB.Connection
  Dim Record As New ADODB.Recordset
  Dim aAktivniTarif As Integer
  Dim I, ii As Integer

  ' otevreme spojeni
  Conn.CursorLocation = adUseClient
  Conn.Open (ConnectionString)
  
  ' zjistime cislo aktualniho tarifu
  aAktivniTarif = 0
  For I = 1 To Tarify.Count
    If Tarify(I) Is Aktivni Then aAktivniTarif = I
  Next
  
  Set Record.ActiveConnection = Conn
  
  ' smazeme exstujici seznam tarifu a casu
  Record.Open "delete from Obecne"
  Record.Open "delete from Tarif"
  Record.Open "delete from Impulzy"
  
  ' pro kazdy tarif ...
  For I = 1 To Tarify.Count
    ' ... ulozime zaznam o nem
    Record.Open "insert into Tarif(ID, Nazev) values(" & I & ", '" & Tarify(I).Nazev & "')"
    'pro kazdy jeho casovy interval
    For ii = 1 To Tarify(I).Casy.Count
      Dim Cas As CasTarifu
      Dim Datum As String
      Set Cas = Tarify(I).Casy(ii)
      
      If Cas.Den = dnKonkretni Then
        Datum = "'" & Cas.DayStr & "'"
      Else
        Datum = "null"
      End If
      ' ulozime o nem zaznam
      Record.Open _
        "insert into Impulzy(Tarif, Kdy, Den, OdKdy, DoKdy, Impulzy) values(" & _
        I & ", '" & DenStr(Cas.Den) & "', '" & Cas.Datum & "', '" & Cas.CasOd & "', '" & _
        Cas.CasDo & "', '" & Cas.ImpulseStr & "')"
    Next
  Next
    
  ' ulozime obecne nastaveni (1 radek)
  Record.Open _
    "insert into Obecne(AktivniTarif, CenaZaImpulz, Svatky) values(" & _
      aAktivniTarif & ", '" & Cena & "', '" & SvatkyToStr(Svatky, True) & "')"
  
  Set Record = Nothing
  Set Conn = Nothing
End Sub

Sub Inicializace()
  DataDir = "c:\inetcost"
  ConnectionString = _
    "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & DataDir & "\inetcost.mdb;Persist Security Info=True"
  StartCas = Now
  Set Aktivni = Nothing

  Call NahrajNastaveni
End Sub

Sub Finalizace()
  Call UlozNastaveni
End Sub
