PROGRAM Kartoteka;
{$I-}
USES Crt, Dos,
     UzivRozh;

CONST JmenoSouboru = 'KARTOTEK.DAT';
      DocasnySoubor = 'KARTOTEK.TMP';

CONST DAutor = 25;
      DNazev = 40;
      DSlova = 50;
TYPE PClanek = ^TClanek;
     TClanek = RECORD
       Autor: String[DAutor];
       Nazev: String[DNazev];
       Slova: String[DSlova];
       Delka: LongInt;
       Pozice: LongInt;
       Dalsi: PClanek;
     END;

VAR OMenu: Integer;
    Index: PClanek;

  FUNCTION VelikostZaznamu: Word;
     { Vrati velikost uvodnich dat o kazdem zazamu (clanku) }
  VAR C: TClanek;
  BEGIN
    VelikostZaznamu:=SizeOf(C.Autor)+SizeOf(C.Nazev)+
       SizeOf(C.Slova)+SizeOf(C.Delka)
  END;

  FUNCTION OtevriSoubor(VAR f: File): Boolean;
     { Otevre datovy soubor s kontrolou spravnosti provedeni }
     { Pokud parametr Chyba je True pri chybe zobrazi chybove hlaseni }
  VAR V: Boolean;
  BEGIN
    Assign(f, JmenoSouboru);
    Reset(f, 1);       { Pokud o otevreni }
    V:=(IOResult=0);
    IF NOT V THEN
    BEGIN
      Rewrite(f, 1);   { Nejde otevrit -> vytvori se novy }
      V:=(IOResult=0);
           { Pokud ani to nevyjde zobrazi chybove hlaseni }
      Zprava('Soubor nelze otevrit');
    END;
    OtevriSoubor:=V;
  END;

  FUNCTION JmenoClanku(Clanek: PClanek): String;
     { Vrati cele jmeno clanku (Autor+Nazev) }
     { Podle tohoto jmena jsou clanku razeny v indexnim seznamu }
  BEGIN
    JmenoClanku:=Clanek^.Autor+': '+Clanek^.Nazev;
  END;

  FUNCTION PocetClanku: Integer;
    { Zjisti pocet clanku v indexnim seznamu }
  VAR C: PClanek;
      Pocet: Integer;
  BEGIN
    C:=Index;
    Pocet:=0;
    WHILE C<>NIL DO
    BEGIN
      Inc(Pocet);
      C:=C^.Dalsi;
    END;
    PocetClanku:=Pocet;
  END;

  FUNCTION ClanekNaPozici(Poradi: Integer): PClanek;
    { Vrati clanek na dane pozici v indexnim seznamu }
  VAR C: PClanek;
      Pocet: Integer;
  BEGIN
    C:=Index;
    Pocet:=1;
    WHILE (C<>NIL) AND (Pocet<Poradi) DO
    BEGIN
      Inc(Pocet);
      C:=C^.Dalsi;
    END;
    ClanekNaPozici:=C;
  END;

  PROCEDURE OdstranClanek(Pozice: Integer);
     { Odastrani clanek na dane pozici z indexniho seznamu }
     { ale neuvolni pamet jim obsazenou }
  VAR C: PClanek;
  BEGIN
    IF Pozice=1 THEN Index:=Index^.Dalsi
       ELSE
    BEGIN
      C:=ClanekNaPozici(Pozice-1);
      C^.Dalsi:=C^.Dalsi^.Dalsi;
    END;
  END;

  PROCEDURE ZaradClanek(Clanek: PClanek);
     { Dany clanek zaradi na spravne misto v indexnim seznamu }
  VAR C, Za, Min: PClanek;
      Nasel: Boolean;
  BEGIN
    IF Index=NIL THEN
       { Seznam je prazdy, novy clanek je jedinym v seznamu }
    BEGIN
      Index:=Clanek;
      Clanek^.Dalsi:=NIL;
    END
       ELSE
    BEGIN
      C:=Index; Za:=NIL; Min:=NIL; Nasel:=False;
         { Hledani mista pro umistneni noveho clanku }
      WHILE (C<>NIL) AND (NOT Nasel) DO
      BEGIN
        IF JmenoClanku(C)>JmenoClanku(Clanek) THEN
        BEGIN
          Za:=Min;
          Nasel:=True;
        END;
        Min:=C;
        C:=C^.Dalsi;
      END;
          { Pokud neexistuje zadny clanek, ktery by mel byt az za novym }
          { bude novy clanek zarazen az na konec senamu }
          { Posledni clanek seznamu je v teto situaci ulozen v promene Min }
      IF NOT Nasel THEN Za:=Min;

      IF Za<>NIL THEN
         { Novy clanek neni na 1. seznamu }
      BEGIN
        Clanek^.Dalsi:=Za^.Dalsi;
        Za^.Dalsi:=Clanek;
      END
         ELSE
         { Novy clanek je na 1. miste seznamu }
      BEGIN
        Clanek^.Dalsi:=Index;
        Index:=Clanek;
      END;
    END;
  END;

  PROCEDURE Nahraj;
  VAR f: File;
      C: PClanek;
  BEGIN
    Hlaseni('Nahravam ...');  { Zobrazi hlaseni o provadene akci }

    Index:=NIL; { Senzma je zatim prazdny }

    IF OtevriSoubor(f) THEN
       { Pokud je mozne otevrit soubor }
    BEGIN
      WHILE NOT EOF(f) DO
      BEGIN
        New(C);       { Vytvori novy prvek indexniho seznamu }
        BlockRead(f, C^, VelikostZaznamu);  { Nacte do nej data }
        C^.Pozice:=FilePos(f);
        Seek(f, FilePos(f)+C^.Delka);   { Preskoci text clanku }
        C^.Dalsi:=NIL;

        ZaradClanek(C);    { Zaradi clanek na spravne misto v seznamu }
      END;
      Close(f);
    END;

    ZrusOkno(-1);   { Schova okno s hlasenim }
  END;

  PROCEDURE ZnicIndex;

    PROCEDURE ZnicClanek(VAR C: PClanek);
       { Rekukzivni procedura pro uvolneni pameti pro cely seznam }
    BEGIN
      IF C^.Dalsi<>NIL THEN ZnicClanek(C^.Dalsi);
      Dispose(C);
      C:=NIL;
    END;

  BEGIN
    IF Index<>NIL THEN ZnicClanek(Index);
  END;

  PROCEDURE HlavniMenu(VAR V: Integer);
     { Zobrazi menu a vrati poradi polozky, ktera byla vybrana }
  BEGIN
    Menu(OMenu, 0, 0, 0, 0, V,
       PolozkaMenu('Novy clanek',
       PolozkaMenu('Nastaveni clanku',
       PolozkaMenu('Vymazani clanku',
       PolozkaMenu('Vyhledavani',
       PolozkaMenu('Seznam',
       {PolozkaMenu('O programu',}
       PolozkaMenu('Konec', NIL)))))), True, False);
  END;

  FUNCTION EditujClanek(OHlavni, OInfo: Integer; Clanek: PClanek): Boolean;
     { Tato procedura je pouzita jak pro zadavani udaju o novem clanku }
     { tak pro upravovani udaju o jez existujicim }
     { Parametrem OHlavi je dano ID cislo okna ve kterem bude provadena }
     { vlastni editace a parametrem OInfo ID cislo okna do ktereho }
     { bude zobrazovana napoveda }
  BEGIN
    EditujClanek:=False;

      { Zadavani jmena autora + zobrazeni napovedy k tomuto ukonu }
    VynechRadek(OHlavni);
    RadekDoOkna(OHlavni, '   Jmeno autora');
    {} RadekDoOkna(OInfo, ' Zde zadejte jmeno autora clanku (max. '+CisloNaText(DAutor)+' znaku)');
    {} RadekDoOkna(OInfo, ' Nejdriv prijmeni, potom jmeno');
    {} PisDoOkna(OInfo,   ' Priklad: Prikryl Martin');

    IF CtiText(OHlavni, 2, Clanek^.Autor, DAutor) THEN
    BEGIN
         { Obdobne jako pro jmeno autora }
      VynechRadek(OHlavni);
      RadekDoOkna(OHlavni, '   Nazev clanku');
      {} SmazOkno(OInfo);
      {} RadekDoOkna(OInfo, ' Zde zadejte cely nazev clanku');
      {} RadekDoOkna(OInfo, ' (max. '+CisloNaText(DNazev)+' znaku)');

      IF CtiText(OHlavni, 2, Clanek^.Nazev, DNazev) THEN
      BEGIN
        VynechRadek(OHlavni);
        RadekDoOkna(OHlavni, '   Klicova slova');
        {} SmazOkno(OInfo);
        {} RadekDoOkna(OInfo, ' Napiste nekolik slov,vystihujicich obsah clanku');
        {} RadekDoOkna(OInfo, ' Slova musi byt oddelena strednikem (;)');
        {} PisDoOkna(OInfo,   ' Priklad: software;programy;T602');

        IF CtiText(OHlavni, 2, Clanek^.Slova, DSlova) THEN EditujClanek:=True;
      END;
    END;
  END;

  PROCEDURE ZobrazClanek(C: PClanek);
      { Zobrazi dany clanek }
      { Tato procedura je volana z procedur Seznam a Vyhledavani }
  VAR f: File;
      Text: Pointer;
  BEGIN
    NoveOkno(5, 2, 75, 24, vzNormalni);
       { Vytvori okno, ve kterem bude provadeno prohlizeni }

       { Zobrazi zakladni udaje o clanku }
    VynechRadek(-1);
    CentrujDoOkna(-1, JmenoClanku(C));
    CentrujDoOkna(-1, '('+C^.Slova+')');

    IF OtevriSoubor(f) THEN
       { Pokud je mozne otevrit soubor }
    BEGIN
      Seek(f, C^.Pozice);
      GetMem(Text, C^.Delka);           { Obsadi potrebnou pamet }
      BlockRead(f, Text^, C^.Delka);    { A nacte do ni text clanku }
      Close(f);

          { Vlastni prohlizeni }
      ProhlizejText(-1, 2, 4, -2, -1, Text, C^.Delka);
    END;

    ZrusOkno(-1);   { Zrusi okno }
  END;

  PROCEDURE NovyClanek;
  VAR Soubor: String;
      Clanek: PClanek;

    FUNCTION EditujNovyClanek: Boolean;
    VAR OHlavni, OInfo: Integer;
    BEGIN
      EditujNovyClanek:=False;

         { Vytvori prostredi pro zadavani udaju o clanku }
      OHlavni:=NoveOkno(10, 3, 70, 23, vzNormalni);
      OInfo:=NoveOkno(15, 17, 65, 21, vzInfo);

      Clanek^.Autor:=''; Clanek^.Nazev:=''; Clanek^.Slova:='';
      Soubor:='';
          { Provede editaci Jmena autora, Nazvu a klicovych slov }
          { ve vytvorenych oknech }
      IF EditujClanek(OHlavni, OInfo, Clanek) THEN
      BEGIN
            { Zadani jmena souboru, ze ktereho bude clanke nacten }
        VynechRadek(OHlavni);
        RadekDoOkna(OHlavni, '   Jmeno souboru');
        {} SmazOkno(OInfo);
        {} RadekDoOkna(OInfo, ' Napiste jmeno souboru (s plnou cestou), ktery');
        {} RadekDoOkna(OInfo, ' obsahuje text clanku. Soubor musi byt v ASCII');
        {} PisDoOkna(OInfo,   ' formatu.');

        IF CtiText(OHlavni, 2, Soubor, 50) THEN
        BEGIN
          IF FSearch(Soubor, '')='' THEN Zprava('Soubor neexistuje')
             ELSE EditujNovyClanek:=True;
                     { Zadavani dokonceno, soubor existuje }
        END;
      END;

      ZrusOkno(OInfo);      { Smaze obe okna }
      ZrusOkno(OHlavni);
    END;

  VAR fO: File;
      fI: Text;
      Poz: LongInt;
      Radka: String;
      C: PClanek;
  BEGIN
    New(Clanek);
    IF EditujNovyClanek AND OtevriSoubor(fO) THEN
         { Editace probehla v poradku a soubor se podarilo otevrit }
    BEGIN
      Clanek^.Delka:=0;

      Seek(fO, FileSize(fO));    { Na konec souboru zapise }
      Poz:=FilePos(fO);          { jiz zname udaje o souboru }
      BlockWrite(fO, Clanek^, VelikostZaznamu);
      Clanek^.Pozice:=FilePos(fO);

         { Prekopiruje clanek z textoveho do datoveho souboru }
      Assign(fI, Soubor);
      Reset(fI);
      WHILE (IOResult=0) AND (NOT EOF(fI)) DO
      BEGIN
        Readln(fI, Radka);
        BlockWrite(fO, Radka, 1+Length(Radka));
        Inc(Clanek^.Delka, 1+Length(Radka));
      END;
      Close(fI);

      Seek(fO, Poz);    { Zapise nove zjistene udaje }
                        { (pozice a velikost clanku) }
      BlockWrite(fO, Clanek^, VelikostZaznamu);
      Close(fO);

      ZaradClanek(Clanek);    { Novy clanek zaradi do indexniho seznamu }
    END
       ELSE Dispose(Clanek);  { Doslo k chybe, uvolni pamet pro }
                              { Nezarazeny clanek }
  END;

  FUNCTION SeznamClanku: PPolozkaMenu;
     { Vytvori spojovy seznam Menu z Indexniho seznamu }
  VAR SeznamC, P, M: PPolozkaMenu;
      C: PClanek;
  BEGIN
    C:=Index; SeznamC:=NIL; P:=NIL;
    WHILE C<>NIL DO
    BEGIN
      New(M);
      M^.Text:=JmenoClanku(C);
      M^.Dalsi:=NIL;
      IF SeznamC=NIL THEN SeznamC:=M
         ELSE P^.Dalsi:=M;

      P:=M;
      C:=C^.Dalsi;
    END;
    SeznamClanku:=SeznamC;
  END;

  PROCEDURE OknoProVyberClanku(Hlavicka: String);
     { Vytvori okno s hlaviskou do ktereho bude pozdeji }
     { doplneno menu pro vyber clanku }
  BEGIN
    NoveOkno(10, 3, 70, 23, vzNormalni);

    VynechRadek(-1);
    CentrujDoOkna(-1, Hlavicka);
    CentrujDoOkna(-1, 'Pocet: '+CisloNaText(PocetClanku));
  END;

  PROCEDURE Seznam;
  VAR SeznamC: PPolozkaMenu;
      V: Integer;
      Prerus: Boolean;
  BEGIN
    OknoProVyberClanku('Seznam clanku (razeno podle autora)');
       { Zobrazi standartni okno pro vyber clanku }

    SeznamC:=SeznamClanku;
       { Vytvori spojovy seznam menu }
    V:=1;
    REPEAT
      Prerus:=NOT Menu(-1, 2, 4, -2, -1, V, SeznamC, False, True);
           { Vyber clanku }

      IF NOT Prerus THEN ZobrazClanek(ClanekNaPozici(V));
           { Pokud byl vybran -> zobraz ho }
    UNTIL Prerus;
    ZnicMenu(SeznamC);    { Uvolni pamet pro menu }
    ZrusOkno(-1);         { Smaze okno }
  END;

  PROCEDURE NastavClanek;
  VAR Clanek: PClanek;

    FUNCTION EditujStaryClanek: Boolean;
    VAR OHlavni, OInfo: Integer;
    BEGIN
         { Vytvori prostredi pro editaci udaju o clanku }
      OHlavni:=NoveOkno(10, 5, 70, 22, vzNormalni);
      OInfo:=NoveOkno(15, 16, 65, 20, vzInfo);

         { Provede editaci }
      EditujStaryClanek:=EditujClanek(OHlavni, OInfo, Clanek);

      ZrusOkno(OInfo);    { Smaze obe okna }
      ZrusOkno(OHlavni);
    END;

  VAR V: Integer;
      f: File;
  BEGIN
    OknoProVyberClanku('Ktery clanek chcete upravit?');
       { Zobrazi standartni okno pro vyber clanku }

    V:=1;
    IF Menu(-1, 2, 4, -2, -1, V, SeznamClanku, True, True) THEN
          { Vyber clanku }
    BEGIN
      Clanek:=ClanekNaPozici(V);
      IF EditujStaryClanek AND OtevriSoubor(f) THEN
          { Editace probehla uspesne a soubor se podarilo otevrit }
      BEGIN
        Seek(f, Clanek^.Pozice-VelikostZaznamu);
            { V souboru se posune na misto, kde jsou ulozeny udaje }
            { o clanku }
        BlockWrite(f, Clanek^, VelikostZaznamu);
            { A prepise je novymi }
        Close(f);

        OdstranClanek(V);      { Zarazeni clanku na nove misto }
        ZaradClanek(Clanek);
      END;
    END;

    ZrusOkno(-1);   { Smaze okno }
  END;

  PROCEDURE VymazClanek;
  VAR fI, fO: File;

    PROCEDURE KopirujSoubor(Kolik: LongInt);
       { Ze souboru fI prekopiruje do souboru fO dany pocet bajtu }
    CONST BufSize = 10000;
    VAR Buf: ARRAY[1..BufSize] OF Byte;
        K, S: Word;
    BEGIN
      K:=0;
      REPEAT
        IF Kolik-K<BufSize THEN S:=Kolik-K
           ELSE S:=BufSize;

        BlockRead(fI, Buf, S);
        BlockWrite(fO, Buf, S);

        Inc(K, S);
      UNTIL K=Kolik;
    END;

    FUNCTION OtevriVystup: Boolean;
       { Vytvori novy soubor s kontrolo spravnosti provedeni }
    VAR V: Boolean;
    BEGIN
      Assign(fO, DocasnySoubor);
      Rewrite(fO, 1);
      V:=(IOResult=0);
      IF NOT V THEN Zprava('Soubor nelze vytvorit');
      OtevriVystup:=V;
    END;

  VAR V: Integer;
      Clanek: PClanek;
      C: PClanek;
  BEGIN
    OknoProVyberClanku('Ktery clanek chcete vymazat?');
       { Zobrazi standartni okno pro vyber clanku }

    V:=1;
    IF Menu(-1, 2, 4, -2, -1, V, SeznamClanku, True, True) AND
       Potvrzeni('Skutecne vymazat clanek?') AND
       OtevriSoubor(fI) AND OtevriVystup THEN
        { Clanek byl vybran, bylo potvrzeno vymazani }
        { a oba soubory byly uspesne otevreny }
    BEGIN
         { Najde prislusny clanek }
      Clanek:=ClanekNaPozici(V);

         { Prekopiruje vsechny clanky pred vymazavanym }
      KopirujSoubor(Clanek^.Pozice-VelikostZaznamu);
         { Preskoci vymazavany clanek }
      Seek(fI, FilePos(fI)+VelikostZaznamu+Clanek^.Delka);
         { Prekopiruje clanky po vymazavanem }
      KopirujSoubor(FileSize(fI)-FilePos(fI));

      Close(fI);
      Erase(fI);    { Vymaze puvodni soubor }
      Close(fO);
      Rename(fO, JmenoSouboru);  { Prejmenuje novy soubor na }
                                 { jmeno stareho }

      OdstranClanek(V); { Odstrani vymazavani clanek z indexniho seznamu }

         { U vsech clanku, ktere jsou v datovem souboru }
         { ulozeny az po vymazanem, posune jejich pozice }
         { o velikost vymazanaho clanku dopredu }
      C:=Index;
      WHILE C<>NIL DO
      BEGIN
        IF C^.Pozice>Clanek^.Pozice THEN
            Dec(C^.Pozice, VelikostZaznamu+Clanek^.Delka);
        C:=C^.Dalsi;
      END;

      Dispose(Clanek);   { Uvolni pamet }
    END;

    ZrusOkno(-1);   { Smaze okno }
  END;

  PROCEDURE Vyhledavani;

    FUNCTION VyjmyPo(VAR S: String; Hranice: Char): String;
       { Z retezce S vyjme vsechny znaky az po znak Hranice (vcetne }
       { Vyjmuty retezec vrati jako vysledek funkce (bez znaku Hranice) }
       { Pokud S znak Hranice neobsahuje vrati cely retezec S }
       { a S vyprazdni }
    VAR T: String;
    BEGIN
      IF Pos(Hranice, S)>0 THEN
      BEGIN
        T:=Copy(S, 1, Pos(Hranice, S)-1);
        Delete(S, 1, Length(T)+1);
      END
         ELSE
      BEGIN
        T:=S;
        S:='';
      END;
      VyjmyPo:=T;
    END;

    FUNCTION ObsahujeSlovo(KlicSlova: String; Slovo: String): Boolean;
       { Zjisti jestli hledane slovo je obsazene v klicovych slovech }
    VAR Obsahuje: Boolean;
        S: String;
        Pred, Za: Boolean;
    BEGIN
      Obsahuje:=False;
          { Zjisti pripadne specialni znaku ve slove }
      Pred:=(Copy(Slovo, 1, 1)='*');
      IF Pred THEN Delete(Slovo, 1, 1);
      Za:=(Copy(Slovo, Length(Slovo), 1)='*');
      IF Za THEN Dec(Slovo[0]);

         { Hledani nebere ohled na mala a velka pismena }
      Slovo:=NaVelke(Slovo);
      KlicSlova:=NaVelke(KlicSlova);

      WHILE (KlicSlova<>'') AND (NOT Obsahuje) DO
         { Opakuj dokud je co porovnavat }
         { V pripade, ze je slovo nalezeno prerus hledani }
      BEGIN
           { Vyjme dalsi slovo pro porovnani }
        S:=VyjmyPo(KlicSlova, ';');

           { Porovnani pro vsechny kombinace hvedicek (*) v zadani }
        IF Pred AND Za THEN Obsahuje:=(Pos(Slovo, S)>0)
           ELSE
        IF Pred THEN Obsahuje:=(Length(Slovo)<=Length(S)) AND
                  (Copy(S, Length(S)-Length(Slovo)+1, Length(Slovo))=Slovo)
           ELSE
        IF Za THEN Obsahuje:=(Length(Slovo)<=Length(S)) AND
                       (Copy(S, 1, Length(Slovo))=Slovo)
           ELSE Obsahuje:=(S=Slovo);
      END;
      ObsahujeSlovo:=Obsahuje;
    END;

    FUNCTION ZkoumejClanek(Clanek: PClanek; Slova: String;
        VAR Procenta: Integer): Boolean;
        { Zjisti jestli clanek odpovida zadani, pokud ano }
        { je vysledek fce True a v parametru Procenta vrati }
        { na Kolik procent clanek odpovida zadani }
    VAR MuzeByt, Obsahuje: Boolean;
        S: String;
        C: Char;
        Shoda, Nepovine, Celkem: Integer;
    BEGIN
      MuzeByt:=True;
      Shoda:=0; Nepovine:=0; Celkem:=0;

      WHILE (Slova<>'') AND MuzeByt DO
          { Dokud je co zkoumat a clanek ma narok odpovidat zadani }
      BEGIN
            { Zjisti dalsi slovo zadani }
        S:=VyjmyPo(Slova, ' ');

            { Ulozi specialni znaky slova a odstrani je }
        C:=S[1];
        IF C IN ['+', '-'] THEN Delete(S, 1, 1);

            {Zjisti jestli clanek obsahuje toto slovo }
        Obsahuje:=ObsahujeSlovo(Clanek^.Slova, S);

        CASE C OF
          '+':
          BEGIN
            MuzeByt:=Obsahuje;   { Clanek toto slovo musi obsahovat }
            IF Obsahuje THEN Inc(Celkem);
          END;
          '-': MuzeByt:=NOT Obsahuje;  { Clanek toto slovo nesmi obsahovat }
             ELSE
          BEGIN
               { Pokud clanek toto slovo obsahuje zvysi se }
               { prevdepodobnost, toho ze clanek }
               { odpovida zadani }
            IF Obsahuje THEN
            BEGIN
              Inc(Shoda);
              Inc(Celkem);
            END;
            Inc(Nepovine);
          END;
        END;
      END;
           { Vypocita na kolik procet clanek odpovida zadani }
      IF Nepovine=0 THEN Procenta:=100
         ELSE Procenta:=(Shoda*100) DIV Nepovine;

      ZkoumejClanek:=(MuzeByt) AND (Celkem>0);
    END;

    FUNCTION HledejClanky(Slova: String): PPolozkaMenu;
        { Vyhleda clanky, ktere odpovidaji zadani }
        { prubezne je uklada do pole, ktere nasledne }
        { Seradi podle toho, jak presne nalezena clanky odpovidaji }
        { zadani. A ze serazeneho pole vytvori spojovy seznam menu }
    CONST MaxNalezenych = 100;
    TYPE TNalezeny = RECORD
           Clanek: PClanek;
           Procenta: Byte;
         END;
    VAR Nalezene: ARRAY[1..MaxNalezenych] OF TNalezeny;
        PocetN, P, i: Integer;
        C: PClanek;
        Prerazeno: Boolean;
        N: TNalezeny;
        Polozky: PPolozkaMenu;
    BEGIN
      PocetN:=0;

      C:=Index;
      WHILE (C<>NIL) AND (PocetN<=MaxNalezenych) DO
         { Opakuj pro vsechny clanky, v pripade ze pocet nalezenych }
         { presahne maximum, prerus hledani }
      BEGIN
        IF ZkoumejClanek(C, Slova, P) THEN
            { Clanek odpovida zadani }
        BEGIN
             { Zarazeni do pole }
          Inc(PocetN);
          IF PocetN<=MaxNalezenych THEN
          BEGIN
            Nalezene[PocetN].Clanek:=C;
            Nalezene[PocetN].Procenta:=P;
          END;
        END;
        C:=C^.Dalsi;
      END;

      IF PocetN=0 THEN
      BEGIN
            { Nebyl nalezen zadny clanek }
        Zprava('Nenalezen ani 1 clanek.');
        HledejClanky:=NIL;   { Vrati prazdny seznam }
      END
         ELSE
      IF PocetN<=MaxNalezenych THEN
      BEGIN
            { Hledani probehlu uspesne }
            { Provede Bubble sort pro setrideni clanku }
            { 1. kriterium- na kolik % clanek odpovida zadani }
            { 2. kriterium- abecedne podle jmena clanku }
        REPEAT
          Prerazeno:=False;
          FOR i:=1 TO PocetN-1 DO
          BEGIN
            IF (Nalezene[i].Procenta<Nalezene[i+1].Procenta) OR
               ((Nalezene[i].Procenta=Nalezene[i+1].Procenta) AND
                (JmenoClanku(Nalezene[i].Clanek)<
                     JmenoClanku(Nalezene[i+1].Clanek))) THEN
            BEGIN
              N:=Nalezene[i];
              Nalezene[i]:=Nalezene[i+1];
              Nalezene[i+1]:=N;
              Prerazeno:=True;
            END;
          END;
        UNTIL NOT Prerazeno;

            { Vytvoreni spojoveho seznamu menu }
        Polozky:=NIL;
        FOR i:=PocetN DOWNTO 1 DO
        BEGIN
          Polozky:=PolozkaMenu(JmenoClanku(Nalezene[i].Clanek)+
             ' ('+CisloNaText(Nalezene[i].Procenta)+'%)', Polozky);
                { Ke kazde polozce ulozi odkaz na clanek }
                { ktereho se tyka }
          Polozky^.Odkaz:=Nalezene[i].Clanek;
        END;
        HledejClanky:=Polozky;
      END
         ELSE
      BEGIN
            { Bylo nalezeno prilis mnoho clanku }
            { ktere odpovidaji zadani }
        Zprava('Specifikujte blize hledany clanek.');
        HledejClanky:=NIL;
      END;
    END;

  VAR OHlavni, OInfo, V: Integer;
      Vysledek: PPolozkaMenu;
      Hledat, Prerus: Boolean;
      Slova: String;
  BEGIN
      { Vytvoreni prostredi pro zadavani slov pro vyhledani }
      { Okna: }
    OHlavni:=NoveOkno(10, 2, 70, 24, vzNormalni);
    OInfo:=NoveOkno(15, 7, 65, 23, vzInfo);

      { Napoveda v informacnim okne }
    VynechRadek(OHlavni);
    RadekDoOkna(OHlavni, '  Zadej klicova slova');
    {} RadekDoOkna(OInfo, ' Zadejte klicova slova vystihujici clanky, ktere');
    {} RadekDoOkna(OInfo, ' chcete najit.');
    {} RadekDoOkna(OInfo, ' Slova musi byt oddelena mezerou.');
    {} VynechRadek(OInfo);
    {} RadekDoOkna(OInfo, ' Pokud slovo konci hvezdickou (*), budou');
    {} RadekDoOkna(OInfo, ' vyhledany vsechny clanky, ktere obsahuji');
    {} RadekDoOkna(OInfo, ' klicova slova zacinajici danymi znaky.');
    {} RadekDoOkna(OInfo, ' Napr: "strom*" -> "strom" "stromy" "stromoradi"');
    {} RadekDoOkna(OInfo, ' Podobne to je s hvezdickou na zacatku slova.');
    {} RadekDoOkna(OInfo, ' Plus (+) pred slovem znamena, ze budou ignoro-');
    {} RadekDoOkna(OInfo, ' vany vsechny clanky, ktere toto slova neobsahu-');
    {} RadekDoOkna(OInfo, ' ji, i kdyby obsahovali jine slovo ze zadani.');
    {} RadekDoOkna(OInfo, ' Minus (-) pred sloven znamena, ze clanek toto');
    {} RadekDoOkna(OInfo, ' slovo nesmi obsahovat.');
    {} PisDoOkna(OInfo,   ' Priklad: +software editor* -Microsoft');

    Slova:='';
       { Zadani slov pro hledani }
    Hledat:=CtiText(OHlavni, 2, Slova, 53);

    ZrusOkno(OInfo);    { Smaze obe okna }
    ZrusOkno(OHlavni);

    IF Hledat THEN
    BEGIN
           { Provede hledani clanku a vysledek vrati ve }
           { fotrme spojoveho seznamu menu }
      Vysledek:=HledejClanky(Slova);
      IF Vysledek<>NIL THEN
         { Byl nelezan alespon 1 clanek }
      BEGIN
           { Vytvoreni okna }
        NoveOkno(10, 3, 70, 23, vzNormalni);
        VynechRadek(-1);
        CentrujDoOkna(-1, 'Vysledek hledani klicovych slov');
        CentrujDoOkna(-1, Slova);

        V:=1;
        REPEAT
              { Vyber clanku }
          Prerus:=NOT Menu(-1, 2, 4, -2, -1, V, Vysledek, False, True);

          IF NOT Prerus THEN
              { V Polozce Odkaz menu je ulozen ukazatel }
              { na clanek, ktery ji odpovida }
              ZobrazClanek(VratPolozku(Vysledek, V)^.Odkaz);
        UNTIL Prerus;
        ZnicMenu(Vysledek);   { Uvolneni pameti }
        ZrusOkno(-1);    { Smaze okno }
      END;
    END;
  END;

VAR Volba: Integer;
    Pamet: LongInt;
BEGIN
     { Zaznamena si kolik volne pameti byla na zacatku programu }
  Pamet:=MemAvail;

     { Zobrazeni loga a pozadi }
  ZacatekProgramu('Kartoteka v1.0 (c) Brezen 1997 Martin Prikryl');

     { Vytvori okenko s info o programu }
  NoveOkno(15, 4, 65, 10, vzLogo);
  RadekDoOkna(-1,   '');
  CentrujDoOkna(-1, 'KARTOTEKA verze 1.0');
  RadekDoOkna(-1,   '');
  CentrujDoOkna(-1, 'Program pro rychle vyhledavani clanku');

  Nahraj;   { Vytvoreni indexniho seznamu }

     { Vytvori okenko ve kterem bude obsazeno menu }
  OMenu:=NoveOkno(27, 14, 52, 21, vzMenu);

  Volba:=1;
  REPEAT
    HlavniMenu(Volba);   { Vyber funkce programu }
    CASE Volba OF
      1: NovyClanek;     { Jeji provedeni }
      2: NastavClanek;
      3: VymazClanek;
      4: Vyhledavani;
      5: Seznam;
    END;
  UNTIL ((Volba=6) OR (Volba<0)) AND Potvrzeni('Skutecne ukoncit?');
         { Preruseni programu muze byt provedeno klavesou ESC }
         { nebo zvolenim polozky Konec v menu. Musi byt nasledne }
         { potvrzeno pri otazce klavesou A }

  ZrusOkno(OMenu);    { Zrusi okno ve kterem bylo menu }
  ZnicIndex;          { Uvolni pamet obsazenou indexnim seznamem }
  ZrusOkno(-1);       { Zrusi okno s informacemi o programu }
  KonecProgramu;      { Obnovi stav pred zacatkem programu }

     { Otestuje jestli jsem neopomnel uvolnit }
     { nejakou dynamickou promenou }
  IF Pamet<>MemAvail THEN
  BEGIN
    Write(#7);
    Writeln('Pamet na zacatku: ', Pamet);
    Writeln('Pamet na konci: ', MemAvail);
    Writeln('Rozdil: ', Pamet-MemAvail);
  END;
END.