UNIT UzivRozh;

INTERFACE

FUNCTION CisloNaText(Cislo: LongInt): String;
  { Prevede typ Integer na retezec znaku }
FUNCTION NaVelke(S: String): String;
  { Vsechny male znaky v retezci S prevede na velke }

FUNCTION CtiKlavesu: Word;
  { Vrati kod stisknute klavesy }
  { Pro normalni klavesy bude horni bajt obsahovat kod a dolni 0 }
  { Pro rozsirene klavesy horni bajt obsahuje 0 a dolni kod klavesy }

FUNCTION ZnakKlavesy(K: Word): Char;
  { Parametr K je kod vraceny funkci CtiKlavesu, vysledkem teto funkce }
  { je znak, ktery teto klavese odpovida, pokud byla stisknuta }
  { nektera klavesa rozsirene klavesnice vrati znak #0 }

PROCEDURE ZacatekProgramu(Logo: String);
  { Vypise logo, vytvori okno na pozadi a provede dalsi upravy }
PROCEDURE KonecProgramu;
  { Obnovy stav pred zacatkem programu }

PROCEDURE SkryjKurzor;
  { Schova hardwarovy kurzor }
PROCEDURE UkazKurzor;
  { Zobrazi hardwarovy kurzor }

CONST vzPozadi = 1;
      vzMenu = 2;
      vzLogo = 3;
      vzHlaseni = 4;
      vzNormalni = 5;
      vzInfo = 6;

FUNCTION NoveOkno(X1, Y1, X2, Y2: Byte; Vzor: Byte): Byte;
  { Na danych souradnicich nakresli okno podle daneho vzoru }
  { Vrati identifikacni cislo tohoto okna }
FUNCTION Hlaseni(S: String): Byte;
  { Vytvori okno podle vzoru vzHlaseni, velke dostatecne na to }
  { aby obsahovalo text S a ten do nej vepise. Vrati ID cislo tohoto okna }
PROCEDURE Zprava(S: String);
  { Provede to same co hlaseni, a navic ceka na stisk klavesy }
  { a potom vytvorene okno zrusi }
FUNCTION Potvrzeni(S: String): Boolean;
  { Provede to same co Zprava. v pripade ze stisknuta klavesa }
  { byla N nebo ESC vrati False pokud to bylo A vrati True }
PROCEDURE ZrusOkno(Okno: ShortInt);
  { Schova okno s ID cislem Okno }
PROCEDURE SmazOkno(Okno: ShortInt);
  { Vymaze obsah okna s ID cislem Okno }
PROCEDURE PisDoOkna(Okno: ShortInt; S: String);
  { Do daneho okna napis text S, obdoba Write(S); }
PROCEDURE RadekDoOkna(Okno: ShortInt; S: String);
  { Do daneho okna napise text S, obdoba Writeln(S); }
PROCEDURE VynechRadek(Okno: ShortInt);
  { V danem okne vynecha radek, obdoba Writeln; }
PROCEDURE CentrujDoOkna(Okno: ShortInt; S: String);
  { Do daneho okna napise vycentrovane radek obsahujici text S }

  { Tento typ se pouziva jako spojovy seznam pro definovani polozek }
  { menu. K vytvoreni se da pouzit fce PolozkaMenu }
  { K zruseni procedure ZnicMenu }
TYPE PPolozkaMenu = ^TPolozkaMenu;
     TPolozkaMenu = RECORD
       Text: String;      { Text polozky menu }
       Odkaz: Pointer;    { Doplnujici informace }
       Dalsi: PPolozkaMenu; { Odkaz na dalsi polozku, NIL pokud je posledni }
     END;

FUNCTION PolozkaMenu(AText: String; ADalsi: PPolozkaMenu): PPolozkaMenu;
  { Obsadi pamet pro novou polozku menu a vyplni jeji prvky }
FUNCTION VratPolozku(Menu: PPolozkaMenu; Poradi: Integer): PPolozkaMenu;
  { Vrati polozku na dane pozici v menu }
PROCEDURE ZnicMenu(P: PPolozkaMenu);
  { Uvolni pamet pro vsechny polozky menu }
FUNCTION Menu(DoOkna: ShortInt; Levy, Horni, Pravy, Dolni: ShortInt;
    VAR Volba: Integer; CONST Polozky: PPolozkaMenu;
    Znicit, Hledat: Boolean): Boolean;
    { V danem okne provede vyber z menu, definovanem parametrem Polozky }
    { Pokud jsou parametry Pravy a Dolni zaporne, oznacuji }
    { vzdalenost okraje menu od praveho a dolniho okraje okna }
    { jinak vzdalenost od leveho a horniho }
    { Na zacatku je aktivni polozka dana parametrem Volba, timto }
    { take funkce vraci vyslednou polozku, pokud je vyber prerusen }
    { klavesou ESC je vracena zaporna hodnota a zaroven je vysledek }
    { fce False. Parametr Znicit definuje, jestli bude na konci }
    { uvolnena pamet pro menu (Polozky). Parametr Hledat znamena }
    { jestli bude povoleno hledani polozek podle stiknutych klaves }

FUNCTION CtiText(Okno: ShortInt; Odsazeni: ShortInt; VAR Text: String;
    MaxDelka: Byte): Boolean;
    { V danem okne zobrazi na aktualni radce a sloupci danem }
    { parametrem odsazeni editacni okenko, ve kterem probehne editace }
    { textu v promene Text, maximalni povolena delka textu je dana }
    { parametrem Text }

PROCEDURE ProhlizejText(DoOkna: ShortInt; Levy, Horni, Pravy, Dolni: ShortInt;
     Text: Pointer; Delka: Word);
     { Vytvori okenko pro prohlizeni textoveho souboru obsazenem }
     { na adrese dane parametrem Text s delkou Delka }
     { Ostatni parametry maji stejny vyznam jako u funkce Menu }

IMPLEMENTATION

USES Crt, Dos;

TYPE PPodklad = ^TPodklad;
     TPodklad = ARRAY[1..80*25*2] OF Byte;
     TVysec = RECORD
       X1, Y1, X2, Y2: Byte;
       Podklad: PPodklad;
     END;

TYPE TVzor = RECORD
       Ramecek: Byte;
       Stin: Boolean;
       Vzor: String[80];
       Posunuti: Byte;
       Paleta: ARRAY[1..8] OF Byte;
     END;

CONST plRamecek = 1;
      plPlocha = 2;
      plNadpis = 3;
      plText = 4;
      plMenu = 5;
      plMenuA = 6;
      plVstup = 7;
      plProhlizec = 8;

CONST Vzory: ARRAY[1..6] OF TVzor =
        ((Ramecek: 0; Stin: False; Vzor: '';
          Posunuti: 0; Paleta: (0, LightGray SHL 4+DarkGray, 0, 0, 0, 0, 0, 0)),
         (Ramecek: 1; Stin: True; Vzor: ' '; Posunuti: 0;
          Paleta: (Blue SHL 4+White, Blue SHL 4+LightGray,
                   0, Blue SHL 4+LightGray, Blue SHL 4+Yellow,
                   LightGray SHL 4+Blue, 0, 0)),
         (Ramecek: 2; Stin: True; Vzor: ' '; Posunuti: 0;
          Paleta: (Cyan SHL 4+Blue, Cyan SHL 4+Blue, 0,
                   Cyan SHL 4+Red, 0, 0, 0, 0)),
         (Ramecek: 1; Stin: True; Vzor: ' '; Posunuti: 0;
          Paleta: (Red SHL 4+White, Red SHL 4+Blue, 0,
                   Red SHL 4+Yellow, 0, 0, 0, 0)),
         (Ramecek: 2; Stin: True; Vzor: ' '; Posunuti: 0;
          Paleta: (LightGray SHL 4+White, LightGray SHL 4, 0,
                   LightGray SHL 4+Black, Cyan SHL 4+Black,
                   Green SHL 4+White, Blue SHL 4+White, Blue SHL 4+White)),
         (Ramecek: 1; Stin: True; Vzor: ' '; Posunuti: 0;
          Paleta: (Cyan SHL 4+Black, Cyan SHL 4, 0,
                   Cyan SHL 4+Blue, 0, 0, 0, 0)));

TYPE TOkno = RECORD
       Obsazene: Boolean;
       Poradi: Word;
       X1, Y1, X2, Y2: Byte;
       Vzor: Byte;
       KurzorX, KurzorY: Byte;
       Vysec: TVysec;
     END;

VAR Okna: ARRAY[1..20] OF TOkno;
    PocetOken: Word;

{ -------- }

TYPE ScrStateType = RECORD
       X, Y: Byte;
       LastAttr: Byte;
       LastMin, LastMax: Word;
     END;

VAR ScrState: ARRAY[1..100] OF ScrStateType;
                               { Vnitrni promena pro ulozeni stavu obr. }
    UlozeneObrazovky: Byte;       { Pocet ulozenych stavy obr. }

VAR VidSeg, VidOffs: Word;
    NumRows: Byte;

VAR ActMode: Byte ABSOLUTE $0000:$0449;  { Rezim Obrazovky }
    NumCols: Word ABSOLUTE $0000:$044A;  { Pocet Sloupcu }
    PageSize: Word ABSOLUTE $0000:$044C; { Velikost videostranky }
    VidStart: Word ABSOLUTE $0000:$044E; { Zacatek videostranky }
    ActPage: Byte ABSOLUTE $0000:$0462;  { Aktualni videostranka }
    NumRows1: Byte ABSOLUTE $0000:$0484;  { Pocet radku-1 }
    CharHeight: Byte ABSOLUTE $0000:$0485; { Vyska znaku }

FUNCTION CisloNaText(Cislo: LongInt): String;
VAR S: String;
BEGIN
  Str(Cislo:0, S);
  CisloNaText:=S;
END;

FUNCTION NaVelke(S: String): String;
VAR i: Byte;
BEGIN
  FOR i:=1 TO Length(S) DO S[i]:=UpCase(S[i]);
  NaVelke:=S;
END;

PROCEDURE TestObrazovky;
BEGIN
  NumRows:=NumRows1+1;
  IF ActMode=7 THEN VidSeg:=$B000
         ELSE VidSeg:=$B800;
  VidOffs:=ActPage*PageSize;
END;

PROCEDURE SkryjKurzor;
VAR Reg: Registers;
BEGIN
  Reg.AH:=$01;
  Reg.CL:=0;
  Reg.CH:=1;
  Intr($10, Reg);
END;

PROCEDURE UkazKurzor;
VAR Reg: Registers;
BEGIN
  Reg.AH:=$01;
  Reg.CL:=14;
  Reg.CH:=13;
  Intr($10, Reg);
END;

PROCEDURE UlozStavObrazovky;
BEGIN
  IF UlozeneObrazovky>=100 THEN Exit;
  Inc(UlozeneObrazovky);
  WITH ScrState[UlozeneObrazovky] DO
  BEGIN
    X:=WhereX;
    Y:=WhereY;
    LastAttr:=TextAttr;
    LastMin:=WindMin;
    LastMax:=WindMax;
  END;
END;

PROCEDURE ObnovStavObrazovky;
BEGIN
  IF UlozeneObrazovky=0 THEN Exit;
  WITH ScrState[UlozeneObrazovky] DO
  BEGIN
    Window(Lo(LastMin)+1, Hi(LastMin)+1, Lo(LastMax)+1, Hi(LastMax)+1);
    GotoXY(X, Y);
    TextAttr:=LastAttr;
  END;
  Dec(UlozeneObrazovky);
END;

{ -------- }

PROCEDURE UlozVysec(X1, Y1, X2, Y2: Byte; VAR Vysec: TVysec);
VAR y: Byte;
BEGIN
  GetMem(Vysec.Podklad, (Y2-Y1+1)*(X2-X1+1)*2);
  FOR y:=Y1 TO Y2 DO
  BEGIN
    Move(Mem[VidSeg:VidOffs+((y-1)*NumCols+X1-1)*2],
        Vysec.Podklad^[(y-Y1)*(X2-X1+1)*2+1], (X2-X1+1)*2);
  END;
  Vysec.X1:=X1;
  Vysec.X2:=X2;
  Vysec.Y1:=Y1;
  Vysec.Y2:=Y2;
END;

PROCEDURE ObnovVysec(VAR Vysec: TVysec);
VAR y: Byte;
BEGIN
  FOR y:=Vysec.Y1 TO Vysec.Y2 DO
  BEGIN
    Move(Vysec.Podklad^[(y-Vysec.Y1)*(Vysec.X2-Vysec.X1+1)*2+1],
        Mem[VidSeg:VidOffs+((y-1)*NumCols+Vysec.X1-1)*2],
        (Vysec.X2-Vysec.X1+1)*2);
  END;
  FreeMem(Vysec.Podklad, (Vysec.Y2-Vysec.Y1+1)*(Vysec.X2-Vysec.X1+1)*2);
  Vysec.Podklad:=NIL;
END;

PROCEDURE PisZnak(X, Y: Byte; Ch: Char; Barva: Byte);
BEGIN
  MEM[VidSeg:VidOffs+((NumCols*(Y-1))+(X-1))*2]:=Byte(Ch);
  MEM[VidSeg:VidOffs+((NumCols*(Y-1))+(X-1))*2+1]:=Barva;
END;

PROCEDURE PisText(X, Y: Byte; Text: String; Barva: Byte);
VAR Offs: Word;
    i: Word;
BEGIN
  Offs:=VidOffs+((NumCols*(Y-1))+(X-1))*2;
  FOR i:=1 TO Length(Text) DO
  BEGIN
    MEM[VidSeg:Offs]:=Byte(Text[i]);
    MEM[VidSeg:Offs+1]:=Barva;
    Offs:=Offs+2;
  END;
END;

{ ----------------- }

PROCEDURE ZacatekProgramu(Logo: String);
BEGIN
  Writeln('   ', Logo);
  Delay(200);
  UlozStavObrazovky;
  SkryjKurzor;
  NoveOkno(1, 1, 80, 25, vzPozadi);
END;

PROCEDURE KonecProgramu;
BEGIN
  ZrusOkno(1);
  ObnovStavObrazovky;
  UkazKurzor;
END;

{ --------------- }

FUNCTION PrvniVolneOkno: Byte;
VAR i: Byte;
BEGIN
  FOR i:=1 TO High(Okna) DO
  BEGIN
    IF NOT Okna[i].Obsazene THEN
    BEGIN
      PrvniVolneOkno:=i;
      Exit;
    END;
  END;
  PrvniVolneOkno:=0;
END;

FUNCTION PosledniOkno: Byte;
VAR O, M, i: Word;
BEGIN
  M:=0; O:=0;
  FOR i:=1 TO High(Okna) DO
  BEGIN
    IF (Okna[i].Obsazene) AND
       (Okna[i].Poradi>M) THEN O:=i;
  END;
  PosledniOkno:=O;
END;

FUNCTION OkrajX(Vzor: Byte): Byte;
BEGIN
  IF Vzory[Vzor].Ramecek=0 THEN OkrajX:=0
     ELSE OkrajX:=1;
END;

FUNCTION OkrajY(Vzor: Byte): Byte;
BEGIN
  IF Vzory[Vzor].Ramecek=0 THEN OkrajY:=0
     ELSE OkrajY:=1;
END;

PROCEDURE Ramecek(X1, Y1, X2, Y2: Byte; Cara: Byte; Barva: Byte);
CONST Znaky: ARRAY[1..2] OF String[6] =
       ('ĳڿ', 'ͺɻȼ');
VAR i: Byte;
BEGIN
  PisZnak(X1, Y1, Znaky[Cara, 3], Barva);
  PisZnak(X2, Y1, Znaky[Cara, 4], Barva);
  PisZnak(X1, Y2, Znaky[Cara, 5], Barva);
  PisZnak(X2, Y2, Znaky[Cara, 6], Barva);
  FOR i:=X1+1 TO X2-1 DO
  BEGIN
    PisZnak(i, Y1, Znaky[Cara, 1], Barva);
    PisZnak(i, Y2, Znaky[Cara, 1], Barva);
  END;
  FOR i:=Y1+1 TO Y2-1 DO
  BEGIN
    PisZnak(X1, i, Znaky[Cara, 2], Barva);
    PisZnak(X2, i, Znaky[Cara, 2], Barva);
  END;
END;

PROCEDURE KresliVzor(X1, Y1, X2, Y2: Byte; Vzor: String; Posunuti: Byte; Barva: Byte);
VAR S: String;
    y: Byte;
BEGIN
  S:='';
  FOR y:=Y1 TO Y2 DO
  BEGIN
    WHILE Length(S)<(X2-X1+1) DO S:=S+Vzor;
    PisText(X1, y, Copy(S, 1, X2-X1+1), Barva);
    Delete(S, 1, Posunuti);
  END;
END;

PROCEDURE KresliStin(X1, Y1, X2, Y2: Byte);
VAR i: Byte;
BEGIN
  FOR i:=X1+2 TO X2+2 DO
      MEM[VidSeg:VidOffs+((NumCols*(Y2+1-1))+(i-1))*2+1]:=LightGray;
  FOR i:=Y1+1 TO Y2 DO
  BEGIN
    MEM[VidSeg:VidOffs+((NumCols*(i-1))+(X2+1-1))*2+1]:=LightGray;
    MEM[VidSeg:VidOffs+((NumCols*(i-1))+(X2+2-1))*2+1]:=LightGray;
  END;
END;

FUNCTION NoveOkno(X1, Y1, X2, Y2: Byte; Vzor: Byte): Byte;
VAR O: Byte;
    V: TVzor;
    W: TOkno;
    S: String;
BEGIN
  O:=PrvniVolneOkno;
  NoveOkno:=O;
  IF O=0 THEN Exit;

  W.Obsazene:=True;
  W.Vzor:=Vzor;
  W.X1:=X1;
  W.X2:=X2;
  W.Y1:=Y1;
  W.Y2:=Y2;
  V:=Vzory[Vzor];

  IF V.Stin THEN
  BEGIN
    UlozVysec(X1, Y1, X2+2, Y2+1, W.Vysec);
    KresliStin(X1, Y1, X2, Y2);
  END
     ELSE UlozVysec(X1, Y1, X2, Y2, W.Vysec);
  IF V.Ramecek>0 THEN Ramecek(X1, Y1, X2, Y2, V.Ramecek, V.Paleta[plRamecek]);
  KresliVzor(X1+OkrajX(Vzor), Y1+OkrajY(Vzor),
       X2-OkrajX(Vzor), Y2-OkrajY(Vzor), V.Vzor, V.Posunuti, V.Paleta[plPlocha]);
  W.KurzorX:=1;
  W.KurzorY:=1;
  Inc(PocetOken);
  W.Poradi:=PocetOken;

  Okna[O]:=W;
END;

PROCEDURE ZrusOkno(Okno: ShortInt);
BEGIN
  IF Okno=-1 THEN Okno:=PosledniOkno;
  ObnovVysec(Okna[Okno].Vysec);
  Okna[Okno].Obsazene:=False;
END;

PROCEDURE SmazOkno(Okno: ShortInt);
VAR O: TOkno;
BEGIN
  IF Okno=-1 THEN Okno:=PosledniOkno;

  UlozStavObrazovky;
  O:=Okna[Okno];
  Window(O.X1+OkrajX(O.Vzor), O.Y1+OkrajY(O.Vzor),
         O.X2-OkrajX(O.Vzor), O.Y2-OkrajY(O.Vzor));
  TextAttr:=Vzory[O.Vzor].Paleta[plText];
  ClrScr;
  O.KurzorX:=1;
  O.KurzorY:=1;
  Okna[Okno]:=O;
  ObnovStavObrazovky;
END;

PROCEDURE PisDoOkna(Okno: ShortInt; S: String);
VAR O: TOkno;
    i: Byte;
BEGIN
  IF Okno=-1 THEN Okno:=PosledniOkno;

  UlozStavObrazovky;
  O:=Okna[Okno];
  Window(O.X1+OkrajX(O.Vzor), O.Y1+OkrajY(O.Vzor),
         O.X2-OkrajX(O.Vzor), O.Y2-OkrajY(O.Vzor));
  GotoXY(O.KurzorX, O.KurzorY);
  TextAttr:=Vzory[O.Vzor].Paleta[plText];
  IF S[1]=^C THEN
  BEGIN
    Delete(S, 1, 1);
    IF Copy(S, Length(S)-1, 2)=#13#10 THEN Dec(S[0], 2);
    FOR i:=1 TO (((O.X2-O.X1+1)-2*OkrajX(O.Vzor)-WhereX+1)-
       Length(S)) DIV 2 DO Write(' ');
    S:=S+#13#10;
  END;

  Write(S);
  O.KurzorX:=WhereX;
  O.KurzorY:=WhereY;
  Okna[Okno]:=O;
  ObnovStavObrazovky;
END;

PROCEDURE RadekDoOkna(Okno: ShortInt; S: String);
BEGIN
  PisDoOkna(Okno, S+#13#10);
END;

PROCEDURE VynechRadek(Okno: ShortInt);
BEGIN
  RadekDoOkna(Okno, '');
END;

PROCEDURE CentrujDoOkna(Okno: ShortInt; S: String);
BEGIN
  PisDoOkna(Okno, ^C+S);
END;

FUNCTION Hlaseni(S: String): Byte;
BEGIN
  Hlaseni:=NoveOkno(23, 12, 57, 16, vzHlaseni);
  RadekDoOkna(-1, '');
  CentrujDoOkna(-1, S);
END;

PROCEDURE Zprava(S: String);
BEGIN
  Hlaseni(S);
  CtiKlavesu;
  ZrusOkno(-1);
END;

FUNCTION Potvrzeni(S: String): Boolean;
VAR K: Word;
BEGIN
  NoveOkno(40-(Length(S) DIV 2)-3, 10, 40+(Length(S) DIV 2)+3, 14, vzNormalni);

  VynechRadek(-1);
  CentrujDoOkna(-1, S);

  REPEAT
    K:=CtiKlavesu
  UNTIL (K=27) OR ((Hi(K)=0) AND (UpCase(Char(Lo(K))) IN ['A', 'N']));

  ZrusOkno(-1);

  Potvrzeni:=(Hi(K)=0) AND (UpCase(Char(Lo(K)))='A');
END;

{ ---------------- }

FUNCTION CtiKlavesu: Word;
VAR C1, C2: Char;
BEGIN
  C1:=#0; C2:=#0;
  C1:=ReadKey;
  IF C1=#0 THEN C2:=ReadKey;
  CtiKlavesu:=Byte(C2) SHL 8+Byte(C1);
END;

FUNCTION ZnakKlavesy(K: Word): Char;
BEGIN
  ZnakKlavesy:=Char(Lo(K));
END;

{ ---------------- }

FUNCTION PolozkaMenu(AText: String; ADalsi: PPolozkaMenu): PPolozkaMenu;
VAR P: PPolozkaMenu;
BEGIN
  New(P);
  P^.Text:=AText;
  P^.Dalsi:=ADalsi;
  P^.Odkaz:=NIL;
  PolozkaMenu:=P;
END;

FUNCTION VratPolozku(Menu: PPolozkaMenu; Poradi: Integer): PPolozkaMenu;
VAR x: Integer;
BEGIN
  x:=1;
  WHILE (Menu<>NIL) AND (x<Poradi) DO
  BEGIN
    Menu:=Menu^.Dalsi;
    Inc(x);
  END;
  VratPolozku:=Menu;
END;

PROCEDURE ZnicMenu(P: PPolozkaMenu);
BEGIN
  IF P<>NIL THEN
  BEGIN
    IF P^.Dalsi<>NIL THEN ZnicMenu(P^.Dalsi);
    Dispose(P);
    P:=NIL;
  END;
END;

FUNCTION SpocitejMenu(P: PPolozkaMenu): Integer;
VAR A: Integer;
BEGIN
  A:=0;
  WHILE P<>NIL DO
  BEGIN
    P:=P^.Dalsi;
    Inc(A);
  END;
  SpocitejMenu:=A;
END;

FUNCTION Menu(DoOkna: ShortInt; Levy, Horni, Pravy, Dolni: ShortInt;
    VAR Volba: Integer; CONST Polozky: PPolozkaMenu;
    Znicit, Hledat: Boolean): Boolean;
VAR Prvni: Integer;
    Sirka, Vyska: Integer;
    Hledani: Integer;
    Nalezeno: String;
    W: TOkno;

  PROCEDURE Kresli;
  VAR P: PPolozkaMenu;
      S: String;
      B, i: Byte;
  BEGIN
    P:=Polozky;
    IF Prvni>1 THEN
      FOR i:=1 TO Prvni-1 DO P:=P^.Dalsi;

    FOR i:=1 TO Vyska DO
    BEGIN
      IF P=NIL THEN S:=''
         ELSE
      BEGIN
        S:=' '+P^.Text;
        IF Length(S)>Sirka-1 THEN S[0]:=Char(Sirka-1);
        P:=P^.Dalsi;
      END;
      WHILE Length(S)<Sirka DO S:=S+' ';
      IF Volba=i+Prvni-1 THEN B:=Vzory[W.Vzor].Paleta[plMenuA]
         ELSE B:=Vzory[W.Vzor].Paleta[plMenu];
      PisText(Levy, Horni+i-1, S, B);
    END;
    GotoXY(Levy+1+Length(Nalezeno), Horni+Volba-Prvni);
  END;

  PROCEDURE Hledej(Znak: Char);
  VAR N: String;
      P: PPolozkaMenu;
      x: Integer;
  BEGIN
    N:=Nalezeno;
    IF Znak=#8 THEN
    BEGIN
      IF Nalezeno<>'' THEN Dec(Nalezeno[0])
    END
       ELSE Nalezeno:=Nalezeno+UpCase(Znak);

    P:=Polozky; x:=1;
    WHILE (P<>NIL) AND
          (NaVelke(Copy(P^.Text, 1, Length(Nalezeno)))<>Nalezeno) DO
    BEGIN
      P:=P^.Dalsi;
      Inc(X);
    END;
    IF P=NIL THEN Nalezeno:=N
       ELSE Volba:=x;
  END;

VAR K: Word;
    Minule: Integer;
BEGIN
  IF DoOkna=-1 THEN DoOkna:=PosledniOkno;
  W:=Okna[DoOkna];
  Levy:=W.X1+OkrajX(W.Vzor)+Levy;
  Horni:=W.Y1+OkrajY(W.Vzor)+Horni;
  IF Pravy>0 THEN Pravy:=W.X1+OkrajX(W.Vzor)+Pravy
     ELSE Pravy:=W.X2+Pravy-OkrajX(W.Vzor);
  IF Dolni>0 THEN Dolni:=W.Y1+OkrajY(W.Vzor)+Dolni
     ELSE Dolni:=W.Y2+Dolni-OkrajY(W.Vzor);
  Sirka:=Pravy-Levy+1;
  Vyska:=Dolni-Horni+1;

  IF Volba<0 THEN Volba:=-Volba;
  IF Volba>Vyska THEN Prvni:=Volba-Vyska+1
     ELSE Prvni:=1;

  Minule:=-1; Nalezeno:='';
  IF Hledat THEN UkazKurzor;
  REPEAT
    IF Volba<>Minule THEN
    BEGIN
      Kresli;
      Minule:=Volba;
    END;

    K:=CtiKlavesu;
    CASE K OF
      20480, 19712: IF Volba<SpocitejMenu(Polozky) THEN Inc(Volba);
      18432, 19200: IF Volba>1 THEN Dec(Volba);
      18176: Volba:=1;
      20224: Volba:=SpocitejMenu(Polozky);
      18688: IF Volba>Vyska THEN Dec(Volba, Vyska)
                 ELSE Volba:=1;
      20736: IF Volba+Vyska<=SpocitejMenu(Polozky) THEN Inc(Volba, Vyska)
                 ELSE Volba:=SpocitejMenu(Polozky);
    END;
    IF Volba<>Minule THEN Nalezeno:='';
    IF ZnakKlavesy(K) IN [#8, #32..#255] THEN Hledej(ZnakKlavesy(K));
    IF Vyska<SpocitejMenu(Polozky) THEN
    BEGIN
      IF Volba<Prvni THEN Prvni:=Volba;
      IF Volba>Prvni+Vyska-1 THEN Prvni:=Volba-Vyska+1;
    END;
  UNTIL (K=13) OR (K=27);
  IF K=27 THEN Volba:=-Volba;
  IF Znicit THEN ZnicMenu(Polozky);
  IF Hledat THEN SkryjKurzor;
  Menu:=(K=13);
END;

{ ------------- }

FUNCTION CtiText(Okno: ShortInt; Odsazeni: ShortInt; VAR Text: String;
    MaxDelka: Byte): Boolean;
VAR X, Y: Integer;
    B: Byte;
    S: String;

  PROCEDURE Kresli;
  VAR t: String;
  BEGIN
    t:=' '+S;
    WHILE Length(t)<MaxDelka+2 DO t:=t+' ';
    PisText(X, Y, t, B);
    GotoXY(X+1+Length(S), Y);
  END;

VAR O: TOkno;
    K: Word;
    M: String;
BEGIN
  IF Okno=-1 THEN Okno:=PosledniOkno;

  UlozStavObrazovky;
  O:=Okna[Okno];
  X:=O.X1+OkrajX(O.Vzor)+O.KurzorX-1+Odsazeni;
  Y:=O.Y1+OkrajY(O.Vzor)+O.KurzorY-1;
  B:=Vzory[O.Vzor].Paleta[plVstup];
  O.KurzorX:=1;
  Inc(O.KurzorY);
  Okna[Okno]:=O;

  UkazKurzor;
  M:=#0; S:=Text;
  REPEAT
    IF M<>S THEN
    BEGIN
      Kresli;
      M:=S;
    END;

    K:=CtiKlavesu;

    IF (ZnakKlavesy(K) IN [#32..#255]) AND (Length(S)<MaxDelka) THEN
        S:=S+ZnakKlavesy(K);
    IF (K=8) AND (Length(S)>0) THEN Dec(S[0]);

  UNTIL (K=13) OR (K=27);
  SkryjKurzor;

  ObnovStavObrazovky;

  IF K=13 THEN Text:=S;

  CtiTexT:=(K=13);
END;

{ ------------------- }

PROCEDURE ProhlizejText(DoOkna: ShortInt; Levy, Horni, Pravy, Dolni: ShortInt;
     Text: Pointer; Delka: Word);
VAR W: TOkno;
    Sirka, Vyska: Integer;
    Sloupec, Prvni, Min, MinS, Pocet: Integer;

  FUNCTION VratRadku(X: Integer): String;
  TYPE TCharArray = ARRAY[1..65534] OF Char;
  VAR P, i: Integer;
      S: String;
  BEGIN
    P:=1; i:=1; S:='';
    WHILE (i<=X) AND (P<=Delka) DO
    BEGIN
      IF i=X THEN Move(TCharArray(Text^)[P], S, 1+Byte(TCharArray(Text^)[P]));
      Inc(P, 1+Byte(TCharArray(Text^)[P]));
      Inc(i);
    END;
    VratRadku:=S;
  END;

  FUNCTION PocetRadku: Integer;
  TYPE TCharArray = ARRAY[1..65534] OF Char;
  VAR P, x: Integer;
  BEGIN
    x:=0; P:=1;
    WHILE P<=Delka DO
    BEGIN
      Inc(P, 1+Byte(TCharArray(Text^)[P]));
      Inc(x);
    END;
    PocetRadku:=x;
  END;

  PROCEDURE Kresli;
  VAR S: String;
      B, i: Byte;
  BEGIN
    B:=Vzory[W.Vzor].Paleta[plProhlizec];
    FOR i:=1 TO Vyska DO
    BEGIN
      IF Prvni+i-1<=Pocet THEN S:=VratRadku(Prvni+i-1)
         ELSE S:='';
      Delete(S, 1, Sloupec-1);
      IF Length(S)>Sirka THEN S[0]:=Char(Sirka);
      WHILE Length(S)<Sirka DO S:=S+' ';
      PisText(Levy, Horni+i-1, S, B);
    END;
  END;

VAR K: Word;
BEGIN
  IF DoOkna=-1 THEN DoOkna:=PosledniOkno;

  W:=Okna[DoOkna];
  Levy:=W.X1+OkrajX(W.Vzor)+Levy;
  Horni:=W.Y1+OkrajY(W.Vzor)+Horni;
  IF Pravy>0 THEN Pravy:=W.X1+OkrajX(W.Vzor)+Pravy
     ELSE Pravy:=W.X2+Pravy-OkrajX(W.Vzor);
  IF Dolni>0 THEN Dolni:=W.Y1+OkrajY(W.Vzor)+Dolni
     ELSE Dolni:=W.Y2+Dolni-OkrajY(W.Vzor);
  Sirka:=Pravy-Levy+1;
  Vyska:=Dolni-Horni+1;

  Pocet:=PocetRadku;

  Prvni:=1; Min:=0; Sloupec:=1;
  REPEAT
    IF (Prvni<>Min) OR (Sloupec<>MinS) THEN
    BEGIN
      Kresli;
      Min:=Prvni;
      MinS:=Sloupec;
    END;
    K:=CtiKlavesu;
    CASE K OF
      20480: Inc(Prvni);
      18432: Dec(Prvni);
      18176: BEGIN Prvni:=1; Sloupec:=1; END;
      20224: Prvni:=Pocet-Vyska+1;
      20736: Inc(Prvni, Vyska-1);
      18688: Dec(Prvni, Vyska-1);
      19712: Inc(Sloupec);
      19200: IF Sloupec>1 THEN Dec(Sloupec);
    END;
    IF Prvni>Pocet-Vyska+1 THEN Prvni:=Pocet-Vyska+1;
    IF Prvni<1 THEN Prvni:=1;
  UNTIL K=27;

  FreeMem(Text, Delka);
END;

VAR i: Integer;
BEGIN
  TestObrazovky;
  FOR i:=1 TO High(Okna) DO Okna[i].Obsazene:=False;
  PocetOken:=0;
  UlozeneObrazovky:=0;
END.