PROGRAM Kresleni;
{$X+,F+,I-}
USES Graph,
     Kr_Sys;

CONST zpCara =     11;
      zpObdelnik = 12;
      zpElipsa =   13;
      zpVymaz =    14;

      zpNaSpod = 31;
      zpNaVrch = 32;

      zpUloz =   41;
      zpNahraj = 42;
      zpSmaz  =  43;

      zpPodkladAktivni = 51;
      zpObrazekAktivni = 52;
      zpPrekresliVysec = 53;
      zpVymazMne =       54;

CONST poZadny =    0;
      poCara =     1;
      poObdelnik = 2;
      poElipsa =   3;

CONST JmenoSouboru: String = 'KRESLENI.OBR';

TYPE PPodklad = ^TPodklad;
     TPodklad = OBJECT(TPredmet)
       PROCEDURE Kresli; VIRTUAL;
     END;

TYPE PPrvekObrazku = ^TPrvekObrazku;
     TPrvekObrazku = OBJECT(TPredmet)
       Barva, Pozadi: Byte;
       StylCary: Byte;
       PretoceneH, PretoceneV: Boolean;
       Aktivni: Boolean;

       CONSTRUCTOR Vytvor(MaxX, MaxY: Integer);
       PROCEDURE Prekresli;
       FUNCTION Kliknuto(X, Y: Integer): Boolean; VIRTUAL;
       PROCEDURE Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer); VIRTUAL;
       PROCEDURE KamKreslit(VAR X, Y: Integer);
       PROCEDURE Aktivuj;
       PROCEDURE NastavRozsah(aX1, aY1, aX2, aY2: Integer); VIRTUAL;
       FUNCTION JePretoceneH: Boolean;
       FUNCTION JePretoceneV: Boolean;
       PROCEDURE NastavPretoceni(aH, aV: Boolean);
       PROCEDURE InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean); VIRTUAL;
       PROCEDURE UlozDoSouboru(VAR f: File);
       PROCEDURE NahrajZeSouboru(VAR f: File);
     END;

CONST VelikostOvladace = 2;
TYPE POvladac = ^TOvladac;
     TOvladac = OBJECT(TPredmet)
       Skryty: Boolean;
       Prvek: PPrvekObrazku;
       ProhozenH, ProhozenV: Boolean;
       MeniSe: Boolean;

       CONSTRUCTOR Vytvor;
       PROCEDURE Ukaz(Ukazat: Boolean);
       PROCEDURE Kresli; VIRTUAL;
       PROCEDURE Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer); VIRTUAL;
       FUNCTION JeSkryty: Boolean;
       FUNCTION Kliknuto(X, Y: Integer): Boolean; VIRTUAL;
       PROCEDURE NastavRozsah(aX1, aY1, aX2, aY2: Integer); VIRTUAL;
     END;

TYPE PCara = ^TCara;
     TCara = OBJECT(TPrvekObrazku)
       PROCEDURE Kresli; VIRTUAL;
       PROCEDURE InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean); VIRTUAL;
       FUNCTION JeToVevnitr(X, Y: Integer): Boolean; VIRTUAL;
     END;

TYPE PObdelnik = ^TObdelnik;
     TObdelnik = OBJECT(TPrvekObrazku)
       PROCEDURE Kresli; VIRTUAL;
       PROCEDURE InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean); VIRTUAL;
     END;

TYPE PElipsa = ^TElipsa;
     TElipsa = OBJECT(TPrvekObrazku)
       PROCEDURE Kresli; VIRTUAL;
       PROCEDURE InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean); VIRTUAL;
     END;

TYPE PObrazek = ^TObrazek;
     TObrazek = OBJECT(TSkupina)
       Pozadi: Integer;
       PodkladAktivni: Boolean;
       Ovladac: POvladac;

       CONSTRUCTOR Vytvor(X, Y, ASirka, AVyska: Integer; AOvladac: POvladac);
       PROCEDURE PrekresliVysec(vX1, vY1, vX2, vY2: Integer);
       PROCEDURE Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer); VIRTUAL;
       PROCEDURE Kresli; VIRTUAL;
       FUNCTION Kliknuto(X, Y: Integer): Boolean; VIRTUAL;
       PROCEDURE AktivujPodklad;
       PROCEDURE NahrajZeSouboru(Jmeno: String);
       PROCEDURE UlozDoSouboru(Jmeno: String);
       PROCEDURE SmazObrazek;
       FUNCTION VytvorPrvek(ID: Byte): PPrvekObrazku;
     END;

TYPE PDeska = ^TDeska;
     TDeska = OBJECT(TSkupina)
       CONSTRUCTOR Vytvor(X, Y, ASirka, AVyska: Integer);
     END;

TYPE TKresleni = OBJECT(TProgram)
       CONSTRUCTOR Vytvor;
       PROCEDURE VlozTlacitka(AY: Integer;
          NaRadku, VyskaTl, Pocet, Ikonka, Prikaz: Integer);
     END;

PROCEDURE KresliciIkonky(Ikonka: Integer);
VAR D: Integer;
BEGIN
     { KONEC }
  IF Ikonka=1 THEN
  BEGIN
    SetColor(Red);
    TlustaCara;
    Line(5, 5, 85, 21);
    Line(5, 21, 85, 5);
  END;

     { CARA }
  IF Ikonka=11 THEN
  BEGIN
    SetColor(Black);
    Line(35, 5, 5, 15);
  END;
     { OBDELNIK }
  IF Ikonka=12 THEN
  BEGIN
    SetColor(Black);
    Rectangle(10, 3, 30, 18);
  END;
     { ELIPSA }
  IF Ikonka=13 THEN
  BEGIN
    SetColor(Black);
    Ellipse(20, 10, 0, 360, 13, 8);
  END;
     { VYMAZANI }
  IF Ikonka=14 THEN
  BEGIN
    SetColor(Red);
    TlustaCara;
    Line(13, 3, 27, 17);
    Line(27, 3, 13, 17);
  END;

     { STYLY CAR }
  IF Ikonka IN [21..24] THEN
  BEGIN
    SetLineStyle(Ikonka-21, 0, NormWidth);
    SetColor(Black);
    Line(5, 10, 35, 10);
  END;

     { DO POZADI }
  IF Ikonka=31 THEN
  BEGIN
    SetColor(Black);
    Rectangle(10, 6, 30, 15);
    SetFillStyle(SolidFill, Red);
    Bar3D(5, 3, 18, 11, 0, True);
    Bar3D(22, 10, 35, 18, 0, True);
  END;
     { DO POPREDI }
  IF Ikonka=32 THEN
  BEGIN
    SetColor(Black);
    Rectangle(5, 3, 18, 11);
    Rectangle(22, 10, 35, 18);
    SetFillStyle(SolidFill, Red);
    Bar3D(10, 6, 30, 15, 0, True);
  END;

     { ULOZ }
  IF Ikonka=41 THEN
  BEGIN
    SetColor(Black);
    SetFillStyle(SolidFill, Blue);
    Bar3D(18, 3, 33, 18, 0, True);
    SetFillStyle(SolidFill, DarkGray);
    Bar(23, 14, 29, 18);
    SetFillStyle(SolidFill, White);
    Bar(21, 4, 30, 11);

    SetLineStyle(SolidLn, 0, ThickWidth);
    SetColor(Red);
    Line(7, 11, 27, 11);
    Line(22, 6, 27, 11);
    Line(22, 16, 27, 11);
  END;
     { NAHRAJ }
  IF Ikonka=42 THEN
  BEGIN
    SetColor(Black);
    SetFillStyle(SolidFill, Blue);
    Bar3D(8, 3, 23, 18, 0, True);
    SetFillStyle(SolidFill, DarkGray);
    Bar(13, 14, 19, 18);
    SetFillStyle(SolidFill, White);
    Bar(11, 4, 20, 11);

    SetLineStyle(SolidLn, 0, ThickWidth);
    SetColor(Red);
    Line(15, 11, 35, 11);
    Line(30, 6, 35, 11);
    Line(30, 16, 35, 11);
  END;
     { SMAZ }
  IF Ikonka=43 THEN
  BEGIN
    SetColor(Black);
    SetFillStyle(SolidFill, White);
    Bar3D(5, 3, 35, 18, 0, True);
  END;

     { BARVY }
  IF Ikonka IN [101..116] THEN
  BEGIN
    SetColor((Ikonka MOD 100)-1);
    Rectangle(3, 3, 12, 12);
    Rectangle(4, 4, 11, 11);
  END;
     { ZADNA BARVA POZADI }
  IF Ikonka=201 THEN
  BEGIN
    SetColor(Black);
    Rectangle(3, 3, 12, 12);
  END;
     { BARVY POZADI }
  IF Ikonka IN [202..216] THEN
  BEGIN
    SetFillStyle(SolidFill, (Ikonka MOD 100)-1);
    Bar(3, 3, 12, 12);
  END;
END;


  { TPodklad }

PROCEDURE TPodklad.Kresli;
BEGIN
  TlustaCara;
  SetColor(White);
  Rectangle(1, 1, Sirka-1-1, Vyska-1-1);
END;


  { TOvladac }

CONSTRUCTOR TOvladac.Vytvor;
BEGIN
  INHERITED Vytvor(0, 0, 0, 0);

  Skryty:=True;
  Prvek:=NIL;
  MeniSe:=False;
END;

PROCEDURE TOvladac.Ukaz(Ukazat: Boolean);
BEGIN
  IF NOT (Ukazat XOR Skryty) THEN
  BEGIN
    Skryty:=NOT Ukazat;
    NaKresli;
    {IF Skryty THEN NastavRozsah(0, 0, 0, 0);}
  END;
END;

PROCEDURE TOvladac.NastavRozsah(aX1, aY1, aX2, aY2: Integer);
VAR X: Integer;
    pX1, pY1, pX2, pY2: Integer;
    pH, pV: Boolean;
BEGIN
  IF Prvek<>NIL THEN
  BEGIN
    Ukaz(False);

    Prvek^.Vlastnik^.NaObrazovku(0, 0, pX1, pY1);
    Vlastnik^.NaPredmet(pX1, pY1, pX1, pY1);

    Prvek^.Vlastnik^.NaObrazovku(Prvek^.Vlastnik^.Sirka-1,
        Prvek^.Vlastnik^.Vyska-1, pX2, pY2);
    Vlastnik^.NaPredmet(pX2, pY2, pX2, pY2);

    IF pX1>aX1 THEN aX1:=pX1;
    IF pY1>aY1 THEN aY1:=pY1;
    IF pX2<aX2 THEN aX2:=pX2;
    IF pY2<aY2 THEN aY2:=pY2;

    ProhozenH:=False; ProhozenV:=False;
    IF aX1+VelikostOvladace>aX2-VelikostOvladace THEN
    BEGIN
      X:=aX2; aX2:=aX1+2*VelikostOvladace; aX1:=X-2*VelikostOvladace;
      ProhozenH:=True;
    END;
    IF aY1+VelikostOvladace>aY2-VelikostOvladace THEN
    BEGIN
      X:=aY2; aY2:=aY1+2*VelikostOvladace; aY1:=X-2*VelikostOvladace;
      ProhozenV:=True;
    END;

    pH:=Prvek^.JePretoceneH;
    pV:=Prvek^.JePretoceneV;
    IF ProhozenH THEN pH:=NOT pH;
    IF ProhozenV THEN pV:=NOT pV;
    Prvek^.NastavPretoceni(pH, pV);

    INHERITED NastavRozsah(aX1, aY1, aX2, aY2);
    Ukaz(True);
  END;
END;

FUNCTION TOvladac.Kliknuto(X, Y: Integer): Boolean;
VAR H, V: Integer;
    aX1, aY1, aX2, aY2: Integer;
    mX, mY, Co: Integer;
    pH, pV: Boolean;

  PROCEDURE NastavMeniSe(Hodnota: Boolean);
  BEGIN
    Ukaz(False);
    MeniSe:=Hodnota;
    Ukaz(True);
  END;

BEGIN
  Kliknuto:=False;
  IF NOT Skryty THEN
  BEGIN
    NaPredmet(X, Y, mX, mY);

    H:=0; V:=0;
    IF (mY>=0) AND (mY<=VelikostOvladace*2) THEN V:=-1;
    IF (mY>=Vyska-1-VelikostOvladace*2) AND (mY<=Vyska-1) THEN V:=+1;

    IF (mX>=0) AND (mX<=VelikostOvladace*2) THEN H:=-1;
    IF (mX>=Sirka-1-VelikostOvladace*2) AND (mX<=Sirka-1) THEN H:=+1;

    IF ((H<>0) AND (V<>0)) OR
       Prvek^.JeToVevnitr(X, Y) THEN
    BEGIN
      IF (H<>0) AND (V<>0) THEN
      BEGIN
        pH:=Prvek^.JePretoceneH; pV:=Prvek^.JePretoceneV;
        REPEAT
          CekejNaMys(Co, X, Y);
          IF Co=msPohyb THEN
          BEGIN
            IF NOT MeniSe THEN NastavMeniSe(True);

            VratRozsah(aX1, aY1, aX2, aY2);
            IF (H=-1) AND (V=-1) THEN Vlastnik^.NaPredmet(X, Y, aX1, aY1);
            IF (H=-1) AND (V=+1) THEN Vlastnik^.NaPredmet(X, Y, aX1, aY2);
            IF (H=+1) AND (V=-1) THEN Vlastnik^.NaPredmet(X, Y, aX2, aY1);
            IF (H=+1) AND (V=+1) THEN Vlastnik^.NaPredmet(X, Y, aX2, aY2);
            NastavRozsah(aX1, aY1, aX2, aY2);

            IF ProhozenH OR ProhozenV THEN
            BEGIN
              IF ProhozenH THEN
              BEGIN
                H:=-H;
                pH:=NOT pH;
              END;
              IF ProhozenV THEN
              BEGIN
                V:=-V;
                pV:=NOT pV;
              END;
            END;
          END;
        UNTIL Co=msPusteno;
      END
         ELSE
      BEGIN
        PolohaMysi(mX, mY);
        REPEAT
          CekejNaMys(Co, X, Y);
          IF Co=msPohyb THEN
          BEGIN
            IF NOT MeniSe THEN NastavMeniSe(True);

            VratRozsah(aX1, aY1, aX2, aY2);
            Inc(aX1, X-mX); Inc(aX2, X-mX);
            Inc(aY1, Y-mY); Inc(aY2, Y-mY);
            NastavRozsah(aX1, aY1, aX2, aY2);
            mX:=X; mY:=Y;
          END;
        UNTIL Co=msPusteno;
      END;
      IF MeniSe THEN
      BEGIN
        NastavMeniSe(False);

        NaObrazovku(VelikostOvladace, VelikostOvladace, aX1, aY1);
        Prvek^.Vlastnik^.NaPredmet(aX1, aY1, aX1, aY1);
        NaObrazovku(Sirka-1-VelikostOvladace, Vyska-1-VelikostOvladace, aX2, aY2);
        Prvek^.Vlastnik^.NaPredmet(aX2, aY2, aX2, aY2);

        Prvek^.NastavRozsah(aX1, aY1, aX2, aY2);
      END;

      Kliknuto:=True;
    END;
  END;
END;

FUNCTION TOvladac.JeSkryty: Boolean;
BEGIN
  JeSkryty:=Skryty;
END;

PROCEDURE TOvladac.Kresli;

  PROCEDURE InverzniRamecek(cX1, cY1, cX2, cY2: Integer);
  VAR i: Integer;
  BEGIN
    FOR i:=cX1 TO cX2 DO
    BEGIN
      InverzniBod(i, cY1);
      InverzniBod(i, cY2);
    END;
    FOR i:=cY1+1 TO cY2-1 DO
    BEGIN
      InverzniBod(cX1, i);
      InverzniBod(cX2, i);
    END;
  END;

  PROCEDURE InverzniCtverecek(X, Y: Integer);
  VAR i: Integer;
  BEGIN
    InverzniBod(X, Y);
    FOR i:=1 TO VelikostOvladace DO InverzniRamecek(X-i, Y-i, X+i, Y+i);
  END;

  PROCEDURE InverzniCara(X1, Y1, X2, Y2: Integer);
  VAR i, st, e: Integer;
      DeltaX, DeltaY: Integer;
      DirectX, DirectY: Integer;
      Stp: Boolean;

    PROCEDURE Prohod(VAR A, B: Integer);
    VAR P: Integer;
    BEGIN
      P:=A;
      A:=B;
      B:=P;
    END;

    FUNCTION Znamenko(X: Integer): Integer;
    BEGIN
      IF X<0 THEN Znamenko:=-1
          ELSE Znamenko:=1;
    END;

  BEGIN
    DeltaX:=Abs(X2-X1);
    DirectX:=Znamenko(X2-X1);
    DeltaY:=Abs(Y2-Y1);
    DirectY:=Znamenko(Y2-Y1);
    Stp:=DeltaY>DeltaX;
    IF Stp THEN
    BEGIN
      Prohod(X1, Y1);
      Prohod(DeltaX, DeltaY);
      Prohod(DirectX, DirectY);
    END;
    e:=2*DeltaY-DeltaX;
    FOR i:=1 TO DeltaX DO
    BEGIN
      IF Stp THEN InverzniBod(Y1, X1)
          ELSE InverzniBod(X1, Y1);
      WHILE e>=0 DO
      BEGIN
        Y1:=Y1+DirectY;
        e:=e-2*DeltaX;
      END;
      X1:=X1+DirectX;
      e:=e+2*DeltaY;
    END;
    InverzniBod(X2, Y2);
  END;

VAR pH, pV, Obdelnikovy: Boolean;
    ID: Byte;
BEGIN
  IF Prvek<>NIL THEN
  BEGIN
    pH:=Prvek^.JePretoceneH;
    pV:=Prvek^.JePretoceneV;
    Prvek^.InfoOPrvku(ID, Obdelnikovy);

    IF Obdelnikovy OR
       (NOT (pH XOR pV)) THEN
    BEGIN
      { LH } InverzniCtverecek(VelikostOvladace, VelikostOvladace);
      { PD } InverzniCtverecek(Sirka-1-VelikostOvladace, Vyska-1-VelikostOvladace);
    END;
    IF Obdelnikovy OR
       (pH XOR pV) THEN
    BEGIN
      { PH } InverzniCtverecek(Sirka-VelikostOvladace-1, VelikostOvladace);
      { LD } InverzniCtverecek(VelikostOvladace, Vyska-1-VelikostOvladace);
    END;

    IF MeniSe THEN
    BEGIN
      IF Obdelnikovy THEN
      BEGIN
        IF Sirka>VelikostOvladace*4+2 THEN
        BEGIN
          InverzniCara(VelikostOvladace*2+1, VelikostOvladace,
                       Sirka-1-VelikostOvladace*2-1, VelikostOvladace);
          InverzniCara(VelikostOvladace*2+1, Vyska-1-VelikostOvladace,
                       Sirka-1-VelikostOvladace*2-1, Vyska-1-VelikostOvladace);
        END;
        IF Vyska>VelikostOvladace*4+2 THEN
        BEGIN
          InverzniCara(VelikostOvladace, VelikostOvladace*2+1,
                       VelikostOvladace, Vyska-1-VelikostOvladace*2-1);
          InverzniCara(Sirka-1-VelikostOvladace, VelikostOvladace*2+1,
                       Sirka-1-VelikostOvladace, Vyska-1-VelikostOvladace*2-1);
        END;
      END
         ELSE
      BEGIN
        IF NOT (pH XOR pV) THEN
        BEGIN
          InverzniCara(VelikostOvladace, VelikostOvladace,
                       Sirka-1-VelikostOvladace, Vyska-1-VelikostOvladace);
        END
           ELSE
        BEGIN
          InverzniCara(VelikostOvladace, Vyska-1-VelikostOvladace,
                       Sirka-1-VelikostOvladace, VelikostOvladace);
        END;
      END;
    END;
  END;
END;

PROCEDURE TOvladac.Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer);
VAR aX1, aY1, aX2, aY2: Integer;
BEGIN
  IF Cislo=zpPodkladAktivni THEN
  BEGIN
    Ukaz(False);
    Prvek:=NIL;
  END;

  IF Cislo=zpObrazekAktivni THEN
  BEGIN
    IF NOT Skryty THEN Ukaz(False);

    Prvek:=PPrvekObrazku(OdKoho);
    Prvek^.VratRozsah(aX1, aY1, aX2, aY2);

    Prvek^.NaObrazovku(aX2-aX1, aY2-aY1, aX2, aY2);
    Vlastnik^.NaPredmet(aX2, aY2, aX2, aY2);

    Prvek^.NaObrazovku(0, 0, aX1, aY1);
    Vlastnik^.NaPredmet(aX1, aY1, aX1, aY1);

    NastavRozsah(aX1-VelikostOvladace, aY1-VelikostOvladace,
                 aX2+VelikostOvladace, aY2+VelikostOvladace);

    Ukaz(True);
  END;
END;


  { TPrvek }

CONSTRUCTOR TPrvekObrazku.Vytvor(MaxX, MaxY: Integer);
VAR X, Y, ASirka, AVyska: Integer;
BEGIN
  ASirka:=70;
  AVyska:=50;
  X:=Random(MaxX-ASirka-100)+50;
  Y:=Random(MaxY-AVyska-100)+50;

  INHERITED Vytvor(X, Y, ASirka, AVyska);

  Barva:=White; Pozadi:=Black;
  StylCary:=SolidLn;
  PretoceneH:=False; PretoceneV:=False;
  KresleniDoVysece:=False;
  Aktivni:=False;
END;

PROCEDURE TPrvekObrazku.UlozDoSouboru(VAR f: File);
VAR ID: Byte;
    O: Boolean;
BEGIN
  InfoOPrvku(ID, O);

  BlockWrite(f, ID, SizeOf(ID));
  BlockWrite(f, X1, SizeOf(X1)+SizeOf(Y1)+SizeOf(X2)+SizeOf(Y2));
  BlockWrite(f, Barva, SizeOf(Barva)+SizeOf(Pozadi)+SizeOf(StylCary)+
      SizeOf(PretoceneH)+SizeOf(PretoceneV));
END;

PROCEDURE TPrvekObrazku.NahrajZeSouboru(VAR f: File);
BEGIN
  BlockRead(f, X1, SizeOf(X1)+SizeOf(Y1)+SizeOf(X2)+SizeOf(Y2));
  BlockRead(f, Barva, SizeOf(Barva)+SizeOf(Pozadi)+SizeOf(StylCary)+
      SizeOf(PretoceneH)+SizeOf(PretoceneV));
END;

PROCEDURE TPrvekObrazku.InfoOPrvku(VAR IDCislo: Byte;
   VAR Obdelnikovy: Boolean);
BEGIN
  IDCislo:=poZadny;
  Obdelnikovy:=True;
END;

PROCEDURE TPrvekObrazku.NastavRozsah(aX1, aY1, aX2, aY2: Integer);
VAR pX1, pY1, pX2, pY2: Integer;
BEGIN
  pX1:=X1; pY1:=Y1; pX2:=X2; pY2:=Y2;

  INHERITED NastavRozsah(aX1, aY1, aX2, aY2);

  PObrazek(Vlastnik)^.PrekresliVysec(pX1, pY1, pX2, pY2);
  Prekresli;
END;

PROCEDURE TPrvekObrazku.Aktivuj;
BEGIN
  IF NOT Aktivni THEN
  BEGIN
    PosliZpravu(zpObrazekAktivni, NIL);
    Aktivni:=True;
  END;
END;

FUNCTION TPrvekObrazku.JePretoceneH: Boolean;
BEGIN
  JePretoceneH:=PretoceneH;
END;

FUNCTION TPrvekObrazku.JePretoceneV: Boolean;
BEGIN
  JePretoceneV:=PretoceneV;
END;

PROCEDURE TPrvekObrazku.NastavPretoceni(aH, aV: Boolean);
BEGIN
  PretoceneH:=aH;
  PretoceneV:=aV;
END;

PROCEDURE TPrvekObrazku.Prekresli;
BEGIN
  PosliZpravu(zpPrekresliVysec, NIL);
END;

PROCEDURE TPrvekObrazku.Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer);
BEGIN
  IF ((Cislo=zpObrazekAktivni) AND (OdKoho<>@Self)) OR
     (Cislo=zpPodkladAktivni) THEN Aktivni:=False;

  IF (Cislo=zpVymaz)AND Aktivni THEN PosliZpravu(zpVymazMne, NIL);

  IF (Cislo IN [21..24]) AND Aktivni THEN
  BEGIN
    StylCary:=Cislo-21;
    Prekresli;
  END;
  IF (Cislo IN [201..216]) AND Aktivni THEN
  BEGIN
    Pozadi:=Cislo-201;
    Prekresli;
  END;
  IF (Cislo IN [101..116]) AND Aktivni THEN
  BEGIN
    Barva:=Cislo-101;
    Prekresli;
  END;

  IF (Cislo=zpNaVrch) AND Aktivni THEN
  BEGIN
    Vlastnik^.NaVrch(@Self);
    Prekresli;
  END;
  IF (Cislo=zpNaSpod) AND Aktivni THEN
  BEGIN
    Vlastnik^.NaSpod(@Self);
    Prekresli;
  END;
END;

FUNCTION TPrvekObrazku.Kliknuto(X, Y: Integer): Boolean;
BEGIN
  Aktivuj;
END;

PROCEDURE TPrvekObrazku.KamKreslit(VAR X, Y: Integer);
VAR VP: ViewPortType;
BEGIN
  NaObrazovku(0, 0, X, Y);
  GetViewSettings(VP);
  X:=X-VP.X1;
  Y:=Y-VP.Y1;
END;


  { TCara }

PROCEDURE TCara.Kresli;
VAR X, Y: Integer;
BEGIN
  SetColor(Barva);
  SetLineStyle(StylCary, 0, NormWidth);
  KamKreslit(X, Y);
  IF NOT (PretoceneH XOR PretoceneV) THEN Line(X, Y, X+Sirka-1, Y+Vyska-1)
     ELSE Line(X, Y+Vyska-1, X+Sirka-1, Y);
END;

PROCEDURE TCara.InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean);
BEGIN
  IDCislo:=poCara;
  Obdelnikovy:=False;
END;

FUNCTION TCara.JeToVevnitr(X, Y: Integer): Boolean;
VAR AnoJe: Boolean;
    aX, aY: Integer;
    Delta: Real;
BEGIN
  AnoJe:=False;
  NaPredmet(X, Y, aX, aY);
  IF Sirka>Vyska THEN
  BEGIN
    IF (0<=aX) AND (aX<=Sirka-1) THEN
    BEGIN
      IF NOT (PretoceneH XOR PretoceneV) THEN
         Delta:=(Vyska/Sirka*aX)-aY
         ELSE Delta:=(Vyska/Sirka*aX)-(Vyska-aY);
      AnoJe:=Abs(Delta)<4;
    END;
  END
     ELSE
  BEGIN
    IF (0<=aY) AND (aY<=Vyska-1) THEN
    BEGIN
      IF NOT (PretoceneH XOR PretoceneV) THEN
         Delta:=(Sirka/Vyska*aY)-aX
         ELSE Delta:=(Sirka/Vyska*aY)-(Sirka-aX);
      AnoJe:=Abs(Delta)<4;
    END;
  END;
  JeToVevnitr:=AnoJe;
END;


  { TObdelnik }

PROCEDURE TObdelnik.Kresli;
VAR X, Y: Integer;
BEGIN
  SetColor(Barva);
  SetLineStyle(StylCary, 0, NormWidth);
  KamKreslit(X, Y);
  IF Pozadi=0 THEN Rectangle(X, Y, X+Sirka-1, Y+Vyska-1)
     ELSE
  BEGIN
    SetFillStyle(SolidFill, Pozadi);
    Bar3D(X, Y, X+Sirka-1, Y+Vyska-1, 0, TopOn)
  END;
END;

PROCEDURE TObdelnik.InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean);
BEGIN
  IDCislo:=poObdelnik;
  Obdelnikovy:=True;
END;



  { TElipsa }

PROCEDURE TElipsa.Kresli;
VAR X, Y: Integer;
BEGIN
  SetColor(Barva);
  SetLineStyle(StylCary, 0, NormWidth);
  KamKreslit(X, Y);

  Ellipse(X+Sirka DIV 2, Y+Vyska DIV 2, 0, 360, Sirka DIV 2-1, Vyska DIV 2-1);
  IF Pozadi<>0 THEN
  BEGIN
    SetFillStyle(SolidFill, Pozadi);
    FillEllipse(X+Sirka DIV 2, Y+Vyska DIV 2, Sirka DIV 2-1, Vyska DIV 2-1);
  END;
END;

PROCEDURE TElipsa.InfoOPrvku(VAR IDCislo: Byte; VAR Obdelnikovy: Boolean);
BEGIN
  IDCislo:=poElipsa;
  Obdelnikovy:=True;
END;


  { TObrazek }

CONSTRUCTOR TObrazek.Vytvor(X, Y, ASirka, AVyska: Integer; AOvladac: POvladac);
BEGIN
  INHERITED Vytvor(X, Y, ASirka, AVyska);

  Pozadi:=Black;
  PodkladAktivni:=True;
  Ovladac:=AOvladac;
END;

PROCEDURE TObrazek.Kresli;
BEGIN
  SetFillStyle(SolidFill, Pozadi);
  Bar(0, 0, Sirka-1, Vyska-1);

  ZrusKresliciOkno;
  INHERITED Kresli;
END;

PROCEDURE TObrazek.PrekresliVysec(vX1, vY1, vX2, vY2: Integer);
VAR P: PPredmet;
    U: Boolean;
BEGIN
  NaObrazovku(vX1, vY1, vX1, vY1);
  NaObrazovku(vX2, vY2, vX2, vY2);

  SkryjMys;

  U:=Ovladac^.JeSkryty;
  IF NOT U THEN Ovladac^.Ukaz(False);

  SetViewPort(vX1, vY1, vX2+1, vY2+1, True);
  SetFillStyle(SolidFill, Pozadi);
  Bar(0, 0, vX2-vX1, vY2-vY1);
  P:=Posledni;
  WHILE P<>NIL DO
  BEGIN
    NormalniCara;
    P^.Kresli;
    P:=P^.PredesliPredmet;
  END;
  UkazMys;

  IF NOT U THEN Ovladac^.Ukaz(True);
END;

PROCEDURE TObrazek.AktivujPodklad;
BEGIN
  PodkladAktivni:=True;
  PosliZpravu(zpPodkladAktivni, NIL);
END;

FUNCTION TObrazek.Kliknuto(X, Y: Integer): Boolean;
VAR K: Boolean;
BEGIN
  K:=INHERITED Kliknuto(X, Y);

  IF NOT K THEN AktivujPodklad;
END;

PROCEDURE TObrazek.Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer);
VAR P: PPrvekObrazku;

  PROCEDURE PrekresliPresPrvek;
  BEGIN
    PrekresliVysec(PPrvekObrazku(OdKoho)^.X1, PPrvekObrazku(OdKoho)^.Y1,
          PPrvekObrazku(OdKoho)^.X2, PPrvekObrazku(OdKoho)^.Y2);
  END;

BEGIN
  INHERITED Zprava(OdKoho, Cislo, Udaje);

  IF Cislo=zpObrazekAktivni THEN PodkladAktivni:=False;
  IF (Cislo IN [201..216]) AND PodkladAktivni THEN
  BEGIN
    Pozadi:=Cislo-201;
    NaKresli;
  END;
  IF Cislo IN [zpCara..zpElipsa] THEN
  BEGIN
    P:=VytvorPrvek(Cislo-zpCara+1);
    Vloz(P);
    P^.Aktivuj;
  END;
  IF Cislo=zpPrekresliVysec THEN PrekresliPresPrvek;
  IF Cislo=zpVymazMne THEN
  BEGIN
    AktivujPodklad;
    Vymaz(OdKoho);
    PrekresliPresPrvek;
    Dispose(OdKoho, Zrus);
  END;

  IF Cislo=zpSmaz THEN SmazObrazek;
  IF Cislo=zpUloz THEN UlozDoSouboru(JmenoSouboru);
  IF Cislo=zpNahraj THEN NahrajZeSouboru(JmenoSouboru);
END;

FUNCTION TObrazek.VytvorPrvek(ID: Byte): PPrvekObrazku;
VAR P: PPrvekObrazku;
BEGIN
  CASE ID OF
    poCara: P:=New(PCara, Vytvor(Sirka, Vyska));
    poObdelnik: P:=New(PObdelnik, Vytvor(Sirka, Vyska));
    poElipsa: P:=New(PElipsa, Vytvor(Sirka, Vyska));
       ELSE P:=NIL;
  END;
  VytvorPrvek:=P;
END;

PROCEDURE TObrazek.SmazObrazek;
VAR P: PPredmet;
BEGIN
  Pozadi:=Black;
  WHILE Prvni<>NIL DO
  BEGIN
    P:=Prvni;
    Vymaz(P);
    Dispose(P, Zrus);
  END;
  Nakresli;
END;

PROCEDURE TObrazek.NahrajZeSouboru(Jmeno: String);
VAR f: File;
    ID: Byte;
    P: PPrvekObrazku;
BEGIN
  SmazObrazek;

  Assign(f, Jmeno);
  Reset(f, 1);
  BlockRead(f, Pozadi, SizeOf(Pozadi));

  WHILE NOT EOF(f) DO
  BEGIN
    BlockRead(f, ID, SizeOf(ID));
    P:=VytvorPrvek(ID);
    IF P<>NIL THEN
    BEGIN
      P^.NahrajZeSouboru(f);
      Vloz(P);
    END;
  END;

  Close(f);

  NaKresli;
END;

PROCEDURE TObrazek.UlozDoSouboru(Jmeno: String);
VAR f: File;
    P: PPrvekObrazku;
BEGIN
  Assign(f, Jmeno);
  Rewrite(f, 1);
  BlockWrite(f, Pozadi, SizeOf(Pozadi));

  P:=PPrvekObrazku(Posledni);
  WHILE P<>NIL DO
  BEGIN
    P^.UlozDoSouboru(f);
    P:=PPrvekObrazku(P^.PredesliPredmet);
  END;

  Close(f);
END;


  { TDeska }

CONSTRUCTOR TDeska.Vytvor(X, Y, ASirka, AVyska: Integer);
VAR Ovladac: POvladac;
BEGIN
  INHERITED Vytvor(X, Y, ASirka, AVyska);

  Vloz(New(PPodklad, Vytvor(0, 0, ASirka, AVyska)));
  New(Ovladac, Vytvor);
  Vloz(New(PObrazek, Vytvor(5, 5, ASirka-10, AVyska-10, Ovladac)));
  Vloz(Ovladac);
END;


  { TKresleni }

CONSTRUCTOR TKresleni.Vytvor;
BEGIN
  Randomize;

  INHERITED Vytvor;

  IkonkyTlacitek:=KresliciIkonky;

  VlozTlacitka(  0, 2, 30,  4,  10,  10);
  VlozTlacitka( 66, 2, 30,  4,  20,  20);
  VlozTlacitka(132, 4, 25, 16, 100, 100);
  VlozTlacitka(238, 4, 25, 16, 200, 200);
  VlozTlacitka(345, 2, 30,  2,  30,  30);
  VlozTlacitka(380, 2, 30,  3,  40,  40);

  Vloz(New(PTlacitko, Vytvor(0, 445, 99, 35, 1, zpKonec)));

  Vloz(New(PDeska, Vytvor(100, 0, 540, 480)));
END;

PROCEDURE TKresleni.VlozTlacitka(AY: Integer; NaRadku, VyskaTl, Pocet,
   Ikonka, Prikaz: Integer);
VAR X, Y, i, S: Integer;
BEGIN
  S:=100 DIV NaRadku;
  X:=0; Y:=AY;
  FOR i:=1 TO Pocet DO
  BEGIN
    Vloz(New(PTlacitko, Vytvor(X, Y, S-1, VyskaTl-1, Ikonka+i, Prikaz+i)));

    IF i MOD NaRadku=0 THEN
    BEGIN
      X:=0;
      Inc(Y, VyskaTl);
    END
       ELSE Inc(X, S);
  END;
END;

VAR K: TKresleni;
    P: LongInt;
BEGIN
  {} P:=MemAvail;

  IF ParamCount>0 THEN JmenoSouboru:=ParamStr(1);

  K.Vytvor;
  K.Spust;
  K.Zrus;

  {} IF P<>MemAvail THEN Writeln(#7, 'Ztrata pameti: ', P-MemAvail, ' bajtu');
END.