UNIT Kr_Sys;

INTERFACE

USES Crt;

CONST msNic = 1;
      msStisknuto = 2;
      msPusteno = 3;
      msPohyb = 4;

TYPE PPredmet = ^TPredmet;
     PSkupina = ^TSkupina;
     PProgram = ^TProgram;

     TPredmet = OBJECT
       X1, Y1, X2, Y2: Integer;
       VlastnikS: PSkupina;
       DalsiP: PPredmet;
       KresleniDoVysece: Boolean;

       CONSTRUCTOR Vytvor(X, Y, ASirka, AVyska: Integer);
       DESTRUCTOR Zrus; VIRTUAL;

       PROCEDURE CekejNaMys(VAR Co, X, Y: Integer); VIRTUAL;
       FUNCTION Dalsi: PPredmet;
       FUNCTION DalsiPredmet: PPredmet;
       FUNCTION JeToVevnitr(X, Y: Integer): Boolean; VIRTUAL;
       FUNCTION Kliknuto(X, Y: Integer): Boolean; VIRTUAL;
       PROCEDURE Kresli; VIRTUAL;
       PROCEDURE Nakresli;
       FUNCTION NaObrazovceX: Integer;
       FUNCTION NaObrazovceY: Integer;
       PROCEDURE NaObrazovku(AX, AY: Integer; VAR X, Y: Integer);
       PROCEDURE NaPredmet(AX, AY: Integer; VAR X, Y: Integer);
       PROCEDURE NastavDalsiho(ADalsi: PPredmet);
       PROCEDURE NastavKresliciVysec(LX, HY, PX, DY: Integer);
       PROCEDURE NastavKresliciOkno;
       PROCEDURE NastavRozsah(aX1, aY1, aX2, aY2: Integer); VIRTUAL;
       PROCEDURE NastavVlastnika(AVlastnik: PSkupina);
       FUNCTION Nejvyssi: PProgram;
       PROCEDURE PosliZpravu(Cislo: Word; Udaje: Pointer);
       FUNCTION Predesli: PPredmet;
       FUNCTION PredesliPredmet: PPredmet;
       FUNCTION Sirka: Integer;
       FUNCTION Vlastnik: PSkupina;
       PROCEDURE VratRozsah(VAR aX1, aY1, aX2, aY2: Integer);
       FUNCTION Vyska: Integer;
       PROCEDURE Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer); VIRTUAL;
       PROCEDURE ZrusKresliciOkno;
     END;
     TSkupina = OBJECT(TPredmet)
       PrvniP: PPredmet;

       CONSTRUCTOR Vytvor(X, Y, ASirka, AVyska: Integer);
       DESTRUCTOR Zrus; VIRTUAL;

       FUNCTION Kliknuto(X, Y: Integer): Boolean; VIRTUAL;
       PROCEDURE Kresli; VIRTUAL;
       PROCEDURE NaSpod(APosledni: PPredmet);
       PROCEDURE NastavPrvniho(APrvni: PPredmet);
       PROCEDURE NaVrch(APrvni: PPredmet);
       FUNCTION PodMysi(X, Y: Integer): PPredmet;
       FUNCTION Posledni: PPredmet;
       FUNCTION Prvni: PPredmet;
       PROCEDURE Vloz(P: PPredmet);
       PROCEDURE Vymaz(P: PPredmet);
       PROCEDURE VymazVsechny;
       PROCEDURE Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer); VIRTUAL;
     END;
     TProgram = OBJECT(TSkupina)
       Ukonceno: Boolean;

       CONSTRUCTOR Vytvor;
       DESTRUCTOR Zrus; VIRTUAL;

       PROCEDURE CekejNaMys(VAR Co, X, Y: Integer); VIRTUAL;
       PROCEDURE IkonkyTlacitek(Ikonka: Integer); VIRTUAL;
       PROCEDURE Konec;
       PROCEDURE Spust;
     END;


CONST OkrajTlacitka: Byte = 4;
      BarvaTlacitkaS: Byte = White;
      BarvaTlacitkaT: Byte = DarkGray;
      BarvaTlacitkaP: Byte = LightGray;

TYPE PTlacitko = ^TTlacitko;
     TTlacitko = OBJECT(TPredmet)
       Ikonka, Prikaz: Integer;
       Stiskle, JenomOkraj: Boolean;

       CONSTRUCTOR Vytvor(X, Y, ASirka, AVyska, AIkonka, APrikaz: Integer);

       FUNCTION Kliknuto(X, Y: Integer): Boolean; VIRTUAL;
       PROCEDURE Kresli; VIRTUAL;
     END;

PROCEDURE TlustaCara;
PROCEDURE NormalniCara;

PROCEDURE UkazMys;
PROCEDURE SkryjMys;

PROCEDURE InverzniBod(X, Y: Integer);

PROCEDURE PolohaMysi(VAR X, Y: Integer);

IMPLEMENTATION

USES Dos, Graph, Objects;

CONST PolohaMysiX: Integer = 0;
      PolohaMysiY: Integer = 0;
      MysJeStisknuta: Boolean = False;

PROCEDURE UkazMys;
VAR Reg: Registers;
BEGIN
  Reg.AX:=$01;
  Intr($33, Reg);
END;

PROCEDURE SkryjMys;
VAR Reg: Registers;
BEGIN
  Reg.AX:=$02;
  Intr($33, Reg);
END;

PROCEDURE PolohaMysi(VAR X, Y: Integer);
VAR Reg: Registers;
BEGIN
  Reg.AX:=$03;
  Intr($33, Reg);
  X:=Reg.CX;
  Y:=Reg.DX;
END;

PROCEDURE TlustaCara;
BEGIN
  SetLineStyle(SolidLn, 0, ThickWidth);
END;

PROCEDURE NormalniCara;
BEGIN
  SetLineStyle(SolidLn, 0, NormWidth);
END;

PROCEDURE InverzniBod(X, Y: Integer);
BEGIN
  PutPixel(X, Y, NOT GetPixel(X, Y));
END;


  { TPredmet }

CONSTRUCTOR TPredmet.Vytvor(X, Y, ASirka, AVyska: Integer);
BEGIN
  X1:=X;
  Y1:=Y;
  X2:=X1+ASirka-1;
  Y2:=Y1+AVyska-1;
  NastavVlastnika(NIL);
  NastavDalsiho(NIL);
  KresleniDoVysece:=True;
END;

FUNCTION TPredmet.Vlastnik: PSkupina;
BEGIN
  Vlastnik:=VlastnikS;
END;

PROCEDURE TPredmet.NastavDalsiho(ADalsi: PPredmet);
BEGIN
  DalsiP:=ADalsi;
END;

PROCEDURE TPredmet.NastavVlastnika(AVlastnik: PSkupina);
BEGIN
  VlastnikS:=AVlastnik;
END;

PROCEDURE TPredmet.PosliZpravu(Cislo: Word; Udaje: Pointer);
VAR Komu: PPredmet;
BEGIN
  IF Vlastnik=NIL THEN Komu:=@Self
     ELSE Komu:=Nejvyssi;
  IF Komu<>NIL THEN Komu^.Zprava(@Self, Cislo, Udaje);
END;

PROCEDURE TPredmet.Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer);
BEGIN
END;

FUNCTION TPredmet.Kliknuto(X, Y: Integer): Boolean;
BEGIN
  Kliknuto:=False;
END;

FUNCTION TPredmet.JeToVevnitr(X, Y: Integer): Boolean;
  { Souradnice na urovni obrazovky }
VAR AnoJe: Boolean;
    gX1, gX2, gY1, gY2: Integer;
BEGIN
  NaObrazovku(0, 0, gX1, gY1);
  NaObrazovku(Sirka-1, Vyska-1, gX2, gY2);
  AnoJe:=(X>=gX1) AND (X<=gX2) AND (Y>=gY1) AND (Y<=gY2);
  JeToVevnitr:=AnoJe;
END;

PROCEDURE TPredmet.Nakresli;
  { Vyhodnoti zda ma smysl prekreslovat objekt }
  { pokud ano pripravy vse pro jeho prekresleni }
  { a spusti metodu Kresli po te vse navrati do puvodniho stavu }
VAR VP: ViewPortType;
    gX1, gY1, gX2, gY2: Integer;
BEGIN
  GetViewSettings(VP);
  NaObrazovku(0, 0, gX1, gY1);
  NaObrazovku(Sirka-1, Vyska-1, gX2, gY2);

     { Ma smysl prekreslovat objekt }
     { tj. je alespon cast objektu v aktualni kreslici oblasti ? }
  IF (VP.X2>=gX1) AND (VP.Y2>=gY1) AND
     (VP.X1<=gX2) AND (VP.Y1<=gY2) THEN
  BEGIN
      { Skryje mys a nastavi normalni caru }
    SkryjMys;
    NormalniCara;
      { Pokud objekt vyzaduja nastaveni kreslici oblasti provede to }
    IF KresleniDoVysece THEN NastavKresliciOkno;
      { Vykresli objekt }
    Kresli;
      { Opet ukaze mys }
    UkazMys;
      { Obnovi puvodni kreslici oblast, pro pripad, ze byla zmenena }
    SetViewPort(VP.X1, VP.Y1, VP.X2, VP.Y2, VP.Clip);
  END;
END;

PROCEDURE TPredmet.Kresli;
BEGIN
END;

PROCEDURE TPredmet.NaPredmet(AX, AY: Integer; VAR X, Y: Integer);
BEGIN
  X:=AX-X1;
  Y:=AY-Y1;
  IF Vlastnik<>NIL THEN Vlastnik^.NaPredmet(X, Y, X, Y);
END;

PROCEDURE TPredmet.NaObrazovku(AX, AY: Integer; VAR X, Y: Integer);
BEGIN
  X:=AX+X1;
  Y:=AY+Y1;
  IF Vlastnik<>NIL THEN Vlastnik^.NaObrazovku(X, Y, X, Y);
END;

PROCEDURE TPredmet.CekejNaMys(VAR Co, X, Y: Integer);
VAR P: PPredmet;
BEGIN
  P:=Nejvyssi;
  IF P<>NIL THEN P^.CekejNaMys(Co, X, Y);
END;

FUNCTION TPredmet.Sirka: Integer;
BEGIN
  Sirka:=X2-X1+1;
END;

FUNCTION TPredmet.Vyska: Integer;
BEGIN
  Vyska:=Y2-Y1+1;
END;

FUNCTION TPredmet.NaObrazovceX: Integer;
VAR X, Y: Integer;
BEGIN
  NaObrazovku(0, 0, X, Y);
  NaObrazovceX:=X;
END;

PROCEDURE TPredmet.NastavKresliciOkno;
VAR aX1, aY1, aX2, aY2: Integer;
BEGIN
  NaObrazovku(0, 0, aX1, aY1);
  NaObrazovku(Sirka-1, Vyska-1, aX2, aY2);
  SetViewPort(aX1, aY1, aX2, aY2, False);
END;

PROCEDURE TPredmet.NastavKresliciVysec(LX, HY, PX, DY: Integer);
VAR aX1, aY1, aX2, aY2: Integer;
BEGIN
  NaObrazovku(0+LX, 0+HY, aX1, aY1);
  NaObrazovku(Sirka-1-PX, Vyska-1-DY, aX2, aY2);
  SetViewPort(aX1, aY1, aX2, aY2, False);
END;

PROCEDURE TPredmet.ZrusKresliciOkno;
BEGIN
  SetViewPort(0, 0, GetMaxX, GetMaxY, True);
END;

FUNCTION TPredmet.NaObrazovceY: Integer;
VAR X, Y: Integer;
BEGIN
  NaObrazovku(0, 0, X, Y);
  NaObrazovceY:=Y;
END;

DESTRUCTOR TPredmet.Zrus;
BEGIN
END;

FUNCTION TPredmet.Nejvyssi: PProgram;
BEGIN
  IF Vlastnik=NIL THEN Nejvyssi:=@Self
     ELSE Nejvyssi:=Vlastnik^.Nejvyssi;
END;

FUNCTION TPredmet.Predesli: PPredmet;
VAR P: PPredmet;
BEGIN
  IF Vlastnik=NIL THEN P:=NIL
     ELSE
  BEGIN
    P:=Vlastnik^.Prvni;
    WHILE P^.Dalsi<>@Self DO P:=P^.Dalsi;
  END;
  Predesli:=P;
END;

FUNCTION TPredmet.Dalsi: PPredmet;
BEGIN
  Dalsi:=DalsiP;
END;

FUNCTION TPredmet.DalsiPredmet: PPredmet;
VAR P: PPredmet;
BEGIN
  IF Vlastnik=NIL THEN P:=NIL
     ELSE
  BEGIN
    IF @Self=Vlastnik^.Posledni THEN P:=NIL
       ELSE P:=Dalsi;
  END;
  DalsiPredmet:=P;
END;

FUNCTION TPredmet.PredesliPredmet: PPredmet;
VAR P: PPredmet;
BEGIN
  IF Vlastnik=NIL THEN P:=NIL
     ELSE
  BEGIN
    IF @Self=Vlastnik^.Prvni THEN P:=NIL
       ELSE P:=Predesli;
  END;
  PredesliPredmet:=P;
END;

PROCEDURE TPredmet.VratRozsah(VAR aX1, aY1, aX2, aY2: Integer);
BEGIN
  aX1:=X1;
  aY1:=Y1;
  aX2:=X2;
  aY2:=Y2;
END;

PROCEDURE TPredmet.NastavRozsah(aX1, aY1, aX2, aY2: Integer);
BEGIN
  X1:=aX1;
  Y1:=aY1;
  X2:=aX2;
  Y2:=aY2;
END;


  { TTlacitko }

CONSTRUCTOR TTlacitko.Vytvor(X, Y, ASirka, AVyska, AIkonka, APrikaz: Integer);
BEGIN
  INHERITED Vytvor(X, Y, ASirka, AVyska);

  Ikonka:=AIkonka;
  Prikaz:=APrikaz;
  JenomOkraj:=False;
  Stiskle:=False;
END;

PROCEDURE TTlacitko.Kresli;
VAR bH, bD, i: Integer;
BEGIN
  IF NOT Stiskle THEN
  BEGIN
    bH:=BarvaTlacitkaS;
    bD:=BarvaTlacitkaT;
  END
     ELSE
  BEGIN
    bH:=BarvaTlacitkaT;
    bD:=BarvaTlacitkaS;
  END;

  FOR i:=0 TO OkrajTlacitka-1 DO
  BEGIN
    SetColor(bH);
    MoveTo(0+i, Vyska-1-i);
    LineTo(0+i, 0+i);
    LineTo(Sirka-1-i, 0+i);
    SetColor(bD);
    LineTo(Sirka-1-i, Vyska-1-i);
    LineTo(0+i, Vyska-1-i);
  END;

  IF NOT JenomOkraj THEN
  BEGIN
    SetFillStyle(SolidFill, BarvaTlacitkaP);
    Bar(OkrajTlacitka, OkrajTlacitka,
        Sirka-OkrajTlacitka-1, Vyska-OkrajTlacitka-1);
    IF (Nejvyssi<>NIL) AND (Ikonka<>0) THEN
    BEGIN
      NastavKresliciVysec(OkrajTlacitka, OkrajTlacitka,
          OkrajTlacitka, OkrajTlacitka);
      Nejvyssi^.IkonkyTlacitek(Ikonka);
    END;
  END;
END;

FUNCTION TTlacitko.Kliknuto(X, Y: Integer): Boolean;
VAR Co: Integer;
    S: Boolean;
BEGIN
  JenomOkraj:=True;
  Stiskle:=True;
  Nakresli;
  REPEAT
    CekejNaMys(Co, X, Y);
    IF Stiskle<>JeToVevnitr(X, Y) THEN
    BEGIN
      Stiskle:=NOT Stiskle;
      Nakresli;
    END;
  UNTIL Co=msPusteno;
  S:=Stiskle;
  Stiskle:=False;
  Nakresli;
  JenomOkraj:=False;
  IF S THEN PosliZpravu(Prikaz, NIL);

  Kliknuto:=True;
END;


  { TSkupina }

CONSTRUCTOR TSkupina.Vytvor(X, Y, ASirka, AVyska: Integer);
BEGIN
  INHERITED Vytvor(X, Y, ASirka, AVyska);

  NastavPrvniho(NIL);
END;

DESTRUCTOR TSkupina.Zrus;
BEGIN
  VymazVsechny;

  INHERITED Zrus;
END;

PROCEDURE TSkupina.VymazVsechny;
VAR P: PPredmet;
BEGIN
  WHILE Prvni<>NIL DO
  BEGIN
    P:=Prvni;
    Vymaz(P);
    Dispose(P, Zrus);
  END;
END;

FUNCTION TSkupina.Prvni: PPredmet;
BEGIN
  Prvni:=PrvniP;
END;

PROCEDURE TSkupina.NastavPrvniho(APrvni: PPredmet);
BEGIN
  PrvniP:=APrvni;
END;

FUNCTION TSkupina.Posledni: PPredmet;
VAR P: PPredmet;
BEGIN
  IF Prvni=NIL THEN P:=NIL
     ELSE P:=Prvni^.Predesli;
  Posledni:=P;
END;

FUNCTION TSkupina.PodMysi(X, Y: Integer): PPredmet;
VAR P: PPredmet;
BEGIN
  P:=Prvni;
  WHILE (P<>NIL) AND (NOT P^.JeToVevnitr(X, Y)) DO P:=P^.DalsiPredmet;
  PodMysi:=P;
END;

PROCEDURE TSkupina.Vloz(P: PPredmet);
VAR L: PPredmet;
BEGIN
  IF P<>NIL THEN
  BEGIN
    L:=Posledni;
    IF Prvni<>NIL THEN P^.NastavDalsiho(Prvni)
       ELSE P^.NastavDalsiho(P);
    P^.NastavVlastnika(@Self);
    NastavPrvniho(P);
    IF L<>NIL THEN L^.NastavDalsiho(P);
    P^.NaKresli;
  END;
END;

PROCEDURE TSkupina.Vymaz(P: PPredmet);
VAR L: PPredmet;
BEGIN
  IF (P<>NIL) AND (P^.Vlastnik=@Self) THEN
  BEGIN
    L:=P^.Predesli;
    L^.NastavDalsiho(P^.Dalsi);
    IF P=Prvni THEN
    BEGIN
      IF P^.Dalsi=P THEN NastavPrvniho(NIL)
         ELSE NastavPrvniho(P^.Dalsi);
    END;

    P^.NastavVlastnika(NIL);
    P^.NastavDalsiho(NIL);
  END;
END;

FUNCTION TSkupina.Kliknuto(X, Y: Integer): Boolean;
VAR P: PPredmet;
    K: Boolean;
BEGIN
  P:=Prvni;
  K:=False;
  WHILE (P<>NIL) AND (NOT K) DO
  BEGIN
    IF P^.JeToVevnitr(X, Y) THEN K:=P^.Kliknuto(X, Y);
    P:=P^.DalsiPredmet;
  END;
  Kliknuto:=K;
END;

PROCEDURE TSkupina.Kresli;
VAR P: PPredmet;
BEGIN
  P:=Posledni;
  WHILE P<>NIL DO
  BEGIN
    P^.NaKresli;
    P:=P^.PredesliPredmet;
  END;
END;

PROCEDURE TSkupina.Zprava(OdKoho: PPredmet; Cislo: Word; Udaje: Pointer);
VAR P: PPredmet;
BEGIN
  P:=Prvni;
  WHILE P<>NIL DO
  BEGIN
    P^.Zprava(OdKoho, Cislo, Udaje);
    P:=P^.DalsiPredmet;
  END;
END;

PROCEDURE TSkupina.NaVrch(APrvni: PPredmet);
BEGIN
  Vymaz(APrvni);
  Vloz(APrvni);
END;

PROCEDURE TSkupina.NaSpod(APosledni: PPredmet);
VAR P: PPredmet;
BEGIN
  IF APosledni<>Posledni THEN
  BEGIN
    Vymaz(APosledni);
    Posledni^.NastavDalsiho(APosledni);
    APosledni^.NastavDalsiho(Prvni);
    APosledni^.NastavVlastnika(@Self);
  END;
END;


  { TProgram }

CONSTRUCTOR TProgram.Vytvor;
VAR Driver, Mode: Integer;
    Reg: Registers;
BEGIN
     { Zapneme grafiku }
  Driver:=Detect;
  InitGraph(Driver, Mode, '');
     { Inicializace misy }
  Reg.AX:=$00;
  Intr($33, Reg);
  UkazMys;

  INHERITED Vytvor(0, 0, GetMaxX, GetMaxY);

  Ukonceno:=False;
END;

DESTRUCTOR TProgram.Zrus;
BEGIN
  INHERITED Zrus;

  SkryjMys;
  CloseGraph;
END;

PROCEDURE TProgram.IkonkyTlacitek(Ikonka: Integer);
BEGIN
  Abstract;
END;

PROCEDURE TProgram.Konec;
BEGIN
  Ukonceno:=True;
END;

PROCEDURE TProgram.Spust;
VAR Co, X, Y: Integer;
BEGIN
  REPEAT
    CekejNaMys(Co, X, Y);
    IF Co=msStisknuto THEN Kliknuto(X, Y);
  UNTIL Ukonceno;
END;

PROCEDURE TProgram.CekejNaMys(VAR Co, X, Y: Integer);
VAR Reg: Registers;
    BylaStisknuta: Boolean;
BEGIN
  Co:=msNic;

  REPEAT
    Reg.AX:=$03;
    Intr($33, Reg);

    BylaStisknuta:=MysJeStisknuta;
    MysJeStisknuta:=((Reg.BX AND 1)=1);

    IF (NOT BylaStisknuta) AND MysJeStisknuta THEN Co:=msStisknuto
       ELSE
    IF BylaStisknuta AND (NOT MysJeStisknuta) THEN Co:=msPusteno
       ELSE
    IF (PolohaMysiX<>Reg.CX) OR (PolohaMysiY<>Reg.DX) THEN Co:=msPohyb
       ELSE Co:=msNic;
    PolohaMysiX:=Reg.CX;
    PolohaMysiY:=Reg.DX;
  UNTIL (Co<>msNic);
  X:=PolohaMysiX;
  Y:=PolohaMysiY;
END;

END.