PROGRAM Zivot_Ci_Smrt;
USES Crt, Graph;
CONST VelikostX = 11;
      VelikostY = 11;
TYPE TPlaneta = ARRAY[1..VelikostX, 1..VelikostY] OF Integer;
CONST Nic = 0;
      Smrt = -1;
      Zivot = 1;

  PROCEDURE ZapniGrafiku;
  VAR GraphDriver, GraphMode: Integer;
  BEGIN
    GraphDriver:=Detect;
    InitGraph(GraphDriver, GraphMode, 'v:\bp\bgi');
  END;

  PROCEDURE NovaPlaneta(VAR Planeta: TPlaneta);
  VAR iy, ix: Integer;
  BEGIN
    FOR iy:=1 TO 11 DO FOR ix:=1 TO 11 DO Planeta[ix, iy]:=Nic;
    Planeta[6, 6]:=Zivot;
    Planeta[5, 6]:=Zivot;
    Planeta[7, 6]:=Zivot;
    Planeta[6, 5]:=Zivot;
    Planeta[6, 7]:=Zivot;
  END;

  PROCEDURE KresliPlanetu(Jmeno: String; VAR Planeta: TPlaneta);
  CONST PindulikX = 60;
        PindulikY = 40;

    PROCEDURE ZivyPindulik(X, Y: Integer);
    BEGIN
      SetLineStyle(SolidLn, 0, 1);
      SetColor(Green);
      SetFillStyle(SolidFill, Green);
      FillEllipse(X, Y, 20, 10);
      SetLineStyle(SolidLn, 0, 3);
      Line(X, Y, X-20, Y-20);
      Line(X, Y, X+20, Y-20);
      SetColor(LightGreen);
      SetFillStyle(SolidFill, LightGreen);
      PieSlice(X-20, Y-20, 0, 360, 2);
      PieSlice(X+20, Y-20, 0, 360, 2);
      SetColor(Red);
      SetFillStyle(SolidFill, Red);
      PieSlice(X-10, Y-3, 0, 360, 1);
      PieSlice(X+10, Y-3, 0, 360, 1);
    END;

    PROCEDURE MrtvyPindulik(X, Y: Integer);
    BEGIN
      SetLineStyle(SolidLn, 0, 1);
      SetColor(DarkGray);
      SetFillStyle(SolidFill, LightGray);
      FillEllipse(X, Y, 20, 10);
      Bar(X-7, Y, X+7, Y+14);
      Line(X-3, Y+10, X-3, Y+14);
      Line(X+3, Y+10, X+3, Y+14);
      SetFillStyle(SolidFill, DarkGray);
      PieSlice(X-10, Y-2, 0, 360, 2);
      PieSlice(X+10, Y-2, 0, 360, 2);
    END;

  VAR ix, iy: Integer;
      x, y: Integer;
  BEGIN
    SetTextStyle(GothicFont, HorizDir, 20);
    SetColor(LightMagenta);
    SetTextJustify(CenterText, CenterText);
    OutTextXY(320, 30, Jmeno);

    FOR iy:=1 TO VelikostY DO FOR ix:=1 TO VelikostX DO
    BEGIN
      x:=30+(ix-1)*PindulikX;
      y:=50+(iy-1)*PindulikY;
      CASE Planeta[ix, iy] OF
        Zivot: ZivyPindulik(x, y);
        Smrt: MrtvyPindulik(x, y);
      END;
    END;
  END;

  FUNCTION KdoJeTam(VAR Planeta: TPlaneta; X, Y: Integer): Integer;
  BEGIN
    IF (X>=1) AND (X<=VelikostX) AND
       (Y>=1) AND (Y<=VelikostY) THEN KdoJeTam:=Planeta[X, Y]
          ELSE KdoJeTam:=Nic;
  END;

  PROCEDURE DalsiGenerace(VAR Planeta: TPlaneta);
  VAR Sousedi: Integer;
      KdoTamBude: Integer;
      ix, iy: Integer;
      Stara: TPlaneta;
  BEGIN
    Stara:=Planeta;
    FOR iy:=1 TO VelikostY DO FOR ix:=1 TO VelikostX DO
    BEGIN
      Sousedi:=0;
      IF KdoJeTam(Stara, ix-1, iy-1)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix-1, iy)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix-1, iy+1)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix, iy-1)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix, iy+1)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix+1, iy-1)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix+1, iy)=Zivot THEN Inc(Sousedi);
      IF KdoJeTam(Stara, ix+1, iy+1)=Zivot THEN Inc(Sousedi);
      KdoTamBude:=Nic;
      CASE Stara[ix, iy] OF
        Nic: IF Sousedi=3 THEN KdoTamBude:=Zivot
                ELSE KdoTamBude:=Nic;
        Zivot: IF Sousedi IN [2, 3] THEN KdoTamBude:=Zivot
                ELSE KdoTamBude:=Smrt;
        Smrt: IF Sousedi=3 THEN KdoTamBude:=Zivot
                  ELSE KdoTamBude:=Nic;
      END;
      Planeta[ix, iy]:=KdoTamBude;
    END;
  END;

VAR Mars: TPlaneta;
    C: Char;
BEGIN
  ZapniGrafiku;
  NovaPlaneta(Mars);
  REPEAT
    ClearDevice;
    KresliPlanetu('Mars', Mars);
    DalsiGenerace(Mars);
    C:=ReadKey;
  UNTIL C=#27;
  CloseGraph;
END.