unit fMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, ExtCtrls, StdCtrls, Mask, DBCtrls, Grids, DBGrids;

const
  niNic = 0;
  niOddeleni = 1;
  niZamestnanec = 2;
  niFunkce = 3;
  niTrida = 4;
  niStruktura = 5;
  niFunkceVse = 6;
  niTridy = 7;

type
  THlavniOkno = class(TForm)
    TreeView: TTreeView;
    HSplitter: TSplitter;
    OddeleniPanel: TPanel;
    OddeleniNav: TDBNavigator;
    OddeleniNazevEdit: TDBEdit;
    Label1: TLabel;
    Label2: TLabel;
    OddeleniPopisEdit: TDBEdit;
    Label3: TLabel;
    OddeleniNadrizeneEdit: TDBEdit;
    OddeleniPages: TPageControl;
    OddeleniZamestnanci: TTabSheet;
    OddeleniVsichniZamestnanci: TTabSheet;
    OddeleniEditNav: TDBNavigator;
    ZamestnanecPanel: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    ZamestnanecBrowseNav: TDBNavigator;
    ZamestnanecPrijmeniEdit: TDBEdit;
    ZamestnanecJmenoEdit: TDBEdit;
    ZamestnanecOddeleniEdit: TDBEdit;
    ZamestnanecEditNav: TDBNavigator;
    Label7: TLabel;
    ZamestnanecFunkceCombo: TDBLookupComboBox;
    Label8: TLabel;
    ZamestnanecTridaCombo: TDBLookupComboBox;
    Label9: TLabel;
    ZamestnanecRCEdit: TDBEdit;
    StrukturaPanel: TPanel;
    TridaPanel: TPanel;
    Label10: TLabel;
    TridaBrowseNav: TDBNavigator;
    TridaEditNav: TDBNavigator;
    TridaNazevEdit: TDBEdit;
    ZamestnanecPages: TPageControl;
    ZamestnanecPodrobnostiPage: TTabSheet;
    Label11: TLabel;
    ZamestnanecPrijetiEdit: TDBEdit;
    GroupBox1: TGroupBox;
    ZamestnanecUliceEdit: TDBEdit;
    Label12: TLabel;
    Label13: TLabel;
    ZamestnanecMestoEdit: TDBEdit;
    Label14: TLabel;
    ZamestnanecPSCEdit: TDBEdit;
    Label16: TLabel;
    ZamestnanecTelefonEdit: TDBEdit;
    Label17: TLabel;
    ZamestnanecPlatEdit: TDBEdit;
    ZamestnanecDovolenePage: TTabSheet;
    ZamestnanecNemocenskePage: TTabSheet;
    Bevel1: TBevel;
    Bevel3: TBevel;
    DovoleneBrowseNav: TDBNavigator;
    DovoleneEditNav: TDBNavigator;
    Bevel2: TBevel;
    DBNavigator2: TDBNavigator;
    Bevel4: TBevel;
    DBNavigator3: TDBNavigator;
    DovoleneGrid: TDBGrid;
    NemocenskeGrid: TDBGrid;
    DBNavigator1: TDBNavigator;
    Bevel5: TBevel;
    DBGrid1: TDBGrid;
    DBNavigator4: TDBNavigator;
    Bevel6: TBevel;
    DBGrid2: TDBGrid;
    Bevel7: TBevel;
    Bevel8: TBevel;
    Bevel9: TBevel;
    Bevel10: TBevel;
    FunkcePanel: TPanel;
    Label18: TLabel;
    FunkceNazevEdit: TDBEdit;
    FunkceBrowseNav: TDBNavigator;
    DBNavigator6: TDBNavigator;
    PageControl1: TPageControl;
    StrukturaOddeleniPage: TTabSheet;
    StrukturaOddeleniBrowseNav: TDBNavigator;
    Bevel11: TBevel;
    OddeleniVseGrid: TDBGrid;
    Bevel12: TBevel;
    StrukturaZamestnanciPage: TTabSheet;
    Bevel15: TBevel;
    DBNavigator5: TDBNavigator;
    DBGrid3: TDBGrid;
    FunkceVsePanel: TPanel;
    Bevel16: TBevel;
    Bevel17: TBevel;
    FunkceVseGrid: TDBGrid;
    FunkceVseNav: TDBNavigator;
    Bevel18: TBevel;
    PlatyPanel: TPanel;
    PlatyBrowseNav: TDBNavigator;
    Bevel19: TBevel;
    PlatyEditNav: TDBNavigator;
    PlatyGrid: TDBGrid;
    Bevel14: TBevel;
    Bevel13: TBevel;
    FunkceDetailPanel: TPanel;
    Bevel20: TBevel;
    DBNavigator7: TDBNavigator;
    DBGrid4: TDBGrid;
    Bevel21: TBevel;
    TridyPanel: TPanel;
    Bevel22: TBevel;
    Bevel23: TBevel;
    TridyGrid: TDBGrid;
    TridyBrowseNav: TDBNavigator;
    procedure FormCreate(Sender: TObject);
    procedure TreeViewExpanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
    procedure TreeViewMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TreeViewStartDrag(Sender: TObject;
      var DragObject: TDragObject);
    procedure TreeViewDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TreeViewDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure TreeViewEnter(Sender: TObject);
    procedure OddeleniVseGridDblClick(Sender: TObject);
    procedure ZamestnanecDblClick(Sender: TObject);
    procedure FunkceVseGridDblClick(Sender: TObject);
    procedure OddeleniNadrizeneEditClick(Sender: TObject);
    procedure ZamestnanecOddeleniEditClick(Sender: TObject);
    procedure TridyGridDblClick(Sender: TObject);
  private
    { Private declarations }
    DragNode: TTreeNode;
    function NodePopupMenu(Node: TTreeNode): TPopupMenu;
    procedure OtevriOddeleniCislo(Oddeleni: Integer);
    procedure OtevriZamestnanceCislo(RC: string);
    procedure CancelEdits;
  public
    { Public declarations }
    StrukturaNode: TTreeNode;
    FunkceNode: TTreeNode;
    PlatyNode: TTreeNode;

    procedure VyberNode(TopNode: TTreeNode;
      ImageIndex: Integer; Data: Pointer);
    procedure OtevriOddeleni(Oddeleni: Integer);
    procedure ZobrazPanel(Panel: Byte; ID: Variant);
    procedure ZobrazPanelNode(Node: TTreeNode);
    procedure NahrajNode(Node: TTreeNode);
    procedure NovyZamestnanec(Oddeleni: Integer);
    procedure NoveOddeleni(Nadrazene: Integer);
    procedure NovaFunkce;
    procedure NovaTrida;
    procedure ZamestnanciVseUpdate;
  end;

var
  HlavniOkno: THlavniOkno;

implementation

uses
  DBTables, DB,
  fOddeleni, uObecne, mDatabaze, mMenus;

{$R *.DFM}

// ------------- metody (public) ----------------

procedure THlavniOkno.ZamestnanciVseUpdate;
// Upravi podminku v SQL dotazu na tabulku zamestnancu ve vztahu master-detail k
// tabulce oddeleni resp. tabulce funkci
begin
  with Databaze.ZamestnanciVseDetailQ do
  begin
    if Active then Close;
    if Databaze.OddeleniTbl.Active then
      // vytvori podminku obsahujici cisla vsech oddeleni
      // podrizenych vybranemu oddeleni
      SQL[3] := Databaze.OddeleniSQL(
        Databaze.OddeleniTbl.FieldByName('id').AsInteger, 'oddeleni')
      else
    if Databaze.FunkceTbl.Active then
      // vytvori podminku na zobrazeni vsech zamestnancu zastavajich
      // vybranou funkci
      SQL[3] := Format('funkce = %d',
        [Databaze.FunkceTbl.FieldByName('id').AsInteger]);
    Open;
  end;
end;

procedure THlavniOkno.NahrajNode(Node: TTreeNode);

  procedure PridejPrvky(DataSet: TDataSet;
    Zamestnanci: Boolean; ImageIndex: Integer);
  // projede predanou tabulku/dotaz a pro kazdy radek prida jeden
  // prvek do slozky Node v zavislosti na parametru Zamestnanci
  var
    NNode: TTreeNode;
  begin
    with DataSet do
    try
      Open;
      First;
      // Provedeme pro kazdy radek tabulky/dotazu
      while not EOF do
      begin
        if Zamestnanci then
          // pokud je to zamestnanec pridame jmeno a prijmeni a
          // ulozime rodne cislo
          NNode := TreeView.Items.AddChildObject(Node,
            FormatujJmeno(
              FieldByName('prijmeni').AsString,
              FieldByName('jmeno').AsString),
            RCToPointer(FieldByName('rc').AsString))
        else
          // v ostatnich pripadech pridame jmeno a ulozime identifikacni cislo
          NNode := TreeView.Items.AddChildObject(Node,
            FieldByName('nazev').AsString,
            Pointer(FieldByName('id').AsInteger));
        // zamestnanci nemuzou mit podrizene prvky, v ostatnich
        // pripadech jeste nevim, ale muze byt
        NNode.HasChildren := not Zamestnanci;
        // podle vlastnosti ImageIndex rozeznavam druhy prvku ve stormu
        NNode.ImageIndex := ImageIndex;
        NNode.SelectedIndex := ImageIndex;
        Next;
      end;
      Close;
    except
      if Active then Close;
    end;
  end;

var
  Query: TQuery;
  Expanded: Boolean;
begin
  if Node = nil then Exit;
  Expanded := Node.Expanded; // ulozime stav
  Node.DeleteChildren; // smazeme vsechny podrizene prvky

  if (Node.ImageIndex in [niOddeleni]) or
     (Node = StrukturaNode) then
  // Seznam oddeleni/zamestnancu
  begin
    // Pridame pracovniky v oddeleni
    if Node = StrukturaNode then Query := Databaze.ZamestnanecTopNodeQ
      else
    begin
      Query := Databaze.ZamestnanecNodeQ;
      Query.Params[0].AsInteger := Integer(Node.Data);
    end;
    PridejPrvky(Query, True, niZamestnanec);

    // pridame pododdeleni
    if Node = StrukturaNode then Query := Databaze.OddeleniTopNodeQ
      else
    begin
      Query := Databaze.OddeleniNodeQ;
      Query.Params[0].AsInteger := Integer(Node.Data);
    end;
    PridejPrvky(Query, False, niOddeleni);
  end
    else
  if Node = FunkceNode then
  // Seznam funkci
      PridejPrvky(Databaze.FunkceNodeQ, False, niFunkce)
    else
  if Node = PlatyNode then
  // Seznam platovych trid
      PridejPrvky(Databaze.TridyNodeQ, False, niTrida)
    else
  if (Node.ImageIndex = niFunkce) or
     (Node.ImageIndex = niTrida) then
  // Zamestnanci v platovove tride/funkci
  begin
    if Node.ImageIndex = niFunkce then
         Query := Databaze.ZamestnanciFunkceNodeQ
      else Query := Databaze.ZamestnanciTridaNodeQ;
    with Query do
    begin
      if Active then Close;
      ParamByName('id').AsInteger := Integer(Node.Data);
    end;
    PridejPrvky(Query, True, niZamestnanec);
  end;

  // Pokud jsme nenasli zadne deti zakazeme otevreni
  Node.HasChildren := (Node.Count > 0);
  Node.Expanded := Expanded;
end;

procedure THlavniOkno.ZobrazPanel(Panel: Byte; ID: Variant);
// zobrazi panel urceny parametrem Panel a v prirazene tabulce
// vyhleda radek identifikovany parametrem ID (pokud ma smysl)
var
  B: Boolean;
begin
  Databaze.Upozornovat := False;
  with Databaze do
  try
    OddeleniDetailTbl.Close;
    ZamestnanciVseDetailQ.Close;

    // Zobrazujeme panel organizacni struktury
    B := (Panel = niStruktura);
    OddeleniVseQ.Active := B;
    StrukturaPanel.Visible := B;
    if B then
    with ZamestnanciVseDetailQ do
    begin
      // vyuzijeme nadefinovany dotaz na zamestnance
      // potrebujeme zobrazit vsechny, proto ta nesmyslna podminka
      SQL[3] := 'oddeleni = oddeleni';
      Open;
    end;

    // Zobrazujeme panel funkce
    B := (Panel = niFunkceVse);
    FunkceVseQ.Active := B;
    FunkceVsePanel.Visible := B;

    // Zobrazujeme panel funkce
    B := (Panel = niTridy);
    TridyVseQ.Active := B;
    TridyPanel.Visible := B;

    // Zobrazujeme panel oddeleni
    B := (Panel = niOddeleni);
    OddeleniTbl.Active := B;
    ZamestnanciDetailQ.Active := B;
    if B then
    begin
      // pripoutame tabulku Oddeleni, kvuli zobrazeni nadrizeneho oddeleni
      // sdili se s panelem Zamestnanci, proto nemuze byt nastaveno design-time
      with OddeleniDetailTbl do
      begin
        MasterFields := '';
        MasterSource := OddeleniSrc;
        MasterFields := 'nadrazene';
        Open;
      end;
      if ID <> Null then
        // zkusime najit oddeleni
        if not OddeleniTbl.Locate('ID', ID, []) then
        begin
          Chyba('Oddlen nenalezeno!');
          B := False;
        end;
      OddeleniTbl.Refresh;
      // obnovime podminku na zobrazeni zamestnancu (vcetne podrizenych oddeleni)
      // sdili se s panelem funkce
      ZamestnanciVseUpdate;
    end;
    OddeleniPanel.Visible := B;

    // Zobrazujeme panel zamestnance
    B := (Panel = niZamestnanec);
    ZamestnanecTbl.Active := B;
    FunkceLookupTbl.Active := B;
    TridaLookupTbl.Active := B;
    DovoleneQ.Active := B;
    NemocenskeQ.Active := B;
    if B then
    begin
      // pripoutame tabulku Oddeleni, kvuli zobrazeni oddeleni
      // sdili se s panelem Oddeleni, proto nemuze byt nastaveno design-time
      with OddeleniDetailTbl do
      begin
        MasterFields := '';
        MasterSource := ZamestnanecSrc;
        MasterFields := 'oddeleni';
        Open;
      end;
      if ID <> Null then
        // zkusime najit zamestnance
        if not ZamestnanecTbl.Locate('rc', ID, []) then
        begin
          Chyba('Zamstnanec nenalezen');
          B := False;
        end;
      ZamestnanecTbl.Refresh;
    end;
    ZamestnanecPanel.Visible := B;

    // Zobrazujeme panel funkce
    B := (Panel = niFunkce);
    FunkceTbl.Active := B;
    if B then
    begin
      if ID <> Null then
        // zkusime najit funkci
        if not FunkceTbl.Locate('ID', ID, []) then
        begin
          Chyba('Funkce nenalezena!');
          B := False;
        end;
      FunkceTbl.Refresh;
      // obnovime podminku na zobrazeni zamestnancu
      // sdili se s panelem Oddeleni
      ZamestnanciVseUpdate;
    end;
    FunkcePanel.Visible := B;

    // Zobrazujeme panel tridy
    B := (Panel = niTrida);
    TridaTbl.Active := B;
    PlatTbl.Active := B;
    if B then
    begin
      if ID <> Null then
        // zkusime najit platovou tridu
        if not TridaTbl.Locate('ID', ID, []) then
        begin
          Chyba('Platov tda nenalezena!');
          B := False;
        end;
      TridaTbl.Refresh;
    end;
    TridaPanel.Visible := B;
  finally
    Upozornovat := True;
  end;
end;

procedure THlavniOkno.ZobrazPanelNode(Node: TTreeNode);
// podle prvku stromu otevre prislusny panel
var
  ID: Variant;
begin
  if Node <> nil then
  begin
    // pokud je to zamestnanec je klicem rodne cislo
    // jinak je to identifikacni cislo
    if Node.ImageIndex = niZamestnanec then
        ID := PointerToRC(Node.Data)
      else ID := Integer(Node.Data);
    ZobrazPanel(Node.ImageIndex, ID);
  end
    else ZobrazPanel(niNic, Null);
end;

procedure THlavniOkno.OtevriOddeleni(Oddeleni: Integer);
// rekurzivne otevre a z databaze nahraje vsechna jeste neotevrena a nenahrana
// nadrizena oddeleni daneho oddeleni (vcetne)
var
  Node: TTreeNode;
begin
  // pokud je to 0 otevreme root stromu (tedy seznam oddeleni, ktera
  // jiz nemaji nadrizene
  if Oddeleni = 0 then StrukturaNode.Expand(False)
    else
  begin
    // zkusime zjistit jestli je jiz nadrizene oddeleni nahrano
    Node := NajdiNode(StrukturaNode, niOddeleni, Pointer(Oddeleni));
    // pokud je tak ho jenom otevreme a tim nahrajeme jeho podrizene
    if Node <> nil then Node.Expand(False)
      else
    begin
      // pokud neni tak otevreme rekurzivne jeho nadrizeneho
      OtevriOddeleni(Databaze.NadrazeneOddeleni(Oddeleni));
      // a opet se ho pokusime otevrit
      OtevriOddeleni(Oddeleni);
    end;
  end;
end;

procedure THlavniOkno.NoveOddeleni(Nadrazene: Integer);
// pripravi prostredi pro vkladani noveho oddeleni
begin
  // zobrazi panel
  ZobrazPanel(niOddeleni, Null);
  with Databaze, Databaze.OddeleniTbl do
  begin
    try
      Upozornovat := False;
      // vlozi novy prazdny zaznam
      Append;
    finally
      Upozornovat := True;
    end;
    FieldByName('nadrazene').AsInteger := Nadrazene;
  end;
  // vybere prvni komponentu formulare
  OddeleniNazevEdit.SetFocus;
end;

procedure THlavniOkno.NovyZamestnanec(Oddeleni: Integer);
// pripravy prostredi pro vkladani noveho zamestnance
begin
  // zobrazi panel
  ZobrazPanel(niZamestnanec, Null);
  with Databaze, Databaze.ZamestnanecTbl do
  begin
    try
      Upozornovat := False;
      // vlozi novy prazdny zaznam
      Append;
    finally
      Upozornovat := True;
    end;
    FieldByName('oddeleni').AsInteger := Oddeleni;
  end;
  // vybere prvni komponentu formulare
  ZamestnanecRCEdit.SetFocus;
end;

procedure THlavniOkno.NovaFunkce;
// pripravy prostredi pro vkladani nove funkce
begin
  // zobrazi panel
  ZobrazPanel(niFunkce, Null);
  with Databaze, Databaze.FunkceTbl do
  begin
    try
      Upozornovat := False;
      // vlozi novy prazdny zaznam
      Append;
    finally
      Upozornovat := True;
    end;
  end;
  // vybere prvni komponentu formulare
  FunkceNazevEdit.SetFocus;
end;

procedure THlavniOkno.NovaTrida;
// pripravy prostredi pro vkladani nove tridy
begin
  // zobrazi panel
  ZobrazPanel(niTrida, Null);
  with Databaze, Databaze.TridaTbl do
  begin
    try
      Upozornovat := False;
      // vlozi novy prazdny zaznam
      Append;
    finally
      Upozornovat := True;
    end;
  end;
  // vybere prvni komponentu formulare
  TridaNazevEdit.SetFocus;
end;

// ------------- metody (private) ----------------

procedure THlavniOkno.OtevriOddeleniCislo(Oddeleni: Integer);
// simuluje vyber oddeleni v tabulce
// zpusoby jeho vyber ve stromu i zobrazeni prislusneho panelu
begin
  if Oddeleni > 0 then
  with Databaze.OddeleniTbl do
  begin
    Databaze.Upozornovat := False;
    Open;
    Databaze.Upozornovat := True;
    Locate('id', Oddeleni, []);
  end;
end;

procedure THlavniOkno.OtevriZamestnanceCislo(RC: string);
// simuluje vyber zamestnance v tabulce
// zpusoby jeho vyber ve stromu i zobrazeni prislusneho panelu
begin
  with Databaze.ZamestnanecTbl do
  begin
    Databaze.Upozornovat := False;
    Open;
    Databaze.Upozornovat := True;
    Locate('rc', RC, []);
  end;
end;

procedure THlavniOkno.CancelEdits;
// zrusi zmeny ve vsechn editovatelnych tabulkach
// pouziva tehdy kdyz je treba aby neprobihala zadna editace

  procedure Zavri(DataSet: TDataSet);
  begin
    with DataSet do
      if Active and (State in [dsEdit, dsInsert]) then Cancel;
  end;

begin
  with Databaze do
  begin
    Zavri(OddeleniTbl);
    Zavri(ZamestnanecTbl);
    Zavri(FunkceTbl);
    Zavri(TridaTbl);
    Zavri(PlatTbl);
    Zavri(NemocenskeQ);
    Zavri(DovoleneQ);
  end;
end;

function THlavniOkno.NodePopupMenu(Node: TTreeNode): TPopupMenu;
// vrati menu odpovidajici prvku stromu urcenem parametrem Node 
begin
  with TreeView, PopupMenus do
  begin
    Result := nil;
    if Node = StrukturaNode then Result := StrukturaMenu
      else
    if Node = FunkceNode then Result := FunkceMenu
      else
    if Node = PlatyNode then Result := TridyMenu
      else
    if Node.ImageIndex = niZamestnanec then Result := ZamestnanecMenu
      else
    if Node.ImageIndex = niFunkce then Result := Funkce1Menu
      else
    if Node.ImageIndex = niTrida then Result := TridaMenu
      else
    if Node.ImageIndex = niOddeleni then Result := OddeleniMenu;
  end;
end;

// -------------------------- udalosti --------------------------------

procedure THlavniOkno.TreeViewExpanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
// pokud se dana slozka jeste nikdy neotvirala nahraje jeji obsah
// pokud je prazda zakaze otevreni
begin
  if Node.Count = 0 then NahrajNode(Node);
  AllowExpansion := (Node.Count > 0);
end;

procedure THlavniOkno.TreeViewMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
// pokud se na strom klikne pravym tlacitkem zobrazi prislusne
// kontextove menu
var
  Menu: TPopupMenu;
  P: TPoint;
begin
  // je to prave tlacitko ?
  if Button = mbRight then
  begin
    PopupMenus.Node := TreeView.GetNodeAt(X, Y);
    // je na miste kliknuti vubec neco?
    if PopupMenus.Node <> nil then
    begin
      // vyberu prvek na ktery se kliklo
      TreeView.Selected := PopupMenus.Node;
      Menu := NodePopupMenu(PopupMenus.Node);
      // je prirazeno nejake menu?
      if Menu <> nil then
      begin
        // vypocitam souradnice relativne k obrazovce
        P.X := X;
        P.Y := Y;
        P := TreeView.ClientToScreen(P);
        // a zobrazim ho
        Menu.Popup(P.X, P.Y);
      end;
    end;
  end;
end;

procedure THlavniOkno.TreeViewStartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
  // na zacatku drag-n-drip si zapamatuju co vlastne tahnu
  DragNode := TreeView.Selected;
end;

procedure THlavniOkno.TreeViewDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
// urci jestli je mozne pustit pretahovany objekt na misto kde je kurzor mysi
var
  Node, Top, DragTop: TTreeNode;
begin
  Node := TreeView.GetNodeAt(X, Y);
  // Je kurzor nad nejakym prkvem?
  if (Node <> nil) and (Node <> DragNode) then
  begin
    Top := TopNode(Node);
    DragTop := TopNode(DragNode);
    // Nelze pretahovat mezi ruznymi stromy,
    // nelze pretahovat koren stromu a
    // nelze pretahovat nadrizeny do podrizeneho a
    // nema smysl pretahovat tam kde ted je
    if (DragTop <> DragNode) and (DragTop = Top) and
       (not IsAncestorNode(Node, DragNode)) and
       (DragNode.Parent <> Node) then
    begin
      // Pretahavame v organizacni strkture
      if Top = StrukturaNode then
      begin
        // Cilem nesmi byt zamestnanec ale oddeleni
        Accept :=
          ((Node.ImageIndex = niOddeleni) or
           (Node = StrukturaNode));
      end
        else
      // Pretahaveme mezi funkcemi
      if Top = FunkceNode then
      begin
        // Cilem musi byt funkce a zdrojem zamestnanec
        Accept := (Node.ImageIndex = niFunkce) and
          (DragNode.ImageIndex = niZamestnanec);
      end
        else
      // Pretahaveme mezi platovymi tridami
      if Top = PlatyNode then
      begin
        // Cilem musi byt platova trida a zdrojem zamestnanec
        Accept := (Node.ImageIndex = niTrida) and
          (DragNode.ImageIndex = niZamestnanec);
      end
        else Accept := False;
    end
      else Accept := False;
  end
    else Accept := False;
end;

procedure THlavniOkno.TreeViewDragDrop(Sender, Source: TObject; X,
  Y: Integer);
// co se stane kdyz se pusti pretahovany objekt na strom
var
  Node, Top: TTreeNode;
  Query: TQuery;
  NoveO: LongInt;
  ImageIndex: Integer;
  Data: Pointer;
begin
  Node := TreeView.GetNodeAt(X, Y);
  // je na miste kurzoru vubec neco?
  if Node <> nil then
  begin
    Top := TopNode(Node);
    // Prekpoklada se ze bezpecnost pretazeni je zajistena
    // udalosti OnDragOver !!!
    if Top = StrukturaNode then
    begin
      // pokud poustim ja organizacni strukturu tak pretahuju
      // oddeleni nebo zamestnance do noveho oddeleni
      if DragNode.ImageIndex = niOddeleni then
          Query := Databaze.PresunOddeleniQ
        else Query := Databaze.PresunZamestnanceQ;
      with Query do
      begin
        if Active then Close;
        // zadam prametry do predpripraveneho SQL prikazu
        if DragNode.ImageIndex = niOddeleni then
            ParamByName('ID_ODDELENI').AsInteger :=
              LongInt(DragNode.Data)
          else SQL[3] := PointerToRC(DragNode.Data);
        if Node <> StrukturaNode then NoveO := LongInt(Node.Data)
          else NoveO := 0;
        ParamByName('NOVE_ODDELENI').AsInteger := NoveO;
      end;
    end
      else
    // pretahuji zamestnace mezi fukcemi/platovymi tridami
    if (Top = FunkceNode) or (Top = PlatyNode) then
    begin
      // vyberu prislusny predpripraveny SQL prikaz
      if Top = FunkceNode then Query := Databaze.PresunFunkciQ
        else Query := Databaze.PresunTridQ;
      // predam mu parametry (pro oba prikazy jsou stejne)
      with Query do
      begin
        if Active then Close;
        ParamByName('rc').AsString := PointerToRC(DragNode.Data);
        ParamByName('nove').AsInteger := Integer(Node.Data);
      end;
    end
      else Query := nil;

    // pokud jsem vytvoril nejaky prikaz tak ho provedu
    if Query <> nil then
    with Query do
    try
      // zapamatuju si parametry pretahovaneho objektu
      ImageIndex := DragNode.ImageIndex;
      Data := DragNode.Data;
      // provedu presun v databazi
      ExecSQL;
      // smazu objekt z puvodniho umistneni
      DragNode.Delete;
      // znovu nahraju cilovou slozku
      NahrajNode(Node);
      // a vyhledam v ni presunuty objekt
      VyberNode(Node, ImageIndex, Data);
    except
      Chyba('Pi pesouvn objektu do novho oddlen dolo k chyb!');
    end;
  end;
end;

procedure THlavniOkno.TreeViewChange(Sender: TObject; Node: TTreeNode);
// zobrazi panel nove vybraneho objektu stromu
begin
  CancelEdits;
  ZobrazPanelNode(Node);
end;

procedure THlavniOkno.TreeViewEnter(Sender: TObject);
// OnChange stromu se nevyvola pokud kliknu na drive vybrany objekt a
// prave vkladam novy, ktery jeste nema reprezentaci ve stromu, proto
// musim pri prvnim kliknuti na strom radeji provest to co
// by se jinak provedlo
begin
  CancelEdits;
  ZobrazPanelNode(TreeView.Selected);
end;

procedure THlavniOkno.VyberNode(TopNode: TTreeNode;
  ImageIndex: Integer; Data: Pointer);
// nalezne objekt ve stormu se zadanymi parametry a ucini ho aktivnim
var
  Node: TTreeNode;
begin
  Node := NajdiNode(TopNode, ImageIndex, Data);
  TreeView.Selected := Node;
end;

procedure THlavniOkno.OddeleniVseGridDblClick(Sender: TObject);
// vybere oddeleni na ktere se kliklo v seznamu oddeleni
begin
  OtevriOddeleniCislo(Databaze.OddeleniVseQ.FieldByName('id').AsInteger);
end;

procedure THlavniOkno.ZamestnanecDblClick(Sender: TObject);
// vybere zamestnance na ktereho se kliklo v seznamu zamestancu
begin
  OtevriZamestnanceCislo(
    TDBGrid(Sender).DataSource.DataSet.FieldByName('rc').AsString);
end;

procedure THlavniOkno.FunkceVseGridDblClick(Sender: TObject);
// vybere funkci na kterou se kliklo v seznamu funkci
begin
  with Databaze.FunkceTbl do
  begin
    Databaze.Upozornovat := False;
    Open;
    Databaze.Upozornovat := True;
    Locate('id', Databaze.FunkceVseQ.FieldByName('id').AsInteger, []);
  end;
end;

procedure THlavniOkno.OddeleniNadrizeneEditClick(Sender: TObject);
// vybere nadrizene oddeleni pri kliknuti na komponentu
// ktera nadrizene oddeleni zobrazuje na panelu Oddeleni
begin
  OtevriOddeleniCislo(Databaze.OddeleniTbl.FieldByName('nadrazene').AsInteger);
end;

procedure THlavniOkno.ZamestnanecOddeleniEditClick(Sender: TObject);
// vybere oddeleni pri kliknuti na komponentu ktera oddeleni
// zobrazuje na panelu Zamestnec
begin
  OtevriOddeleniCislo(Databaze.ZamestnanecTbl.FieldByName('oddeleni').AsInteger);
end;

procedure THlavniOkno.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  // u vsech panelu nastavime aby zaplnili celou zbyvajici plochu okna
  // nelze nastavit design-time protoze by se to obtizne upravovalo
  OddeleniPanel.Align := alClient;
  ZamestnanecPanel.Align := alClient;
  FunkcePanel.Align := alClient;
  TridaPanel.Align := alClient;
  StrukturaPanel.Align := alClient;
  FunkceVsePanel.Align := alClient;
  TridyPanel.Align := alClient;
// pri startu vytvori zaklad stromu
  with TreeView.Items do
  begin
    StrukturaNode := Item[0];
    StrukturaNode.ImageIndex := niStruktura;
    StrukturaNode.SelectedIndex := niStruktura;
    FunkceNode := Item[1];
    FunkceNode.ImageIndex := niFunkceVse;
    FunkceNode.SelectedIndex := niFunkceVse;
    PlatyNode := Item[2];
    PlatyNode.ImageIndex := niTridy;
    PlatyNode.SelectedIndex := niTridy;
    // vsechny slozky lze otevrit, prestoze na zacatku namaji zadny obsah
    for i := 0 to Count-1 do Item[i].HasChildren := True;
  end;
end;

procedure THlavniOkno.TridyGridDblClick(Sender: TObject);
begin
  with Databaze.TridaTbl do
  begin
    Databaze.Upozornovat := False;
    Open;
    Databaze.Upozornovat := True;
    Locate('id', Databaze.TridyVseQ.FieldByName('id').AsInteger, []);
  end;
end;

end.
