unit mMenus;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Comctrls, AppEvnts, ImgList;

type
  TPopupMenus = class(TDataModule)
    StrukturaMenu: TPopupMenu;
    OddeleniMenu: TPopupMenu;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    ZamestnanecMenu: TPopupMenu;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    MainMenu: TMainMenu;
    FunkceMenu: TPopupMenu;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem11: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem13: TMenuItem;
    MenuItem18: TMenuItem;
    TridyMenu: TPopupMenu;
    MenuItem14: TMenuItem;
    MenuItem15: TMenuItem;
    MenuItem16: TMenuItem;
    MenuItem17: TMenuItem;
    MenuItem19: TMenuItem;
    MenuItem20: TMenuItem;
    Funkce1Menu: TPopupMenu;
    MenuItem21: TMenuItem;
    MenuItem23: TMenuItem;
    MenuItem24: TMenuItem;
    MenuItem25: TMenuItem;
    MenuItem26: TMenuItem;
    TridaMenu: TPopupMenu;
    MenuItem22: TMenuItem;
    MenuItem27: TMenuItem;
    MenuItem28: TMenuItem;
    MenuItem29: TMenuItem;
    MenuItem30: TMenuItem;
    Npovda2: TMenuItem;
    Konec2: TMenuItem;
    OpenImageList: TImageList;
    ImageList: TImageList;
    procedure PopupMenusCreate(Sender: TObject);
    procedure OtevriClick(Sender: TObject);
    procedure ZavriClick(Sender: TObject);
    procedure NoveOddeleniClick(Sender: TObject);
    procedure ObnovClick(Sender: TObject);
    procedure OtevriVseClick(Sender: TObject);
    procedure SmazOddeleniClick(Sender: TObject);
    procedure NovyZamestnanecClick(Sender: TObject);
    procedure SmazZamestnanceClick(Sender: TObject);
    procedure NovaFunkceClick(Sender: TObject);
    procedure SmazFunkciClick(Sender: TObject);
    procedure NovaPlatovaTridaClick(Sender: TObject);
    procedure SmazPlatovouTriduClick(Sender: TObject);
    procedure Npovda2Click(Sender: TObject);
    procedure Konec2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Node: TTreeNode;
  end;

var
  PopupMenus: TPopupMenus;

implementation

uses fMain, mDatabaze;

{$R *.DFM}

procedure TPopupMenus.PopupMenusCreate(Sender: TObject);
begin
  Node := nil;
end;

// ------------- zakladni povely slozek ------------------

procedure TPopupMenus.OtevriClick(Sender: TObject);
begin
  // otevre vybranou slozku ve stromu
  if Node <> nil then Node.Expand(False);
end;

procedure TPopupMenus.ZavriClick(Sender: TObject);
begin
  // zavre vybranou slozku ve stromu
  if Node <> nil then Node.Collapse(False);
end;

procedure TPopupMenus.OtevriVseClick(Sender: TObject);
begin
  // otevre vybranou slozku ve stromu vcetne vsech podslozek
  if Node <> nil then Node.Expand(True);
end;

procedure TPopupMenus.ObnovClick(Sender: TObject);
begin
  // obnovi obsah vybrane slozky
  if Node <> nil then HlavniOkno.NahrajNode(Node);
end;

// --------------- vytvareni novych zaznamu ---------------

procedure TPopupMenus.NoveOddeleniClick(Sender: TObject);
begin
  // vyvola vkladani noveho oddeleni
  HlavniOkno.NoveOddeleni(Integer(Node.Data));
end;

procedure TPopupMenus.NovyZamestnanecClick(Sender: TObject);
begin
  // vyvola vkladani noveho zamestnance
  HlavniOkno.NovyZamestnanec(Integer(Node.Data));
end;

procedure TPopupMenus.NovaFunkceClick(Sender: TObject);
begin
  // vyvola vkladani nove funkce
  HlavniOkno.NovaFunkce;
end;

procedure TPopupMenus.NovaPlatovaTridaClick(Sender: TObject);
begin
  // vyvola vkladani nove platove tridy
  HlavniOkno.NovaTrida;
end;

// -------------- mazani zaznamu -------------------

procedure TPopupMenus.SmazOddeleniClick(Sender: TObject);
begin
  // po potvrzeni uzivatelem smaze vybrane oddeleni
  if Node <> nil then
  begin
    if MessageDlg('Oddlen bude smazno vetn vech podzench '+
        'oddlen a zamstnanc! Skuten smazat?',
        mtConfirmation, mbOKCancel, 0) = mrOK then
          Databaze.SmazOddeleni;
  end;
end;

procedure TPopupMenus.SmazZamestnanceClick(Sender: TObject);
begin
  // po potvrzeni uzivatelem smaze vybraneho zamestnance
  if Node <> nil then
  begin
    if MessageDlg('Skuten smazat vybranho zamstnance?',
        mtConfirmation, mbOKCancel, 0) = mrOK then
          Databaze.SmazZamestnance;
  end;
end;

procedure TPopupMenus.SmazFunkciClick(Sender: TObject);
begin
  // po potvrzeni uzivatelem smaze vybranou funkci
  // pokud existuje zamestnanec ktery zastava tuto funkci zobrazi
  // chybove hlaseni
  with Databaze, HlavniOkno do
  if Node <> nil then
  begin
    if Node.Count = 0 then NahrajNode(Node);
    if Node.Count > 0 then
       MessageDlg('Nelze smazat funkci, kterou zastv alespo jeden '+
                  'zamstnanec!', mtError, [mbOK], 0)
       else
    if MessageDlg('Skuten smazat vybranou funkci?',
        mtConfirmation, mbOKCancel, 0) = mrOK then SmazFunkci;
  end;
end;

procedure TPopupMenus.SmazPlatovouTriduClick(Sender: TObject);
begin
  // po potvrzeni uzivatelem smaze vybranou platovou tridu
  // pokud existuje zamestnanec ktery je v teto platove tride zobrazi
  // chybove hlaseni
  with Databaze, HlavniOkno do
  if Node <> nil then
  begin
    if Node.Count = 0 then NahrajNode(Node);
    if Node.Count > 0 then
       MessageDlg('Nelze smazat platovou tdu, ve kter je alespo jeden '+
                  'zamstnanec!', mtError, [mbOK], 0)
       else
    if MessageDlg('Skuten smazat vybranou platovou tdu?',
        mtConfirmation, mbOKCancel, 0) = mrOK then SmazTridu;
  end;
end;

procedure TPopupMenus.Npovda2Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TPopupMenus.Konec2Click(Sender: TObject);
begin
  Application.Terminate;
end;

end.
