unit uObecne;

interface

uses
  comCtrls;

function TopNode(Node: TTreeNode): TTreeNode;

function IsAncestorNode(Node, Test: TTreeNode): Boolean;

function NajdiNode(Top: TTreeNode; ImageIndex: Integer;
  Data: Pointer): TTreeNode;

function FormatujJmeno(Prijmeni, Jmeno: string): string;

function RCToPointer(RC: string): Pointer;

function PointerToRC(Ptr: Pointer): string;

procedure Chyba(s: string);

implementation

uses
  SysUtils, Dialogs;

procedure Chyba(s: string);
// zobrazi chybove hlaseni
begin
  ShowMessage(s);
end;

{function StrToFl(S: ShortString): Extended;
// zobrazi chybove hlaseni
var
  i: Byte;
begin
  Result := 0;
  for i := 1 to Length(S) do
    Result := Result * 10 + StrToInt(S[i]);
end;}

function RCToPointer(RC: string): Pointer;
// zakoduje RC do 4 bytu, ktere interpretuje jako ukazatel
var
  N: Cardinal;
  F: Double;
begin
  if Length(RC) < 10 then N := StrToInt(RC)
    else
  begin
    F := StrToFloat(RC);
    N := -Round(F/11);
  end;
  Result := Pointer(N);
end;

function PointerToRC(Ptr: Pointer): string;
// dekoduje RC ze 4 bytu
var
  N: LongInt;
  F: Double;
begin
  N := LongInt(Ptr);
  if N >= 0 then
  begin
    Result := IntToStr(N);
    N := 9;
  end
    else
  begin
    F := -N;
    F := F*11;
    Result := FloatToStrF(F, ffFixed, 10, 0);
    N := 10;
  end;
  while Length(Result) < N do Result := '0' + Result;
end;

function IsAncestorNode(Node, Test: TTreeNode): Boolean;
// zjisti jeste je objekt Test jeden z nadrazenych slozek objektu Node
begin
  Result := False;
  repeat
    if Node = Test then Result := True;
    Node := Node.Parent;
  until Node = nil;
end;

function NajdiNode(Top: TTreeNode; ImageIndex: Integer;
  Data: Pointer): TTreeNode;
// vyhleda ve stromu objekt ktery ma vlastnosti ImageIndex a Data
// nastaveny tak jak je predano v parametrech
var
  i: Integer;
begin
  for i := 0 to Top.Count-1 do
  begin
    if (Top.Item[i].ImageIndex = ImageIndex) and
       (Top.Item[i].Data = Data) then
    begin
      Result := Top.Item[i];
      Exit;
    end;
    Result := NajdiNode(Top.Item[i], ImageIndex, Data);
    if Result <> nil then Exit;
  end;
  if Data = nil then Result := Top
    else Result := nil;
end;

function TopNode(Node: TTreeNode): TTreeNode;
// vrati nejvyssi nadrazenou slozku objektu Node
begin
  if Node <> nil then
    while Node.Parent <> nil do Node := Node.Parent;
  Result := Node;
end;

function FormatujJmeno(Prijmeni, Jmeno: string): string;
// vrati retezec obsahujici prijmeni a jmeno oddelene carkou
begin
  Result := Format('%s, %s', [Prijmeni, Jmeno]);
end;

end.
