PROGRAM Garaz;
USES Crt, Dos;

CONST JmenoSouboru = 'GARAZ.DAT';
      PlatbaZaHodinu = 55;

CONST MaxJmeno = 30;
      MaxSPZ = 9;
TYPE TCas = RECORD
       Hod, Min, Sek: Word;
     END;
TYPE TZaznam = RECORD
       Jmeno: String[MaxJmeno];
       SPZ: String[MaxSPZ];
       UzOdjel: Boolean;
       Prijezd, Odjezd: TCas;
       DobaPobytu: TCas;
       Platba: Word;
     END;
VAR Soubor: FILE OF TZaznam;

PROCEDURE UlozCas(VAR Cas: TCas);
 { Do rekordu Cas ulozi aktualni cas }
VAR S100: Word;
BEGIN
  GetTime(Cas.Hod, Cas.Min, Cas.Sek, S100);
END;

FUNCTION Sekundy(Cas: TCas): Integer;
  { spocita pocet sekund od pulnoci do casu v recordu Cas }
BEGIN
  Sekundy:=Cas.Hod*60*60+Cas.Min*60+Cas.Sek;
END;

PROCEDURE SekundyNaCas(S: Integer; VAR Cas: TCas);
  { vypocita cas z poctu sekund od pulnoci (opak funkce Sekundy) }
BEGIN
  WITH Cas DO
  BEGIN
    Hod:=S DIV (60*60);
    Min:=(S MOD (60*60)) DIV 60;
    Sek:=S MOD 60;
  END;
END;

PROCEDURE Prijezd(VAR Z: TZaznam);
  { zaznamena data pri prijezdu: Jmeno, SPZ, cas prijezdu }
BEGIN
  Write('Jmeno: ');
  Readln(Z.Jmeno);
  Write('SPZ: ');
  Readln(Z.SPZ);
  Z.UzOdjel:=False;
  UlozCas(Z.Prijezd);
END;

PROCEDURE Odjezd(VAR Z: TZaznam);
  { zaznamena data pri odjezdu: cas odjezdu, doba pritomnosti, platba }
VAR S, H: Word;
BEGIN
  WITH Z DO
  BEGIN
    UlozCas(Odjezd);
    UzOdjel:=True;
    S:=Sekundy(Odjezd)-Sekundy(Prijezd);
    SekundyNaCas(S, DobaPobytu);
    H:=S DIV (60*60);
    IF S MOD (60*60)>0 THEN Inc(H);
    Platba:=H*PlatbaZahodinu;
  END;
END;

FUNCTION Cislo(A: Integer; C: Char; Delka: Byte): String;
   { vrati string, ktery obsahuje cislo A a pred nej doplni tolik }
   { znaku C aby delka byla Delka }
VAR S: String;
BEGIN
  Str(A, S);
  WHILE Length(S)<Delka DO S:=C+S;
  Cislo:=S;
END;

PROCEDURE PisCas(VAR Cas: TCas);
  { Vypise cas obsazeny v promnene Cas }
BEGIN
  WITH Cas DO
    Write(Cislo(Hod, ' ', 2)+':'+Cislo(Min, '0', 2)+':'+Cislo(Sek, '0', 2));
END;

PROCEDURE Pis(VAR Z: TZaznam);
  { Vypise data ze zaznamu }
VAR Pobyt, H: Integer;
BEGIN
  WITH Z DO
  BEGIN
    Writeln('Jmeno: ', Jmeno);
    Writeln('SPZ: ', SPZ);
    Write('Prijezd: ');
    PisCas(Prijezd);
    Writeln;
    IF UzOdjel THEN
    BEGIN
      Write('Odjezd:  ');
      PisCas(Odjezd);
      Writeln;
      Write('Doba pobytu: ');
      PisCas(DobaPobytu);
      Writeln;
      Writeln('Platba: ', Platba, ' Kc');
    END
       ELSE Writeln('<Stale pritomen>');
  END;
END;

FUNCTION Menu: Byte;
VAR C: Char;
    N: Byte;
BEGIN
  ClrScr;
  Writeln('1 - prijezd');
  Writeln('2 - odjezd');
  Writeln('3 - vypis');
  Writeln('4 - vymaz');
  Writeln('5 - platby');
  Writeln('6 - konec');
  Write('- ');
  REPEAT
    C:=ReadKey;
  UNTIL C IN ['1'..'6'];
  Writeln(C);
  Writeln;
  N:=Ord(C)-Ord('1')+1;
  IF N=6 THEN N:=0;
  Menu:=N;
END;

PROCEDURE _Prijezd;
VAR Zaznam: TZaznam;
BEGIN
  Prijezd(Zaznam);
  Seek(Soubor, FileSize(Soubor));
  Write(Soubor, Zaznam);
END;

PROCEDURE _Odjezd;
VAR Jmeno: String;
    Zaznam: TZaznam;
BEGIN
  Write('Jmeno: ');
  Readln(Jmeno);
  Zaznam.Jmeno:='ABC#';
  Seek(Soubor, 0);
  WHILE (NOT EOF(Soubor)) AND
        (NOT ((Jmeno=Zaznam.Jmeno) AND (NOT Zaznam.UzOdjel))) DO
        Read(Soubor, Zaznam);
  IF Zaznam.Jmeno<>Jmeno THEN
  BEGIN
    Writeln('Nebyl zaznamenan prijezd');
    ReadKey;
  END
     ELSE
  BEGIN
    Odjezd(Zaznam);
    Seek(Soubor, FilePos(Soubor)-1);
    Write(Soubor, Zaznam);
  END;
END;

PROCEDURE _Vypis;
VAR Zaznam: TZaznam;
BEGIN
  Seek(Soubor, 0);
  WHILE NOT EOF(Soubor) DO
  BEGIN
    Read(Soubor, Zaznam);
    Pis(Zaznam);
    Writeln;
  END;
  Readkey;
END;

PROCEDURE _Vymaz;
BEGIN
  Rewrite(Soubor);
END;

PROCEDURE _Platby;
VAR Jmeno: String;
    Zaznam: TZaznam;
    CelkemKc: Integer;
    CelkemCas: LongInt;
    Cas: TCas;
BEGIN
  Write('Jmeno: ');
  Readln(Jmeno);
  Writeln;
  CelkemKc:=0;
  CelkemCas:=0;
  Seek(Soubor, 0);
  WHILE NOT EOF(Soubor) DO
  BEGIN
    Read(Soubor, Zaznam);
    IF Zaznam.Jmeno=Jmeno THEN
    BEGIN
      Pis(Zaznam);
      IF Zaznam.UzOdjel THEN
      BEGIN
        Inc(CelkemKc, Zaznam.Platba);
        Inc(CelkemCas, Sekundy(Zaznam.DobaPobytu));
      END;
      Writeln;
    END;
  END;
  Writeln('Platba celkem: ', CelkemKc, ' Kc');
  Write('Doba pobytu celkem: ');
  SekundyNaCas(CelkemCas, Cas);
  PisCas(Cas);
  Writeln;
  Readkey;
END;

VAR M: Byte;
BEGIN
  TextAttr:=LightGray;

  Assign(Soubor, JmenoSouboru);
{$I-}
  Reset(Soubor);
{$I+}
  IF IOResult<>0 THEN Rewrite(Soubor);

  M:=1;
  WHILE M<>0 DO
  BEGIN
    M:=Menu;
    CASE M OF
      1: _Prijezd;
      2: _Odjezd;
      3: _Vypis;
      4: _Vymaz;
      5: _Platby;
    END;
  END;
  Close(Soubor);
END.






