unit Kalk;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, VBXCtrl, Switch, Bigauge, Grids,
  Calendar, ColorGrd, Menus,
  Tlac, Clipbrd, ExtCtrls, About;

const skPrvni =  0;
      skPrubeh = 1;
      skChyba =  2;

const ChybaStr = 'Chyba';

type
  THlavniOkno = class(TForm)
    Cislo7: TTlacitkoKalkulacky;
    Ciselnik: TLabel;
    Cislo4: TTlacitkoKalkulacky;
    VyvolaniPameti: TTlacitkoKalkulacky;
    Cislo8: TTlacitkoKalkulacky;
    Cislo9: TTlacitkoKalkulacky;
    Cislo5: TTlacitkoKalkulacky;
    Cislo6: TTlacitkoKalkulacky;
    SmazPamet: TTlacitkoKalkulacky;
    PametPlus: TTlacitkoKalkulacky;
    PametMinus: TTlacitkoKalkulacky;
    Deleno: TTlacitkoKalkulacky;
    Krat: TTlacitkoKalkulacky;
    Cislo1: TTlacitkoKalkulacky;
    Cislo2: TTlacitkoKalkulacky;
    Cislo3: TTlacitkoKalkulacky;
    Minus: TTlacitkoKalkulacky;
    Cislo0: TTlacitkoKalkulacky;
    Tecka: TTlacitkoKalkulacky;
    RovnaSe: TTlacitkoKalkulacky;
    Plus: TTlacitkoKalkulacky;
    Vymaz: TTlacitkoKalkulacky;
    Umaz: TTlacitkoKalkulacky;
    Procento: TTlacitkoKalkulacky;
    PlusMinus: TTlacitkoKalkulacky;
    Obrys: TShape;
    MainMenu1: TMainMenu;
    Menu1: TMenuItem;
    Editace1: TMenuItem;
    Kopiruj1: TMenuItem;
    Vloz1: TMenuItem;
    OAplikaci2: TMenuItem;
    Konec1: TMenuItem;
    N1: TMenuItem;

    procedure Smaz;
    procedure Zpracuj(C: Char);
    procedure KresliDisplay;

    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Konec1Click(Sender: TObject);
    procedure StavMenu(Sender: TObject);
    procedure Kopiruj1Click(Sender: TObject);
    procedure Vloz1Click(Sender: TObject);
    procedure OAplikaci2Click(Sender: TObject);

    private
    Cislo: String[11];
    Stav: Byte;
    Znamenko: Char;
    Operator: Char;
    Operand: Double;
    Pamet: Double;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  HlavniOkno: THlavniOkno;

implementation

{$R *.DFM}

procedure THlavniOkno.KresliDisplay;
var s: String;
begin
  s:=Znamenko+Cislo;
  if Pamet<>0 then
  begin
    while Length(s)<1+High(Cislo) do s:=' '+s;
    s:='M'+s;
  end;
  Ciselnik.Caption:=s;
end;

procedure THlavniOkno.Smaz;
begin
  Stav:=skPrvni;
  Cislo:='0';
  Znamenko:=' ';
  Operator:='=';
  KresliDisplay;
end;

procedure THlavniOkno.Zpracuj(C: Char);
var R: Double;

  procedure Chyba;
  begin
    Stav:=skChyba;
    Cislo:=ChybaStr;
    Znamenko:=' ';
  end;

  procedure NaDisplay(R: Double);
  var S: string[63];
  begin
    Str(R:0:10, S);
    if S[1]<>'-' then Znamenko:=' '
       else
    begin
      Delete(S, 1, 1);
      Znamenko:='-';
    end;
    while ((Length(S)>High(Cislo)) or
           (S[Length(S)]='0')) and
          (Pos('.', S)>0) do Dec(S[0]);
    if S[Length(S)]='.' then Dec(S[0]);
    if Length(S)>High(Cislo) then Chyba
       else Cislo:=S;
  end;

  function CoNaDisplei: Double;
  var E: Integer;
      R: Double;
  begin
    Val(Znamenko+Cislo, R, E);
    CoNaDisplei:=R;
  end;

  procedure PokudJePrvni;
  begin
    if Stav=skPrvni then
    begin
      Stav:=skPrubeh;
      Cislo:='0';
      Znamenko:=' ';
    end;
  end;

begin
  C:=UpCase(C);
  if (Stav=skChyba) and (C<>'C') then C:=' ';
  case C of
    '0'..'9':
      begin
        PokudJePrvni;
        if Cislo='0' then Cislo:='';
        Cislo:=Cislo+C;
      end;
    '.':
      begin
        PokudJePrvni;
        if Pos('.', Cislo)=0 then
             Cislo:=Cislo+'.';
      end;
    #8:
      begin
        PokudJePrvni;
        if Length(Cislo)=1 then Cislo:='0'
             else Dec(Cislo[0]);
      end;
    '_':
      if Znamenko=' ' then Znamenko:='-'
           else Znamenko:=' ';
    '+', '-', '*', '/', '=', '%':
      begin
        {if Stav=skPrubeh then}
        begin
          Stav:=skPrvni;
          R:=CoNaDisplei;
          if C='%' then
          begin
            case Operator of
              '+', '-': R:=Operand*R/100;
              '*', '/': R:=R/100;
            end;
          end;
          case Operator of
            '+': NaDisplay(Operand+R);
            '-': NaDisplay(Operand-R);
            '*': NaDisplay(Operand*R);
            '/': if R=0 then Chyba
                    else NaDisplay(Operand/R);
          end;
        end;
        if C in ['+', '-', '/', '*'] then
           Operator:=C;
        Operand:=CoNaDisplei;
      end;
    'C': Smaz;
    'M': Pamet:=Pamet+CoNaDisplei;
    'R':
      begin
        NaDisplay(Pamet);
        Operator:='=';
        Operand:=CoNaDisplei;
      end;
    #1:  Pamet:=0;
    #2:  Pamet:=Pamet-CoNaDisplei;
  end;
  KresliDisplay;
end;

procedure THlavniOkno.FormCreate(Sender: TObject);
begin
  Pamet:=0;
  Smaz;
end;

procedure THlavniOkno.FormKeyPress(Sender: TObject; var Key: Char);
begin
  Zpracuj(Key);
end;

procedure THlavniOkno.Konec1Click(Sender: TObject);
begin
  Close;
end;

procedure THlavniOkno.StavMenu(Sender: TObject);
begin
  Vloz1.Enabled:=Clipboard.HasFormat(CF_TEXT);
  Kopiruj1.Enabled:=(Cislo<>ChybaStr);
end;

procedure THlavniOkno.Kopiruj1Click(Sender: TObject);
var s: String;
begin
  if Znamenko='-' then s:='-' else s:='';
  s:=s+Cislo;
  Clipboard.AsText:=s;
end;                    

procedure THlavniOkno.Vloz1Click(Sender: TObject);
var s: String;
    i: Integer;
begin
  s:=Clipboard.AsText;
  for i:=1 to Length(s) do Zpracuj(s[i]);
end;

procedure THlavniOkno.OAplikaci2Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

end.


