<%@ Language=VBScript %>

<%

option explicit

dim objConn
dim objRS
dim Zprava
dim Admin
dim DatabazeOtevrena 

sub Databaze_Otevri
  	Dim objRS
	Dim strSQLQuery, strOutput
	
	' Vytvoreni objektu ADODB.Connection a nastaveni jeho vlastnosti
	Set objConn = Server.CreateObject("ADODB.Connection")
	objConn.ConnectionString = Application("Zkousky_ConnectionString")
	objConn.ConnectionTimeout = Application("Zkousky_ConnectionTimeout")
	
	' Otevreni spojeni do databaze (vcetne osetreni chyboveho stavu)
	On Error Resume Next
	objConn.Open
	If Err <> 0 Then
		Response.Write "Nelze otevt spojen do databze"
		
		' Uklid
		Set objConn = Nothing
		
		Response.End
	End If
	DatabazeOtevrena = True
end sub

sub Databaze_Zavri
  set objConn = Nothing
end sub

sub SQL_Otevri (byval query)
	' Priprava SQL dotazu
	
	' Vytvoreni objektu typu ADODB.Recordset
	Set objRS = Server.CreateObject("ADODB.Recordset")
	
	' Provedeni dotazu (vcetne osetreni chyb)
	On Error Resume Next
	objRS.Open query, objConn, adOpenForwardOnly, adLockReadOnly, adCmdText
	If Err <> 0 Then
		Response.Write "<p>Nelze provst databzov dotaz</p>" & vbNewLine
		Response.Write "<p>" & err.Description & "</p>" & vbNewLine
		Response.Write "<p><code>" & query & "</code></p>" & vbNewLine
		' Uklid
		objConn.Close
		Set objRS = Nothing
		Set objConn = Nothing
		
		Response.End
	End If
end sub

sub SQL_Zavri
  set objRS = Nothing
end sub

sub SQL_Proved (byval query)
	' Priprava SQL dotazu
	
	' Vytvoreni objektu typu ADODB.Recordset
    dim objCmd
	Set objCmd = Server.CreateObject("ADODB.Recordset")
	
	' Provedeni dotazu (vcetne osetreni chyb)
	On Error Resume Next
	objCmd.Open query, objConn, adOpenForwardOnly, adLockReadOnly, adCmdText
	If Err <> 0 Then
		Response.Write "<p>Nelze provst databzov dotaz</p>" & vbNewLine
		Response.Write "<p>" & err.Description & "</p>" & vbNewLine
		Response.Write "<p><code>" & query & "</code></p>" & vbNewLine
		' Uklid
		objConn.Close
		Set objCmd = Nothing
		Set objConn = Nothing
		
		Response.End
    else
		Set objCmd = Nothing
	End If
end sub

function SQL_Existuje(query)
  SQL_Otevri(query)
  SQL_Existuje = not objRS.EOF
  SQL_Zavri
end function

function SQL_Hodnota(query) ' vraci hodnotu ze select
  SQL_Otevri(query)
  if not objRS.EOF then
    SQL_Hodnota = objRS(0)
  else
    SQL_Hodnota = Null
  end if
  SQL_Zavri
end function

sub Zobraz_Zpravu() ' vypis zpravy do stranky
  if Zprava <> "" then
    Response.Write("<P CLASS=""chyba"">" & Zprava & "<P>")
  end if
end sub

sub Navrat()
  Response.Write("<p><a href=""" & Session("logged") & ".asp"">Zpet</a>" + vbNewLine)
end sub

function casKurzu() ' vraci cas kurzu
  dim Den
  select case objRS("den")
    case "po" Den = "Po"
    case "ut" Den = "t"
    case "st" Den = "St"
    case "ct" Den = "t"
    case "pa" Den = "P"
    case "so" Den = "So"
    case "ne" Den = "Ne"
  end select
  if (objRS("cyklus") = "A") or (objRS("cyklus") = "a") then
    casKurzu = Den
  else
    casKurzu = Den & " " & objRS("cyklus")
  end if
  casKurzu = casKurzu & " " & FormatDateTime(objRS("odkdy"), vbShortTime) & _
    " - " & FormatDateTime(objRS("dokdy"), vbShortTime) 
end function

function formatujKurz(Kurz) ' doplnuje nuly do cisla kurzu
  dim strKurz
  strKurz = Kurz
  do while Len(strKurz) < 5 
    strKurz = "0" & strKurz
  loop
  formatujKurz = strKurz
end function

function formatujCas(Cas)
'  formatujCas = DatePart("d", Cas) & "." & DatePart("m", Cas) & "." & DatePart("yyyy", Cas) & _
    '" " & DatePart("h", Cas) & ":" & DatePart("m", Cas)
  formatujCas = FormatDateTime(Cas, vbShortDate) & " " & FormatDateTime(Cas, vbShortTime)
end function

function SexStr(sex) ' prevadi boolean pohlavi na M, Z
  if sex then
    SexStr = "M"
  else
    SecStr = ""
  end if
end function

dim S_Username, S_Jmeno, S_Sex, S_Semester, S_Major, S_Minor

sub Nahraj_Studenta() ' nahraje data o studentovi
  SQL_Otevri("select username, name, sex, semester, major, minor from student where username='" & session("user") & "'")
  
  if not objRS.EOF then
    S_Username = lcase(objRS("username"))
    S_Jmeno = objRS("name")
    S_Sex = objRS("sex")
    S_Semester = objRS("semester")
    S_Major = objRS("major")
    S_Minor = objRS("minor")
  else
    Response.Redirect("login.asp")
  end if
  
  SQL_Zavri  
end sub

dim K_UserName, K_Jmeno

Sub Opravneni_Kantor(MusiBytAdmin, ZjistitAdmin, PresmerovatNa) ' kontrola kantorvych opravneni
  if Session("Logged") <> "kantor" then
    Response.Redirect "login.asp"
  end if
  
  if PresmerovatNa = "" then
    PresmerovatNa = "login.asp"
  end if
 
 
  SQL_Otevri("select username, name, admin from kantor where username = '" & Session("user") & "'")
  Admin = not objRS.EOF
  if Admin then 
    Admin = objRS("admin")
    K_Username = objRS("username")
    K_Jmeno = objRS("name")
  end if
  SQL_Zavri

  
  if MusiBytAdmin and (not Admin) then
    if DatabazeOtevrena then Databaze_Zavri()
    Response.Redirect(PresmerovatNa)
  end if
End Sub

dim P_Ident, P_Nazev
dim T_Ident, T_Cas, T_Mistnost, T_Kapacita

Sub Opravneni_Kantor_Predmet(MusiBytAdmin, ZjistitAdmin, PresmerovatNa, Ident, Termin) 'kontrola prav kantora k predmetu
  dim OK
  call Opravneni_Kantor(MusiBytAdmin, ZjistitAdmin, PresmerovatNa)
  if PresmerovatNa = "" then
    PresmerovatNa = "login.asp"
  end if

  if Ident <> "" then
    SQL_Otevri("select p.ident, p.nazev from predmet p, kantor_predmet k " & _
      "where k.kantor='" & Session("user") & "' and p.ident = k.ident and p.ident = '" & Ident & "'")
    OK = not objRS.EOF    
    if OK then 
      P_Ident = UCase(objRS("ident"))
      P_Nazev = objRS("nazev")
    end if
    SQL_Zavri
    if not OK then
      Databaze_Zavri()
      Response.Redirect(PresmerovatNa)
    end if
    exit sub
  end if
  
  if IsNumeric(Termin) and (Termin > 0) then
    SQL_Otevri("select p.nazev, t.ident, t.cas, t.mistnost, t.kapacita from predmet p, termin t, kantor_predmet k " & _
        "where k.kantor='" & Session("user") & "' and k.ident=t.ident and p.ident = t.ident and t.id=" & Termin)
    OK = not objRS.EOF    
    if OK then 
      P_Ident = UCase(objRS("ident"))
      P_Nazev = objRS("nazev")
      T_Ident = P_Ident
      T_Cas = objRS("cas") 
      T_Mistnost = objRS("mistnost")
      T_Kapacita = objRS("kapacita")
    end if
    SQL_Zavri
    if not OK then
      Databaze_Zavri()
      Response.Redirect(PresmerovatNa)
    end if
    exit sub
  end if

  Response.Redirect(PresmerovatNa)
End Sub

function PrihlasenyStr ' prihlaseny uzivatel
  if Session("Logged") = "kantor" then
    PrihlasenyStr = _
      "<table class=""prihlaseny""><tr><td>Uivatel: <B>" & K_Jmeno & "</B> (" & K_UserName & ")</td></tr></table>"
  elseif Session("Logged") = "student" then
    dim S_Minor2
    dim S_Sex2
    if (S_Sex) then 
      S_Sex2 = "M"
    else
      S_Sex2 = ""
    end if
    if (S_Minor <> "") and (not IsNull(S_Minor)) then S_Minor2 = ", " & S_Minor
    PrihlasenyStr = _
      "<table class=""prihlaseny""><tr><td>Uivatel: <B>" & S_Jmeno & "</B> (" & S_UserName & _
      ", " & S_Sex2 & ", " & S_Semester & ", " & S_Major & S_Minor2 & ")</td></tr></table>"
  end if
end function

%>
